<?php

namespace app\admin\controller;


class Storehelp extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    /**
     * 帮助列表
     */
    public function index()
    {
        $model_help = Model('help');
        $condition = array();
        //$condition['help_id'] = array('gt', '99');//内容列表不显示系统自动添加的数据
        if (trim(input('param.key')) != '') {
            $condition['help_title'] = array('like', '%' . input('param.key') . '%');
        }
        $type_id = intval(input('param.type_id'));
        if ($type_id > 0) {
            $condition['type_id'] = $type_id;
        }
        $help_list = $model_help->getStoreHelpList($condition, 10);
        $this->assign('help_list', $help_list);
        $this->assign('show_page', $model_help->page_info->render());

        $type_list = $model_help->getStoreHelpTypeList();
        //halt($type_list);
        $this->assign('type_list', $type_list);
        $this->setAdminCurItem('index');
        return $this->fetch();
    }

    /**
     * 帮助类型
     */
    public function help_type()
    {
        $model_help = Model('help');
        $condition = array();

        $type_list = $model_help->getStoreHelpTypeList($condition, 10);
        $this->assign('type_list', $type_list);
        $this->assign('show_page', $model_help->page_info->render());
        $this->setAdminCurItem('help_type');
        return $this->fetch();
    }

    /**
     * 新增帮助
     *
     */
    public function add_help()
    {
        $model_help = Model('help');
        $help=array(
            'help_title'=>'',
            'type_id'=>'',
            'help_sort'=>'',
            'help_url'=>'',
            'help_info'=>'',
            'help_id'=>'',
        );
        $this->assign('help', $help);
        if (request()->isPost()) {
            $help_array = array();
            $help_array['help_title'] = $_POST['help_title'];
            $help_array['help_url'] = $_POST['help_url'];
            $help_array['help_info'] = $_POST['content'];
            $help_array['help_sort'] = intval($_POST['help_sort']);
            $help_array['type_id'] = intval($_POST['type_id']);
            $help_array['update_time'] = time();
            $help_array['page_show'] = '1';//页面类型:1为店铺,2为会员
            $state = $model_help->addHelp($help_array);
            if ($state) {
                if (!empty($_POST['file_id']) && is_array($_POST['file_id'])) {
                    $model_help->editHelpPic($state, $_POST['file_id']);
                }
                $this->log('新增店铺帮助，编号' . $state);
                $this->success(lang('ds_common_op_succ'), 'storehelp/index');
            }
            else {
                $this->errot(lang('ds_common_op_fail'));
            }
        }
        $type_list = $model_help->getStoreHelpTypeList();
        $this->assign('type_list', $type_list);
        $condition = array();
        $condition['item_id'] = '0';
        $pic_list = $model_help->getHelpPicList($condition);
        $this->assign('pic_list', $pic_list);
        $this->setAdminCurItem('add_help');
        return $this->fetch('edit_help');
    }

    /**
     * 编辑帮助
     *
     */
    public function edit_help()
    {
        $model_help = Model('help');
        $condition = array();
        $help_id = intval(input('param.help_id'));
        $condition['help_id'] = $help_id;
        $help_list = $model_help->getStoreHelpList($condition);
        //halt($help_list);
        $help = $help_list[0];
        $this->assign('help', $help);
        if (request()->isPost()) {
            $help_array = array();
            $help_array['help_title'] = $_POST['help_title'];
            $help_array['help_url'] = $_POST['help_url'];
            $help_array['help_info'] = $_POST['content'];
            $help_array['help_sort'] = intval($_POST['help_sort']);
            $help_array['type_id'] = intval($_POST['type_id']);
            $help_array['update_time'] = time();
            $state = $model_help->editHelp($condition, $help_array);
            if ($state) {
                $this->log('编辑店铺帮助，编号' . $help_id);
                $this->success(lang('ds_common_op_succ'), 'storehelp/index');
            }
            else {
                $this->error(lang('ds_common_op_fail'));
            }
        }
        $type_list = $model_help->getStoreHelpTypeList();
        $this->assign('type_list', $type_list);
        $condition = array();
        $condition['item_id'] = $help_id;
        $pic_list = $model_help->getHelpPicList($condition);
        $this->assign('pic_list', $pic_list);
        $this->setAdminCurItem('edit');

        return $this->fetch();
    }

    /**
     * 删除帮助
     *
     */
    public function del_help()
    {
        $model_help = Model('help');
        $condition = array();
        $condition['help_id'] = intval(input('param.help_id'));
        $state = $model_help->delHelp($condition, array($condition['help_id']));
        if ($state) {
            $this->log('删除店铺帮助，编号' . $condition['help_id']);
            $this->success(lang('ds_common_del_succ'), 'storehelp/index');
        }
        else {
            $this->error(lang('ds_common_del_fail'));
        }
    }

    /**
     * 新增帮助类型
     *
     */
    public function add_type()
    {
        $model_help = Model('help');
        if (request()->isPost()) {
            $type_array = array();
            $type_array['type_name'] = $_POST['type_name'];
            $type_array['type_sort'] = intval($_POST['type_sort']);
            $type_array['help_show'] = intval($_POST['help_show']);//是否显示,0为否,1为是
            $type_array['page_show'] = '1';//页面类型:1为店铺,2为会员

            $state = $model_help->addHelpType($type_array);
            if ($state) {
                $this->log('新增店铺帮助类型，编号' . $state);
                $this->success(lang('ds_common_save_succ'), 'storehelp/help_type');
            }
            else {
                $this->error(lang('ds_common_save_fail'));
            }
        }
        $type=array(
            'type_name'=>'',
            'type_sort'=>'255',
            'help_show'=>'1',
        );
        $this->assign('type', $type);
        $this->setAdminCurItem('add_type');
        return $this->fetch('edit_type');
    }

    /**
     * 编辑帮助类型
     *
     */
    public function edit_type()
    {
        $model_help = Model('help');
        $condition = array();
        $condition['type_id'] = intval(input('param.type_id'));
        $type_list = $model_help->getHelpTypeList($condition);
        $type = $type_list[0];
        if (request()->isPost()) {
            $type_array = array();
            $type_array['type_name'] = $_POST['type_name'];
            $type_array['type_sort'] = intval($_POST['type_sort']);
            $type_array['help_show'] = intval($_POST['help_show']);//是否显示,0为否,1为是
            $state = $model_help->editHelpType($condition, $type_array);
            if ($state) {
                $this->log('编辑店铺帮助类型，编号' . $condition['type_id']);
                $this->success(lang('ds_common_op_succ'), 'storehelp/help_type');
            }
            else {
                $this->error(lang('ds_common_op_fail'));
            }
        }
        $this->setAdminCurItem('edit_type');
        $this->assign('type', $type);
        return $this->fetch();
    }

    /**
     * 删除帮助类型
     *
     */
    public function del_type()
    {
        $model_help = Model('help');
        $condition = array();
        $condition['type_id'] = intval(input('param.type_id'));
        $state = $model_help->delHelpType($condition);
        if ($state) {
            $this->log('删除店铺帮助类型，编号' . $condition['type_id']);
            $this->success(lang('ds_common_del_succ'), 'storehelp/help_type');
        }
        else {
            $this->error(lang('ds_common_del_fail'));
        }
    }

    /**
     * 上传图片
     */
    public function upload_pic()
    {
        $data = array();
        if (!empty($_FILES['fileupload']['name'])) {//上传图片
            $fprefix = 'admin/storehelp';
            $upload_file= BASE_UPLOAD_PATH . DS. $fprefix;
            $filename=$file_name= date('YmdHis') . rand(10000, 99999);
            $file = request()->file('fileupload');
            $info = $file->validate(['ext'=>'jpg,png,gif'])->move($upload_file,$filename);
          if($info){
              $file_name=$info->getFilename();
          }
            $model_upload = Model('upload');
            $insert_array = array();
            $insert_array['file_name'] = $file_name;
            $insert_array['file_size'] = $_FILES['fileupload']['size'];
            $insert_array['upload_time'] = time();
            $insert_array['item_id'] = intval(input('param.item_id'));
            $insert_array['upload_type'] = '2';
            $result = $model_upload->add($insert_array);
            if ($result) {
                $data['file_id'] = $result;
                $dir=UPLOAD_SITE_URL.'/'.$fprefix.'/';
                $data['file_name'] = $dir.$file_name;
            }
        }
        echo json_encode($data);
        exit;
    }

    /**
     * 删除图片
     */
    public function del_pic()
    {
        $condition = array();
        $condition['upload_id'] = intval(input('param.file_id'));
        $model_help = Model('help');
        $state = $model_help->delHelpPic($condition);
        if ($state) {
            echo 'true';
            exit;
        }
        else {
            echo 'false';
            exit;
        }
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'index', 'text' => '帮助内容', 'url' => url('Storehelp/index')
            ), array(
                'name' => 'help_type', 'text' => '帮助类型', 'url' => url('Storehelp/help_type')
            )
        );
        if (request()->action() == 'edit_help') {
            $menu_array[] = array('name' => 'edit', 'text' => '编辑内容', 'url' => url('Storehelp/edit_help'));
        }
        if (request()->action() == 'index'||request()->action() =='add_help') {
            $menu_array[] = array('name' => 'add_help', 'text' => '新增内容', 'url' => url('Storehelp/add_help')
            );
        }
        if (request()->action() == 'help_type'||request()->action() =='add_type') {
            $menu_array[] = array('name' => 'add_type', 'text' => '新增类型', 'url' =>url('Storehelp/add_type'));
        }
        if (request()->action() == 'edit_type') {
            $menu_array[] = array('name' => 'edit_type', 'text' => '编辑类型', 'url' =>url('Storehelp/edit_type'));
        }
        return $menu_array;
    }

}