<?php

namespace app\admin\controller;


class Storejoin extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    /**
     * 前台头部图片传
     */
    public function index() {
        $size = 3;//上传显示图片总数
        $i = 1;
        $info['pic'] = array();
        $info['show_txt'] = '';
        $model_setting = Model('config');
        $code_info = $model_setting->getRowconfig('store_joinin_pic');
        if(!empty($code_info['value'])) {
            $info = unserialize($code_info['value']);
        }
        if (request()->isPost()) {
            $info['show_txt'] = $_POST['show_txt'];
            for ($i;$i <= $size;$i++) {
                $file = 'pic'.$i;
                $info['pic'][$i] = $_POST['show_pic'.$i];
                if (!empty($_FILES[$file]['name'])) {//上传图片
                    $filename_tmparr = explode('.', $_FILES[$file]['name']);
                    $ext = end($filename_tmparr);
                    $file_name = 'store_joinin_'.$i.'.'.$ext;
                    $upload_file= BASE_UPLOAD_PATH . DS. 'admin/Storejion';
                    $file = request()->file($file);
                    $result = $file->validate(['ext'=>'jpg,png,gif'])->move($upload_file,$file_name);
                    if ($result) {
                        $info['pic'][$i] = $file_name;
                    }
                }
            }
            $code_info = serialize($info);

            $update_array = array();
            $update_array['store_joinin_pic'] = $code_info;
             $model_setting->updateConfig($update_array);
            $this->success(lang('ds_common_save_succ'),'Storejoin/index');
        }
        $this->assign('size',$size);
        $this->assign('pic',$info['pic']);
        $this->assign('show_txt',$info['show_txt']);
        $this->setAdminCurItem('index');
        return $this->fetch();
    }

    /**
     * 入驻指南
     *
     */
    public function help_list() {
        $model_help = Model('help');
        $condition = array();
        $condition['type_id'] = '1';
        $help_list = $model_help->getStoreHelpList($condition);
        $this->assign('help_list',$help_list);
        $this->setAdminCurItem('help_list');
        return $this->fetch();
    }

    /**
     * 编辑入驻指南
     *
     */
    public function edit_help() {
        $model_help = Model('help');
        $condition = array();
        $help_id = intval(input('param.help_id'));
        $condition['help_id'] = $help_id;
        $help_list = $model_help->getStoreHelpList($condition);
        $help = $help_list[0];
        $this->assign('help',$help);
        if (request()->isPost()) {
            $help_array = array();
            $help_array['help_title'] = $_POST['help_title'];
            $help_array['help_info'] = $_POST['content'];
            $help_array['help_sort'] = intval($_POST['help_sort']);
            $help_array['update_time'] = time();
            $state = $model_help->editHelp($condition, $help_array);
            if ($state) {
                $this->log('编辑店铺入驻指南，编号'.$help_id);
                $this->success(lang('ds_common_save_succ'),'store_join/help_list');
            } else {
                $this->error(lang('ds_common_save_fail'));
            }
        }
        $condition = array();
        $condition['item_id'] = $help_id;
        $pic_list = $model_help->getHelpPicList($condition);
        $this->assign('pic_list',$pic_list);
        $this->setAdminCurItem('edit');
        return $this->fetch();
    }

    /**
     * 上传图片
     */
    public function upload_pic() {
        $data = array();
        if (!empty($_FILES['fileupload']['name'])) {//上传图片
            $fprefix = 'admin/storehelp';
            $upload_file= BASE_UPLOAD_PATH . DS. $fprefix;
            $file = request()->file('fileupload');
            $info = $file->validate(['ext'=>'jpg,png,gif'])->move($upload_file);
            if($info){
                $file_name=$info->getSaveName();
            }
            $model_upload = Model('upload');
            $insert_array = array();
            $insert_array['file_name'] = $file_name;
            $insert_array['file_size'] = $_FILES['fileupload']['size'];
            $insert_array['upload_time'] = time();
            $insert_array['item_id'] = intval(input('param.item_id'));
            $insert_array['upload_type'] = '2';
            $result = $model_upload->add($insert_array);
            if ($result) {
                $data['file_id'] = $result;
                $data['file_name'] = $file_name;
            }
        }
        echo json_encode($data);
        exit;
    }

    /**
     * 删除图片
     */
    public function del_picOp() {
        $condition = array();
        $condition['upload_id'] = intval(input('param.file_id'));
        $model_help = Model('help');
        $state = $model_help->delHelpPic($condition);
        if ($state) {
            echo 'true';exit;
        } else {
            echo 'false';exit;
        }
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'index', 'text' => '图片及提示', 'url' => url('Storejoin/index')
            ), array(
                'name' => 'help_list', 'text' => '入驻指南', 'url' => url('Storejoin/help_list')
            )
        );
        if (request()->action() == 'edit_help') {
            $menu_array[] = array('name' => 'edit', 'text' => '编辑内容', 'url' => url('Storejoin/edit_help'));
        }
        return $menu_array;
    }
}