<?php

namespace app\admin\controller;
use think\Lang;
use think\Validate;

class Vrgroupbuy extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/zh-cn/vrgroupbuy.lang.php');
    }

    /*
     * 列表分类
     */
    public function index()
    {
        $model_vr_groupbuy_class = Model('vrgroupbuyclass');
        $list = $model_vr_groupbuy_class->getVrGroupbuyClassList();
        $this->assign('list', $list);
        $this->setAdminCurItem('index');
        return $this->fetch();
    }

    /*
     * 添加分类
     */
    public function class_add()
    {
        if (request()->isPost()) { //添加虚拟抢购分类
            // 数据验证
            $obj_validate = new Validate();
            $data = [
                'class_name' => $_POST['class_name'], 'class_sort' => $_POST['class_sort'],
            ];
            $rule = [
                ['class_name', 'require|length:1,10', lang('groupbuy_class_name_is_not_null')],
                ['class_sort', 'require|between:0,255', lang('groupbuy_class_sort_is_not_null')]
            ];

            $error = $obj_validate->check($data, $rule);
            if (!$error) {
                $this->error($obj_validate->getError());
            }

            $params = array();
            $params['class_name'] = trim($_POST['class_name']);
            $params['class_sort'] = intval($_POST['class_sort']);
            if (isset($_POST['parent_class_id']) && intval($_POST['parent_class_id']) > 0) {
                $params['parent_class_id'] = $_POST['parent_class_id'];
            }
            else {
                $params['parent_class_id'] = 0;
            }

            $model_vr_groupbuy_class = Model('vrgroupbuyclass');
            $res = $model_vr_groupbuy_class->addVrGroupbuyClass($params); //添加分类
            if ($res) {
                // 删除虚拟抢购分类缓存
                Model('groupbuy')->dropCachedData('groupbuyvrclasses');

                $this->log('添加虚拟抢购分类[ID:' . $res . ']', 1);

                $this->success('添加成功');
            }
            else {
                $this->error('添加失败', 'vrgroupbuy/index');
            }
        }

        $model_vr_groupbuy_class = Model('vrgroupbuyclass'); //一级分类
        $list = $model_vr_groupbuy_class->getVrGroupbuyClassList(array('parent_class_id' => 0));
        $this->assign('list', $list);
        $this->setAdminCurItem('class_add');
        $parent_id = input('param.parent_class_id');
        $this->assign('parent_class_id', !empty($parent_id) ? intval($parent_id) : 0);
        return $this->fetch();
    }

    /*
     * 编辑分类
     */
    public function class_edit()
    {
        if (request()->isPost()) {
            // 数据验证
            $obj_validate = new Validate();
            $data = [
                'class_name' => $_POST['class_name'], 'class_sort' => $_POST['class_sort'],
            ];
            $rule = [
                ['class_name', 'require|length:1,10', lang('groupbuy_class_name_is_not_null')],
                ['class_sort', 'require|between:0,255', lang('groupbuy_class_sort_is_not_null')]
            ];

            $error = $obj_validate->check($data, $rule);
            if (!$error) {
                $this->error($obj_validate->getError());
            }

            $params = array();
            $params['class_name'] = trim($_POST['class_name']);
            $params['class_sort'] = intval($_POST['class_sort']);
            if (isset($_POST['parent_class_id']) && intval($_POST['parent_class_id']) > 0) {
                $params['parent_class_id'] = $_POST['parent_class_id'];
            }
            else {
                $params['parent_class_id'] = 0;
            }

            $condition = array(); //条件
            $condition['class_id'] = intval($_POST['class_id']);

            $model_vr_groupbuy_class = Model('vrgroupbuyclass');
            $res = $model_vr_groupbuy_class->editVrGroupbuyClass($condition, $params);

            if ($res) {
                // 删除虚拟抢购分类缓存
                Model('groupbuy')->dropCachedData('groupbuyvrclasses');

                $this->log('编辑虚拟抢购分类[ID:' . intval($_POST['class_id']) . ']', 1);
                $this->error('编辑成功', 'vrgroupbuy/index');
            }
            else {
                $this->error('编辑失败', 'vrgroupbuy/index');
            }
        }

        $model_vr_groupbuy_class = Model('vrgroupbuyclass'); //分类信息
        $class = $model_vr_groupbuy_class->getVrGroupbuyClassInfo(array('class_id' => intval(input('param.class_id'))));
        if (empty($class)) {
            $this->error('该分类不存在');
        }
        $this->assign('class', $class);


        $list = $model_vr_groupbuy_class->getVrGroupbuyClassList(array('parent_class_id' => 0));
        $this->assign('list', $list);
        $this->setAdminCurItem('class_edit');
        return $this->fetch();
    }

    /*
     * 删除分类
     */
    public function class_del()
    {
        if (request()->isPost()) {
            $classidArr = explode(",", $_POST['class_id']);
            if (!empty($classidArr)) {
                foreach ($classidArr as $val) {
                    $class = db('vrgroupbuyclass')->where(array('class_id' => $val))->find();
                    if ($class['parent_class_id'] == 0) {
                        db('vrgroupbuyclass')->where(array('parent_class_id' => $class['class_id']))->delete();
                    }
                    db('vrgroupbuyclass')->where(array('class_id' => $val))->delete();
                }
            }
        }

        // 删除虚拟抢购分类缓存
        Model('groupbuy')->dropCachedData('groupbuy_vr_classes');

        $this->log('删除虚拟抢购分类[ID:' . $_POST['class_id'] . ']', 1);
        $this->error('删除成功', 'vrgroupbuy/index');
    }

    public function ajaxOp()
    {
        $field = input('param.column');
        $id = input('param.id');
        $value = input('param.value');

        switch (input('param.column')) {
            case 'class_name':
                if (mb_strlen((string)$value, 'utf-8') > 10)
                    return;
                break;
            case 'class_sort':
                if ($value < 0 || $value > 255)
                    return;
                break;

            default:
                return;
        }

        switch (input('param.branch')) {
            case 'class':
                $model_vr_groupbuy_class = Model('vr_groupbuy_class');
                $res = $model_vr_groupbuy_class->editVrGroupbuyClass(array('class_id' => $id), array($field => $value));
                if ($res) {
                    // 删除虚拟抢购分类缓存
                    Model('groupbuy')->dropCachedData('groupbuy_vr_classes');

                    $this->log('编辑虚拟抢购分类[ID:' . $id . ']', 1);
                    echo 'true';
                }
                else {
                    echo 'false';
                }
                exit;

            default:
                return;
        }
    }

    /*
     * 区域列表
     */
    public function area_list()
    {
        $condition = array(); // 搜索条件
        $condition['parent_area_id'] = 0;
        if (strlen($area_name = trim(input('param.area_name')))) {
            $condition['area_name'] = array('like', "%{$area_name}%");
            $this->assign('area_name', $area_name);
        }
        $first_letter = input('param.first_letter');
        if (isset($first_letter) && !empty($first_letter)) {
            $condition['first_letter'] = input('param.first_letter');
            $this->assign('first_letter', input('param.first_letter'));
        }

        $model_vr_groupbuy_area = Model('vrgroupbuyarea');
        $area = $model_vr_groupbuy_area->getVrGroupbuyAreaList($condition);
        $this->assign('list', $area); //区域列表
        $this->assign('show_page', $model_vr_groupbuy_area->page_info->render());

        // 城市首字母
        $this->assign('letter', $this->letterArr);
        $this->setAdminCurItem('area_list');
        return $this->fetch();
    }

    /*
     * 添加区域
     */
    public function area_add()
    {
        if (request()->isPost()) {
            // 数据验证
            $obj_validate = new Validate();
            $data = [
                'area_name' => $_POST['area_name'], 'first_letter' => $_POST['first_letter']
            ];
            $rule = [
                ['area_name', 'require', '区域名称不能为空'], ['first_letter', 'require', '首字母不能为空']
            ];
            $error = $obj_validate->check($data, $rule);
            if (!$error) {
                $this->error($obj_validate->getError());
            }
            $params = array(
                'area_name' => trim($_POST['area_name']),
                'parent_area_id' => isset($_POST['parent_area_id']) && !empty($_POST['parent_area_id']) ? $_POST['parent_area_id'] : 0,
                'add_time' => time(), 'first_letter' => $_POST['first_letter'],
                'area_number' => trim($_POST['area_number']), 'post' => trim($_POST['post']),
                'hot_city' => intval($_POST['is_hot'])
            );

            $model_vr_groupbuy_area = Model('vrgroupbuyarea');
            $res = $model_vr_groupbuy_area->addVrGroupbuyArea($params);

            if ($res) {
                // 删除虚拟抢购区域缓存
                Model('groupbuy')->dropCachedData('groupbuyvrcities');

                $this->log('添加虚拟抢购区域[ID:' . $res . ']', 1);
                $this->error('添加成功', 'vrgroupbuy/area_list');
            }
            else {
                $this->error('添加失败', 'vrgroupbuy/area_list');
            }
        }

        // 城市首字母
        $this->assign('letter', $this->letterArr);
        $area_id = input('param.area_id');
        if (empty($area_id)) {
            $model_vr_groupbuy_area = Model('vrgroupbuyarea');
            $area = $model_vr_groupbuy_area->getVrGroupbuyAreaInfo(array('area_id' => intval(input('param.area_id'))));

            $this->assign('area_name', $area['area_name']);
            $this->assign('area_id', $area['area_id']);
        }
        else {
            $this->assign('area_name', lang('area_first_area'));
            $this->assign('area_id', 0);
        }
        $this->setAdminCurItem('area_add');
        return $this->fetch();
    }

    /*
     * 编辑区域
     */
    public function area_edit()
    {
        if (request()->isPost()) {
            //数据验证
            $obj_validate = new Validate();
            $data = [
                'area_name' => $_POST['area_name'], 'first_letter' => $_POST['first_letter']
            ];
            $rule = [
                ['area_name', 'require', '区域名称不能为空'], ['first_letter', 'require', '首字母不能为空']
            ];
            $error = $obj_validate->check($data, $rule);
            if (!$error) {
                $this->error($obj_validate->getError());
            }

            $params = array(
                'area_name' => trim($_POST['area_name']), 'add_time' => time(),
                'first_letter' => $_POST['first_letter'], 'area_number' => trim($_POST['area_number']),
                'post' => trim($_POST['post']), 'hot_city' => intval($_POST['is_hot'])
            );

            $condition = array();
            $condition['area_id'] = intval($_POST['area_id']);

            $model_vr_groupbuy_area = Model('vrgroupbuyarea');
            $res = $model_vr_groupbuy_area->editVrGroupbuyArea($condition, $params);
            if ($res) {
                // 删除虚拟抢购区域缓存
                Model('groupbuy')->dropCachedData('groupbuyvrcities');

                $this->log('编辑虚拟抢购区域[ID:' . intval($_POST['area_id']) . ']', 1);
                $this->success('编辑成功', 'vrgroupbuy/area_list');
            }
            else {
                $this->error('编辑失败', 'vrgroupbuy/area_list');
            }
        }

        //城市首字母
        $this->assign('letter', $this->letterArr);

        $area = db('vrgroupbuyarea')->where(array('area_id' => intval(input('param.area_id'))))->find();
        $this->assign('area', $area);

        $parent_area = db('vrgroupbuyarea')->where(array('area_id' => $area['parent_area_id']))->find();
        if (!empty($parent_area)) {
            $this->assign('parent_area_name', $parent_area['area_name']);
        }
        else {
            $this->assign('parent_area_name', lang('area_first_area'));
        }
        $this->setAdminCurItem('area_edit');
        return $this->fetch();
    }

    /*
     * 查看区域
     */
    public function area_view()
    {
        //获取区域信息
        $area_list = db('vrgroupbuyarea')->where(array('parent_area_id' => intval(input('param.parent_area_id'))))->paginate(10,false,['query' => request()->param()]);
        $this->assign('show_page', $area_list->render());
        $this->assign('list', $area_list);

        $area = db('vrgroupbuyarea')->where(array('area_id' => intval(input('param.parent_area_id'))))->find();
        $this->assign('parent_area', $area);
        $this->setAdminCurItem('area_view');
        return $this->fetch();
    }

    /*
     * 查看商区
     */
    public function area_street()
    {
        //获取区域信息
        $mall_list = db('vr_groupbuy_area')->where(array('parent_area_id' => intval(input('param.parent_area_id'))))->paginate(10,false,['query' => request()->param()]);
        $this->assign('show_page', $mall_list->render());
        $this->assign('list', $mall_list);

        $mall = db('vr_groupbuy_area')->where(array('area_id' => intval(input('param.parent_area_id'))))->find();
        $this->assign('parent_area', $mall);

        return $this->fetch("area_street");
    }

    /*
     * 删除区域
     */
    public function area_drop()
    {
        $res = db('vrgroupbuyarea')->where(array('area_id' => array('in', intval($_POST['area_id']))))->delete();

        if ($res) {
            // 删除虚拟抢购区域缓存
            Model('groupbuy')->dropCachedData('groupbuyvrcities');

            $this->log('删除虚拟抢购区域[ID:' . intval($_POST['area_id']) . ']', 1);
            $this->error('删除成功', 'vrgroupbuy/area_list');
        }
        else {
            $this->error('删除失败', 'vrgroupbuy/area_list');
        }
    }

    protected $letterArr = array(
        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V',
        'W', 'X', 'Y', 'Z',
    );

    protected function getAdminItemList()
    {

        $menu_array = array(
            array(
                'name' => 'index', 'text' => '分类管理', 'url' => url('vrgroupbuy/index')
            ), array(
                'name' => 'class_add', 'text' => '添加分类', 'url' => url('vrgroupbuy/class_add')
            ), array(
                'name' => 'area_list', 'text' => '区域管理', 'url' => url('vrgroupbuy/area_list')
            ), array(
                'name' => 'area_add', 'text' => '添加区域', 'url' => url('vrgroupbuy/area_add')
            ),
        );
        if (request()->action() == 'class_edit') {
            $menu_array[] = array(
                'name' => 'class_edit', 'text' => '编辑分类', 'url' => url('vrgroupbuy/class_edit')
            );
        }
        if (request()->action() == 'area_view') {
            $menu_array[] = array(
                'name' => 'area_view', 'text' => '查看区域', 'url' => url('vrgroupbuy/area_view')
            );
        }
        if (request()->action() == 'price_edit') {
            $menu_array[] = array(
                'name' => 'price_edit', 'text' => lang('groupbuy_price_edit'), 'url' => url('groupbuy/price_edit')
            );
        }
        return $menu_array;
    }
}