<?php

namespace app\common\model;

use think\Model;

class Snscomment extends Model {

    public $page_info;

    /**
     * 新增评论
     *
     * @param $param 添加信息数组
     * @return 返回结果
     */
    public function commentAdd($param) {
        $result = db('snscomment')->insertGetId($param);
        return $result;
    }

    /**
     * 评论记录列表
     *
     * @param $condition 条件
     * @param $page 分页
     * @param $field 查询字段
     * @return array 数组格式的返回结果
     */
    public function getCommentList($condition, $page = '', $field = '*') {
        $where = $this->getCondition($condition);
        $order = isset($condition['order']) ? $condition['order'] : 'comment_id desc';
        $limit = isset($condition['limit']) ? $condition['limit'] : '';
        $group = isset($condition['group']) ? $condition['group'] : '';
        if ($limit) {
            return db('snscomment')->alias('snscomment')->where($where)->field($field)->order($order)->limit($limit)->group($group)->page($page)->select();
        } else {
            $res = db('snscomment')->alias('snscomment')->where($where)->field($field)->order($order)->limit($limit)->group($group)->paginate($page,false,['query' => request()->param()]);
            $this->page_info = $res;
            return $res->items();
        }
    }

    /**
     * 评论总数
     *
     * @param $condition 条件
     * @param $field 查询字段
     * @return array 数组格式的返回结果
     */
    public function getCommentCount($condition) {
        $condition_str = $this->getCondition($condition);
        return db('snscomment')->where($condition_str)->count();
    }

    /**
     * 获取评论详细
     *
     * @param $condition 查询条件
     * @param $field 查询字段
     */
    public function getCommentRow($condition, $field = '*') {
        return db('snscomment')->where($condition)->find();
    }

    /**
     * 删除评论
     */
    public function delComment($condition) {
        if (empty($condition)) {
            return false;
        }
        $condition_str = '';
        if ($condition['comment_id'] != '') {
            $condition_str .= " and comment_id='{$condition['comment_id']}' ";
        }
        if ($condition['comment_id_in'] != '') {
            $condition_str .= " and comment_id in('{$condition['comment_id_in']}')";
        }
        if ($condition['comment_originalid_in'] != '') {
            $condition_str .= " and comment_originalid in('{$condition['comment_originalid_in']}') ";
        }
        if ($condition['comment_originalid'] != '') {
            $condition_str .= " and comment_originalid='{$condition['comment_originalid']}' ";
        }
        if ($condition['comment_originaltype'] != '') {
            $condition_str .= " and comment_originaltype = '{$condition['comment_originaltype']}' ";
        }
        return db('snscomment')->where($condition_str)->delete();
    }

    /**
     * 更新评论记录
     * @param    array $param 修改信息数组
     * @param    array $condition 条件数组
     */
    public function commentEdit($param, $condition) {
        if (empty($param)) {
            return false;
        }
        //得到条件语句
        $condition_str = $this->getCondition($condition);
        $result = db('snscomment')->where($condition_str)->update($param);
        return $result;
    }

    /**
     * 将条件数组组合为SQL语句的条件部分
     *
     * @param    array $condition_array
     * @return    string
     */
    private function getCondition($condition_array) {
        $condition_sql = '1=1';
        //ID in
        if (isset($condition_array['comment_id_in']) && $condition_array['comment_id_in'] != '') {
            $condition_sql .= " and snscomment.comment_id in('{$condition_array['comment_id_in']}')";
        }
        //原帖ID
        if (isset($condition_array['comment_originalid']) && $condition_array['comment_originalid'] != '') {
            $condition_sql .= " and snscomment.comment_originalid = '{$condition_array['comment_originalid']}'";
        }
        //原帖类型
        if (isset($condition_array['comment_originaltype']) && $condition_array['comment_originaltype'] != '') {
            $condition_sql .= " and snscomment.comment_originaltype = '{$condition_array['comment_originaltype']}'";
        }
        //会员名like
        if (isset($condition_array['comment_membername_like']) && $condition_array['comment_membername_like'] != '') {
            $condition_sql .= " and snscomment.comment_membername like '%{$condition_array['comment_membername_like']}%'";
        }
        //状态
        if (isset($condition_array['comment_state']) && $condition_array['comment_state'] != '') {
            $condition_sql .= " and snscomment.comment_state = '{$condition_array['comment_state']}'";
        }
        //内容
        if (isset($condition_array['comment_content_like']) && $condition_array['comment_content_like'] != '') {
            $condition_sql .= " and snscomment.comment_content like '%{$condition_array['comment_content_like']}%'";
        }
        //添加时间
        if (isset($condition_array['stime']) && $condition_array['stime'] != '') {
            $condition_sql .= " and `snscomment`.comment_addtime >= {$condition_array['stime']}";
        }
        if (isset($condition_array['etime']) && $condition_array['etime'] != '') {
            $condition_sql .= " and `snscomment`.comment_addtime <= {$condition_array['etime']}";
        }
        return $condition_sql;
    }

}