<?php

/**
 * 取得商品缩略图的完整URL路径，接收商品信息数组，返回所需的商品缩略图的完整URL
 *
 * @param array $goods 商品信息数组
 * @param string $type 缩略图类型  值为60,240,360,1280
 * @return string
 */
function thumb($goods = array(), $type = '')
{
    $type_array = explode(',_', ltrim(GOODS_IMAGES_EXT, '_'));
    if (!in_array($type, $type_array)) {
        $type = '240';
    }

    if (empty($goods)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage($type);
    }
    if (array_key_exists('apic_cover', $goods)) {
        $goods['goods_image'] = $goods['apic_cover'];
    }

    if (empty($goods['goods_image'])) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage($type);
    }
    $file = $goods['goods_image'];
    $fname = basename($file);

    //对象存储文件
    $upload_type = explode('_', $fname);
    if (in_array($upload_type['0'], array('oss', 'cos'))) {
        $store_id = $upload_type['1'];
        return config($upload_type['0'] . '_endpoint') . '/' . ATTACH_GOODS . '/' . $store_id . '/' . $file;
    }
    //取店铺ID
    if (preg_match('/^(\d+_)/', $fname)) {
        $store_id = substr($fname, 0, strpos($fname, '_'));
    }
    else {
        $store_id = $goods['store_id'];
    }

    if (!file_exists(BASE_UPLOAD_PATH . '/' . ATTACH_GOODS . '/' . $store_id . '/' . $file)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage($type);
    }
    $thumb_host = UPLOAD_SITE_URL . '/' . ATTACH_GOODS;
    return $thumb_host . '/' . $store_id . '/' . $file;
}

/**
 * 取得商品缩略图的完整URL路径，接收图片名称与店铺ID
 *
 * @param string $file 图片名称
 * @param string $type 缩略图尺寸类型，值为60,240,360,1280
 * @param mixed $store_id 店铺ID 如果传入，则返回图片完整URL,如果为假，返回系统默认图
 * @return string
 */
function cthumb($file, $type = '', $store_id = false)
{
    $type_array = explode(',_', ltrim(GOODS_IMAGES_EXT, '_'));
    if (!in_array($type, $type_array)) {
        $type = '240';
    }
    if (empty($file)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage($type);
    }
    $fname = basename($file);
    // 取店铺ID
    $upload_type = explode('_', $fname);
    //外网存储图片
    if (in_array($upload_type['0'], array('oss', 'cos'))) {
        $store_id = $upload_type['1'];
        return config($upload_type['0'] . '_endpoint') . '/' . ATTACH_GOODS . '/' . $store_id . '/' . $file;
    }

    if ($store_id === false || !is_numeric($store_id)) {
        $store_id = substr($fname, 0, strpos($fname, '_'));
    }
    // 本地存储时，增加判断文件是否存在，用默认图代替
    if (!file_exists(BASE_UPLOAD_PATH . '/' . ATTACH_GOODS . '/' . $store_id . '/' . $file)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage($type);
    }
    $thumb_host = UPLOAD_SITE_URL . '/' . ATTACH_GOODS;
    return $thumb_host . '/' . $store_id . '/' . $file;
}

/**
 * 商品二维码
 * @param array $goods_info
 * @return string
 */
function goodsQRCode($goods_info)
{
    if (!file_exists(BASE_UPLOAD_PATH . '/' . ATTACH_STORE . '/' . $goods_info['store_id'] . '/' . $goods_info['goods_id'] . '.png')) {
        return UPLOAD_SITE_URL . DS . ATTACH_STORE . DS . 'default_qrcode.png';
    }
    return UPLOAD_SITE_URL . DS . ATTACH_STORE . DS . $goods_info['store_id'] . DS . $goods_info['goods_id'] . '.png';
}

/**
 * 商品二维码 v3-b12
 * @param array $goods_info
 * @return string
 */
function storeQRCode($store_id)
{
    if (!file_exists(BASE_UPLOAD_PATH . '/' . ATTACH_STORE . '/' . $store_id . '/' . $store_id . '_store.png')) {
        return UPLOAD_SITE_URL . DS . ATTACH_STORE . DS . 'default_qrcode.png';
    }
    return UPLOAD_SITE_URL . DS . ATTACH_STORE . DS . $store_id . DS . $store_id . '_store.png';
}

/**
 * 取得抢购缩略图的完整URL路径
 *
 * @param string $imgurl 商品名称
 * @param string $type 缩略图类型  值为small,mid,max
 * @return string
 */
function gthumb($image_name = '')
{
    if (empty($image_name)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage($type);
    }
    list($base_name, $ext) = explode('.', $image_name);
    list($store_id) = explode('_', $base_name);
    $file_path = ATTACH_GROUPBUY . DS . $store_id . DS . $image_name;
    if (!file_exists(BASE_UPLOAD_PATH . DS . $file_path)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage('240');
    }
    return UPLOAD_SITE_URL . DS . $file_path;
}

/**
 * 取得买家缩略图的完整URL路径
 *
 * @param string $imgurl 商品名称
 * @param string $type 缩略图类型  值为240,1024
 * @return string
 */
function snsThumb($image_name = '', $type = '')
{
    if (!in_array($type, array('240', '1024')))
        $type = '240';
    if (empty($image_name)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage('240');
    }

    list($member_id) = explode('_', $image_name);
    $file_path = ATTACH_MALBUM . DS . $member_id . DS . $image_name;
    if (!file_exists(BASE_UPLOAD_PATH . '/' . DS . $file_path)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage('240');
    }
    return UPLOAD_SITE_URL . DS . $file_path;
}

/**
 * 取得积分商品缩略图的完整URL路径
 *
 * @param string $imgurl 商品名称
 * @param string $type 缩略图类型  值为small
 * @return string
 */
function pointprodThumb($image_name = '', $type = '')
{

    if (empty($image_name)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage('240');
    }
    $file_path = ATTACH_POINTPROD . DS . $image_name;

    if (!file_exists(BASE_UPLOAD_PATH . DS . $file_path)) {
        return UPLOAD_SITE_URL . '/' . defaultGoodsImage('240');
    }
    return UPLOAD_SITE_URL . DS . $file_path;
}

/**
 * 取得品牌图片
 *
 * @param string $image_name
 * @return string
 */
function brandImage($image_name = '')
{
    if ($image_name != '') {
        return UPLOAD_SITE_URL . '/' . ATTACH_BRAND . '/' . $image_name;
    }
    return UPLOAD_SITE_URL . '/' . ATTACH_COMMON . '/default_brand_image.gif';
}

/**
 * 取得订单状态文字输出形式
 *
 * @param array $order_info 订单数组
 * @return string $order_state 描述输出
 */
function orderState($order_info)
{
    switch ($order_info['order_state']) {
        case ORDER_STATE_CANCEL:
            $order_state = lang('order_state_cancel');
            break;
        case ORDER_STATE_NEW:
            $order_state = lang('order_state_new');
            break;
        case ORDER_STATE_PAY:
            $order_state = lang('order_state_pay');
            break;
        case ORDER_STATE_SEND:
            $order_state = lang('order_state_send');
            break;
        case ORDER_STATE_SUCCESS:
            $order_state = lang('order_state_success');
            break;
    }
    return $order_state;
}

/**
 * 取得订单支付类型文字输出形式
 *
 * @param array $payment_code
 * @return string
 */
function orderPaymentName($payment_code)
{
    return str_replace(array('offline', 'online', 'alipay', 'tenpay', 'chinabank', 'predeposit', 'wxpay'), array(
        '货到付款', '在线付款', '支付宝', '财付通', '网银在线', '站内余额支付', '微信支付'
    ), $payment_code);
}

/**
 * 取得订单商品销售类型文字输出形式
 *
 * @param array $goods_type
 * @return string 描述输出
 */
function orderGoodsType($goods_type)
{
    return str_replace(array('1', '2', '3', '4', '5'), array('', '抢购', '限时折扣', '优惠套装', '赠品'), $goods_type);
}

/**
 * 取得结算文字输出形式
 *
 * @param array $bill_state
 * @return string 描述输出
 */
function billState($bill_state)
{
    return str_replace(array('1', '2', '3', '4'), array('已出账', '商家已确认', '平台已审核', '结算完成'), $bill_state);
}

/**
 *商品图片上传的处理方式
 * upload_file  文件保存路径
 * file_name  上传文件的value值
 * save_name  文件保存名称
 */
function upload_goods_image($upload_file, $file_name = 'file', $save_name)
{
    //判断是否上传图片
    if (!empty($_FILES[$file_name]['name'])) {
        $upload_dir = config('upload_type');
        //远程保存
        if ($upload_dir == 'oss') {
            $accessId = config('oss_accessid');
            $accessSecret = config('oss_accesssecret');
            $bucket = config('oss_bucket');
            $endpoint = config('oss_endpoint');
            $endpoint_type = config('endpoint_type') == '1' ? true : false;
            if (!strpos($save_name, '.')) {
                $save_name .= '.' . pathinfo($_FILES[$file_name]['name'], PATHINFO_EXTENSION);
            }
            $object = $upload_file . '/' . 'oss_' . $save_name;
            $filePath = $_FILES[$file_name]['tmp_name'];
            $OssClient = new \OSS\OssClient($accessId, $accessSecret, $endpoint, $endpoint_type);
            try {
                $fileinfo = $OssClient->uploadFile($bucket, $object, $filePath);
                return array('code' => '200', 'message' => '', 'result' => $fileinfo['info']['url']);
            } catch (OssException $e) {
                return array('code' => '100', 'message' => $e->getMessage(), 'result' => '');
            }
        }
        elseif ($upload_dir == 'local') {
            //本地图片保存
            $file_object = request()->file($file_name);
            $upload_file = BASE_UPLOAD_PATH . DS . $upload_file;
            $info = $file_object->rule('uniqid')->validate(['ext' => 'jpg,png,gif'])->move($upload_file, $save_name);
            if ($info) {
                $img_path = $upload_file . '/' . $info->getFilename();
                return array('code' => '200', 'message' => '', 'result' => $img_path);
            }
            else {
                $error = $file_object->getError();
                $data['code'] = '100';
                $data['message'] = $error;
                $data['result'] = $_FILES[$file_name]['name'];
                return $data;
            }
        }
        //预留文件类型检测
    }
    else {
        return array('code' => '100', 'message' => '', 'result' => '');
    }
}

/**删除商品图文件
 *pic_list  要删除的文件
 **/
function del_goods_image($pic_list, $store_id)
{
    if (!empty($pic_list) && is_array($pic_list)) {
        $count = '0';
        foreach ($pic_list as $val) {
            $upload_type = explode('_', $val['apic_cover']);
            if ($upload_type['0'] == 'oss') {
                $count++;
            }
        }
        foreach ($pic_list as $v) {
            $upload_type = explode('_', $v['apic_cover']);
            //外网存储图片
            if (in_array($upload_type['0'], array('oss', 'cos'))) {
                if (!$store_id) {
                    $store_id = $upload_type['1'];
                }
                if ($upload_type['0'] == 'oss') {
                    if ($count > 1) {
                        $object[] = ATTACH_GOODS . '/' . $store_id . '/' . $v['apic_cover'];
                    }
                    else {
                        $object = ATTACH_GOODS . '/' . $store_id . '/' . $v['apic_cover'];
                    }
                }
            }
            else {
                $upload_file = BASE_UPLOAD_PATH . DS . ATTACH_GOODS . DS . $store_id;
                @unlink($upload_file . DS . $v['apic_cover']);
            }
        }

        //外网存储图片删除
        $accessId = config('oss_accessid');
        $accessSecret = config('oss_accesssecret');
        $bucket = config('oss_bucket');
        $endpoint = config('oss_endpoint');
        $endpoint_type = config('endpoint_type') == '1' ? true : false;
        $OssClient = new \OSS\OssClient($accessId, $accessSecret, $endpoint, $endpoint_type);
        try {
            if (is_array($object)) {
                $OssClient->deleteObjects($bucket, $object);
            }
            else {
                $OssClient->deleteObject($bucket, $object);
            }
            return array('code' => '200', 'message' => '', 'result' => '');
        } catch (OssException $e) {
            return array('code' => '100', 'message' => $e->getMessage(), 'result' => '');
        }
        return array('code' => '200', 'message' => '', 'result' => '');
    }
}

/**
 * 取得广告图片
 *
 * @param string $image_name
 * @return string
 */
function advImage($image_name = '')
{
    if ($image_name != '') {
        return UPLOAD_SITE_URL . '/' . ATTACH_ADV . '/' . $image_name;
    }
}

?>
