<?php

namespace app\home\controller;


use think\Lang;

class Connectsina extends BaseMall
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH.'home/lang/zh-cn/connectsina.lang.php');
        Lang::load(APP_PATH . 'home/lang/zh-cn/login-register.lang.php');
        /**
         * 判断新浪微博登录功能是否开启
         */
        if (config('sina_isuse') != 1) {
            $this->error(lang('home_sconnect_unavailable'));
        }
        if (!session('slast_key')) {
            $this->error(lang('home_sconnect_error'));
        }
        $this->assign('hidden_nctoolbar', 1);
    }

    /**
     * 首页
     */
    public function index()
    {
        /**
         * 检查登录状态
         */
        if (session('is_login') == '1') {
            $this->bindsina();
        }
        else {
            $this->autologin();
            $this->register();
        }
    }

    /**
     * 新浪微博账号绑定新用户
     */
    public function register()
    {
        //实例化模型
        $model_member = Model('member');
        if (request()->isPost()) {
            $update_info = array();
            $update_info['member_password'] = md5(trim($_POST["password"]));
            if (!empty($_POST["email"])) {
                $update_info['member_email'] = $_POST["email"];
                session('member_email', $_POST["email"]);
            }
            $model_member->editMember(array('member_id' => session('member_id')), $update_info);
            $this->success(lang('ds_common_save_succ'),'index/index');
        }
        else {
            //检查登录状态
            $model_member->checkloginMember();
            //获取新浪微博账号信息
            require_once(APP_PATH . 'home/api/sina/saetv2.ex.class.php');
            $c = new \SaeTClientV2(config('sina_wb_akey'), config('sina_wb_skey'), session('slast_key.access_token'));
            $sinauser_info = $c->show_user_by_id(session('slast_key.uid'));//根据ID获取用户等基本信息
            $this->assign('sinauser_info', $sinauser_info);
            $sina_str = serialize($sinauser_info);
            $user_array = array();
            $user_passwd = rand(100000, 999999);
            /**
             * 会员添加
             */
            $user_array['member_name'] = $sinauser_info['screen_name'];
            $user_array['member_password'] = $user_passwd;
            $user_array['member_email'] = '';
            $user_array['member_sinaopenid'] = session('slast_key.uid');//sina openid
            $user_array['member_sinainfo'] = $sina_str;//sina 信息
            $rand = rand(100, 899);
            if (strlen($user_array['member_name']) < 3)
                $user_array['member_name'] = $sinauser_info['screen_name'] . $rand;
            $check_member_name = $model_member->getMemberInfo(array('member_name' => trim($user_array['member_name'])));
            $result = 0;
            if (empty($check_member_name)) {
                $result = $model_member->addMember($user_array);
            }
            else {
                for ($i = 1; $i < 999; $i++) {
                    $rand += $i;
                    $user_array['member_name'] = trim($sinauser_info['screen_name']) . $rand;
                    $check_member_name = $model_member->getMemberInfo(array('member_name' => trim($user_array['member_name'])));
                    if (empty($check_member_name)) {
                        $result = $model_member->addMember($user_array);
                        break;
                    }
                }
            }
            if ($result) {
                $this->assign('user_passwd', $user_passwd);
                $avatar = @copy($sinauser_info['avatar_large '], BASE_UPLOAD_PATH. '/' . ATTACH_AVATAR . "/avatar_$result.jpg");
                $update_info = array();
                if ($avatar) {
                    $update_info['member_avatar'] = "avatar_$result.jpg";
                    $model_member->editMember(array('member_id' => $result), $update_info);
                }
                $member_info = $model_member->getMemberInfo(array('member_name' => $user_array['member_name']));
                $model_member->createSession($member_info, true);
                echo $this->fetch($this->template_dir.'connect_register');
            }
            else {
                $this->error(lang('login_usersave_regist_fail'), url('login/register'));
            }
        }
    }

    /**
     * 绑定新浪微博账号后自动登录
     */
    public function autologin()
    {
        //查询是否已经绑定该新浪微博账号,已经绑定则直接跳转
        $model_member = Model('member');
        $array = array();
        $array['member_sinaopenid'] = session('slast_key.uid');
        $member_info = $model_member->getMemberInfo($array);
        if (is_array($member_info) && count($member_info) > 0) {
            if (!$member_info['member_state']) {//1为启用 0 为禁用
                $this->error(lang('ds_notallowed_login'));
            }
            $model_member->createSession($member_info);
            $success_message = lang('login_index_login_success');
            $this->success($success_message, 'index/index');
        }
    }

    /**
     * 已有用户绑定新浪微博账号
     */
    public function bindsina()
    {
        $model_member = Model('member');
        //验证新浪账号用户是否已经存在
        $array = array();
        $array['member_sinaopenid'] = session('slast_key.uid');
        $member_info = $model_member->getMemberInfo($array);
        if (is_array($member_info) && count($member_info) > 0) {
            session('slast_key.uid',null);
            $this->error(lang('home_sconnect_binding_exist'), 'memberconnect/sinabind');
        }
        //处理sina账号信息
        require_once(APP_PATH . 'home/api/sina/saetv2.ex.class.php');
        $c = new \SaeTClientV2(config('sina_wb_akey'), config('sina_wb_skey'), session('slast_key.access_token'));
        $sinauser_info = $c->show_user_by_id(session('slast_key.uid'));//根据ID获取用户等基本信息
        $sina_arr = array();
        $sina_arr['name'] = $sinauser_info['name'];
        $sina_str = '';
        $sina_str = serialize($sina_arr);
        $edit_state = $model_member->editMember(array('member_id' => session('member_id')), array(
            'member_sinaopenid' => session('slast_key.uid'), 'member_sinainfo' => $sina_str
        ));
        if ($edit_state) {
            $this->success(lang('home_sconnect_binding_success'), 'memberconnect/sinabind');
        }
        else {
            $this->error(lang('home_sconnect_binding_fail'), 'memberconnect/sinabind');
        }
    }

    /**
     * 更换绑定新浪微博账号
     */
    public function changesina()
    {
        //如果用户已经登录，进入此链接则显示错误
        if (session('is_login') == '1') {
            $this->error(lang('home_sconnect_error'));
        }
        session('slast_key',null);
        $this->redirect('api/oa_sina');
        exit;
    }
}