<?php

namespace app\home\controller;

use think\Lang;
use think\Validate;

class Memberconnect extends BaseMember {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/zh-cn/memberconnect.lang.php');
    }

    /**
     * QQ绑定
     */
    public function qqbind() {
        //获得用户信息
        if (trim($this->member_info['member_qqinfo'])) {
            $this->member_info['member_qqinfoarr'] = unserialize($this->member_info['member_qqinfo']);
        }
        $this->assign('member_info', $this->member_info);
        //信息输出
        $this->setMemberCurItem('qq_bind');
        $this->setMemberCurMenu('member_connect');
        return $this->fetch($this->template_dir . 'member_qqbind');
    }

    /**
     * QQ解绑
     */
    public function qqunbind() {
        //修改密码
        $model_member = Model('member');
        $update_arr = array();
        if ($_POST['is_editpw'] == 'yes') {
            /**
             * 填写密码信息验证
             */
            $data = array(
                'new_password' => input('post.new_password'),
                'confirm_password' => input('post.confirm_password')
            );
            $rule = array(
                array('new_password', 'require|length:6,20', lang('member_qqconnect_password_null')),
                array('confirm_password', 'require|requireIf:new_password,1', lang('member_qqconnect_input_two_password_again'))
            );
            $obj_validate = new Validate($rule);
            $error = $obj_validate->check($data);
            if (!$error) {
                $this->error($obj_validate->getError());
            }
            $update_arr['member_password'] = md5(trim($_POST['new_password']));
        }
        $update_arr['member_qqopenid'] = '';
        $update_arr['member_qqinfo'] = '';
        $edit_state = $model_member->editMember(array('member_id' => session('member_id')), $update_arr);
        if (!$edit_state) {
            $this->error(lang('member_qqconnect_password_modify_fail'),url('Memberconnect/qqbind'));
        }
       session(null);
        $this->success(lang('member_qqconnect_unbind_success'), 'login/login?ref_url=' . urlencode(url('memberconnect/qqbind')));
    }

    /**
     * 新浪绑定
     */
    public function sinabind() {
        //获得用户信息
        if (trim($this->member_info['member_sinainfo'])) {
            $this->member_info['member_sinainfoarr'] = unserialize($this->member_info['member_sinainfo']);
        }
        $this->assign('member_info', $this->member_info);
        //信息输出
        $this->setMemberCurItem('sina_bind');
        $this->setMemberCurMenu('member_connect');
        return $this->fetch($this->template_dir . 'member_sinabind');
    }

    /**
     * 新浪解绑
     */
    public function sinaunbind() {
        //修改密码
        $model_member = Model('member');
        $update_arr = array();
        if ($_POST['is_editpw'] == 'yes') {
            /**
             * 填写密码信息验证
             */
            $obj_validate = new Validate();
            $data = array(
                'new_password' => input('post.new_password'),
                'confirm_password' => input('post.confirm_password')
            );
            $rule = array(
                array('new_password', 'require|ength:6,20', lang('member_sconnect_password_null')),
                array('confirm_password', 'require|requireIf:new_password,1', lang('member_sconnect_input_two_password_again'))
            );

            $error = $obj_validate->check($data, $rule);
            if (!$error) {
                $this->error($obj_validate->getError());
            }
            $update_arr['member_password'] = md5(trim($_POST['new_password']));
        }
        $update_arr['member_sinaopenid'] = '';
        $update_arr['member_sinainfo'] = '';
        $edit_state = $model_member->editMember(array('member_id' => session('member_id')), $update_arr);

        if (!$edit_state) {
            $this->error(lang('member_sconnect_password_modify_fail'));
        }
       session(null);
        $this->success(lang('member_sconnect_unbind_success'), 'login/login?ref_url=' . urlencode(url('memberconnect/sinabind')));
    }

    /**
     * 微信绑定
     */
    public function weixinbind() {
        //获得用户信息
        if (trim($this->member_info['weixin_info'])) {
            $this->member_info['weixin_infoarr'] = unserialize($this->member_info['weixin_info']);
        }
        $this->assign('member_info', $this->member_info);
        //信息输出
        $this->setMemberCurMenu('member_connect');
        $this->setMemberCurItem('weixin_bind');
        return $this->fetch($this->template_dir . 'member_weixinbind');
    }

    /**
     * 微信解绑
     */
    public function weixinunbind() {
        //修改密码
        $model_member = Model('member');
        $update_arr = array();
        if ($_POST['is_editpw'] == 'yes') {
            /**
             * 填写密码信息验证
             */
            $obj_validate = new Validate();
            $data=[
                'new_password'=>$_POST["new_password"],
                'confirm_password'=>$_POST["confirm_password"]
            ];

            $rule=[
                ['new_password','require|length:6,20',lang('member_sconnect_password_null')],
                ['confirm_password','require|confirm:new_password',lang('member_sconnect_input_two_password_again')]
            ];
            $error=$obj_validate->check($data,$rule);

            if (!$error) {
               $this->error($obj_validate->getError());
            }
            $update_arr['member_password'] = md5(trim($_POST['new_password']));
        }
        $update_arr['weixin_unionid'] = '';
        $update_arr['weixin_info'] = '';
        $edit_state = $model_member->editMember(array('member_id' => session('member_id')), $update_arr);
        if (!$edit_state) {
            $this->error('保存失败');
        }
       session(null);
       $this->success('微信解绑成功', 'login/login?ref_url='. urlencode(url('memberconnect/weixinbind')));
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string	$menu_type	导航类型
     * @param string 	$name	当前导航的name
     * @param array 	$array		附加菜单
     * @return
     */
    protected function getMemberItemList() {
        $menu_array = array(
            array('name' => 'qq_bind', 'text' => lang('ds_member_path_qq_bind'), 'url' => url('memberconnect/qqbind')),
            array('name' => 'sina_bind', 'text' => lang('ds_member_path_sina_bind'), 'url' => url('memberconnect/sinabind')),
            array('name' => 'weixin_bind', 'text' => '微信绑定', 'url' => url('memberconnect/weixinbind')),
        );
        return $menu_array;
    }

}