<?php

namespace app\home\controller;


use think\Lang;
use think\Validate;

class Memberinform extends BaseMember
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/zh-cn/memberinfom.lang.php');
    }

    /*
         * 获取当前用户的举报列表
         */
    public function index()
    {
        /*
         * 得到当前用户的举报列表
         */
        $model_inform = Model('inform');
        $condition = array();
        $condition['inform_state'] = intval(input('param.select_inform_state'));
        $condition['inform_member_id'] = session('member_id');
        $condition['order'] = 'inform_id desc';
        $list = $model_inform->getInform($condition, 10);
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('member_inform');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('inform_list');
        $this->assign('list', $list);
        $this->assign('show_page', $model_inform->page_info->render());
        return $this->fetch($this->template_dir.'index');
    }

    /*
     * 提交举报商品
     */
    public function inform_submit()
    {

        //检查当前用户是否允许举报
        $this->check_member_allow_inform();

        $goods_id = intval(input('param.goods_id'));

        //获取商品详细信息
        $goods_info = $this->get_goods_info_byid($goods_id);

        //检查是否是本店商品
        if (!empty(session('store_id'))) {
            if ($goods_info['store_id'] == session('store_id')) {
                $this->error(lang('para_error'));
            }
        }

        $model_inform = Model('inform');
        //检查是否当前正在举报
        if ($model_inform->isProcessOfInform($goods_id)) {
            $this->error(lang('inform_handling'));
        }

        //获取举报类型
        $model_inform_subject_type = Model('informsubjecttype');
        $inform_subject_type_list = $model_inform_subject_type->getActiveInformSubjectType();
        if (empty($inform_subject_type_list)) {
            $this->error(lang('inform_type_null'));
        }
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('member_inform');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('inform_list');

        $this->assign('goods_info', $goods_info);
        $this->assign('type_list', $inform_subject_type_list);
        return $this->fetch($this->template_dir.'inform_submit');
    }

    /*
     * 保存用户提交的商品举报
     */
    public function inform_save()
    {

        //检查当前用户是否允许举报
        $this->check_member_allow_inform();

        $goods_id = intval($_POST['inform_goods_id']);

        //获取商品详细信息
        $goods_info = $this->get_goods_info_byid($goods_id);

        //检查是否是本店商品
        if (!empty(session('store_id'))) {
            if ($goods_info['store_id'] == session('store_id')) {
                showDialog(lang('para_error'));
            }
        }

        //实例化举报模型
        $model_inform = Model('inform');
        //检查是否当前正在举报
        if ($model_inform->isProcessOfInform($goods_id)) {
            showDialog(lang('inform_handling'));
        }
        //处理用户输入的数据
        $input = array();
        $input['inform_member_id'] = session('member_id');
        $input['inform_member_name'] = session('member_name');
        $input['inform_goods_id'] = $goods_id;
        $input['inform_goods_name'] = $goods_info['goods_name'];
        $input['inform_goods_image'] = $goods_info['goods_image'];
       // halt(explode(",", trim($_POST['inform_subject'])));
        list($input['inform_subject_id'], $input['inform_subject_content']) = explode(",", trim($_POST['inform_subject']));
        $input['inform_content'] = trim($_POST['inform_content']);

        //上传图片
        $inform_pic = array();
        $inform_pic[1] = 'inform_pic1';
        $inform_pic[2] = 'inform_pic2';
        $inform_pic[3] = 'inform_pic3';
        /*$pic_name             = $this->inform_upload_pic($inform_pic);*/
        $input['inform_pic1'] = '';
        $input['inform_pic2'] = '';
        $input['inform_pic3'] = '';

        $input['inform_datetime'] = time();
        $input['inform_store_id'] = $goods_info['store_id'];
        $input['inform_store_name'] = $goods_info['store_name'];
        $input['inform_state'] = 1;
        $input['inform_handle_message'] = '';
        $input['inform_handle_member_id'] = 0;
        $input['inform_handle_datetime'] = 1;

        //验证输入的数据
        $obj_validate = new Validate();
        $data = [
            'inform_content' => $input["inform_content"],
            'inform_subject_content' => $input["inform_subject_content"]
        ];
        $rule=[
            ['inform_content','require|max:100|min:1',lang('inform_content_null')],
            ['inform_subject_content','require|max:50|min:1',lang('para_error')]
        ];

        $error = $obj_validate->check($data,$rule);
        if (!$error) {
            showDialog($obj_validate->getError());
        }

        //保存
        if ($model_inform->saveInform($input)) {
            showDialog(lang('inform_success'), url('memberinform/index'), 'succ');
        } else {
            showDialog(lang('inform_fail'),url('memberinform/index'), 'error');
        }
    }


    /*
     * 取消用户提交的商品举报
     */
    public function inform_cancel()
    {

        $inform_id = intval(input('param.inform_id'));
        $inform_info = $this->get_inform_info($inform_id);

        if (intval($inform_info['inform_state']) === 1) {
            $pics = array();
            if (!empty($inform_info['inform_pic1'])) {
                $pics[] = $inform_info['inform_pic1'];
            }
            if (!empty($inform_info['inform_pic2'])) {
                $pics[] = $inform_info['inform_pic2'];
            }
            if (!empty($inform_info['inform_pic3'])) {
                $pics[] = $inform_info['inform_pic3'];
            }
            $this->drop_inform($inform_id, $pics);
            showDialog(lang('inform_cancel_success'), 'reload', 'succ');
        } else {
            showDialog(lang('inform_cancel_fail'), '', 'error');
        }
    }


    /**
     * 商品举报详细
     */
    public function inform_info()
    {

        $inform_id = intval(input('param.inform_id'));
        $inform_info = $this->get_inform_info($inform_id);
        $this->assign('inform_info', $inform_info);
        // 商品信息
        $goods_info = Model('goods')->getGoodsInfoByID($inform_info['inform_goods_id']);
        $this->assign('goods_info', $goods_info);
        // 投诉类型
        $subject_info = Model('informsubject')->getInformSubject(array('in_inform_subject_id' => $inform_info['inform_subject_id']));
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('member_inform');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('inform_list');
        $this->assign('subject_info', $subject_info[0]);
        return $this->fetch($this->template_dir.'inform_info');
    }


    /*
     * 根据id获取投诉详细信息
     */
    private function get_inform_info($inform_id)
    {

        if (empty($inform_id)) {
            $this->error(lang('para_error'));
        }

        $model_inform = Model('inform');
        $inform_info = $model_inform->getoneInform($inform_id);

        if (empty($inform_info)) {
            $this->error(lang('para_error'));
        }

        if (intval($inform_info['inform_member_id']) !== intval(session('member_id'))) {
            $this->error(lang('para_error'));
        }

        return $inform_info;

    }


    /*
     * 根据id获取投诉详细信息
     */
    private function drop_inform($inform_id, $inform_pics)
    {

        $model_inform = Model('inform');
        //删除图片
        if (!empty($inform_pics)) {
            foreach ($inform_pics as $pic) {
                $this->inform_delete_pic($pic);
            }
        }
        $model_inform->dropInform(array('inform_id' => $inform_id));
    }

    /*
     * 根据id获取商品详细信息
     */
    private function get_goods_info_byid($goods_id)
    {

        if (empty($goods_id)) {
            $this->error(lang('para_error'));
        }

        $model_goods = Model('goods');
        $goods_info = $model_goods->getGoodsOnlineInfoByID($goods_id);

        //检查该商品是否存在
        if (empty($goods_info)) {
            $this->error(lang('goods_null'));
        }

        return $goods_info;
    }


    /*
     * 检查当前用户是否允许举报
     */
    private function check_member_allow_inform()
    {

        //检查是否允许举报
        $model_member = Model('member');
        if (!$model_member->isMemberAllowInform(session('member_id'))) {
            $this->error(lang('deny_inform'));
        }
    }

    /*
     * 上传用户提供的举报图片
     */
    private function inform_upload_pic($inform_pic)
    {

        $pic_name = array();
        $upload = new UploadFile();
        $uploaddir = ATTACH_PATH . DS . 'inform' . DS;
        $upload->set('default_dir', $uploaddir);
        $upload->set('allow_type', array(
            'jpg',
            'jpeg',
            'gif',
            'png'
        ));
        $count = 1;
        foreach ($inform_pic as $pic) {
            if (!empty($_FILES[$pic]['name'])) {
                $result = $upload->upfile($pic);
                if ($result) {
                    $pic_name[$count] = $upload->file_name;
                    $upload->file_name = '';
                } else {
                    $pic_name[$count] = '';
                }
            }
            $count++;
        }

        return $pic_name;

    }

    /*
     * 上传用户提供的举报图片
     */
    private function inform_delete_pic($pic_name)
    {

        //上传路径
        $pic = BASE_UPLOAD_PATH . DS . ATTACH_PATH . DS . 'inform' . DS . $pic_name;
        if (file_exists($pic)) {
            @unlink($pic);
        }

    }


    /*
     * 获取文件名
     */
    private function get_pic_filename()
    {
        return date('Ymd') . substr(implode(null, array_map('ord', str_split(substr(uniqid(), 7, 13), 1))), -8, 8);
    }


    /*
     * 根据举报类型id获取，举报具体列表
     */
    public function get_subject_by_typeid()
    {

        $inform_subject_type_id = intval(input('param.type_id'));
        if (empty($inform_subject_type_id)) {
            echo '';
        } else {
            /*
             * 获得举报主题列表
             */
            $model_inform_subject = Model('informsubject');

            //搜索条件
            $condition = array();
            $condition['order'] = 'inform_subject_id asc';
            $condition['inform_subject_type_id'] = $inform_subject_type_id;
            $condition['inform_subject_state'] = 1;
            $inform_subject_list = $model_inform_subject->getInformSubject($condition, 10, 'inform_subject_id,inform_subject_content');

            echo json_encode($inform_subject_list);

        }
    }


    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $menu_key 当前导航的menu_key
     * @param array $array 附加菜单
     *
     * @return
     */
    public function getMemberItemList()
    {
        $menu_array = array(
            array(
                'name' => 'inform_list',
                'text' => '违规举报',
                'url' => url('memberinform/index')
            ),
        );

        return $menu_array;
    }

}