<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2017/9/16
 * Time: 16:49
 */

namespace app\home\controller;


use think\Validate;

class Membermallconsult extends BaseMember
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    /**
     * 平台客服咨询首页
     */
    public function index()
    {
        // 咨询列表
        $model_mallconsult = Model('mallconsult');
        $consult_list = $model_mallconsult->getMallConsultList(array('member_id' => session('member_id')), '*', '10');
        $this->assign('consult_list', $consult_list);
        $this->assign('show_page', $model_mallconsult->page_info->render());

        // 回复状态
        $this->typeState();
        $this->setMemberCurMenu();
        $this->setMemberCurItem('consult_list');
        return $this->fetch($this->template_dir . 'member_mallconsult_list');
    }

    /**
     * 平台咨询详细
     */
    public function mallconsult_info()
    {
        $id = intval(input('param.id'));
        if ($id <= 0) {
            showDialog(lang('wrong_argument'));
        }
        // 咨询详细信息
        $consult_info = Model('mallconsult')->getMallConsultInfo(array(
                                                                     'mc_id' => $id, 'member_id' => session('member_id')
                                                                 ));
        $this->assign('consult_info', $consult_info);

        // 咨询类型列表
        $type_list = Model('mallconsulttype')->getMallConsultTypeList(array(), 'mct_id,mct_name', 'mct_id');
        $this->assign('type_list', $type_list);

        // 回复状态
        $this->typeState();

        return $this->fetch($this->template_dir . 'member_mallconsult_info');
    }

    /**
     * 添加平台客服咨询
     */
    public function add_mallconsult()
    {
        // 咨询类型列表
        $type_list = Model('mallconsulttype')->getMallConsultTypeList(array());
        $this->assign('type_list', $type_list);
        if (input('param.inajax')) {
            return $this->fetch($this->template_dir . 'add_inajax');
        }
        else {
            return $this->fetch($this->template_dir . 'member_mallconsult_add');
        }
    }

    /**
     * 保存平台咨询
     */
    public function save_mallconsult()
    {
        if (!request()->isPost()) {
            showDialog(lang('wrong_argument'), 'reload');
        }

        //验证表单信息
        $obj_validate = new Validate();
        $data=[
            'type_id'=>input('type_id'),
            'consult_content'=>input('consult_content')
        ];

        $rule=[
            ['type_id','require|number','请选择咨询类型'],
            ['consult_content','require','请填写咨询内容']
        ];
       $error=$obj_validate->check($data,$rule);
        if (!$error) {
            showDialog($obj_validate->getError());
        }

        $insert = array();
        $insert['mct_id'] = $_POST['type_id'];
        $insert['member_id'] = session('member_id');
        $insert['member_name'] = session('member_name');
        $insert['mc_content'] = $_POST['consult_content'];

        $result = Model('mallconsult')->addMallConsult($insert);
        if ($result) {
            showDialog(lang('ds_common_op_succ'), 'reload', 'succ');
        }
        else {
            showDialog(lang('ds_common_op_fail'), 'reload');
        }
    }

    /**
     * 删除平台客服咨询
     */
    public function del_mallconsultOp()
    {
        $id = intval($_GET['id']);
        if ($id <= 0) {
            showDialog(lang('wrong_argument'));
        }

        $result = Model('mall_consult')->delMallConsult(array('mc_id' => $id, 'member_id' => session('member_id')));
        if ($result) {
            showDialog(lang('ds_common_del_succ'), 'reload', 'succ');
        }
        else {
            showDialog(lang('ds_common_del_fail'));
        }
    }

    /**
     * 咨询的回复状态
     */
    private function typeState()
    {
        $state = array('0' => '未回复', '1' => '已回复');
        $this->assign('state', $state);
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_key 当前导航的menu_key
     * @return
     */
    protected function getMemberItemList()
    {
        $menu_array = array(
             array(
                'name' => 'consult_list', 'text' => '平台客服咨询列表',
                'url' => url('membermallconsult/index')
            ),
        );
       return $menu_array;
    }
}