<?php

namespace app\home\controller;


use think\Lang;

class Memberpointorder extends BaseMember
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/zh-cn/memberpoints.lang.php');
    }

    /**
     * 兑换信息列表
     */
    public function index()
    {
        //兑换信息列表
        $where = array();
        $where['point_buyerid'] = session('member_id');

        $model_pointorder = Model('pointorder');
        $order_list = $model_pointorder->getPointOrderList($where, '*', 10, 0, 'point_orderid desc');
        $order_idarr = array();
        $order_listnew = array();
        if (is_array($order_list) && count($order_list) > 0) {
            foreach ($order_list as $k => $v) {
                $order_listnew[$v['point_orderid']] = $v;
                $order_idarr[] = $v['point_orderid'];
            }
        }

        //查询兑换商品
        if (is_array($order_idarr) && count($order_idarr) > 0) {
            $prod_list = $model_pointorder->getPointOrderGoodsList(array(
                'point_orderid' => array(
                    'in',
                    $order_idarr
                )
            ));
            if (is_array($prod_list) && count($prod_list) > 0) {
                foreach ($prod_list as $v) {
                    if (isset($order_listnew[$v['point_orderid']])) {
                        $order_listnew[$v['point_orderid']]['prodlist'][] = $v;
                    }
                }
            }
        }

        //信息输出
        $this->assign('order_list', $order_listnew);
        $this->assign('page', $model_pointorder->page_info->render());
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('member_point');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('orderlist');
        return $this->fetch($this->template_dir.'index');
    }

    /**
     *    取消兑换
     */
    public function cancel_order()
    {
        $model_pointorder = Model('pointorder');
        //取消订单
        $data = $model_pointorder->cancelPointOrder(input('param.order_id'), session('member_id'));
        if ($data['state']) {
            showDialog(lang('member_pointorder_cancel_success'), url('memberpointorder/index'), 'succ');
        } else {
            showDialog($data['msg'], url('memberpointorder/index'), 'error');
        }
    }

    /**
     * 确认收货
     */
    public function receiving_order()
    {
        $data = Model('pointorder')->receivingPointOrder(input('param.order_id'));
        if ($data['state']) {
            showDialog(lang('member_pointorder_confirmreceiving_success'), url('memberpointorder/index'), 'succ');
        } else {
            showDialog($data['msg'], url('memberpointorder/index'), 'error');
        }
    }

    /**
     * 兑换信息详细
     */
    public function order_info()
    {
        $order_id = intval(input('order_id'));
        if ($order_id <= 0) {
            showDialog(lang('member_pointorder_parameter_error'), url('memberpointorder/index'), 'error');
        }
        $model_pointorder = Model('pointorder');
        //查询兑换订单信息
        $where = array();
        $where['point_orderid'] = $order_id;
        $where['point_buyerid'] = session('member_id');
        $order_info = $model_pointorder->getPointOrderInfo($where);
        if (!$order_info) {
            showDialog(lang('member_pointorder_record_error'), url('memberpointorder/index'), 'error');
        }
        //获取订单状态
        $pointorderstate_arr = $model_pointorder->getPointOrderStateBySign();
        $this->assign('pointorderstate_arr', $pointorderstate_arr);

        //查询兑换订单收货人地址
        $orderaddress_info = $model_pointorder->getPointOrderAddressInfo(array('point_orderid' => $order_id));
        $this->assign('orderaddress_info', $orderaddress_info);

        //兑换商品信息
        $prod_list = $model_pointorder->getPointOrderGoodsList(array('point_orderid' => $order_id));
        $this->assign('prod_list', $prod_list);

        //物流公司信息
        if ($order_info['point_shipping_ecode'] != '') {
            $data = Model('express')->getExpressInfoByECode($order_info['point_shipping_ecode']);
            if ($data['state']) {
                $express_info = $data['data']['express_info'];
            }
            $this->assign('express_info', $express_info);
        }

        $this->assign('order_info', $order_info);
        $this->assign('left_show', 'order_view');
        return $this->fetch($this->template_dir.'member_pointorder_info');
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $menu_key 当前导航的menu_key
     * @return
     */
    public function getMemberItemList()
    {
       
        $menu_array = array();
        if(request()->action()=='index'){
                $menu_array = array(
                   array(
                        'name' => 'points',
                        'text' => lang('ds_member_path_points'),
                        'url' => url('memberpoints/index')
                    ),
                    array(
                        'name' => 'orderlist',
                        'text' => lang('member_pointorder_list_title'),
                        'url' => url('memberpointorder/orderlist')
                    )
                );
        }
        if(request()->action()=='orderlistin'){
                $menu_array = array(
                    array(
                        'name' => 'points',
                        'text' => lang('ds_member_path_points'),
                        'url' => url('memberpoints/index')
                    ),
                     array(
                        'name' => 'orderlist',
                        'text' => lang('ds_member_path_pointorder_list'),
                        'url' => url('memberpointorder/orderlist')
                    ),
                     array(
                        'name' => 'orderinfo',
                        'text' => lang('ds_member_path_pointorder_info'),
                        ''
                    )
                );
        }
       return $menu_array;
    }
}