<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2017/11/9
 * Time: 16:55
 */

namespace app\home\controller;


class Pointgrade extends BasePointShop
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        if (session('is_login') != '1'){
            showDialog(lang('no_login'),url('login/login'), 'error');
        }
    }

    public function index(){
        //查询会员及其附属信息
        $result = parent::pointshopMInfo(true);
        $member_info = $result['member_info'];
        unset($result);

        $model_member = Model('member');
        //获得会员升级进度
        $membergrade_arr = $model_member->getMemberGradeArr(true, $member_info['member_exppoints'],$member_info['level']);
        $this->assign('membergrade_arr', $membergrade_arr);

        //处理经验值计算说明文字
        $exppoints_rule = config("exppoints_rule")?unserialize(config("exppoints_rule")):array();
        $ruleexplain_arr = array();
        $exppoints_rule['exp_orderrate'] = floatval($exppoints_rule['exp_orderrate']);
        if ($exppoints_rule['exp_orderrate'] > 0){
            $ruleexplain_arr['exp_order'] = "经验值以有效购物金额作为计算标准，有效购物金额{$exppoints_rule['exp_orderrate']}元=1经验值；";
            $exp_ordermax = intval($exppoints_rule['exp_ordermax']);
            if ($exp_ordermax > 0){
                $ruleexplain_arr['exp_order'] .= "单个订单最多获得{$exppoints_rule['exp_ordermax']}经验值；";
            }
        }
        $exppoints_rule['exp_login'] = intval($exppoints_rule['exp_login']);
        if ($exppoints_rule['exp_login'] > 0){
            $ruleexplain_arr['exp_login'] = "会员每天第一次登录获得{$exppoints_rule['exp_login']}经验值；";
        }
        $exppoints_rule['exp_comments'] = intval($exppoints_rule['exp_comments']);
        if ($exppoints_rule['exp_comments'] > 0){
            $ruleexplain_arr['exp_comments'] = "进行一次订单商品评价将获得{$exppoints_rule['exp_comments']}经验值；";
        }
        $this->assign('ruleexplain_arr', $ruleexplain_arr);

        //分类导航
        $nav_link = array(
            0=>array('title'=>lang('homepage'),'link'=>SHOP_SITE_URL),
            1=>array('title'=>lang('ds_pointprod'),'link'=>url('pointshop/index')),
            2=>array('title'=>'我的成长进度')
        );
        $this->assign('nav_link_list', $nav_link);
        return $this->fetch($this->template_dir.'pointgrade');
    }
    /**
     * 经验明细列表
     */
    public function exppointlog(){
        //查询会员及其附属信息
        $result = parent::pointshopMInfo();

        //查询积分日志列表
        $model_exppoints = Model('exppoints');
        $where = array();
        $where['exp_memberid'] = session('member_id');
        $list_log = $model_exppoints->getExppointsLogList($where, '*', 20, 0, 'exp_id desc');
        //信息输出
        $this->assign('stage_arr',$model_exppoints->getStage());
        $this->assign('show_page', $model_exppoints->page_info->render());
        $this->assign('list_log',$list_log);
        //分类导航
        $nav_link = array(
            0=>array('title'=>lang('homepage'),'link'=>SHOP_SITE_URL),
            1=>array('title'=>lang('ds_pointprod'),'link'=>url('pointshop/index')),
            2=>array('title'=>'经验值明细')
        );
        $this->assign('nav_link_list', $nav_link);
        return $this->fetch($this->template_dir.'point_exppointslog');
    }
}