<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2017/11/10
 * Time: 11:12
 */

namespace app\home\controller;


use think\Lang;

class Pointvoucher extends BasePointShop
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH.'home/lang/zh-cn/voucher.lang.php');
        if (config('voucher_allow') != 1){
            showDialog(lang('voucher_pointunavailable'),'index.php','error');
        }
    }

    public function index(){
        $this->pointvoucher();
        return $this->fetch($this->template_dir.'pointvoucher');
    }
    /**
     * 代金券列表
     */
    public function pointvoucher(){
        //查询会员及其附属信息
        parent::pointshopMInfo();

        $model_voucher = Model('voucher');

        //代金券模板状态
        $templatestate_arr = $model_voucher->getTemplateState();

        //查询会员信息
        $member_info = Model('member')->getMemberInfoByID(session('member_id'));

        //查询代金券列表
        $where = array();
        $where['voucher_t_state'] = $templatestate_arr['usable'][0];
        $where['voucher_t_end_date'] = array('gt',time());
        if (intval(input('sc_id')) > 0){
            $where['voucher_t_sc_id'] = intval(input('sc_id'));
        }
        if (intval(input('price')) > 0){
            $where['voucher_t_price'] = intval(input('price'));
        }
        //查询仅我能兑换和所需积分
        $points_filter = array();
        if (intval(input('isable')) == 1){
            $points_filter['isable'] = $member_info['member_points'];
        }
        if (intval(input('points_min')) > 0){
            $points_filter['min'] = intval(input('points_min'));
        }
        if (intval(input('points_max')) > 0){
            $points_filter['max'] = intval(input('points_max'));
        }
        if (count($points_filter) > 0){
            asort($points_filter);
            if (count($points_filter) > 1){
                $points_filter = array_values($points_filter);
                $where['voucher_t_points'] = array('between',array($points_filter[0],$points_filter[1]));
            } else {
                if ($points_filter['min']){
                    $where['voucher_t_points'] = array('egt',$points_filter['min']);
                } elseif ($points_filter['max']) {
                    $where['voucher_t_points'] = array('elt',$points_filter['max']);
                } elseif ($points_filter['isable']) {
                    $where['voucher_t_points'] = array('elt',$points_filter['isable']);
                }
            }
        }
        //排序
        switch (input('orderby')){
            case 'exchangenumdesc':
                $orderby = 'voucher_t_giveout desc,';
                break;
            case 'exchangenumasc':
                $orderby = 'voucher_t_giveout asc,';
                break;
            case 'pointsdesc':
                $orderby = 'voucher_t_points desc,';
                break;
            case 'pointsasc':
                $orderby = 'voucher_t_points asc,';
                break;
            default:
                $orderby = '';
        }
        $orderby .= 'voucher_t_id desc';
        $voucherlist = $model_voucher->getVoucherTemplateList($where, '*', 0, 18, $orderby);
        $this->assign('voucherlist',$voucherlist);
        $this->assign('show_page', $model_voucher->page_info->render());

        //查询代金券面额
        $pricelist = $model_voucher->getVoucherPriceList();
        $this->assign('pricelist',$pricelist);

        //查询店铺分类
        $store_class = rkcache('store_class', true);
        $this->assign('store_class', $store_class);

        //分类导航
        $nav_link = array(
            0=>array('title'=>lang('homepage'),'link'=>SHOP_SITE_URL),
            1=>array('title'=>'积分中心','link'=>url('pointshop/index')),
            2=>array('title'=>'代金券列表')
        );
        $this->assign('nav_link_list', $nav_link);
    }
    /**
     * 兑换代金券
     */
    public function voucherexchange(){
        $vid = intval(input('vid'));
        if(session('is_login') != '1'){
            $js = "login_dialog();";
            showDialog('','','js',$js);
        }elseif (input('dialog')){
            $js = "CUR_DIALOG = ajax_form('vexchange', '".lang('home_voucher_exchangtitle')."', 'index.php/pointvoucher/voucherexchange?vid={$vid}', 550);";
            showDialog('','','js',$js);
            die;
        }
        $result = true;
        $message = "";
        if ($vid <= 0){
            $result = false;
            lang('wrong_argument');
        }
        if ($result){
            //查询可兑换代金券模板信息
            $template_info = Model('voucher')->getCanChangeTemplateInfo($vid,intval(session('member_id')),intval(session('store_id')));
            if ($template_info['state'] == false){
                $result = false;
                $message = $template_info['msg'];
            }else {
                //查询会员信息
                $member_info = Model('member')->getMemberInfoByID(session('member_id'),'member_points');
                $this->assign('member_info',$member_info);
                $this->assign('template_info',$template_info['info']);
            }
        }
        $this->assign('message',$message);
        $this->assign('result',$result);
        echo $this->fetch($this->template_dir.'exchange');
    }
    /**
     * 兑换代金券保存信息
     *
     */
    public function voucherexchange_save(){
        if(session('is_login') != '1'){
            $js = "login_dialog();";
            showDialog('','','js',$js);
        }
        $vid = intval($_POST['vid']);
        $js = "DialogManager.close('vexchange');";
        if ($vid <= 0){
            showDialog(lang('wrong_argument'),'','error',$js);
        }
        $model_voucher = Model('voucher');
        //验证是否可以兑换代金券
        $data = $model_voucher->getCanChangeTemplateInfo($vid,intval(session('member_id')),intval(session('store_id')));
        if ($data['state'] == false){
            showDialog($data['msg'],'','error',$js);
        }
        //添加代金券信息
        $data = $model_voucher->exchangeVoucher($data['info'],session('member_id'),session('member_name'));
        if ($data['state'] == true){
            showDialog($data['msg'],'','succ',$js);
        } else {
            showDialog($data['msg'],'','error',$js);
        }
    }
    
}