<?php

namespace app\home\controller;


use think\Lang;

class Sellergoodsclass extends BaseSeller
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    /**
     * 卖家商品分类
     *
     * @param
     * @return
     */
    public function index()
    {
        $model_class = Model('storegoodsclass');
            $goods_class = $model_class->getTreeClassList(array('store_id' => session('store_id')), 2);
            $str = '';
            if (is_array($goods_class) and count($goods_class) > 0) {
                foreach ($goods_class as $key => $val) {
                    $row[$val['stc_id']] = $key + 1;
                    if ($val['stc_parent_id'] != '0')
                        $str .= intval($row[$val['stc_parent_id']]) . ",";
                }
                $str = substr($str, 0, -1);
            }
            else {
                $str = '0';
            }
            $this->assign('map', $str);
            $this->assign('class_num', count($goods_class) - 1);
            $this->assign('goods_class', $goods_class);

            $this->setSellerCurMenu('sellergoodsclass');
            $this->setSellerCurItem('index');
            return $this->fetch($this->template_dir . 'index');
    }

    /*分类添加*/
    public function goods_class_add(){
        $model_class = Model('storegoodsclass');
        $goods_class = $model_class->getStoreGoodsClassList(array(
                                                                'store_id' => session('store_id'),
                                                                'stc_parent_id' => 0
                                                            ));
        $this->assign('goods_class', $goods_class);
        $this->assign('class_info', array('stc_parent_id'=>input('top_class_id')));
        $this->assign('type','add');
        return $this->fetch($this->template_dir . 'class_add');
    }
    /*分类编辑*/
    public function goods_class_edit(){
        $class_id=input('param.top_class_id');
        $model_class = Model('storegoodsclass');
        $class_info = $model_class->getStoreGoodsClassInfo(array('stc_id' => intval($class_id)));
        $goods_class = $model_class->getStoreGoodsClassList(array(
                                                                'store_id' => session('store_id'),
                                                                'stc_parent_id' => 0
                                                            ));
        $this->assign('goods_class', $goods_class);
        $this->assign('class_info', $class_info);
        $this->assign('type','edit');
        return $this->fetch($this->template_dir . 'class_add');
    }

    /**
     * 卖家商品分类保存
     *
     * @param
     * @return
     */
    public function goods_class_save()
    {
        $model_class = Model('storegoodsclass');
        if ($_POST['type']=='edit') {

            $stc_id = intval($_POST['stc_id']);
            if ($stc_id <= 0) {
                showDialog(lang('wrong_argument'));
            }
            $class_array = array();
            if ($_POST['stc_name'] != '') {
                $class_array['stc_name'] = $_POST['stc_name'];
            }
            if ($_POST['stc_parent_id'] != '') {
                $class_array['stc_parent_id'] = $_POST['stc_parent_id'];
            }
            if ($_POST['stc_state'] != '') {
                $class_array['stc_state'] = $_POST['stc_state'];
            }
            if ($_POST['stc_sort'] != '') {
                $class_array['stc_sort'] = $_POST['stc_sort'];
            }
            $where = array();
            $where['store_id'] = session('store_id');
            $where['stc_id'] = intval($_POST['stc_id']);
            $state = $model_class->editStoreGoodsClass($class_array, $where);
            if ($state) {
                showDialog(lang('ds_common_save_succ'), url('Sellergoodsclass/index'), 'succ', !(input('param.inajax')) ? '' : 'CUR_DIALOG.close();');
            }
            else {
                showDialog(lang('ds_common_save_fail'));
            }
        }
        else {
            $class_array = array();
            $class_array['stc_name'] = $_POST['stc_name'];
            $class_array['stc_parent_id'] = isset($_POST['stc_parent_id']) ? $_POST['stc_parent_id'] : '0';
            $class_array['stc_state'] = $_POST['stc_state'];
            $class_array['store_id'] = session('store_id');
            $class_array['stc_sort'] = $_POST['stc_sort'];
            $state = $model_class->addStoreGoodsClass($class_array);
            if ($state) {
                showDialog(lang('ds_common_save_succ'), url('Sellergoodsclass/index'), 'succ', !(input('param.inajax')) ? '' : 'CUR_DIALOG.close();');
            }
            else {
                showDialog(lang('ds_common_save_fail'));
            }
        }
    }

    /**
     * 卖家商品分类删除
     *
     * @param
     * @return
     */
    public function drop_goods_class()
    {
        $model_class = Model('storegoodsclass');
        $stcid_array = explode(',', input('param.class_id'));

        foreach ($stcid_array as $key => $val) {
            if (!is_numeric($val))
                unset($stcid_array[$key]);
        }

        $where = array();
        $where['stc_id'] = array('in', $stcid_array);
        $where['store_id'] = session('store_id');

        $drop_state = $model_class->delStoreGoodsClass($where);
        if ($drop_state) {
            showDialog(lang('ds_common_del_succ'), url('Sellergoodsclass/index'), 'succ');
        }
        else {
            showDialog(lang('ds_common_del_fail'));
        }
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $name 当前导航的name
     * @return
     */
    protected function getSellerItemList()
    {
        $menu_array = array(
             array(
                'name' => 'index', 'text' => '店铺分类', 'url' => url('Sellergoodsclass/index')
            )
        );
        return $menu_array;
    }
}