<?php
/**
 * 导航栏
 * Date: 2017/6/27
 * Time: 17:01
 */

namespace app\home\controller;

use think\Lang;

class Sellernavigation extends BaseSeller
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    /**
     *导航列表
     */
    public function index()
    {
        $model_store_navigation = Model('storenavigation');
        $navigation_list = $model_store_navigation->getStoreNavigationList(array('sn_store_id' => session('store_id')));
        $this->assign('navigation_list', $navigation_list);
        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('seller_navigation');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('store_navigation');
        return $this->fetch($this->template_dir.'index');
    }

    public function navigation_add()
    {
        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('seller_navigation');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('navigation_add');
        /* 所见即所得编辑器 */
        $this->assign('build_editor', buildEditor(array(
            'name' => 'sn_content',
        )));
        $sn_info = array(
            'sn_id' => '',
            'sn_title' => '',
            'sn_if_show' => '',
            'sn_sort' => '',
            'sn_url' => '',
            'sn_new_open' => '',
        );
        $this->assign('sn_info', $sn_info);
        return $this->fetch($this->template_dir.'navigation_form');
    }

    public function navigation_edit()
    {
        $sn_id = intval(input('param.sn_id'));
        if ($sn_id <= 0) {
            $this->error(lang('wrong_argument'));
        }
        $model_store_navigation = Model('storenavigation');
        $sn_info = $model_store_navigation->getStoreNavigationInfo(array('sn_id' => $sn_id));
        if (empty($sn_info) || intval($sn_info['sn_store_id']) !== intval(session('store_id'))) {
            $this->error(lang('wrong_argument'));
        }
        $this->assign('sn_info', $sn_info);
        /* 所见即所得编辑器 */
        $this->assign('build_editor', buildEditor(array(
            'name' => 'sn_content',
            'content' => $sn_info['sn_content'],
        )));
        $this->setSellerCurMenu('seller_navigation');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('navigation_edit');
        return $this->fetch($this->template_dir.'navigation_form');
    }

    public function navigation_save()
    {
        $sn_info = array(
            'sn_title' => $_POST['sn_title'],
            'sn_content' => $_POST['sn_content'],
            'sn_sort' => empty($_POST['sn_sort']) ? 255 : $_POST['sn_sort'],
            'sn_if_show' => $_POST['sn_if_show'],
            'sn_url' => $_POST['sn_url'],
            'sn_new_open' => $_POST['sn_new_open'],
            'sn_store_id' => session('store_id'),
            'sn_add_time' => TIMESTAMP
        );
        $model_store_navigation = Model('storenavigation');
        if (!empty($_POST['sn_id']) && intval($_POST['sn_id']) > 0) {
            $condition = array('sn_id' => $_POST['sn_id']);
            $result = $model_store_navigation->editStoreNavigation($sn_info, $condition);
        } else {
            $result = $model_store_navigation->addStoreNavigation($sn_info);
        }
        if ($result) {
            $this->success(lang('ds_common_op_succ'), url('sellernavigation/index'));
        } else {
            $this->error(lang('ds_common_op_fail'),  url('sellernavigation/index'));
        }
    }

    public function navigation_del()
    {
        $sn_id = intval(input('param.sn_id'));
        if ($sn_id > 0) {
            $condition = array(
                'sn_id' => $sn_id,
                'sn_store_id' => session('store_id'),
            );
            $model_store_navigation = Model('storenavigation');
            $model_store_navigation->delStoreNavigation($condition);
            showDialog(lang('ds_common_op_succ'), url('Sellernavigation/index'), 'succ');
        } else {
            showDialog(lang('ds_common_op_fail'), url('Sellernavigation/index'), 'error');
        }
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_key 当前导航的menu_key
     * @return
     */
    function getSellerItemList()
    {
        $menu_array = array();
        $menu_array[] = array(
            'name' => 'store_navigation',
            'text' => '导航列表',
            'url' => url('Sellernavigation/index')
        );
        if (request()->action() == 'navigation_add') {
            $menu_array[] = array(
                'name' => 'navigation_add',
                'text' => '添加导航',
                'url' => url('Sellernavigation/navigation_add')
            );
        }
        if (request()->action() == 'navigation_edit') {
            $menu_array[] = array(
                'name' => 'navigation_edit',
                'text' => '编辑导航',
                'url' => url('Sellernavigation/navigation_edit')
            );
        }
        return $menu_array;
    }
}