<?php

namespace app\home\controller;


use think\Lang;

class Sellerpromotionmansong extends BaseSeller
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/zh-cn/sellerpromotionmansong.lang.php');

        //检查满就送是否开启
        if (intval(config('promotion_allow')) !== 1) {
            $this->error(lang('promotion_unavailable'), 'seller/index');
        }
    }


    /**
     * 发布的满就送活动列表
     **/
    public function index()
    {
        $model_mansong_quota = Model('pmansongquota');
        $model_mansong = Model('pmansong');

        $isOwnShop=checkPlatformStore() ? true : false;

        $this->assign('isOwnShop', $isOwnShop);

        $current_mansong_quota = $model_mansong_quota->getMansongQuotaCurrent(session('store_id'));
        $this->assign('current_mansong_quota', $current_mansong_quota);

        $condition = array();
        $condition['store_id'] = session('store_id');
        if ((input('param.mansong_name'))) {
            $condition['mansong_name'] = array('like', '%' . input('param.mansong_name') . '%');
        }
        if ((input('param.state'))) {
            $condition['state'] = intval(input('param.state'));
        }
        $mansong_list = $model_mansong->getMansongList($condition, 10, 'state desc, end_time desc');
        $this->assign('list', $mansong_list);
        $this->assign('show_page', $model_mansong->page_info->render());
        $this->assign('mansong_state_array', $model_mansong->getMansongStateArray());
        $this->setSellerCurMenu('Sellerpromotionmansong');
        $this->setSellerCurItem('mansong_list');
        return $this->fetch($this->template_dir.'index');
    }

    /**
     * 添加满就送活动
     **/
    public function mansong_add()
    {
        $model_mansong_quota = Model('pmansongquota');
        $model_mansong = Model('pmansong');

        $start_time = $model_mansong->getMansongNewStartTime(session('store_id'));

        $end_time=time();
        $isOwnShop = checkPlatformStore() ? true: false ;
        $this->assign('isOwnShop', $isOwnShop);

        if (!$isOwnShop) {
            //检查当前套餐是否可用
            $current_mansong_quota = $model_mansong_quota->getMansongQuotaCurrent(session('store_id'));
            if (empty($current_mansong_quota)) {
                $this->error(lang('mansong_quota_current_error'));
            }

            if (empty($start_time)) {
                $start_time = $current_mansong_quota['start_time'];
            }
            $end_time = $current_mansong_quota['end_time'];
        }

        if (empty($start_time))
            $start_time = time();

        $this->assign('start_time', $start_time);
        $this->assign('end_time', $end_time);

        //输出导航
        $this->setSellerCurMenu('Sellerpromotionmansong');
        $this->setSellerCurItem('mansong_add');
        return $this->fetch($this->template_dir.'mansong_add');
    }

    /**
     * 保存添加的满就送活动
     **/
    public function mansong_save()
    {
        $mansong_name = trim($_POST['mansong_name']);
        $start_time = strtotime($_POST['start_time']);
        $end_time = strtotime($_POST['end_time']);

        $model_mansong_quota = Model('pmansongquota');
        $model_mansong = Model('pmansong');
        $model_mansong_rule = Model('pmansongrule');

        if ($start_time >= $end_time) {
            showDialog(lang('greater_than_start_time'));
        }
        if (empty($mansong_name)) {
            showDialog(lang('mansong_name_error'));
        }

        $start_time_limit = $model_mansong->getMansongNewStartTime(session('store_id'));
        if (!empty($start_time_limit) && $start_time_limit > $start_time) {
            $start_time = $start_time_limit;
        }

        if (!checkPlatformStore()) {
            //检查当前套餐是否可用
            $current_mansong_quota = $model_mansong_quota->getMansongQuotaCurrent(session('store_id'));
            if (empty($current_mansong_quota)) {
                showDialog(lang('mansong_quota_current_error'), 'reload', 'error');
            }

            //验证输入
            $quota_start_time = intval($current_mansong_quota['start_time']);
            $quota_end_time = intval($current_mansong_quota['end_time']);

            if ($start_time < $quota_start_time) {
                showDialog(sprintf(lang('mansong_add_start_time_explain'), date('Y-m-d', $current_mansong_quota['start_time'])));
            }
            if ($end_time > $quota_end_time) {
                showDialog(sprintf(lang('mansong_add_end_time_explain'), date('Y-m-d', $current_mansong_quota['end_time'])));
            }
        }

        if (empty($_POST['mansong_rule'])) {
            showDialog('满即送规则不能为空');
        }

        $param = array();
        $param['mansong_name'] = $mansong_name;
        $param['start_time'] = $start_time;
        $param['end_time'] = $end_time;
        $param['store_id'] = session('store_id');
        $param['store_name'] = session('store_name');
        $param['member_id'] = session('member_id');
        $param['member_name'] = session('member_name');
        $param['quota_id'] = isset($current_mansong_quota['quota_id']) ? $current_mansong_quota['quota_id'] : 0;
        $param['remark'] = trim($_POST['remark']);
        $mansong_id = $model_mansong->addMansong($param);
        if ($mansong_id) {
            $mansong_rule_array = array();
            foreach ($_POST['mansong_rule'] as $value) {
                list($price, $discount, $goods_id) = explode(',', $value);
                $mansong_rule = array();
                $mansong_rule['mansong_id'] = $mansong_id;
                $mansong_rule['price'] = $price;
                $mansong_rule['discount'] = $discount;
                $mansong_rule['goods_id'] = $goods_id;
                $mansong_rule_array[] = $mansong_rule;
            }
            //生成规则
            $result = $model_mansong_rule->addMansongRuleArray($mansong_rule_array);

            $this->recordSellerLog('添加满即送活动，活动名称：' . $mansong_name);

            // 自动发布动态
            // mansong_name,start_time,end_time,store_id
            $data_array = array();
            $data_array['mansong_name'] = $param['mansong_name'];
            $data_array['start_time'] = $param['start_time'];
            $data_array['end_time'] = $param['end_time'];
            $data_array['store_id'] = session('store_id');
            $this->storeAutoShare($data_array, 'mansong');

            showDialog(lang('mansong_add_success'), url('Sellerpromotionmansong/index'), 'succ');
        }
        else {
            showDialog(lang('mansong_add_fail'));
        }
    }

    /**
     * 满就送活动详细信息
     **/
    public function mansong_detail()
    {
        $mansong_id = intval(input('param.mansong_id'));

        $model_mansong = Model('pmansong');
        $model_mansong_rule = Model('pmansongrule');

        $mansong_info = $model_mansong->getMansongInfoByID($mansong_id, session('store_id'));
        if (empty($mansong_info)) {
            showDialog(lang('param_error'));
        }
        $this->assign('mansong_info', $mansong_info);

        $param = array();
        $param['mansong_id'] = $mansong_id;
        $rule_list = $model_mansong_rule->getMansongRuleListByID($mansong_id);
        $this->assign('list', $rule_list);

        //输出导航
        $this->setSellerCurMenu('Sellerpromotionmansong');
        $this->setSellerCurItem('mansong_detail');
        return $this->fetch($this->template_dir.'mansong_detail');
    }

    /**
     * 满就送活动删除
     **/
    public function mansong_del()
    {
        $mansong_id = intval($_POST['mansong_id']);

        $model_mansong = Model('pmansong');

        $mansong_info = $model_mansong->getMansongInfoByID($mansong_id, session('store_id'));
        if (empty($mansong_info)) {
            showDialog(lang('param_error'));
        }

        $condition = array();
        $condition['mansong_id'] = $mansong_id;
        $result = $model_mansong->delMansong($condition);

        if ($result) {
            $this->recordSellerLog('删除满即送活动，活动名称：' . $mansong_info['mansong_name']);
            showDialog(lang('ds_common_op_succ'), url('Sellerpromotionmansong/index'), 'succ');
        }
        else {
            showDialog(lang('ds_common_op_fail'));
        }
    }

    /**
     * 满就送套餐购买
     **/
    public function mansong_quota_add()
    {

        $this->setSellerCurMenu('Sellerpromotionmansong');
        $this->setSellerCurItem('mansong_quota_add');
        return $this->fetch($this->template_dir.'quota_add');
    }

    /**
     * 满就送套餐购买保存
     **/
    public function mansong_quota_add_save()
    {
        $mansong_quota_quantity = intval($_POST['mansong_quota_quantity']);

        if ($mansong_quota_quantity <= 0 || $mansong_quota_quantity > 12) {
            showDialog(lang('mansong_quota_quantity_error'));
        }

        //获取当前价格
        $current_price = intval(config('promotion_mansong_price'));

        //获取该用户已有套餐
        $model_mansong_quota = Model('pmansongquota');
        $current_mansong_quota = $model_mansong_quota->getMansongQuotaCurrent(session('store_id'));
        $add_time = 86400 * 30 * $mansong_quota_quantity;
        if (empty($current_mansong_quota)) {
            //生成套餐
            $param = array();
            $param['member_id'] = session('member_id');
            $param['member_name'] = session('member_name');
            $param['store_id'] = session('store_id');
            $param['store_name'] = session('store_name');
            $param['start_time'] = TIMESTAMP;
            $param['end_time'] = TIMESTAMP + $add_time;
            $model_mansong_quota->addMansongQuota($param);
        }
        else {
            $param = array();
            $param['end_time'] = array('exp', 'end_time + ' . $add_time);
            $model_mansong_quota->editMansongQuota($param, array('quota_id' => $current_mansong_quota['quota_id']));
        }

        //记录店铺费用
        $this->recordStoreCost($current_price * $mansong_quota_quantity, '购买满即送');

        $this->recordSellerLog('购买' . $mansong_quota_quantity . '份满即送套餐，单价' . $current_price . lang('ds_yuan'));

        showDialog(lang('mansong_quota_add_success'), url('Sellerpromotionmansong/index'), 'succ');
    }

    /**
     * 选择活动商品
     **/
    public function search_goods()
    {
        $model_goods = Model('goods');
        $condition = array();
        $condition['store_id'] = session('store_id');
        $condition['goods_name'] = array('like', '%' . input('param.goods_name') . '%');
        $goods_list = $model_goods->getGeneralGoodsList($condition, '*', 8);

        $this->assign('goods_list', $goods_list);
        $this->assign('show_page', $model_goods->page_info->render());
        echo $this->fetch($this->template_dir.'mansong_goods');
    }


    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $name 当前导航的name
     * @param array $array 附加菜单
     * @return
     */
    protected function getSellerItemList()
    {
        $menu_array = array(
             array(
                'name' => 'mansong_list', 'text' => lang('promotion_active_list'),
                'url' => url('Sellerpromotionmansong/index')
            ),
        );
        switch (request()->action()) {
            case 'mansong_add':
                $menu_array[] = array(
                    'name' => 'mansong_add', 'text' => lang('promotion_join_active'),
                    'url' => url('Sellerpromotionmansong/mansong_add')
                );
                break;
            case 'mansong_quota_add':
                $menu_array[] = array(
                    'name' => 'mansong_quota_add', 'text' => lang('promotion_buy_product'),
                    'url' => url('Sellerpromotionmansong/mansong_quota_add')
                );
                break;
            case 'mansong_detail':
                $menu_array[] = array(
                    'name' => 'mansong_detail', 'text' => lang('mansong_active_content'),
                    'url' => url('Sellerpromotionmansong/mansong_detail', array('mansong_id' => input('param.mansong_id')))
                );
                break;
        }
       return $menu_array;
    }

}