<?php

namespace app\home\controller;


use think\Lang;

class Sellerpromotionxianshi extends BaseSeller
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/zh-cn/Sellerpromotionxianshi.lang.php');
        if (intval(config('promotion_allow')) !== 1) {
            $this->error(lang('promotion_unavailable'), 'seller/index');
        }
    }

    public function index()
    {
        $model_xianshi_quota = Model('pxianshiquota');
        $model_xianshi = Model('pxianshi');

        if (checkPlatformStore()) {
            $this->assign('isOwnShop', true);
        }
        else {
            $current_xianshi_quota = $model_xianshi_quota->getXianshiQuotaCurrent(session('store_id'));
            $this->assign('current_xianshi_quota', $current_xianshi_quota);
        }

        $condition = array();
        $condition['store_id'] = session('store_id');
        if ((input('param.xianshi_name'))) {
            $condition['xianshi_name'] = array('like', '%' . input('param.xianshi_name') . '%');
        }
        if ((input('param.state'))) {
            $condition['state'] = intval(input('param.state'));
        }
        $xianshi_list = $model_xianshi->getXianshiList($condition, 10, 'state desc, end_time desc');
        $this->assign('xianshi_list', $xianshi_list);
        $this->assign('show_page', $model_xianshi->page_info->render());
        $this->assign('xianshi_state_array', $model_xianshi->getXianshiStateArray());
        
        $this->setSellerCurMenu('Sellerpromotionxianshi');
        $this->setSellerCurItem('xianshi_list');
        return $this->fetch($this->template_dir.'index');
    }

    /**
     * 添加限时折扣活动
     **/
    public function xianshi_add()
    {
        if (checkPlatformStore()) {
            $this->assign('isOwnShop', true);
        }else {
            $this->assign('isOwnShop', false);
            $model_xianshi_quota = Model('pxianshiquota');
            $current_xianshi_quota = $model_xianshi_quota->getXianshiQuotaCurrent(session('store_id'));
            if (empty($current_xianshi_quota)) {
                $this->error(lang('xianshi_quota_current_error1'));
            }
            $this->assign('current_xianshi_quota', $current_xianshi_quota);
        }

        //输出导航
        $this->setSellerCurMenu('Sellerpromotionxianshi');
        $this->setSellerCurItem('xianshi_add');
        return $this->fetch($this->template_dir.'xianshi_add');
    }

    /**
     * 保存添加的限时折扣活动
     **/
    public function xianshi_save()
    {
        //验证输入
        $xianshi_name = trim($_POST['xianshi_name']);
        $start_time = strtotime($_POST['start_time']);
        $end_time = strtotime($_POST['end_time']);
        $lower_limit = intval($_POST['lower_limit']);
        if ($lower_limit <= 0) {
            $lower_limit = 1;
        }
        if (empty($xianshi_name)) {
            showDialog(lang('xianshi_name_error'));
        }
        if ($start_time >= $end_time) {
            showDialog(lang('greater_than_start_time'));
        }

        if (!checkPlatformStore()) {
            //获取当前套餐
            $model_xianshi_quota = Model('pxianshiquota');
            $current_xianshi_quota = $model_xianshi_quota->getXianshiQuotaCurrent(session('store_id'));
            if (empty($current_xianshi_quota)) {
                showDialog('没有可用限时折扣套餐,请先购买套餐');
            }
            $quota_start_time = intval($current_xianshi_quota['start_time']);
            $quota_end_time = intval($current_xianshi_quota['end_time']);
            if ($start_time < $quota_start_time) {
                showDialog(sprintf(lang('xianshi_add_start_time_explain'), date('Y-m-d', $current_xianshi_quota['start_time'])));
            }
            if ($end_time > $quota_end_time) {
                showDialog(sprintf(lang('xianshi_add_end_time_explain'), date('Y-m-d', $current_xianshi_quota['end_time'])));
            }
        }

        //生成活动
        $model_xianshi = Model('pxianshi');
        $param = array();
        $param['xianshi_name'] = $xianshi_name;
        $param['xianshi_title'] = $_POST['xianshi_title'];
        $param['xianshi_explain'] = $_POST['xianshi_explain'];
        $param['quota_id'] = isset($current_xianshi_quota['quota_id']) ? $current_xianshi_quota['quota_id'] : 0;
        $param['start_time'] = $start_time;
        $param['end_time'] = $end_time;
        $param['store_id'] = session('store_id');
        $param['store_name'] = session('store_name');
        $param['member_id'] = session('member_id');
        $param['member_name'] = session('member_name');
        $param['lower_limit'] = $lower_limit;
        $result = $model_xianshi->addXianshi($param);
        if ($result) {
            $this->recordSellerLog('添加限时折扣活动，活动名称：' . $xianshi_name . '，活动编号：' . $result);
            // 添加计划任务
            $this->addcron(array('exetime' => $param['end_time'], 'exeid' => $result, 'type' => 7), true);
            showDialog(lang('xianshi_add_success'), url('Sellerpromotionxianshi/xianshi_manage','xianshi_id='.$result), 'succ', '', 3);
        }
        else {
            showDialog(lang('xianshi_add_fail'));
        }
    }

    /**
     * 编辑限时折扣活动
     **/
    public function xianshi_edit()
    {
        $model_xianshi = Model('pxianshi');

        $xianshi_info = $model_xianshi->getXianshiInfoByID(input('param.xianshi_id'));
        if (empty($xianshi_info) || !$xianshi_info['editable']) {
            $this->error(lang('param_error'));
        }

        $this->assign('xianshi_info', $xianshi_info);

        //输出导航
        $this->setSellerCurMenu('Sellerpromotionxianshi');
        $this->setSellerCurItem('xianshi_edit');
        return $this->fetch($this->template_dir.'xianshi_add');
    }

    /**
     * 编辑保存限时折扣活动
     **/
    public function xianshi_edit_save()
    {
        $xianshi_id = $_POST['xianshi_id'];

        $model_xianshi = Model('pxianshi');
        $model_xianshi_goods = Model('pxianshigoods');

        $xianshi_info = $model_xianshi->getXianshiInfoByID($xianshi_id, session('store_id'));
        if (empty($xianshi_info) || !$xianshi_info['editable']) {
            $this->error(lang('param_error'));
        }

        //验证输入
        $xianshi_name = trim($_POST['xianshi_name']);
        $lower_limit = intval($_POST['lower_limit']);
        if ($lower_limit <= 0) {
            $lower_limit = 1;
        }
        if (empty($xianshi_name)) {
            showDialog(lang('xianshi_name_error'));
        }

        //生成活动
        $param = array();
        $param['xianshi_name'] = $xianshi_name;
        $param['xianshi_title'] = $_POST['xianshi_title'];
        $param['xianshi_explain'] = $_POST['xianshi_explain'];
        $param['lower_limit'] = $lower_limit;
        $result = $model_xianshi->editXianshi($param, array('xianshi_id' => $xianshi_id));
        $result1 = $model_xianshi_goods->editXianshiGoods($param, array('xianshi_id' => $xianshi_id));
        if ($result && $result) {
            $this->recordSellerLog('编辑限时折扣活动，活动名称：' . $xianshi_name . '，活动编号：' . $xianshi_id);
            showDialog(lang('ds_common_op_succ'), url('Sellerpromotionxianshi/index'), 'succ', '', 3);
        }
        else {
            showDialog(lang('ds_common_op_fail'));
        }
    }

    /**
     * 限时折扣活动删除
     **/
    public function xianshi_del()
    {
        $xianshi_id = intval($_POST['xianshi_id']);

        $model_xianshi = Model('pxianshi');

        $data = array();
        $data['result'] = true;

        $xianshi_info = $model_xianshi->getXianshiInfoByID($xianshi_id, session('store_id'));
        if (!$xianshi_info) {
            showDialog(lang('param_error'));
        }

        $model_xianshi = Model('pxianshi');
        $result = $model_xianshi->delXianshi(array('xianshi_id' => $xianshi_id));

        if ($result) {
            $this->recordSellerLog('删除限时折扣活动，活动名称：' . $xianshi_info['xianshi_name'] . '活动编号：' . $xianshi_id);
            showDialog(lang('ds_common_op_succ'), url('sellerpromotionxianshi/index'), 'succ');
        }
        else {
            showDialog(lang('ds_common_op_fail'));
        }
    }

    /**
     * 限时折扣活动管理
     **/
    public function xianshi_manage()
    {
        $model_xianshi = Model('pxianshi');
        $model_xianshi_goods = Model('pxianshigoods');

        $xianshi_id = intval(input('param.xianshi_id'));
        $xianshi_info = $model_xianshi->getXianshiInfoByID($xianshi_id, session('store_id'));
        if (empty($xianshi_info)) {
            showDialog(lang('param_error'));
        }
        $this->assign('xianshi_info', $xianshi_info);

        //获取限时折扣商品列表
        $condition = array();
        $condition['xianshi_id'] = $xianshi_id;
        $xianshi_goods_list = $model_xianshi_goods->getXianshiGoodsExtendList($condition);

        $this->assign('xianshi_goods_list', $xianshi_goods_list);

        //输出导航
        $this->setSellerCurMenu('Sellerpromotionxianshi');
        $this->setSellerCurItem('xianshi_manage');
        return $this->fetch($this->template_dir.'xianshi_manage');
    }


    /**
     * 限时折扣套餐购买
     **/
    public function xianshi_quota_add()
    {
        //输出导航
        $this->setSellerCurMenu('Sellerpromotionxianshi');
        $this->setSellerCurItem('xianshi_quota_add');
        return $this->fetch($this->template_dir.'xianshi_quota_add');
    }

    /**
     * 限时折扣套餐购买保存
     **/
    public function xianshi_quota_add_save()
    {

        $xianshi_quota_quantity = intval($_POST['xianshi_quota_quantity']);

        if ($xianshi_quota_quantity <= 0 || $xianshi_quota_quantity > 12) {
            showDialog(lang('xianshi_quota_quantity_error'));
        }

        //获取当前价格
        $current_price = intval(config('promotion_xianshi_price'));

        //获取该用户已有套餐
        $model_xianshi_quota = Model('pxianshiquota');
        $current_xianshi_quota = $model_xianshi_quota->getXianshiQuotaCurrent(session('store_id'));
        $add_time = 86400 * 30 * $xianshi_quota_quantity;
        if (empty($current_xianshi_quota)) {
            //生成套餐
            $param = array();
            $param['member_id'] = session('member_id');
            $param['member_name'] = session('member_name');
            $param['store_id'] = session('store_id');
            $param['store_name'] = session('store_name');
            $param['start_time'] = TIMESTAMP;
            $param['end_time'] = TIMESTAMP + $add_time;
            $model_xianshi_quota->addXianshiQuota($param);
        }
        else {
            $param = array();
            $param['end_time'] = array('exp', 'end_time + ' . $add_time);
            $model_xianshi_quota->editXianshiQuota($param, array('quota_id' => $current_xianshi_quota['quota_id']));
        }

        //记录店铺费用
        $this->recordStoreCost($current_price * $xianshi_quota_quantity, '购买限时折扣');

        $this->recordSellerLog('购买' . $xianshi_quota_quantity . '份限时折扣套餐，单价' . $current_price . lang('ds_yuan'));

        showDialog(lang('xianshi_quota_add_success'), url('Sellerpromotionxianshi/index'), 'succ');
    }

    /**
     * 选择活动商品
     **/
    public function goods_select()
    {
        $model_goods = Model('goods');
        $condition = array();
        $condition['store_id'] = session('store_id');
        $condition['goods_name'] = array('like', '%' . input('param.goods_name') . '%');
        $goods_list = $model_goods->getGoodsListForPromotion($condition, '*', 10, 'xianshi');

        $this->assign('goods_list', $goods_list);
        $this->assign('show_page', $model_goods->page_info->render());
        echo $this->fetch($this->template_dir.'goods_select');
    }

    /**
     * 限时折扣商品添加
     **/
    public function xianshi_goods_add()
    {
        $goods_id = intval($_POST['goods_id']);
        $xianshi_id = intval($_POST['xianshi_id']);
        $xianshi_price = floatval($_POST['xianshi_price']);

        $model_goods = Model('goods');
        $model_xianshi = Model('pxianshi');
        $model_xianshi_goods = Model('pxianshigoods');

        $data = array();
        $data['result'] = true;

        $goods_info = $model_goods->getGoodsInfoByID($goods_id);
        if (empty($goods_info) || $goods_info['store_id'] != session('store_id')) {
            $data['result'] = false;
            $data['message'] = lang('param_error');
            echo json_encode($data);
            die;
        }

        $xianshi_info = $model_xianshi->getXianshiInfoByID($xianshi_id, session('store_id'));
        if (!$xianshi_info) {
            $data['result'] = false;
            $data['message'] = lang('param_error');
            echo json_encode($data);
            die;
        }

        //检查商品是否已经参加同时段活动
        $condition = array();
        $condition['end_time'] = array('gt', $xianshi_info['start_time']);
        $condition['goods_id'] = $goods_id;
        $xianshi_goods = $model_xianshi_goods->getXianshiGoodsExtendList($condition);
        if (!empty($xianshi_goods)) {
            $data['result'] = false;
            $data['message'] = '该商品已经参加了同时段活动';
            echo json_encode($data);
            die;
        }

        //添加到活动商品表
        $param = array();
        $param['xianshi_id'] = $xianshi_info['xianshi_id'];
        $param['xianshi_name'] = $xianshi_info['xianshi_name'];
        $param['xianshi_title'] = $xianshi_info['xianshi_title'];
        $param['xianshi_explain'] = $xianshi_info['xianshi_explain'];
        $param['goods_id'] = $goods_info['goods_id'];
        $param['store_id'] = $goods_info['store_id'];
        $param['goods_name'] = $goods_info['goods_name'];
        $param['goods_price'] = $goods_info['goods_price'];
        $param['xianshi_price'] = $xianshi_price;
        $param['goods_image'] = $goods_info['goods_image'];
        $param['start_time'] = $xianshi_info['start_time'];
        $param['end_time'] = $xianshi_info['end_time'];
        $param['lower_limit'] = $xianshi_info['lower_limit'];

        $result = array();
        $xianshi_goods_info = $model_xianshi_goods->addXianshiGoods($param);
        if ($xianshi_goods_info) {
            $result['result'] = true;
            $data['message'] = '添加成功';
            $data['xianshi_goods'] = $xianshi_goods_info;
            // 自动发布动态
            // goods_id,store_id,goods_name,goods_image,goods_price,goods_freight,xianshi_price
            $data_array = array();
            $data_array['goods_id'] = $goods_info['goods_id'];
            $data_array['store_id'] = session('store_id');
            $data_array['goods_name'] = $goods_info['goods_name'];
            $data_array['goods_image'] = $goods_info['goods_image'];
            $data_array['goods_price'] = $goods_info['goods_price'];
            $data_array['goods_freight'] = $goods_info['goods_freight'];
            $data_array['xianshi_price'] = $xianshi_price;
            $this->storeAutoShare($data_array, 'xianshi');
            $this->recordSellerLog('添加限时折扣商品，活动名称：' . $xianshi_info['xianshi_name'] . '，商品名称：' . $goods_info['goods_name']);

            // 添加任务计划
            $this->addcron(array('type' => 2, 'exeid' => $goods_info['goods_id'], 'exetime' => $param['start_time']));
        }
        else {
            $data['result'] = false;
            $data['message'] = lang('param_error');
        }
        echo json_encode($data);
        die;
    }

    /**
     * 限时折扣商品价格修改
     **/
    public function xianshi_goods_price_edit()
    {
        $xianshi_goods_id = intval($_POST['xianshi_goods_id']);
        $xianshi_price = floatval($_POST['xianshi_price']);

        $data = array();
        $data['result'] = true;

        $model_xianshi_goods = Model('pxianshigoods');

        $xianshi_goods_info = $model_xianshi_goods->getXianshiGoodsInfoByID($xianshi_goods_id, session('store_id'));
        if (!$xianshi_goods_info) {
            $data['result'] = false;
            $data['message'] = lang('param_error');
            echo json_encode($data);
            die;
        }

        $update = array();
        $update['xianshi_price'] = $xianshi_price;
        $condition = array();
        $condition['xianshi_goods_id'] = $xianshi_goods_id;
        $result = $model_xianshi_goods->editXianshiGoods($update, $condition);

        if ($result) {
            $xianshi_goods_info['xianshi_price'] = $xianshi_price;
            $xianshi_goods_info = $model_xianshi_goods->getXianshiGoodsExtendInfo($xianshi_goods_info);
            $data['xianshi_price'] = $xianshi_goods_info['xianshi_price'];
            $data['xianshi_discount'] = $xianshi_goods_info['xianshi_discount'];

            // 添加对列修改商品促销价格
            \mall\queue\QueueClient::push('updateGoodsPromotionPriceByGoodsId', $xianshi_goods_info['goods_id']);

            $this->recordSellerLog('限时折扣价格修改为：' . $xianshi_goods_info['xianshi_price'] . '，商品名称：' . $xianshi_goods_info['goods_name']);
        }
        else {
            $data['result'] = false;
            $data['message'] = lang('ds_common_op_succ');
        }
        echo json_encode($data);
        die;
    }

    /**
     * 限时折扣商品删除
     **/
    public function xianshi_goods_deleteOp()
    {
        $model_xianshi_goods = Model('pxianshigoods');
        $model_xianshi = Model('pxianshi');

        $data = array();
        $data['result'] = true;

        $xianshi_goods_id = intval($_POST['xianshi_goods_id']);
        $xianshi_goods_info = $model_xianshi_goods->getXianshiGoodsInfoByID($xianshi_goods_id);
        if (!$xianshi_goods_info) {
            $data['result'] = false;
            $data['message'] = lang('param_error');
            echo json_encode($data);
            die;
        }

        $xianshi_info = $model_xianshi->getXianshiInfoByID($xianshi_goods_info['xianshi_id'], session('store_id'));
        if (!$xianshi_info) {
            $data['result'] = false;
            $data['message'] = lang('param_error');
            echo json_encode($data);
            die;
        }

        if (!$model_xianshi_goods->delXianshiGoods(array('xianshi_goods_id' => $xianshi_goods_id))) {
            $data['result'] = false;
            $data['message'] = lang('xianshi_goods_delete_fail');
            echo json_encode($data);
            die;
        }

        // 添加对列修改商品促销价格
        \mall\queue\QueueClient::push('updateGoodsPromotionPriceByGoodsId', $xianshi_goods_info['goods_id']);

        $this->recordSellerLog('删除限时折扣商品，活动名称：' . $xianshi_info['xianshi_name'] . '，商品名称：' . $xianshi_goods_info['goods_name']);
        echo json_encode($data);
        die;
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $name 当前导航的name
     * @param array $array 附加菜单
     * @return
     */
    protected function getSellerItemList()
    {
        $menu_array = array(
             array(
                'name' => 'xianshi_list', 'text' => lang('promotion_active_list'),
                'url' => url('Sellerpromotionxianshi/index')
            ),
        );
        switch (request()->action()) {
            case 'xianshi_add':
                $menu_array[] = array(
                    'name' => 'xianshi_add', 'text' => lang('promotion_join_active'),
                    'url' => url('Sellerpromotionxianshi/xianshi_add')
                );
                break;
            case 'xianshi_edit':
                $menu_array[] = array(
                    'name' => 'xianshi_edit', 'text' => '编辑活动', 'url' => 'javascript:;'
                );
                break;
            case 'xianshi_quota_add':
                $menu_array[] = array(
                    'name' => 'xianshi_quota_add', 'text' => lang('promotion_buy_product'),
                    'url' => url('Sellerpromotionxianshi/xianshi_quota_add')
                );
                break;
            case 'xianshi_manage':
                $menu_array[] = array(
                    'name' => 'xianshi_manage', 'text' => lang('promotion_goods_manage'),
                    'url' => url('Sellerpromotionxianshi/xianshi_manage','xianshi_id='.input('param.xianshi_id'))
                );
                break;
        }
       return $menu_array;
    }
}