<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2017/6/26
 * Time: 11:47
 */

namespace app\home\controller;
error_reporting(E_ALL || ~E_NOTICE);
use Think\Lang;
class Sellerwaybill extends BaseSeller
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/zh-cn/sellerdeliver.lang.php');
    }

    /**
     * 模板管理
     */
    public function index() {
        $model_store_extend = Model('storeextend');
        $model_express = Model('express');
        $model_store_waybill = Model('storewaybill');

        $store_extend_info = $model_store_extend->getStoreExtendInfo(array('store_id' => session('store_id')), 'express');
        $store_express = $store_extend_info['express'];

        $express_list = $model_express->getExpressListByID($store_express);

        $store_waybill_list = $model_store_waybill->getStoreWaybillListWithWaybillInfo(session('store_id'), $store_express);

        $store_waybill_list = ds_changeArraykey($store_waybill_list, 'express_id');

        if(!empty($express_list)) {
            foreach ($express_list as $key => $value) {
                if(!empty($store_waybill_list[$value['id']])) {
                    $express_list[$key]['waybill_name'] = $store_waybill_list[$value['id']]['waybill_name'];
                    $express_list[$key]['store_waybill_id'] = $store_waybill_list[$value['id']]['store_waybill_id'];
                    $express_list[$key]['is_default_text'] =  $store_waybill_list[$value['id']]['is_default'] ? '是' : '否';
                    $express_list[$key]['waybill_image_url'] = getWaybillImageUrl($store_waybill_list[$value['id']]['waybill_image']);
                    $express_list[$key]['waybill_width'] = $store_waybill_list[$value['id']]['waybill_width'];
                    $express_list[$key]['waybill_height'] = $store_waybill_list[$value['id']]['waybill_height'];
                    $express_list[$key]['bind'] = true;
                } else {
                    $express_list[$key]['waybill_name'] = '未绑定';
                    $express_list[$key]['bind'] = false;
                }
            }
        }
        $this->assign('express_list', $express_list);
        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('sellerwaybill');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('sellerwaybil');
         return $this->fetch($this->template_dir.'index');
    }

    /**
     * 绑定运单打印模板
     */
    public function waybill_bind() {
        $express_id = intval(input('param.express_id'));

        $model_express = Model('express');
        $model_waybill = Model('waybill');

        $express_info = $model_express->getExpressInfo($express_id);

        if(empty($express_info)) {
            $this->error('快递公司不存在');
        }
        $this->assign('express_info', $express_info);

        $waybill_list = $model_waybill->getWaybillUsableList($express_id, session('store_id'));
        $this->assign('waybill_list', $waybill_list);

        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('sellerwaybill');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('waybill_bind');
         return $this->fetch($this->template_dir.'waybill_bind');
    }

    /**
     * 绑定运单打印模板保存
     */
    public function waybill_bind_save() {
        $express_id = intval(input('param.express_id'));
        $waybill_id = intval(input('param.waybill_id'));
        $model_waybill = Model('waybill');
        $model_store_waybill = Model('storewaybill');

        $waybill_info = $model_waybill->getWaybillInfoByID($waybill_id);
        if(!$waybill_info) {
            $this->error('运单模板不存在');
        }

        $param = array();
        $param['store_id'] = session('store_id');
        $param['express_id'] = $express_id;

        //删除已有绑定
        $model_store_waybill->delStoreWaybill($param);

        //保存绑定
        $param['waybill_id'] = $waybill_info['waybill_id'];
        $param['waybill_name'] = $waybill_info['waybill_name'];
        $param['store_waybill_left'] = $waybill_info['waybill_left'];
        $param['store_waybill_top'] = $waybill_info['waybill_top'];
        $result = $model_store_waybill->addStoreWaybill($param);
        if($result) {
            $this->success('绑定成功', 'Sellerwaybill/index');
        } else {
            $this->error('绑定失败');
        }
    }

    /**
     * 解绑运单打印模板
     */
    public function waybill_unbind() {
        $store_waybill_id = intval(input('param.store_waybill_id'));

        $model_store_waybill = Model('storewaybill');

        $condition = array();
        $condition['store_waybill_id'] = $store_waybill_id;
        $condition['store_id'] = session('store_id');

        $result = $model_store_waybill->delStoreWaybill($condition);
        if($result) {
            $this->success('解绑成功');
        } else {
            $this->error('解绑失败');
        }
    }

    /**
     * 运单模板设置
     */
    public function waybill_setting() {
        $store_waybill_id = intval(input('param.store_waybill_id'));

        $model_store_waybill = Model('storewaybill');

        $store_waybill_info = $model_store_waybill->getStoreWaybillInfo(array('store_waybill_id' => $store_waybill_id));
        $this->assign('store_waybill_id', $store_waybill_info['store_waybill_id']);
        $this->assign('store_waybill_left', $store_waybill_info['store_waybill_left']);
        $this->assign('store_waybill_top', $store_waybill_info['store_waybill_top']);
        $this->assign('store_waybill_data', $store_waybill_info['store_waybill_data']);

        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('sellerwaybill');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('sellerwaybil');
         return $this->fetch($this->template_dir.'waybill_setting');
    }

    /**
     * 运单模板设置保存
     */
    public function waybill_setting_save() {
        $store_waybill_id = intval(input('param.store_waybill_id'));
        if($store_waybill_id <= 0) {
            $this->error(lang('wrong_argument'));
        }

        $model_store_waybill = Model('storewaybill');

        $condition = array();
        $condition['store_waybill_id'] = $store_waybill_id;
        $condition['store_id'] = session('store_id');

        $update = array();
        $update['store_waybill_left'] = input('param.store_waybill_left');
        $update['store_waybill_top'] = input('param.store_waybill_top');

        $result = $model_store_waybill->editStoreWaybill($update, $condition, $_POST['data']);
        if($result) {
            showDialog(lang('ds_common_save_succ'),url('Sellerwaybill/index'));
        } else {
            showDialog(lang('ds_common_save_fail'));
        }
    }

    /**
     * 运单打印测试
     */
    public function waybill_test() {
        $model_waybill = Model('waybill');

        $waybill_info = $model_waybill->getWaybillInfoByID(input('param.waybill_id'));
        if(!$waybill_info) {
            $this->error('运单模板不存在');
        }

        $this->assign('waybill_info', $waybill_info);
         return $this->fetch($this->template_dir.'waybill_test');
    }

    /**
     * 设置默认打印模板
     */
    public function waybill_set_default() {
        $store_waybill_id = intval($_POST['store_waybill_id']);

        $model_store_waybill = Model('storewaybill');

        $result = $model_store_waybill->editStoreWaybillDefault($store_waybill_id, session('store_id'));

        if($result) {
            showDialog(lang('ds_common_save_succ'),url('Sellerwaybill/index'),'succ');
        } else {
            showDialog(lang('ds_common_save_fail'),url('Sellerwaybill/index'),'error');
        }
    }

    /**
     * 模板列表
     */
    public function waybill_list() {
        $model_waybill = Model('waybill');

        $waybill_list = $model_waybill->getWaybillSellerList(session('store_id'));
        $this->assign('waybill_list', $waybill_list);

        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('sellerwaybill');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('waybill_list');
         return $this->fetch($this->template_dir.'waybill_list');
    }

    /**
     * 添加运单模板
     */
    public function waybill_add() {
        $model_express = Model('express');

        $this->assign('express_list', $model_express->getExpressList());
        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('sellerwaybill');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('waybill_add');
         return $this->fetch($this->template_dir.'waybill_add');
    }

    /**
     * 保存运单模板
     */
    public function waybill_save() {
        $model_waybill = Model('waybill');
        $result = $model_waybill->saveWaybill($_POST, session('store_id'));

        if(!isset($result['error'])) {
            showDialog(lang('ds_common_save_succ'), url('Sellerwaybill/waybill_list'),'succ');
        } else {
            showDialog(lang('ds_common_save_fail'), url('Sellerwaybill/waybill_list'));
        }
    }

    /**
     * 删除运单模板
     */
    public function waybill_del() {
        $waybill_id = intval(input('param.waybill_id'));
        if($waybill_id <= 0) {
            $this->error(lang('wrong_argument'));
        }

        $model_waybill = Model('waybill');

        $condition = array();
        $condition['waybill_id'] = $waybill_id;
        $condition['store_id'] = session('store_id');
        $result = $model_waybill->delWaybill($condition);
        if($result) {
            $this->success(lang('ds_common_del_succ'));
        } else {
            $this->error(lang('ds_common_del_fail'));
        }
    }

    /**
     * 编辑运单模板
     */
    public function waybill_edit() {
        $model_express = Model('express');
        $model_waybill = Model('waybill');
        $waybill_id=input('param.waybill_id');
        $waybill_info = $model_waybill->getWaybillInfoByID($waybill_id);
        if(!$waybill_info || $waybill_info['store_id'] != session('store_id')) {
            $this->error('运单模板不存在');
        }
        $this->assign('waybill_info', $waybill_info);

        $express_list = $model_express->getExpressList();
        foreach ($express_list as $key => $value) {
            if($value['id'] == $waybill_info['express_id']) {
                $express_list[$key]['selected'] = true;
            }
        }
        $this->assign('express_list', $express_list);
        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('sellerwaybill');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('waybill_edit');
         return $this->fetch($this->template_dir.'waybill_add');
    }

    /**
     * 设计运单模板
     */
    public function waybill_design() {
        $model_waybill = Model('waybill');
        $waybill_id=input('param.waybill_id');
        $result = $model_waybill->getWaybillDesignInfo($waybill_id);
        if(isset($result['error'])) {
            $this->error($result['error']);
        }

        $this->assign('waybill_info', $result['waybill_info']);
        $this->assign('waybill_info_data', $result['waybill_info_data']);
        $this->assign('waybill_item_list', $result['waybill_item_list']);

        /* 设置卖家当前菜单 */
        $this->setSellerCurMenu('sellerwaybill');
        /* 设置卖家当前栏目 */
        $this->setSellerCurItem('waybill_design');
         return $this->fetch($this->template_dir.'waybill_design');
    }

    /**
     * 设计运单模板保存
     */
    public function waybill_design_save() {
        $model_waybill = Model('waybill');

        $result = $model_waybill->editWaybillDataByID($_POST['waybill_data'], $_POST['waybill_id'], session('store_id'));

        if($result) {
            showDialog(lang('ds_common_save_succ'), url('Sellerwaybill/waybill_list'),'succ');
        } else {
            showDialog(lang('ds_common_save_fail'), url('Sellerwaybill/waybill_list'));
        }
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $menu_key 当前导航的menu_key
     * @return
     */
     function getSellerItemList() {
        $menu_array = array();
        $menu_array[] = array(
            'name' => 'waybill_manage',
            'text' => '模板绑定',
            'url' => url('index')
        );
        $menu_array[] = array(
            'name' => 'waybill_list',
            'text' => '自建模板',
            'url' => url('waybill_list')
        );
        if(request()->action() == 'waybill_bind') {
            $menu_array[] = array(
                'name' => 'waybill_bind',
                'text' => '选择模板',
                'url' => url('waybill_bind')
            );
        }
        if(request()->action() == 'waybill_setting') {
            $menu_array[] = array(
                'name' => 'waybill_setting',
                'text' => '模板设置',
                'url' => url('waybill_setting')
            );
        }
        if(request()->action() == 'waybill_add') {
            $menu_array[] = array(
                'name' => 'waybill_add',
                'text' => '添加模板',
                'url' => url('waybill_add')
            );
        }
        if(request()->action() == 'waybill_edit') {
            $menu_array[] = array(
                'name' => 'waybill_edit',
                'text' => '编辑模板',
                'url' => url('waybill_edit')
            );
        }
        if(request()->action() == 'waybill_design') {
            $menu_array[] = array(
                'name' => 'waybill_design',
                'text' => '设计模板',
                'url' => url('waybill_design')
            );
        }
        return $menu_array;
    }
}