<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2017/12/22
 * Time: 14:42
 */

namespace app\home\controller;
use think\Lang;
class Webchat extends BaseMember
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/zh-cn/webchat.lang.php');
    }
    /**
     * add msg
     *
     */
    public function send_msg()
    {
        $member = array();
        $model_chat = Model('webchat');
        $member_id = session('member_id');
        $member_name = session('member_name');
        $f_id = intval(input('f_id'));
        $t_id = intval(input('t_id'));
        $t_name = trim(input('t_name'));
        if (($member_id < 1) || ($member_id != $f_id))
            $this->error(lang('ds_member_chat_login'));
        $member = $model_chat->getMember($t_id);
        if ($t_name != $member['member_name'])
            $this->error(lang('ds_member_chat_name_error'));

        $msg = array();
        $msg['f_id'] = $f_id;
        $msg['f_name'] = $member_name;
        $msg['t_id'] = $t_id;
        $msg['t_name'] = $t_name;
        $msg['t_msg'] = trim(input('t_msg'));
        if ($msg['t_msg'] != '')
            $chat_msg = $model_chat->addMsg($msg);
        if ($chat_msg['m_id']) {
            $this->json($chat_msg);
        }
        else {
            $this->error(lang('ds_member_chat_add_error'));
        }
    }

    /**
     * friends info
     *
     */
    public function get_user_list()
    {
        $member_list = array();
        $model_chat = Model('webchat');
        $member_id = session('member_id');
        $member_name = session('member_name');
        $f_id = intval(input('f_id'));
        if (($member_id < 1) || ($member_id != $f_id))
            $this->error(lang('ds_member_chat_login'));
        $n = intval(input('n'));
        if ($n < 1)
            $n = 50;
        $member_list = $model_chat->getFriendList(array('friend_frommid' => $f_id), $n, $member_list);
        $add_time = date("Y-m-d");
        $add_time30 = strtotime($add_time) - 60 * 60 * 24 * 30;
        $member_list = $model_chat->getRecentList(array(
                                                      'f_id' => $f_id, 'add_time' => array('egt', $add_time30)
                                                  ), 10, $member_list);
        $member_list = $model_chat->getRecentFromList(array(
                                                          't_id' => $f_id, 'add_time' => array('egt', $add_time30)
                                                      ), 10, $member_list);
        $this->json($member_list);
    }

    /**
     * 商家客服
     *
     */
    public function get_seller_list()
    {
        $member_list = array();
        $model_chat = Model('webchat');
        $member_id = session('member_id');
        $member_name = session('member_name');
        $store_id = session('store_id');
        $f_id = intval(input('f_id'));
        if (($member_id < 1) || ($member_id != $f_id))
            $this->error(lang('ds_member_chat_login'));
        $n = intval(input('n'));
        if ($n < 1)
            $n = 50;
        if (!session('seller_list')) {
            $member_list = $model_chat->getSellerList(array('store_id' => $store_id), $n, $member_list);
            session('seller_list', $member_list);
        }
        else {
            $member_list = session('seller_list');
        }
        $add_time = date("Y-m-d");
        $add_time30 = strtotime($add_time) - 60 * 60 * 24 * 30;
        $member_list = $model_chat->getRecentList(array(
                                                      'f_id' => $f_id, 'add_time' => array('egt', $add_time30)
                                                  ), 10, $member_list);
        $member_list = $model_chat->getRecentFromList(array(
                                                          't_id' => $f_id, 'add_time' => array('egt', $add_time30)
                                                      ), 10, $member_list);
        $this->json($member_list);
    }

    /**
     * member info
     *
     */
    public function get_info()
    {
        if (session('member_id') < 1)
            $this->error(lang('ds_member_chat_login'));
        $val = '';
        $member = array();
        $model_chat = Model('webchat');
        $types = array('member_id', 'member_name', 'store_id', 'member');
        $key = input('t');
        $member_id = intval(input('u_id'));
        if (trim($key) != '' && in_array($key, $types)) {
            $member = $model_chat->getMember($member_id);
            $this->json($member);
        }
    }

    /**
     * chat log
     *
     */
    public function get_chat_log()
    {
        $member_id = session('member_id');
        $f_id = intval(input('f_id'));
        $t_id = intval(input('t_id'));
        $page = intval(input('page'));
        if (($member_id < 1) || ($member_id != $f_id))
            $this->error(lang('ds_member_chat_login'));
        if ($page < 1)
            $page = 20;
        $add_time_to = date("Y-m-d");
        $time_from = array();
        $time_from['7'] = strtotime($add_time_to) - 60 * 60 * 24 * 7;
        $time_from['15'] = strtotime($add_time_to) - 60 * 60 * 24 * 15;
        $time_from['30'] = strtotime($add_time_to) - 60 * 60 * 24 * 30;

        $key = $_GET['t'];
        if (trim($key) != '' && array_key_exists($key, $time_from)) {
            $model_chat = Model('web_chat');
            $chat_log = array();
            $list = array();
            $condition_sql = " add_time >= '" . $time_from[$key] . "' ";
            $condition_sql .= " and ((f_id = '" . $f_id . "' and t_id = '" . $t_id . "') or (f_id = '" . $t_id . "' and t_id = '" . $f_id . "'))";
            $list = $model_chat->getLogList($condition_sql, $page);

            $chat_log['list'] = $list;
            $chat_log['total_page'] = $model_chat->gettotalpage();
            $this->json($chat_log);
        }
    }

    /**
     * 商品图片和名称
     *
     */
    public function get_goods_info()
    {
        $model_chat = Model('webchat');
        $goods_id = intval(input('goods_id'));
        $goods = $model_chat->getGoodsInfo($goods_id);
        $this->json($goods);
    }

    /**
     * 店铺推荐商品图片和名称
     *
     */
    public function get_goods_list()
    {
        $s_id = intval(input('s_id'));
        if ($s_id > 0) {
            $model_goods = Model('goods');
            $list = $model_goods->getGoodsCommendList($s_id, 4);
            if (!empty($list) && is_array($list)) {
                foreach ($list as $k => $v) {
                    $v['goods_promotion_price'] = dsPriceFormat($v['goods_promotion_price']);
                    $v['url'] = url('goods/index', array('goods_id' => $v['goods_id']));
                    $v['pic'] = thumb($v, 60);
                    $list[$k] = $v;
                }
            }
            halt($list);
            $this->json($list);
        }
    }

    /**
     * get session
     *
     */
    public function get_session()
    {
        $key = input('key');
        $val = '';
        if (session($key))
            $val = session($key);
        echo $val;
        exit;
    }

    /**
     * json
     *
     */
    public function json($json)
    {
        echo $_GET['callback'] . '(' . json_encode($json) . ')';
        exit;
    }
}