<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2017/8/16
 * Time: 20:15
 */

namespace app\mobile\controller;


use think\Validate;

class Memberaddress extends MobileMember
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    /**
     * 地址列表
     */
    public function address_list()
    {
        $model_address = Model('address');
        $address_list = $model_address->getAddressList(array('member_id' => $this->member_info['member_id']));
        output_data(array('address_list' => $address_list));
    }

    /**
     * 地址详细信息
     */
    public function address_info()
    {
        $address_id = intval($_POST['address_id']);

        $model_address = Model('address');

        $condition = array();
        $condition['address_id'] = $address_id;
        $address_info = $model_address->getAddressInfo($condition);
        if (!empty($address_id) && $address_info['member_id'] == $this->member_info['member_id']) {
            output_data(array('address_info' => $address_info));
        }
        else {
            output_error('地址不存在');
        }
    }

    /**
     * 删除地址
     */
    public function address_del()
    {
        $address_id = intval($_POST['address_id']);

        $model_address = Model('address');

        $condition = array();
        $condition['address_id'] = $address_id;
        $condition['member_id'] = $this->member_info['member_id'];
        $model_address->delAddress($condition);
        output_data('1');
    }

    /**
     * 新增地址
     */
    public function address_add()
    {
        $model_address = Model('address');

        $address_info = $this->_address_valid();

        $result = $model_address->addAddress($address_info);
        if ($result) {
            output_data(array('address_id' => $result));
        }
        else {
            output_error('保存失败');
        }
    }

    /**
     * 编辑地址
     */
    public function address_edit()
    {
        $address_id = intval($_POST['address_id']);

        $model_address = Model('address');

        //验证地址是否为本人
        $address_info = $model_address->getOneAddress($address_id);
        if ($address_info['member_id'] != $this->member_info['member_id']) {
            output_error('参数错误');
        }

        $address_info = $this->_address_valid();
        $result = $model_address->editAddress($address_info, array('address_id' => $address_id));
        if ($result) {
            output_data('1');
        }
        else {
            output_error('保存失败');
        }
    }

    /**
     * 验证地址数据
     */
    private function _address_valid()
    {
        $obj_validate = new Validate();
        $data=[
            'true_name'=>$_POST["true_name"],
            'area_info'=>$_POST["area_info"],
            'address'=>$_POST["address"],
        ];

        $rule=[
            ['true_name','require','姓名不能为空'],
            ['area_info','require','地区不能为空'],
            ['address','require','地址不能为空'],
        ];
        if (!isset($_POST['mob_phone'])&&!isset($_POST['tel_phone'])){
            $data['mob_phone']='';
            $rule[]=['mob_phone','require','联系方式不能为空'];
        }
        $error = $obj_validate->check($data,$rule);
        if (!$error) {
            output_error($obj_validate->getError());
        }

        $data = array();
        $data['member_id'] = $this->member_info['member_id'];
        $data['true_name'] = $_POST['true_name'];
        $data['area_id'] = intval($_POST['area_id']);
        $data['city_id'] = intval($_POST['city_id']);
        $data['area_info'] = $_POST['area_info'];
        $data['address'] = $_POST['address'];
        $data['longitude'] = $_POST['longitude'];
        $data['latitude'] = $_POST['latitude'];
        $data['tel_phone'] = isset($_POST['tel_phone'])?$_POST['tel_phone']:'';
        $data['mob_phone'] = isset($_POST['mob_phone'])?$_POST['mob_phone']:'';
        $data['is_default'] = $_POST['is_default'];
        return $data;
    }

    /**
     * 地区列表
     */
    public function area_list()
    {
        $area_id = intval($_POST['area_id']);

        $model_area = Model('area');

        $condition = array();
        if ($area_id > 0) {
            $condition['area_parent_id'] = $area_id;
        }
        else {
            $condition['area_deep'] = 1;
        }
        $area_list = $model_area->getAreaList($condition, 'area_id,area_name');
        output_data(array('area_list' => $area_list));
    }
}