<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
class AuditController extends BaseController
{
    
    public function index()
    {
        $postdata=I('post.');$this->assign($postdata);
        $where = array();
        if (!empty($postdata['keyword'])) {
            $keyword = $postdata['keyword'];
            $memberwhereor['username'] = array('like', '%' . $keyword . '%');
            $memberwhereor['mobile'] = array('like', '%' . $keyword . '%');
            $memberwhereor['_logic'] = 'or';
            $memberwhere['_complex'] = $memberwhereor;
            $memberwhere['status'] = 1;
            $userid = M('Member')->where($memberwhere)->getField('id', true);
            if (!empty($userid)) {
                $shopwhere['uid'] = array('in', $userid);
                $shopid = M('Shops')->where($shopwhere)->getField('id', true);
                if (!empty($shopid)) $whereor['shops_id'] = array('in', $shopid);
            }
            $whereor['name'] = array('like', '%' . $keyword . '%');
            $whereor['phone'] = array('like', '%' . $keyword . '%');
            $whereor['_logic'] = 'or';
            $where['_complex'] = $whereor;
        }
        $where['publish_wait'] = array('notin','1,4');
        if (!empty($postdata['apply_from'])) $where['updatetime'][] = array('EGT', strtotime($postdata['apply_from']));
        if (!empty($postdata['apply_to'])) $where['updatetime'][] = array('elt', strtotime($postdata['apply_to']));
        $all_info=$this->lists('ShopsSubmit',$where);
        $this->assign('list', $all_info);
        $this->display();
    }

    
    public function edit_shops(){
        $id = I('id');
        $model = M("ShopsSubmit");
        if (isset($id)) {
            $id = isset($id) && intval($id) ? intval($id) : $this->error('参数错误');
        }
        if (empty($id)) $this->error('参数错误');
        $info = $model->where('id='.$id)->find();
		$info['cate_id']=explode(',',$info['cate_ids']);
        $this->assign($info);
        $this->assign('id', $id);
        $this->display();
    }

    
    public function audit_shops(){
        $id=I('id'); if(empty($id))$this->error('参数不正确！');
        $audit=I('get.audit');
        $postdata=I('post.');
        if($audit==2)$postdata['shops_id']=idtoname($id,'ShopsSubmit','shops_id');
        $result=$this->audit_shop_item($id,$postdata,$audit);
        if($result['status']==1)$this->success($result['msg'],U('Audit/index'));
        else $this->error($result['msg']);
    }

    
    public function audit_shop(){
        $audit = I('get.audit');    
        $postdata = I('post.');
        if (empty($postdata['id'])) $this->error('请选择要审核的项！');
        $result=array();
        $result['status']=0;
        
        
        if($audit==2)
        {
            $postdata['id']=explode(',',$postdata['id']);
            $postdata['id']=array_filter($postdata['id']);
        }
       
        foreach ($postdata['id'] as $key => $value) {
            $data=M('ShopsSubmit')->where('id='.$value)->find();
            $data['reason']=$postdata['reason'];
            $result=$this->audit_shop_item($value,$data,$audit);
            unset($data);
        }
        if($result['status']==1)$this->success($result['msg'],U('Audit/index'));
        else $this->error($result['msg']);
    }

    
    public function audit_shop_item($id,$postdata=array(),$audit=1){
        $return=array('status'=>0,'msg'=>'');
        $shops_id=$postdata['shops_id'];
        
        unset($postdata['id'],$postdata['shops_id']);
        $postdata['updatetime']=NOW_TIME;
        if($audit==1) {
            if(!empty($postdata)){
				if(empty($postdata['postion'])){
					$str='';
					if($postdata['province'])$str.=$postdata['province'];unset($postdata['province']);
					if($postdata['city_id'])$str.=','.$postdata['city_id'];unset($postdata['city_id']);
					if($postdata['district'])$str.=','.$postdata['district'];unset($postdata['district']);
					$postdata['postion']=$str;
					
					$postdata['licence_start']=strtotime($postdata['licence_start']);
					$postdata['licence_end']=strtotime($postdata['licence_end']);
				}
                
                $count=M('Shops')->where('id='.$shops_id)->count();
                if ($count >0) {
                    $g_info=M('Shops')->where('id='.$shops_id)->save($postdata);
                } else {
                    $shops_id=$g_info=M('Shops')->add($postdata);
					$save['shop_id']=$shops_id;
					M('Member')->where('id='.$postdata['uid'])->save($save);
					if($postdata['cate_ids']){
						$cateids=explode(',',$postdata['cate_ids']);
						foreach($cateids as $k=>$v){
							$data=array();
							$data['shop_id']=$shops_id;
							$data['cat_id']=$v;
							$data['status']=1;
							$data['type']=2;
							$data['addtime']=NOW_TIME;
							$data['update_time']=NOW_TIME;
							$scl_id=M('ShopCateLink')->add($data);
                            $op_data=array();
                            $op_data['id']=$scl_id;
                            $op_data['status']=2;
                            D('Admin/Shops')->operate_shops_cateadd($op_data);
						}
					}
                }
                if ($g_info>0) {
                    $return['status'] = 1;
                    $return['msg'] = '审核通过成功！';
                    $send_data['to']=$postdata['uid'];
                    $send_data['from']='admin(系统)';
                    $send_data['type']=2;
                    $send_data['content']='您申请的店铺已审核通过！';
                    send_method(3,$send_data);
                }
            }
        }else{
            if(empty($postdata['reason'])){
                $this->error('请填写未通过审核原因！');
            }
            $return['status'] = 1;
            $return['msg']='审核不通过成功！';
            $send_data['to']=$postdata['uid'];
            $send_data['from']='admin(系统)';
            $send_data['type']=2;
            $send_data['content']='您申请的店铺未通过审核！原因是：'.$postdata['reason'];
            send_method(3,$send_data);
        }
        if ($return['status']==1) {
			if($audit==1){
				$sub_data=$postdata;
			}
            $sub_data['publish_wait'] = $audit;
			$sub_data['shops_id']=$shops_id;
			$ss_map['id']=$id;
            M('ShopsSubmit')->where($ss_map)->save($sub_data);
        }
        if(!empty($shops_id)) add_audit_log($shops_id, 2, $audit, $return['msg']);
        if(empty($return['msg']))$return['msg']='审核失败！';
        return $return;
    }

    
    public function goods()
    {
		$postdata=I('post.');
        $shopid = $postdata['shopid'];
        $postdata['shop_id'] = empty($shopid) ? 0 : $shopid;
        $postdata['publish_wait'] = array('neq', 1);
        $map = D('Goods')->index_condition($postdata);
        if (!isset($postdata['catid'])) {
            $postdata['catid'] = 0;
        }
        if (!isset($postdata['brandid'])) {
            $postdata['brandid'] = 0;
        }
        if (!isset($postdata['suppliersid'])) {
            $postdata['suppliersid'] = 0;
        }
        $this->getcateTree($postdata['catid'], '', $postdata['brandid'], $postdata['suppliersid']);
        $g_info = $this->lists('Goods', $map);
        $this->assign('goods_info', $g_info);
        $this->assign($postdata);
        $this->display();
    }

    
    public function goods_shops()
    {
        $name = 'Goods';
        $postdata = I('param.');
        if(!isset($postdata['shops_keyword'])) {
            $postdata['shops_keyword'] = '';
        }
        $postdata['publish_wait'] = array('neq',1);
        $where=D($name)->index_condition($postdata);
		$where['status']=1;
        $g_info = $this->lists('Goods', $where);
        $this->assign('goods_info', $g_info);
        $this->display();
    }

    
    public function audit()
    {
        $name = I('get.model');
        if (!isset($name)) $name = 'Goods';
        $type = 1;  
        $content = '';
        switch ($name) {
            case 'Goods':
                $type = 1;
                break;
            case 'Shops':
                $type = 2;
                break;
            case 'ProjectLabelLink':
                $type = 6;
                break;
        }
        $audit = I('get.audit');    
        $postdata = I('post.');
        if (empty($postdata['id'])) $this->error('请选择要审核的项！');
        $where['publish_wait'] = $audit;
        
        if ($name == 'ProjectLabelLink' && $audit == 1) $where['update_time'] = NOW_TIME;
        foreach ($postdata['id'] as $key => $value) {
            $map['id'] = $value;
            $g_info = M($name)->where($map)->save($where);
            if (!empty($g_info)) {
                if ($audit == 1) $content = '审核通过';
                if ($audit == 2) $content = '审核不通过';
                add_audit_log($value, $type, $audit, $content);
            }
        }
        if (!empty($g_info)) {
            $this->success('审核成功！');
        } else {
            $this->error('审核失败！');
        }
    }

    
    public function delete()
    {
        $name = I('get.model');
        if (!isset($name)) $name = 'Shops';
        $postdata = I('post.');
        if (empty($postdata['id'])) $this->error('请选择要删除的项！');
        foreach ($postdata['id'] as $key => $value) {
            $map['id'] = $value;
            $dete = M($name)->where($map)->delete();
        }
        if ($dete != false) {
            $this->success('删除成功！');
        } else {
            $this->error('删除失败！');
        }
    }

    
    private function getNodeTree($pid = '', $assign = '', $brandid = '', $suppliersid = '')
    {
        if (empty($pid)) $pid = I('pid');
        $this->getcateTree($pid, $assign, $brandid, $suppliersid);
        
        $suppliersattr = M('Suppliers')->where('status>0')->field('id,name')->cache(true)->order('convert(name using gb2312) ASC')->select();
        $supplierattr = array();
        if (!empty($suppliersattr)) {
            foreach ($suppliersattr as $v) {
                $supplierattr[$v['id']] = $v['name'];
            }
        }
        $this->assign('suppliers', $supplierattr);
        unset($suppliersattr, $supplierattr);
    }

    
    private function getcateTree($pid = '', $assign = '', $brandid = '', $suppliersid = '')
    {
        $GoodsCategory = getcache('GoodsCategory');
        $Tree = new \Common\Vendor\Tree();
        $select_categorys = '';
        $treemini = $Tree->treemini($GoodsCategory);
        $select_categorys .= $Tree->treeminioption($treemini, $pid);
        if ($assign) return $select_categorys; else $this->assign('select_categorys', $select_categorys);
        $brand = M('Brand')->where('status=1')->order('convert(brand_name using gb2312) ASC')->field('id,brand_name')->select();
        $brand_op = "<option value=''>" . L('PLEASE_SELECT_BRAND') . "</option>";
        foreach ($brand as $k => $v) {
            if ($brandid == $v['id']) {
                $brand_op .= "<option selected='selected' value='" . $v['id'] . "'>" . $v['brand_name'] . "</option>";
            } else {
                $brand_op .= "<option value='" . $v['id'] . "'>" . $v['brand_name'] . "</option>";
            }
        }
        $this->assign('select_brands', $brand_op);
        $suppliers_info = M('Suppliers')->where('status=1')->order('convert(name using gb2312) ASC')->field('id,name')->select();
        $suppliers_op = '';
        if (!empty($suppliers_info)) {
            foreach ($suppliers_info as $k => $v) {
                if ($suppliersid == $v['id']) {
                    $suppliers_op .= "<option selected='selected' value='" . $v['id'] . "'>" . $v['name'] . "</option>";
                } else {
                    $suppliers_op .= "<option value='" . $v['id'] . "'>" . $v['name'] . "</option>";
                }
            }
        }
        $this->assign('select_suppliers', $suppliers_op);
        unset($GoodsCategory, $select_categorys, $brand, $brand_op, $suppliers_info, $suppliers_op);
    }
}