<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
class BrandCategoryController extends BaseController
{
    public function _initialize()
    {
        parent::_initialize();
        $keyword=I('keyword');
        $keywords=!empty($keyword)?$keyword:'';
        if (is_numeric($keywords)) {
            $map['id|name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if (!empty($keyword)) {
            $map['name'] = array('like', '%' . (string)$keyword . '%');
        }
        $data = I('param.');$order = '';
        if(!empty($data['_order'])&&!empty($data['_field'])){$order = $data['_field']." ".$data['_order'].',';}
        $order .= 'sort asc';
        $this->BrandCategory = M('BrandCategory')->where($map)->order($order)->select();
    }

    
    public function index()
    {
        $pid = I('pid') ? I('pid') : 1;
        $BrandCategory = $this->BrandCategory;
        $Tree = new \Common\Vendor\Tree();
        $Tree->icon = array('&nbsp;&nbsp;&nbsp;│ ', '&nbsp;&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;&nbsp;└─ ');
        $Tree->nbsp = '&nbsp;&nbsp;&nbsp;';
        foreach ($BrandCategory as &$values) {
            $values['str_manage'] = '<a href="' . U('add', array('pid' => $values['id'])) . '" class="operate">' . L('ADD_CHILD_CAT') . '</a>&nbsp;&nbsp;<a class="operate" href="' . U('edit', array('id' => $values['id'])) . '">' . L('EDIT') . '</a>&nbsp;&nbsp;<a class="operate" href="javascript:;" onclick="$.showConfirm(\'' . L('SURE_DELETE') . '\',function(){window.location.href=\''.U('delete', array('id' => $values['id'])).'\'},\'hc\')">' . L('DELETE') . '</a>';
            $values['status'] = '<img src="' . __ROOT__ . '/Application/Admin/View/' . get_default_theme() . '/common/images/status_' . $values['status'] . '.gif" />';
        }
        $Tree->init($BrandCategory);
        $str = "<tr>
                 <td><input value='\$id' name='id[]' type='checkbox' ></td>
	    <td>\$id</td>
		<td ondblclick=editeTable(this,'sort','\$id','sort')>\$sort</td>
		<td title='\$name'>\$spacer\$name</td>
        <td>\$status</td>
		<td>\$str_manage</td>
		</tr>";
        $cateString = $Tree->get_tree(0, $str);
        $this->assign('cateString', $cateString);
        $this->display();
    }

    
    public function insert()
    {
        $model = D(CONTROLLER_NAME);
        if (false === $model->create()) {
            $this->error($model->getError());
        }
        $id = $model->add();
        $data = I('post.');
        $map['name'] = $data['name'] ? $data['name'] : '';
        $map['is_home'] = $data['is_home'] ? $data['is_home'] : '';
        $map['sort'] = $data['sort'] ? $data['sort'] : '';
        $map['pid'] = $data['pid'] ? $data['pid'] : '';
		$map['price'] = $data['price'];
        $map['status'] = $data['status'] ? $data['status'] : '';
        $res = M('BrandCategory')->where('id=' . $id)->data($map)->save();
        if ($res !== false) {
            if (in_array(CONTROLLER_NAME, $this->cache_model)) {
                savecache(CONTROLLER_NAME);
            }
            if ($_POST['isajax']) $this->assign('dialog', '1');
            $jumpUrl = $_POST['forward'] ? $_POST['forward'] : U(CONTROLLER_NAME . '/index');
            $this->assign('jumpUrl', $jumpUrl);
            $this->success(L('ADD_OK'));
        } else {
            $this->error(L('ADD_ERROR') . ': ' . $model->getDbError());
        }
    }

    
    public function update()
    {
        $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/index');
        $id = array_unique((array)I('id', 0));
        $id = is_array($id) ? implode(',', $id) : $id;
        $data = I('post.');
        $map['name'] = $data['name'] ? $data['name'] : '';
        $map['is_home'] = $data['is_home'] ? $data['is_home'] : '';
        $map['sort'] = $data['sort'] ? $data['sort'] : '';
        $map['status'] = $data['status'] ? $data['status'] : '';
		$map['price'] = $data['price'];
        $map['pid'] = $data['pid'] ? $data['pid'] : '';
        $res = M('BrandCategory')->where('id=' . $id)->data($map)->save();
        $msg = array_merge(array('success' => L('edit_ok'), 'error' => L('edit_error'), 'url' => $jumpUrl, 'ajax' => IS_AJAX), (array)$msg);
        if ($res !== false) {
            if (in_array(CONTROLLER_NAME, $this->cache_model)) {
                savecache(CONTROLLER_NAME);
            }
            $this->success($msg['success'], $msg['url'], $msg['ajax']);
        } else {
            $this->error($msg['error'], $msg['url'], $msg['ajax']);
        }
    }

    public function _before_add()
    {
        $this->getNodeTree();
    }

    public function _before_edit()
    {
        $id = I('get.id');
        $info = '';
        if (!$id) $this->error('参数错误!');
        $info = $this->BrandCategory[$id];
        $this->getNodeTree();
    }
	public function _before_delete(){
		$id=I('id');
		$result=check_delete($id,6,CONTROLLER_NAME,'brand_cat_id');
		if(!$result['status']){$this->error($result['info']);exit;}
	} 
    
    private function getNodeTree($pid = '')
    {
        $select_categorys = '';
        $BrandCategory = $this->BrandCategory;
        if (empty($pid)) $pid = I('pid');
        $Tree = new \Common\Vendor\Tree();
        $treemini = $Tree->treemini($BrandCategory);
        $select_categorys .= $Tree->treeminioption($treemini, $pid);
        $this->assign('select_categorys', $select_categorys);
    }
}