<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
class BrandController extends BaseController
{
    public function _initialize()
    {
        parent::_initialize();
    }

    
    public function index()
    {
        $keyword = I('keyword');
        $brand_cat_id = I('brand_cat_id');
        $map = array();
        if (!empty($keyword)) {
            $map['id|brand_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        }
        if (!empty($brand_cat_id)) {
            $map['brand_cat_id'] = $brand_cat_id;
        }
        $this->getNodeTree($brand_cat_id);
        $list = $this->lists(CONTROLLER_NAME, $map);
        $this->assign('list', $list);
        $this->display();
    }

    public function _before_add()
    {
        $this->getNodeTree();
    }

    public function _before_edit()
    {
        $id = I('get.id');
        if (empty($id)) $this->error(L('PARAM_ERR'));
        $info = M('Brand')->where('id=' . $id)->field(true)->find();
        $this->getNodeTree($info['brand_cat_id']);
    }

    public function insert(){
        $name = CONTROLLER_NAME;
        $model = D($name);
        if (false === $model->create()) {
            $this->error($model->getError());
        }
        $postdata = I('post.');
        $map['brand_name']=$postdata['brand_name'];
        $count=M($name)->where($map)->count('id');
        if($count>0){
            $this->error('该品牌已存在，请重新添加',U(CONTROLLER_NAME.'/index'));
        }else{
            $id = $model->add();
            if ($id !==false) {
              if(in_array(CONTROLLER_NAME,$this->cache_model)){savecache(CONTROLLER_NAME);}
                if($_POST['isajax'])$this->assign('dialog','1');
                $jumpUrl = $_POST['forward'] ? $_POST['forward'] : U(CONTROLLER_NAME.'/index');
                $this->assign ( 'jumpUrl',$jumpUrl );
                $this->success (L('ADD_OK'));
            } else {$this->error (L('ADD_ERROR').': '.$model->getDbError());} 
        }
    }

    public function update(){
        $name = CONTROLLER_NAME;
        $model = D($name);
        $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/index');
        $id = array_unique((array)I('id', 0));
        $id = is_array($id) ? implode(',', $id) : $id;
        $data = I('post.'); 
        $map['brand_name']=$data['brand_name'];
        $map['id']=array('neq',$id);
        $count=M('Brand')->where($map)->count('id');
        if($count>0){
            $this->error('填写的品牌名已经存在，请更换名称',$jumpUrl);
        }else{
            $where['id']=$id;
            $res=$model->where($where)->save($data);
            $msg = array_merge(array('success' => L('EDIT_OK'), 'error' => L('EDIT_ERROR'), 'url' => $jumpUrl, 'ajax' => IS_AJAX), (array)$msg);
            if ($res !== false) {
                if (in_array(CONTROLLER_NAME, $this->cache_model)) {
                    savecache(CONTROLLER_NAME);
                }
                $this->success($msg['success'], $msg['url'], $msg['ajax']);
            } else {
                $this->error($msg['error'], $msg['url'], $msg['ajax']);
            }
        }
    }

    
    private function getNodeTree($pid = '')
    {
        $select_categorys = '';
        $BrandCategory = M('BrandCategory')->where('status=1')->order('sort desc,id desc')->field(true)->select();
        if (empty($pid)) $pid = I('brand_cat_id');
        $Tree = new \Common\Vendor\Tree();
        $treemini = $Tree->treemini($BrandCategory);
        $select_categorys .= $Tree->treeminioption($treemini, $pid);
        $this->assign('select_categorys', $select_categorys);
    }
}