<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
class ContractController extends BaseController
{
    public function applylist(){
        $postdata=I('param.');$this->assign($postdata);
        $where=$this->getcondition($postdata);
        $info=array();
        if(!empty($where)) {
            $where['publish_wait'] = array('in', '0,1,2');
            $info = $this->lists('ProjectLabelLink', $where, 'publish_wait');
        }
        $this->assign('info',$info);
        $this->display();
    }
    public function quitlist(){
        $postdata=I('param.');$this->assign($postdata);
        $where=$this->getcondition($postdata);
        $info=array();
        if(!empty($where)) {
            $where['publish_wait'] = array('in', '3,4,5');
            $info = $this->lists('ProjectLabelLink', $where, 'publish_wait');
        }
        $this->assign('info',$info);
        $this->display();
    }
    public function contractlist(){
        $postdata=I('param.');$this->assign($postdata);
        $where=$this->getcondition($postdata);
        $info=array();
        if(!empty($where)) {
            $where['publish_wait'] = array('in', '1,4');
            $info = $this->lists('ProjectLabelLink', $where, 'publish_wait');
        }
        $this->assign('info',$info);
        $this->display();
    }
    public function getcondition($postdata)
    {
        $where = array();
        $plmap['type']=1;
        $label_id=M('ProjectLabel')->where($plmap)->getField('id',true);
        if(empty($label_id))return $where;
        if (!empty($postdata['apply_from'])) $where['apply_time'][] = array('EGT', strtotime($postdata['apply_from']));
        if (!empty($postdata['apply_to'])) $where['apply_time'][] = array('elt', strtotime($postdata['apply_to']));
        if (!empty($postdata['update_from'])) $where['update_time'][] = array('EGT', strtotime($postdata['update_from']));
        if (!empty($postdata['update_to'])) $where['update_time'][] = array('elt', strtotime($postdata['update_to']));
        if (!empty($postdata['keyword'])) {
            $keyword = $postdata['keyword'];
            $where['shop_id'][] = array('like', '%' . $keyword . '%');
            $memberwhereor['username'] = array('like', '%' . $keyword . '%');
            $memberwhereor['mobile'] = array('like', '%' . $keyword . '%');
            $memberwhere['_complex'] = $memberwhereor;
            $memberwhere['status'] = 1;
            $userid = M('Member')->where($memberwhere)->getField('id', true);
            $shoprwhere['name'] = array('like', '%' . $keyword . '%');
            $shoprwhere['status'] = 1;
            $shopids=M('Shops')->where($shoprwhere)->getField('id',true);
            if(!empty($shopids))
            {
                $where['shop_id'][]= array('in', $shopids);
            }
            if (!empty($userid)) {
                $shopwhere['uid'] = array('in', $userid);
                $shopid = M('Shops')->where($shopwhere)->getField('id', true);
                if (!empty($shopid)) $where['shop_id'][] = array('in', $shopid);
            }
            $where['shop_id'][] = 'or';
        } else {
            $where['shop_id'] = array('neq', 0);
        }
        $where['goods_id']=0;
        return $where;
    }
    public function audit()
    {
        $name = 'ProjectLabelLink';
        $type = 4;  
        $content = '';
        $audit = I('get.audit');    
        $postdata = I('param.');
        $id=I('id');
        if($id)$postdata['id']=$id;
        if (empty($postdata['id'])) $this->error('请选择要审核的项！');
        if($audit == 2 || $audit == 5){
            if(empty($postdata['reason'])){
                $this->error('请填写未通过审核原因！');
            }
        }
        if($audit==2)
        {
            $postdata['id']=array_filter(explode(',',$postdata['id']));
        }
        $where['publish_wait'] = $audit;
        if ($audit == 1 || $audit == 4) $where['update_time'] = NOW_TIME;
        $postdata['id']=array($postdata['id']);
        foreach ($postdata['id'] as $key => $value) {
            $map['id'] = $value;
            $g_info = M($name)->where($map)->save($where);
            if (!empty($g_info)) {
                $shop_id=idtoname($value,$name,'shop_id');
                $uid=idtoname($shop_id,'Shops','uid');
                $deposit=idtoname($value,$name,'deposit');
                $protectlabel=idtoname(idtoname($value,$name,'label_id'),'ProjectLabel','label_name');
                if ($audit == 1){
                    $content = '服务('.$protectlabel.')加入申请通过';
                    shop_balance_log($shop_id, -$deposit, 4, 4, '加入('.$protectlabel.')消费者保障服务审核通过');
                    $send_data['to']=$uid;
                    $send_data['from']='admin(系统)';
                    $send_data['type']=2;
                    $send_data['content']='您店铺申请加入的('.$protectlabel.')消费者保障服务已审核通过！';
                    send_method(3,$send_data);
                }elseif ($audit == 2){
                    $content = '服务('.$protectlabel.')加入申请不通过';
                    shop_balance_log($shop_id, -$deposit, 4, 4, '加入('.$protectlabel.')消费者保障服务审核不通过');
                    shop_balance_log($shop_id, $deposit, 1, 4, '加入('.$protectlabel.')消费者保障服务审核不通过');
                    $send_data['to']=$uid;
                    $send_data['from']='admin(系统)';
                    $send_data['type']=2;
                    $send_data['content']='您店铺申请加入的('.$protectlabel.')消费者保障服务审核未通过！原因是：'.$postdata['reason'];
                    send_method(3,$send_data);
                }elseif ($audit == 4){
                    $content = '服务('.$protectlabel.')退出申请通过';
                    shop_balance_log($shop_id, -$deposit, 4, 4, '退出('.$protectlabel.')消费者保障服务审核通过');
                    shop_balance_log($shop_id, $deposit, 1, 4, '退出('.$protectlabel.')消费者保障服务审核通过');
                    $send_data['to']=$uid;
                    $send_data['from']='admin(系统)';
                    $send_data['type']=2;
                    $send_data['content']='您店铺申请退出的('.$protectlabel.')消费者保障服务已审核通过！';
                    send_method(3,$send_data);
                }elseif ($audit == 5){
                    $content = '服务('.$protectlabel.')退出申请不通过';
                    $send_data['to']=$uid;
                    $send_data['from']='admin(系统)';
                    $send_data['type']=2;
                    $send_data['content']='您店铺申请退出的('.$protectlabel.')消费者保障服务审核未通过！原因是：'.$postdata['reason'];
                    send_method(3,$send_data);
                }
                add_audit_log($value, $type, $audit, $content);
            }
        }
        if (!empty($g_info)) {
            $this->success('审核成功！');
        } else {
            $this->error('审核失败！');
        }
    }
    public function citemlist(){
        $type = 1;
        $where['type']=$type;
        $info = M('ProjectLabel')->where($where)->select();
        $this->assign('type', $type);
        $this->assign('list', $info);
        $this->display();
    }
    public function delete()
    {
        $as = I('param.');
		$id=I('id');
		if(isset($id)&&is_array($id)){
            $postdata['id'] = implode(',', $id);
			foreach($id as $k=>$v){
				$result=check_delete($v,9);
				if(!$result['status'])unset($id[$k]);
			}
			if(empty($id)){$this->error($result['info']);return ;}
		}else{
            $postdata['id'] = $id;
			$result=check_delete($id,9);
			if(!$result['status']){$this->error($result['info']);return ;}
		}
        $name=I('model');
        if(empty($name))$name='ProjectLabel';
        if(!in_array($name,array('ProjectLabelLink','ProjectLabel'))){$this->error($result['info']);return ;}
        if (empty($postdata['id']) && !empty($id)) $postdata['id'] = $id;
        if (empty($postdata['id'])) {
            $this->error(L('PARAM_ERR'));
        }
        $map=array();
        $map['id'] =is_array($postdata['id']) || str_exists($postdata['id'],',') ? array('in',$postdata['id']):$postdata['id'];
        $deletes = M($name)->where($map)->delete();
        if ($deletes > 0) {
            $this->success(L('DELETE_SUCCESS'));
        } else {
            $this->error(L('DELETE_FAILED'));
        }
    }
}