<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Admin\Controller;
class FloorController extends BaseController{
    public function index(){
        $name = CONTROLLER_NAME;
        $map=array();
        $keyword=I('keyword');
        $map['device']=I('device');
        if($keyword)$map['name']=array('like',"%".$keyword."%");
        $list = $this->lists($name,$map);
        $this->assign('list', $list);
        $this->display();
    }
    public function _before_add(){
        $data = getmodtpl('','FloorTheme','unset');
        foreach($data as $k=>$v){$v=str_replace('.html','',$v);$theme_options[$v]=$v;}
        $this->assign('theme_options', $theme_options);
        $this->getcateTree();
    }
    public function _before_edit(){  
        $data = getmodtpl('','FloorTheme','unset');
        foreach($data as $k=>$v){$v=str_replace('.html','',$v);$theme_options[$v]=$v;}
        $this->assign('theme_options', $theme_options);
        $pid=idtoname(I('id'),CONTROLLER_NAME,'bind_cateid');
        $this->getcateTree($pid);
        $this->floor_recommend_cate($pid,0);
    }
    public function insert() {
		$name = CONTROLLER_NAME;
		$model = D ($name);
		$data=$model->create ();
		
		$code_map['floor_code']=$data['floor_code'];
		$code_map['status']=1;
        $code_map['device']=$data['device'];
		$is_code=$model->where($code_map)->find();
		if($is_code){$this->error('标识重复');}
		
		if (false === $data) {
			$this->error ( $model->getError () );
		}
        $data['recommend_cate']=implode(',', $data['recommend_cate']);
		$id = $model->add($data);
		if ($id !==false) {
			if($_POST['isajax'])$this->assign('dialog','1');
			$jumpUrl = $_POST['forward'] ? $_POST['forward'] : U(CONTROLLER_NAME.'/index',array('device'=>$_POST['device']));
			$this->assign ( 'jumpUrl',$jumpUrl );
			$this->success (L('ADD_OK'));
		} else {
			$this->error (L('ADD_ERROR').': '.$model->getDbError());
		}
	}
    public function update (){
		if(!$model)$model=CONTROLLER_NAME;
		$data=M($model)->create ();
		$jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME.'/index',array('device'=>$_POST['device']));
        $id    = array_unique((array)I('id',0));
        $id    = is_array($id) ? implode(',',$id) : $id;
        $where = array_merge( array('id' => array('in', $id )) ,(array)$where );
        $msg   = array_merge( array('success'=>L('edit_ok'), 'error'=>L('edit_error'), 'url'=>$jumpUrl ,'ajax'=>IS_AJAX) , (array)$msg );
        
		
		$code_map['floor_code']=$data['floor_code'];
		$code_map['status']=1;
		$code_map['id']=array('neq',$id);
        $code_map['device']=$data['device'];
		$is_code=M($model)->where($code_map)->find();
		if($is_code){$this->error('标识重复',$msg['url'],$msg['ajax']);}

        $data['recommend_cate']=empty($data['recommend_cate'])?'':implode(',', $data['recommend_cate']);
		if( M($model)->where($where)->save($data)!==false ) {
            $this->success($msg['success'],$msg['url'],$msg['ajax']);
        }else{
            $this->error($msg['error'],$msg['url'],$msg['ajax']);
        }
    }
    private function getcateTree($pid = '',$assign='') {
		$GoodsCategory = getcache('GoodsCategory');
		$Tree = new \Common\Vendor\Tree();
		$select_categorys='';
		$treemini=$Tree->treemini($GoodsCategory);
		$select_categorys.= $Tree->treeminioption($treemini,$pid);
		if($assign)return $select_categorys;
		else $this->assign('select_categorys',$select_categorys);
	}
    public function floor_recommend_cate($cateid=0,$is_ajax=1){
        $return=$recommend_cate=array();$return['status']=0;
        if($is_ajax==1){
            $cateid=I('cateid');
        }
        $recommend_cate_html='';
        if($cateid) {
            $GoodsCategory = getcache('GoodsCategory');
            foreach($GoodsCategory as $k=>$v){
                if($v['pid']==$cateid){
                    $recommend_cate[$k]=$v;
                    $recommend_cate_html.='<label class="checkbox-inline "><input name="recommend_cate[]" value="'.$v['id'].'" id="recommend_cate_'.$v['id'].'" type="checkbox">'.$v['name'].' </label>';
                }
            }
        }
        if($is_ajax==1) {
            if (!empty($recommend_cate_html)) {
                $return['status'] = 1;
                $return['html'] = '<th>推荐分类：</th><td>' . $recommend_cate_html . '</td>';
            }
            $this->ajaxReturn($return);
        }else{
            $recommend_cate=format_array2select($recommend_cate);
            $this->assign('recommend_cate_arr', $recommend_cate);
        }
    }
}