<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
class GoodsController extends BaseController
{
    public function _initialize()
    {
        parent::_initialize();
    }
    public function index()
    {
        $name = CONTROLLER_NAME;
        $postdata = I('param.');
        $postdata['is_delete'] = 0;
        $postdata['publish_wait'] = 1;
        $map = D($name)->index_condition($postdata);
        if (!isset($postdata['catid'])) {
            $postdata['catid'] = 0;
        }
        if (!isset($postdata['brandid'])) {
            $postdata['brandid'] = 0;
        }
        if (!isset($postdata['suppliersid'])) {
            $postdata['suppliersid'] = 0;
        }
        $this->getcateTree($postdata['catid'], '', $postdata['brandid'], $postdata['suppliersid']);
        $list = $this->lists($name, $map);
        $this->assign('list', $list);
        $this->assign($postdata);
        $this->display();
    }
    public function _before_add()
    {
        $this->getNodeTree();
        $basedefault = array('moreimg' => '', 'moreimgstr' => '', 'morecatarr' => '', 'morecatid' => '', 'configstr' => '');
        $this->assign($basedefault);
        $this->get_goods_label();
        $this->get_member_price();
    }
    public function insert()
    {
        $name = CONTROLLER_NAME;
        $model = D($name);
        if (false === $model->create()) {
            $this->error($model->getError());
        }
        $id = $model->add();
        if ($id !== false) {
            $postdata = I('post.');
            $postdata['id'] = $id;
            $model->update_goodsattr($postdata, 1);
            $model->update_goodsimg($postdata, 1);
            $model->update_goodstype($postdata, 1);
            $model->update_user_price($postdata, 1);
            $model->update_goods_sn($postdata, 1);
            $model->update_goods_content($postdata, 1);
            $model->update_goods_label($postdata, 1);
            unset($postdata);
            if ($_POST['isajax']) $this->assign('dialog', '1');
            $jumpUrl = $_POST['forward'] ? $_POST['forward'] : U(CONTROLLER_NAME . '/index');
            $this->assign('jumpUrl', $jumpUrl);
            $this->success(L('ADD_OK'));
        } else {
            $this->error(L('ADD_ERROR') . ': ' . $model->getDbError());
        }
    }
    public function edit()
    {
        $id = I('get.id');
        $info = '';
        if (!$id) $this->error(L('PARAM_ERR'));
        $info = M('goods')->field(true)->find($id);
        $this->get_goods_label($id);
        $morecatarr = $morecatidarr = array();
        $where1['goods_id'] = $id;
        $morecat = M('GoodsCat')->where($where1)->field(true)->select();
        if (!empty($morecat)) {
            foreach ($morecat as $v) {
                $morecatidarr[] = $v['catid'];
                $morecatarr[] = $this->getcateTree($v['catid'], 1);
            }
        }
        $this->assign('morecatarr', $morecatarr);
        $this->assign('morecatid', implode(',', $morecatidarr));
        $this->get_member_price($id);
        $moreimg = M('GoodsGallery')->where('goods_id=' . $id)->field('id,goods_img,img_desc,img_sort')->order('id')->select();
        $moreimgarr = array();
        $moreimgstr = '';
        if (!empty($moreimg)) {
            foreach ($moreimg as $v) {
                $moreimgarr['goods_img'][] = $v['goods_img'];
                $moreimgarr['img_desc'][] = $v['img_desc'];
                $moreimgarr['img_sort'][] = $v['img_sort'];
            }
            $moreimgstr = implode('', $moreimgarr['goods_img']) . implode('', $moreimgarr['img_desc']) . implode('', $moreimgarr['img_sort']);
        }
        $this->assign('moreimg', $moreimg);
        $this->assign('moreimgstr', md5($moreimgstr));
        $this->getNodeTree($info['cat_id'], '', $info['brand_id'], $info['suppliers_id'],$id);
        $goodscontent = M('GoodsContent')->where('goods_id = ' . $id)->find();
        $info['content'] = $goodscontent['content'];
        $info['seotitle'] = $goodscontent['seotitle'];
        $info['seokeywords'] = $goodscontent['seokeywords'];
        $info['seodescription'] = $goodscontent['seodescription'];
        $this->assign($info);
        $this->assign('info', $info);
        unset($info, $morecatarr, $morecatidarr, $moreimg, $moreimgarr, $moreimgstr);
        $this->display();
    }
    public function update($model = '', $data = '', $where = '1', $msg = '')
    {
        $model = D(CONTROLLER_NAME);
        $postdata = I('post.');
        $checkcheckbox = array('is_best', 'is_new', 'is_hot', 'is_shipping');
        foreach ($checkcheckbox as $v) {
            if (empty($postdata[$v])) $postdata[$v] = '0';
        }
        $data = $model->create($postdata);
        $data[''] =
        $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/index');
        $id = array_unique((array)I('id', 0));
        $id = is_array($id) ? implode(',', $id) : $id;
        $where = array_merge(array('id' => array('in', $id)), (array)$where);
        $msg = array_merge(array('success' => L('edit_ok'), 'error' => L('edit_error'), 'url' => $jumpUrl, 'ajax' => IS_AJAX), (array)$msg);
        if ($model->where($where)->save($data) !== false) {
            $postdata['id'] = $id;
            $model->update_goodsattr($postdata);
            $model->update_goodsimg($postdata);
            $model->update_goodstype($postdata);
            $model->update_user_price($postdata);
            $model->update_goods_sn($postdata);
            $model->update_goods_content($postdata);
            $model->update_goods_label($postdata);
            clearhomehtml($id);
            unset($data, $postdata, $newgoodscat, $newgoodsimg, $goodstype, $goodstypearr, $newgoodsattr);
            $this->success($msg['success'], $msg['url'], $msg['ajax']);
        } else {
            $this->error($msg['error'], $msg['url'], $msg['ajax']);
        }
    }
    public function get_member_price($id=0){
        $morerank = M('MemberRank')->field('id,name')->select();
        $user_price_list = M('MemberPrice')->where('goods_id = ' . $id)->field('user_price,user_rank')->select();
        $member_price = array();
        if($user_price_list){
            $user_price=format_array2select($user_price_list,'user_price','user_rank');
        }
        if($morerank){
            foreach ($morerank as $key => $v) {
                $k=$v['id'];
                $member_price[$k]['id'] = $v['id'];
                $member_price[$k]['name'] = $v['name'];
                if(!empty($user_price[$k]))$member_price[$k]['user_price'] = $user_price[$k];
            }
        }
        $this->assign('member_price', $member_price);
        $this->assign('morerank', $morerank);
    }
    public function get_goods_label($goods_id = '')
    {
        $goods_label_link = array();
        if (!empty($goods_id)) {
            $map = array();
            $map['goods_id'] = $goods_id;
            $map['type']=0;
            $label_link = M('ProjectLabelLink')->field('label_id')->where($map)->select();
            if (!empty($label_link)) {
                foreach ($label_link as $key => $val) {
                    $goods_label_link[$key] = $val['label_id'];
                }
            }
        }
        $where = array();
        $where['type']=0;
        $goods_label = M('ProjectLabel')->where($where)->select();
        $label_arr = format_array2select($goods_label, 'label_name');
        $select_str = implode(',', $goods_label_link);
        $selectstr = md5($select_str);
        $this->assign('selectstr', $selectstr);
        $this->assign('label_arr', $label_arr);
        $this->assign('select_str', $select_str);
    }
    private function getNodeTree($pid = '', $assign = '', $brandid = '', $suppliersid = '',$shop_id='')
    {
        if (empty($pid)) $pid = I('pid');
        $this->getcateTree($pid, $assign, $brandid, $suppliersid,$shop_id);
        $suppliersattr = M('Suppliers')->where('status>0')->field('id,name')->cache(true)->order('convert(name using gb2312) ASC')->select();
        $supplierattr = array();
        if (!empty($suppliersattr)) {
            foreach ($suppliersattr as $v) {
                $supplierattr[$v['id']] = $v['name'];
            }
        }
        $this->assign('suppliers', $supplierattr);
        unset($suppliersattr, $supplierattr);
    }
    private function getcateTree($pid = '', $assign = '', $brandid = '', $suppliersid = '',$shop_id='')
    {
        $GoodsCategory = getcache('GoodsCategory');
		$shopid=idtoname($shop_id,"Goods",'shop_id');
		if(intval($shopid)>0){
			$map=array();
			$map['shop_id']=$shopid;
			$map['cat_id']=array('gt',0);
			$map['status']=array('in',array(2,4));
			$use_GoodsCategory=M("ShopCateLink")->where($map)->getField('cat_id',true);
			unset($map['cat_id']);
			$map['brand_id']=array('gt',0);
			$use_BrandCategory=M("ShopCateLink")->where($map)->getField('brand_id',true);
			foreach($GoodsCategory as $ke=>$va){
				if($va['pid']==0&&!in_array($va['id'],$use_GoodsCategory)){unset($GoodsCategory[$ke]);continue;}
			} 
		}
        $Tree = new \Common\Vendor\Tree();
        $select_categorys = '';
        $treemini = $Tree->treemini($GoodsCategory);
        $select_categorys .= $Tree->treeminioption($treemini, $pid);
        if ($assign) return $select_categorys; else $this->assign('select_categorys', $select_categorys);
        $brand = M('Brand')->where('status=1')->order('convert(brand_name using gb2312) ASC')->field('id,brand_name')->select();
        $brand_op = "<option value=''>" . L('PLEASE_SELECT_BRAND') . "</option>";
        foreach ($brand as $k => $v) {
			if(intval($shopid)>0&&!in_array($v['id'],$use_BrandCategory)){unset($brand[$k]);continue;}
            if ($brandid == $v['id']) {
                $brand_op .= "<option selected='selected' value='" . $v['id'] . "'>" . $v['brand_name'] . "</option>";
            } else {
                $brand_op .= "<option value='" . $v['id'] . "'>" . $v['brand_name'] . "</option>";
            }
        }
        $this->assign('select_brands', $brand_op);
        $suppliers_info = M('Suppliers')->where('status=1')->order('convert(name using gb2312) ASC')->field('id,name')->select();
        $suppliers_op = '';
        if (!empty($suppliers_info)) {
            foreach ($suppliers_info as $k => $v) {
                if ($suppliersid == $v['id']) {
                    $suppliers_op .= "<option selected='selected' value='" . $v['id'] . "'>" . $v['name'] . "</option>";
                } else {
                    $suppliers_op .= "<option value='" . $v['id'] . "'>" . $v['name'] . "</option>";
                }
            }
        }
        $this->assign('select_suppliers', $suppliers_op);
        unset($GoodsCategory, $select_categorys, $brand, $brand_op, $suppliers_info, $suppliers_op);
    }
    public function attr_html()
    {
        $goods_catid = intval($_REQUEST['catid']);
        $goodsid = intval($_REQUEST['goodsid']);
		$shop_id=idtoname($goodsid,'Goods','shop_id');
		if($shop_id){
			$shop_map['shop_id']=$shop_id;
			$id_shop =M('GoodsAttribute')->where($shop_map)->getField('id',true);
		}
		if ($goods_catid > 0) {
            $getallson = getallson($goods_catid, 'GoodsCategory');
            $getallparent = getallparent($goods_catid, '', 'GoodsCategory');
            $new_catid_array = array_unique(array_merge($getallson, explode(',', $getallparent)));
            if ($new_catid_array) {
                $map['id']=array('in',$new_catid_array);
				$type_ids=M('GoodsCategory')->where($map)->getField('type_id',true);
				$type_ids=array_unique($type_ids);
				$all_map['type_id']=array('in',$type_ids);
				$all_map['shop_id']=0;
				$id_all =M('GoodsAttribute')->where($all_map)->getField('id',true);
            }
        }
		if($id_shop && $id_all){
			$ids=array_unique(array_merge($id_all, $id_shop));
		}elseif($id_shop && !$id_all){
			$ids=array_unique($id_shop);
		}elseif($id_all && !$id_shop){
			$ids=array_unique($id_all);
		}
		$ga_map['id']=array('in',$ids);
		$allattr=M('GoodsAttribute')->where($ga_map)->select();
        foreach ($allattr as $k => $v) {
            if (empty($v['id'])) continue;
            $all_attr[$v['id']] = $v['type'];
            if ($allattr[$k]['options']) {
                $v['options'] = strtoarray($v['options']);
            }
            $all_attr_format[$v['id']] = $v;
        }
        if ($goodsid > 0) {
            $goodsval = $goodsattrarr = array();
            $goodsattr = M('GoodsAttr')->where('goods_id=' . $goodsid)->field('attr_id,attr_value,attr_price,supplier_price,attr_img')->order('id')->select();
            foreach ($goodsattr as $k => $v) {
                $goodsattrarr[] = $v['attr_value'] . intval($v['attr_price']) . $v['attr_img'];
                $goodsval[$v['attr_id']]['attr_id'] = $v['attr_id'];
                if ($all_attr[$v['attr_id']] == 'text') {
                    $goodsval[$v['attr_id']]['attr_text'] = $v['attr_value'];
                } else {
                    $goodsval[$v['attr_id']]['attr_select'][] = $v['attr_value'];
                    $goodsval[$v['attr_id']]['attr_price'][] = $v['attr_price'];
                    $goodsval[$v['attr_id']]['attr_balance_price'][] = $v['supplier_price'];
                    $goodsval[$v['attr_id']]['attr_img'][] = $v['attr_img'];
                    $goodsval[$v['attr_id']]['attr_count'] = count($goodsval[$v['attr_id']]['attr_select']);
                }
            }
            $this->assign('configstr', md5(implode('', $goodsattrarr)));
            $this->assign('goodsattr', $goodsval);
        }
        $this->assign('allattr', $all_attr_format);
        unset($allattr, $goodsattr, $goodsattrarr, $goodsval);
        $this->display();
    }
    public function stock()
    {
        $postdata = I('param.');
        $goods_id = intval($postdata['id']);
        if ($goods_id > 0) {
            $goodsdata = M('Goods')->where('id=' . $goods_id)->field('goods_name,goods_sn')->find();
            $this->assign('goodsdata', $goodsdata);
            $this->assign('id', $goods_id);
            $goodsattr = M('GoodsAttr')->alias('ga')->where("gatt.type='checkbox' and ga.goods_id = " . $goods_id)->JOIN("LEFT JOIN __GOODS_ATTRIBUTE__ gatt ON ga.attr_id=gatt.id")->select();
            foreach ($goodsattr as $k => $v) {
                if (empty($v['id'])) continue;
                $v['options'] = strtoarray($v['options']);
                $check_option[$v['id']][] = $v['attr_value'];
                $goodsattr_format[$v['id']] = $v;
            }
            foreach ($check_option as $k => $v) {
                $check[$k] = array_values($v);
                foreach ($goodsattr_format[$k]['options'] as $key => $val) {
                    if (in_array($key, $check[$k])) {
                        $goodsattr_format[$k]['options_format'][$key] = $val;
                    }
                }
            }
            $goodsattrstock = M('GoodsAttrStock')->where('goods_id=' . $goods_id)->order('id')->select();
            foreach ($goodsattrstock as $k => $v) {
                $attr_key_array[$k]['attr_key'] = explode('_', $v['attr_key']);
                $attr_key_array[$k]['stock_cfg'] = $v['stock_cfg'];
                $attr_key_array[$k]['goods_attr_sn'] = $v['goods_attr_sn'];
                $attr_key_array[$k]['sell_count'] = $v['sell_count'];
            }
            foreach ($attr_key_array as $k => $v) {
                foreach ($v['attr_key'] as $val) {
                    if (empty($val)) continue;
                    $goods_attr_info = M('GoodsAttr')->where('id=' . $val)->field('id,attr_id,attr_value')->find();
                    $attr_key_array_format[$k]['attr_val'][$goods_attr_info['attr_id']]['id'] = $goods_attr_info['attr_id'];
                    $attr_key_array_format[$k]['attr_val'][$goods_attr_info['attr_id']]['val'] = $goods_attr_info['attr_value'];
                    $attr_key_array_format[$k]['stock_cfg'] = $v['stock_cfg'];
                    $attr_key_array_format[$k]['goods_attr_sn'] = $v['goods_attr_sn'];
                    $attr_key_array_format[$k]['sell_count'] = $v['sell_count'];
                }
            }
            if (empty($attr_key_array_format)) {
                foreach ($goodsattr_format as $k => $v) {
                    $where[$k]['goods_id'] = $goods_id;
                    $where[$k]['attr_id'] = $k;
                    $goods_attr_info = M('GoodsAttr')->where($where[$k])->field('id,attr_id,attr_value')->order('id asc')->find();
                    $attr_key_array_format[0]['attr_val'][$k]['id'] = $goods_attr_info['attr_id'];
                    $attr_key_array_format[0]['attr_val'][$k]['val'] = $goods_attr_info['attr_value'];
                }
            }
            $this->assign('attr_count', count(array_keys($attr_key_array_format)));
            $this->assign('goodsattr_format', $goodsattr_format);
            $this->assign('attr_key_array_format', $attr_key_array_format);
        }
        $this->display();
    }
    public function export()
    {
        $name = CONTROLLER_NAME;
        $postdata = I('param.');
        $postdata['is_delete'] = 0;
        $postdata['publish_wait'] = 1;
        $map = D($name)->index_condition($postdata);
        $list = M('Goods')->where($map)->field(true)->select();
        $title = array('序号', '商品编号', '商品名称','价格', '分类', '品牌', '供货商', '库存', '销量');
        $data = array();
        foreach ($list as $k => $v) {
            $data[$k][] = $v['id'];
            $data[$k][] = $v['goods_sn'];
            $data[$k][] = $v['goods_name'];
            $data[$k][] = $v['shop_price'];
            $data[$k][] = idtoname($v['cat_id'], 'GoodsCategory');
            $data[$k][] = idtoname($v['brand_id'], 'Brand', 'brand_name');
            $data[$k][] = idtoname($v['suppliers_id'], 'Suppliers');
            $data[$k][] = $v['goods_number'];
            $data[$k][] = $v['sell_count'];
        }
        export_xls($title, $data, 'utf8');
        unset($title, $data);
        exit;
    }
    public function search_brand()
    {
        $return = array();
        $postdata = I('param.');
        $keyword = $postdata['keyword'];
		$map=array();
		if($postdata['shop_id']){
			$map_b=array();
			$map_b['shop_id']=$postdata['shop_id'];
			$map_b['status']=array('in',array(2,4));
			$map_b['brand_id']=array('gt',0);
			$use_BrandCategory=M("ShopCateLink")->where($map_b)->getField('brand_id',true);
			$map['id']=array('in',$use_BrandCategory);
		}
        if (is_numeric($keyword)) {
            $map['id|brand_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if (!empty($keyword)) {
            $map['brand_name'] = array('like', '%' . (string)$keyword . '%');
        }
        $brands = M('Brand')->where($map)->field('id,brand_name')->order('id asc')->select();
        $options = "<option value=''>" . L('PLEASE_SELECT_BRAND') . "</option>";
        foreach ($brands as $k => $v) {
            $options .= "<option value='" . $v['id'] . "'>" . $v['brand_name'] . "</option>";
        }
        $return['status'] = 1;
        $return['options'] = $options;
        $this->ajaxReturn($return);
    }
    public function search_suppliers()
    {
        $return = array();
        $postdata = I('param.');
        $keyword = $postdata['keyword'];
        if (is_numeric($keyword)) {
            $map['id|name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if (!empty($keyword)) {
            $map['name'] = array('like', '%' . (string)$keyword . '%');
        }
        $brands = M('Suppliers')->where($map)->field('id,name')->order('id asc')->select();
        $options = "<option value=''>" . L('PLEASE_SELECT_SUPPLIER') . "</option>";
        foreach ($brands as $k => $v) {
            $options .= "<option value='" . $v['id'] . "'>" . $v['name'] . "</option>";
        }
        $return['status'] = 1;
        $return['options'] = $options;
        $this->ajaxReturn($return);
    }
    public function recycling()
    {
        $name = 'Goods';
        $postdata = I('post.');
        $id = I('get.id');
        if (empty($postdata['id']) && !empty($id)) $postdata['id'][] = $id;
        $is_delete = I('is_delete');
        if (empty($postdata['id'])) {
            if ($is_delete == 1) $this->error(L('PLEASE_SELECT_DELETE_GOODS'));
            else $this->error('请选择要恢复的商品！');
        }
        $where['is_delete'] = $is_delete;
        foreach ($postdata['id'] as $key => $value) {
            $map['id'] = $value;
            $g_info = M($name)->where($map)->save($where);
        }
        if ($is_delete == 1) {
            if (isset($g_info)) {
                $this->success(L('HAVE_PUT_IN_RECYCLE'));
            } else {
                $this->error(L('DELETE_FAILED'));
            }
        } else {
            if (isset($g_info)) {
                $this->success(L('RECOVER_SUCCESS'));
            } else {
                $this->error(L('RECOVER_FAILED'));
            }
        }
    }
    public function recycle()
    {
        $name = CONTROLLER_NAME;
        $postdata = I('param.');
        $postdata['is_delete'] = 1;
        $map = D($name)->index_condition($postdata);
        if (!isset($postdata['catid'])) {
            $postdata['catid'] = 0;
        }
        if (!isset($postdata['brandid'])) {
            $postdata['brandid'] = 0;
        }
        if (!isset($postdata['suppliersid'])) {
            $postdata['suppliersid'] = 0;
        }
        $this->getcateTree($postdata['catid'], '', $postdata['brandid'], $postdata['suppliersid']);
        $list = $this->lists($name, $map);
        $this->assign('list', $list);
        $this->assign($postdata);
        $this->display();
    }
    public function stock_update()
    {
        $model = D(CONTROLLER_NAME);
        $postdata = I('post.');
        $data = $model->create($postdata);
        $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/index');
        $msg = array_merge(array('success' => L('edit_ok'), 'error' => L('edit_error'), 'url' => $jumpUrl, 'ajax' => IS_AJAX), (array)$msg);
        if (!$model->update_goodsattr_stock($postdata)) {
            $this->error('货品编号有重复，请重新输入');
        }
        clearhomehtml($postdata['id']);
        unset($data, $postdata);
        $this->success($msg['success'], $msg['url'], $msg['ajax']);
    }
    public function check_goods_attr_sn()
    {
        $postdata = I('post.');
        $msg = array_merge(array('success' => L('edit_ok'), 'error' => L('edit_error'), 'url' => '', 'ajax' => IS_AJAX), (array)$msg);
        $map['goods_attr_sn'] = $postdata['goods_attr_sn'];
        $goodsattrstock = M('GoodsAttrStock')->where($map)->count();
        $status = 0;
        if ($goodsattrstock > 0) $status = 1;
        unset($data, $postdata);
        $this->success($status, '', $msg['ajax']);
    }
    public function index_shops()
    {
        $name = CONTROLLER_NAME;
        $postdata = I('param.');
        if (!isset($postdata['shops_keyword'])) {
            $postdata['shops_keyword'] = '';
        }
        $postdata['is_delete'] = 0;
        $postdata['publish_wait'] = 1;
        $map = D($name)->index_condition($postdata);
        $this->getcateTree(!empty($postdata['catid']) ? $postdata['catid'] : 0, '', !empty($postdata['brandid']) ? $postdata['brandid'] : 0);
        $list = $this->lists($name, $map);
        $this->assign('list', $list);
        $this->assign($postdata);
        $this->display();
    }
    public function recycle_shops()
    {
        $name = CONTROLLER_NAME;
        $postdata = I('param.');
        if (!isset($postdata['shops_keyword'])) {
            $postdata['shops_keyword'] = '';
        }
        $postdata['is_delete'] = 1;
        $map = D($name)->index_condition($postdata);
        $this->getcateTree(!empty($postdata['catid'])?$postdata['catid']:0, '', !empty($postdata['brandid'])?$postdata['brandid']:0);
        $list = $this->lists($name, $map);
        $this->assign('list', $list);
        $this->assign($postdata);
        $this->display();
    }
	public function _before_delete(){
		$id=I('id');
		if(isset($id)&&is_array($id)){
			foreach($id as $k=>$v){
				$result=check_delete($v,4);
				if($result['status']==0)unset($id[$k]);
			}
			if(empty($id)){$this->error($result['info']);return;}
		}else{
			$result=check_delete($id,4);
			if($result['status']==0){$this->error($result['info']);return;}
		}
		$this->id=$id;
	} 
    public function collect_goods()
    {
        $name="GoodsCollect";
        $map['status']=1;
        $map['shop_id']=0;
        $map['type']=0;
        $list = $this->lists($name, $map);
        $this->assign('list', $list);
        $this->display();
    }
}