<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Admin\Controller;
class GoodsIntegralController extends BaseController
{
    public function index()
    {
        $keyword = I('keyword');
        if (is_numeric($keyword)) {
            $map['id'] = array(intval($keyword), array('like', '%' . $keyword . '%'));
        } else {
            $map_goods['goods_sn|goods_name'] = array('like', '%' . (string)$keyword . '%');
            $arr = M('Goods')->where($map_goods)->field('id')->select();
            $id = '';
            foreach ($arr as $k => $v) {
                $id .= $v['id'] . ',';
            }
            $map['goods_id'] = array('IN', $id);
        }
        $list = $this->lists('GoodsIntegral', $map, 'id desc');
        $this->assign('list', $list);
        $this->display();
    }

    public function update()
    {
        $url = U('Admin/GoodsIntegral/index');
        $postdata = I('post.');
        $data['goods_id'] = $postdata['goods_id'];
        if($postdata['money']<=0){
            $data['only_integral'] = $postdata['integral'];
            $data['integral'] = 0;
        }else{
            $data['integral'] = $postdata['integral'];
            $data['only_integral'] = $postdata['only_integral'];
        }
        $data['money']=$postdata['money'];
        $data['is_hot'] = $postdata['is_hot'];
        $data['status'] = $postdata['status'];
        $data['catid'] = idtoname($postdata['goods_id'], 'Goods', 'cat_id');
        $where['id'] = $postdata['id'];
        $save = M('GoodsIntegral')->where($where)->save($data);
        if ($save != false) {
            $this->success('修改成功！', $url);
        } else {
            $this->error('修改失败！', $url);
        }
    }

    public function insert()
    {
        $url = U('Admin/GoodsIntegral/index');
        $postdata = I('post.');
        $data['goods_id'] = $postdata['goods_id'];
        $data['money'] = $postdata['money'];
        if($postdata['money']<=0){
            $data['only_integral'] = $postdata['integral'];
        }else{
            $data['integral'] = $postdata['integral'];
            $data['only_integral'] = $postdata['only_integral'];
        }
        $data['is_hot'] = $postdata['is_hot'];
        $data['status'] = $postdata['status'];
        $data['catid'] = idtoname($postdata['goods_id'], 'Goods', 'cat_id');
        $add = M('GoodsIntegral')->add($data);
        if ($add != false) {
            $this->success('添加成功！', $url);
        } else {
            $this->error('添加失败！', $url);
        }
    }

    
    public function search_goods()
    {
        $keyword = I('keyword');
        if (is_numeric($keyword)) {
            $map['id|goods_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else {
            $map['goods_name'] = array('like', '%' . (string)$keyword . '%');
        }
        $map['status'] = 1;
        $map['is_promote'] = 0;
        $map['shop_id']=0;
        
        $goodsids=M('GoodsIntegral')->field('goods_id')->select();
        $goods_ids=array();
        if(!empty($goodsids)){
            foreach($goodsids as $k=>$v){
                $goods_ids[$k]=$v['goods_id'];
            }
        }
        if(!empty($goods_ids))$map['id']=array('notin',$goods_ids);
        $goods_info = M('Goods')->field('id,goods_name')->where($map)->select();
        $data = '';
        foreach ($goods_info as $val) {
            $data .= '<option value="' . $val['id'] . '">' . $val['goods_name'] . '</option>';
        }
        $this->ajaxReturn($data);
    }

    
    public function img_list()
    {
        $wher['code'] = 'integral';
        $pos_id = M('PosterPosition')->where($wher)->getField('id');
        if (empty($pos_id)) {
            $data['code'] = 'integral';
            $data['status'] = 1;
            $data['name'] = '积分专区广告';
            $data['width'] = 1200;
            $data['height'] = 392;
            $data['tpl'] = '&lt;volist name=&quot;ad_list&quot; id=&quot;val&quot; &gt;
								&lt;li&gt;
								&lt;a class=&quot;img&quot; title=&quot;{$val.name}&quot; href=&quot;{$val.url}&quot;&gt;
								&lt;div style=&quot;background: url({$val.code|format_url}) no-repeat  50% 50%; height:{$height}px; width:{$width}px;&quot;&gt;
								&lt;/div&gt;
								&lt;/a&gt;
								&lt;/li&gt;
								&lt;/volist&gt;';
            $result = M('PosterPosition')->add($data);
            $pos_id = $result;
        }
        $map['position_id'] = $pos_id;
        $list = $this->lists('Poster', $map);
        $this->assign('list', $list);
        $this->assign('pos_id', $pos_id);
        $this->display();
    }

    
    public function img_add()
    {
        $id = I('get.id');
        if (!empty($id)) {
            $map['id'] = $id;
            $poster = M('Poster')->where($map)->field(true)->find();
            $this->assign($poster);
        }
        $wher['code'] = 'integral';
        $pos_id = M('PosterPosition')->where($wher)->getField('id');
        $this->assign('pos_id', $pos_id);
        $this->display();
    }

    
    public function img_insert()
    {
        $post = I('post.');
        $re = M('Poster')->add($post);
        if ($re !== false) {
            $this->success('添加成功', U('GoodsIntegral/img_list'));
        } else {
            $this->error('添加失败', U('GoodsIntegral/img_add'));
        }
    }

    
    public function img_update()
    {
        $post = I('post.');
        $id = $post['id'];
        $re = M('Poster')->where('id=' . $id)->save($post);
        if ($re !== false) {
            $this->success('更新成功', U('GoodsIntegral/img_list'));
        } else {
            $this->error('更新失败', U('GoodsIntegral/img_add', array('id' => $id)));
        }
    }

    
    public function img_delete()
    {
        $id = I('get.id');
        $postdata = I('post.');
        if (empty($postdata['id']) && !empty($id)) $postdata['id'][] = $id;
        if (empty($postdata['id'])) $this->error('请选择您要删除的项');
        foreach($postdata[''] as $v){
            $re = M('Poster')->delete($v);
        }
        if ($re !== false) {
            $this->success('删除成功', U('GoodsIntegral/img_list'));
        } else {
            $this->error('删除失败', U('GoodsIntegral/img_list'));
        }
    }
    
    public function collect_goods()
    {
        $name="GoodsCollect";
        $map['status']=1;
        $map['shop_id']=0;
        $map['type']=1;
        $list = $this->lists($name, $map);
        $this->assign('list', $list);
        $this->display();
    }
}