<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
use Common\Controller\HanchaoController;
class LoginController extends HanchaoController
{
    
    public function index()
    {
        $admin_mod = M('Admin');
        if (IS_POST) {
            $return = array('status' => 0, 'msg' => '', 'resetverify' => 1);
            $username = I('post.username');
            $password = I('post.password');
            if (!$username) {
                $return['resetverify'] = 0;
                $return['msg'] = '用户名不能为空';
                $return['ob'] = 'username';
                $this->ajaxReturn($return);
            }
            if (!$password) {
                $return['resetverify'] = 0;
                $return['msg'] = '密码不能为空';
                $return['ob'] = 'password';
                $this->ajaxReturn($return);
            }
            if (!check_verify($_POST['verify'], 'admin')) {
                $return['msg'] = L('verify_error');
                $return['ob'] = 'verify';
                $this->ajaxReturn($return);
            }
            $map = array();
            $map['username'] = $username;
            $map["status"] = array('gt', 0);
            $admin_info = $admin_mod->where($map)->field(true)->find();
            
            if (empty($admin_info)) {
                $return['msg'] = '帐号不存在或已禁用！';
                $return['ob'] = 'username';
                $this->ajaxReturn($return);
            } else {
                $checkpassword = creatpwd($password, $admin_info['salt']);
                if ($checkpassword != $admin_info['password']) {
                    $return['msg'] = '密码错误！';
                    $return['ob'] = 'password';
                    $this->ajaxReturn($return);
                }
                $admin_info['admin_info_auth_sign'] = data_auth_sign($admin_info);
                session('admin_info', $admin_info);
                $uid = $userdata['id'] = $admin_info['id'];
                $where_ad['id'] = $uid;
                $last_time = M('Admin')->where($where_ad)->find();
                session('pre_time', $last_time['last_login_time']);
                session('admin_id', $uid);
                $userdata['login_count'] = array('exp', 'login_count+1');
                $userdata['last_login_time'] = NOW_TIME;
                $userdata['last_login_ip'] = get_client_ip(1);
                $admin_mod->save($userdata);
                action_log('admin_login', 'Admin', $uid, $uid);
                $return['status'] = 1;
                $return['msg'] = '登录成功！';
                $return['ob'] = 'verify';
                $this->ajaxReturn($return);
                exit;
            }
        }
        $this->display();
    }

    
    public function logout()
    {
        $admin_info = session('admin_info');
        if (isset($admin_info)) {
            session('admin_info', null);
            $this->success('退出登录成功！', U('Admin/Login/index'));
        } else {
            $this->error('已经退出登录！');
        }
    }

    
    public function verify()
    {
        $config = array(
            'imageW' => '268',
            'seKey' => 'chanchao' . C('HANCHAO_KEY'),
            'length' => 4,
            'fontSize' => 40,
        );
        $verify = new \Common\Vendor\Verify($config);
        $verify->entry('admin');
    }
}
?>