<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
 
namespace Admin\Controller;
class MemberCollectController extends BaseController
{
    
    public function goods()
    {
        $uid = I('uid');
        $postdata = I('post.');
        $map = array();
        if (!empty($uid)) {
            $map['uid'] = $uid;
            $this->assign('id', I('uid'));
        }
        $map['type'] = 0;
        $keyword=!empty($postdata['keyword'])?$postdata['keyword']:'';
        if (is_numeric($keyword)) {
            $goods_map['id|goods_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if (!empty($keyword)) {
            $goods_map['goods_name'] = array('like', '%' . (string)$keyword . '%');
        }
        if (!empty($goods_map)) {
            $goodsids = M('Goods')->field('id')->where($goods_map)->select();
            $goods_ids = array();
            foreach ($goodsids as $k => $v) {
                $goods_ids[$k] = $v['id'];
            }
            if (!empty($goods_ids)) {
                $map['goods_id'] = array('in', $goods_ids);
            }
        }
        $collect_goods = $this->lists('GoodsCollect', $map);
        $this->assign('keyword', $keyword);
        $this->assign('collect_goods', $collect_goods);
        $this->display();
    }

    
    public function shops()
    {
        $uid = I('uid');
        $postdata = I('post.');
        $map = array();
        if (!empty($uid)) {
            $map['uid'] = $uid;
            $this->assign('id', I('uid'));
        }
        $map['type'] = 1;
        $keyword=!empty($postdata['keyword'])?$postdata['keyword']:'';
        if (is_numeric($keyword)) {
            $shops_map['id|name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if (!empty($keyword)) {
            $shops_map['name'] = array('like', '%' . (string)$keyword . '%');
        }
        if (!empty($shops_map)) {
            $shopsids = M('Shops')->field('id')->where($shops_map)->select();
            $shops_ids = array();
            foreach ($shopsids as $k => $v) {
                $shops_ids[$k] = $v['id'];
            }
            if (!empty($shops_ids)) {
                $map['item_id'] = array('in', $shops_ids);
            }
        }
        $collect_shops = $this->lists('MemberCollect', $map);
        $this->assign('keyword', $keyword);
        $this->assign('collect_shops', $collect_shops);
        $this->display();
    }
}
?>