<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Admin\Controller;
class MemberController extends BaseController{
    public function index(){
        $postdata=I('param.');
        $keyword = I('keyword');
        $map=array();
		if(!empty($keyword)){
			$whereor['id']=array('like','%'.$keyword.'%');
            $whereor['username']=array('like','%'.$keyword.'%');
            $whereor['mobile']=array('like','%'.$keyword.'%');
            $whereor['_logic'] = 'or';
            $map['_complex'] = $whereor;
            $seotitle=$keyword.'_';
		}
		if(!empty($postdata['reg_from']))$map['reg_time'][]=array('EGT',strtotime($postdata['reg_from']));
		if(!empty($postdata['reg_to']))$map['reg_time'][]=array('elt',strtotime($postdata['reg_to']));
	    $map['status']=array(array('GT',0));
        if(!empty($postdata['rank_id'])){
           $map['rank_id']=$postdata['rank_id'];
        }
		$list = $this->lists('Member',$map);
        $this->assign('list', $list);$this->assign($postdata);
        $this->getGroup(1);
        $this->display();
    }

    public function add(){
        if (IS_POST) {
            $member_mod = M('Member');
            $postdata=I('post.');
            if (!isset($postdata['username']) || ($postdata['username'] == '')) {
                $this->error('用户名不能为空');
            }
            if ($postdata['password'] != $postdata['repassword']) {
                $this->error('两次输入的密码不相同');
            }
			$where['username']=$postdata['username'];
            $result = $member_mod->where($where)->count();
            if ($result) {
                $this->error('会员' . $postdata['username'] . '已经存在');
            }
            unset($postdata['repassword']);
            $postdata['salt'] = randStr();
            $postdata['password'] = creatpwd($_POST['password'], 'HANCHAO'.$postdata['salt']);
            $postdata['reg_time'] = $postdata['last_login'] = NOW_TIME;
            $postdata['reg_ip'] = $postdata['last_ip'] = get_client_ip(1);
			$postdata['rank_id']=$postdata['rank_id'];
            $member_mod->create($postdata);
            $result = $member_mod->add();
            unset($postdata);
            if ($result) {
                $this->success(L('DO_OK'), '', '', 'add');
            } else {
                $this->error(L('DO_ERROR'));
            }
        } else {
            $this->getGroup(1);
            $this->display('edit');
        }
    }

    public function edit(){
        $id = I('id');
        $member_mod = D('Member');
        if (IS_POST) {
            $postdata=I('post.');
            $count = $member_mod->where("id!=" . $id . " and username='" . $postdata['username'] . "'")->count();
            if ($count > 0) {
                $this->error('用户名已经存在！');
            }
            $adminsalt = $member_mod->where("username='" . $postdata['username'] . "'")->getField('salt');
            if ($postdata['password']) {
                if ($postdata['password'] != $postdata['repassword']) {
                    $this->error('两次输入的密码不相同');
                }
                $postdata['password'] = creatpwd($postdata['password'],'HANCHAO'.$adminsalt);
            } else {
                unset($postdata['password']);
            }
            if ($postdata['paypassword']) {
                $postdata['paypassword'] = creatpwd($postdata['paypassword'],'HANCHAO'.$adminsalt);
            } else {
                unset($postdata['paypassword']);
            }
            unset($postdata['repassword']);
            if (false === $member_mod->create($postdata)) {
                $this->error($member_mod->getError());
            }
            $result = $member_mod->save();
            unset($postdata);
            if (false !== $result) {
                $this->success(L('DO_OK'), '', '', 'edit');
            } else {
                $this->error(L('DO_ERROR'));
            }
        } else {
            if (isset($id)) {
                $id = isset($id) && intval($id) ? intval($id) : $this->error('参数错误');
            }
            if(!$id)$this->error('参数错误');
            $info = $member_mod->field(true)->find($id);
            $this->assign($info);
            $this->getGroup(1);
            $this->display();
        }
    }
	
	public function _before_delete(){
		$id=I('id');
		if(isset($id)&&is_array($id)){
			foreach($id as $k=>$v){
				$result=check_delete($v,1);
				if(!$result['status'])unset($id[$k]);
			}
			if(empty($id)){$this->error('会员下有未完成的订单或已绑定商铺');exit;}
		}else{
			$result=check_delete($id,1);
			if(!$result['status']){$this->error($result['info']);exit;}
		}
		$this->id=$id;
	} 
	public function view(){
		$id = I('id');
		$rank_info=ex_ranks($id);
		$member_mod = D('Member');
		$info = $member_mod->field(true)->find($id);
		$this->assign($info);
		$this->assign('rank_info',$rank_info);
		$this->getGroup(1);
		$this->display();
	}
	public function export(){
		$postdata=I('param.');
		if($postdata){
			$name = CONTROLLER_NAME;
			$map=array();
			if($postdata['keyword']){
				$whereor['id']=array('like','%'.$postdata['keyword'].'%');
				$whereor['username']=array('like','%'.$postdata['keyword'].'%');
				$whereor['mobile']=array('like','%'.$postdata['keyword'].'%');
				$whereor['_logic'] = 'or';
				$map['_complex'] = $whereor;
				$seotitle=$keyword.'_';
			}
			if($postdata['rank_id'])$map['rank_id']=$postdata['rank_id'];
			if($postdata['reg_from'])$map['reg_time'][]=array('EGT',strtotime($postdata['reg_from']));
			if($postdata['reg_to'])$map['reg_time'][]=array('elt',strtotime($postdata['reg_to']));
			$result=M('Member')->where($map)->field('password,salt',true)->order('id desc')->select();
			$title=array('序号','用户名','等级','性别','姓名','手机','联系地址','注册时间','最后登录','推荐人');
			foreach($result as $k => $v){
				$data[$k][]=$v['id'];
				$data[$k][]=$v['username'];
				$data[$k][]=idtoname($v['rank_id'],'MemberRank');
				$data[$k][]=idtoname($v['sex'],'Type');
				$data[$k][]=$v['nickname'];
				$data[$k][]=$v['mobile'];
				$data[$k][]=$v['address'];
				$data[$k][]=time_format($v['reg_time']);
				$data[$k][]=time_format($v['last_login']);
				$data[$k][]=$v['parent_id']?idtoname($v['parent_id'],'Member','username'):'';
			}
			export_xls($title,$data,'utf8');
			unset($title,$data);exit;
		}
	}
    
    private function getGroup($type = ''){
        $groupData = M('MemberRank')->where('status=1')->field(true)->order('sort,id desc')->select();
        if ($type == 1) {
            foreach ($groupData as $v) {
                $newgroupData[$v['id']] = $v['name'];
            }$groupData=$newgroupData;
        }
        $this->assign('groupData', $groupData);
    }
    public function extension_list(){
        $map = array();
        $postdata=I('param.');
        $pid = $postdata['pid'];
        $sid = $postdata['sid'];
        $parent_id = $postdata['parent_id'];
        if (!empty($pid)) {
            if (is_numeric($pid)) {
                $where_m['id|username'] = array(intval($pid), array('like', '%' . $pid . '%'), '_multi' => true);
            } else if (!empty($pid)) {
                $where_m['username'] = array('like', '%' . (string)$pid . '%');
            }
            $m_list = M('Member')->where($where_m)->field('id')->select();
            if (!empty($m_list)) {
                foreach ($m_list as $k => $v) {
                    $me_list[] = $v['id'];
                }
                $map['parent_id'] = array(array('in', $me_list));
            }
        }elseif(!empty($parent_id)){
            $where_m['id'] = $parent_id;
            $m_list = M('Member')->where($where_m)->field('id')->select();
            if (!empty($m_list)) {
                foreach ($m_list as $k => $v) {
                    $me_list[] = $v['id'];
                }
                $map['parent_id'] = array(array('in', $me_list));
            }
        }else{
            $map['parent_id']=array('gt',0);
        }
        if (!empty($sid)) {
            if (is_numeric($sid)) {
                $where_u['id|username'] = array(intval($sid), array('like', '%' . $sid . '%'), '_multi' => true);
            } else if (!empty($sid)) {
                $where_u['username'] = array('like', '%' . (string)$sid . '%');
            }
            $user_list = M('Member')->where($where_u)->field('id')->select();
            if (!empty($user_list)) {
                foreach ($user_list as $k => $v) {
                    $u_list[] = $v['id'];
                }
                $map['id'] = array(array('in', $u_list));
            }
        }
        $list = $this->lists('Member', $map);
        $this->assign('list', $list);
        $this->assign($postdata);
        $this->display();
    }
}
?>