<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
 
namespace Admin\Controller;
class MemberWithdrawalsController extends BaseController{
	public function _initialize() {
        parent::_initialize();
		$status_type=array(0=>'未处理',1=>'已处理',2=>'已关闭');
		$this->assign('status_type',$status_type);
    }
	
    public function index(){
        $name = 'MemberWithdrawals';
        $postdata=I('param.');
        if(!empty($postdata['status']))$map['status']=$postdata['status']-1;
        if(!empty($postdata['date_from']))$map['create_time'][]=array('EGT',strtotime($postdata['date_from']));
        if(!empty($postdata['date_to']))$map['create_time'][]=array('elt',strtotime($postdata['date_to']));
        if(!empty($postdata['keyword'])){
            $whereor['uid']=$postdata['keyword'];
            $whereor['msg']=array('like','%'.$postdata['keyword'].'%');
            $whereor['_logic'] = 'or';
            $map['_complex'] = $whereor;
        }
		$map['type']=0;
		$this->get_status($postdata['status']);
        $list = $this->lists($name,$map);
		
		
		foreach($list as $k=>$v){
			$map_on['status']=0;
			$map_on['end_time']=array('elt',NOW_TIME+86400);
			$map_on['id']=$v['id'];
			$is_on=M($name)->where($map_on)->field('id')->find();
			if($is_on){
				$list[$k]['on']=1;
			}else{
				$list[$k]['on']=0;
			}
		}
        $this->assign('list',$list);
		$this->assign($postdata);
        $this->display();
    }
	
    public function shop_index(){
        $name = 'MemberWithdrawals';
        $postdata=I('param.');
        if(!empty($postdata['status']))$map['status']=$postdata['status']-1;
        if(!empty($postdata['date_from']))$map['create_time'][]=array('EGT',strtotime($postdata['date_from']));
        if(!empty($postdata['date_to']))$map['create_time'][]=array('elt',strtotime($postdata['date_to']));
        if(!empty($postdata['keyword'])){
            $whereor['uid']=$postdata['keyword'];
            $whereor['msg']=array('like','%'.$postdata['keyword'].'%');
            $whereor['_logic'] = 'or';
            $map['_complex'] = $whereor;
        }
		$map['type']=1;
		$this->get_status($postdata['status']);
        $order='status asc,end_time asc';
        $list = $this->lists($name,$map,$order);
		
		
		foreach($list as $k=>$v){
			$map_on['status']=0;
			$map_on['end_time']=array('elt',NOW_TIME+86400);
			$map_on['id']=$v['id'];
			$is_on=M($name)->where($map_on)->field('id')->find();
			if($is_on){
				$list[$k]['on']=1;
			}else{
				$list[$k]['on']=0;
			}
		}
        $this->assign('list',$list);
		$this->assign($postdata);
        $this->display();
    }
	
	public function edit(){
        $id=I('param.id');
		$info=M('MemberWithdrawals')->alias('mw')->join('JOIN __MEMBER_BANK__ mb ON mw.uid=mb.uid')->where('mw.id='.$id)->field('mw.* , mb.name,mb.bankname,mb.bankcode,mb.bankkai,mb.temp')->find();
        $this->assign('info',$info);
        $this->display();
    }
	
	public function tixian(){
        $postdata=I('param.');if(!$postdata['id'])$this->error('参数错误!');
		$map['id']=$postdata['id'];
		$map['status']=0;
		$info=M('MemberWithdrawals')->where($map)->field(true)->find();
		if(empty($info))$this->error('已处理!');
		$pay_money=$info['money']-$info['free'];
		
		if($postdata['status']==1){
			$save['status']=1;
			account_change($info['uid'],-$info['money'],2,2,'提现成功，解冻资金',$postdata['adminid']);
			
			account_change($info['uid'],-$pay_money,1,2,'会员提现（平台出账）',$postdata['adminid'],false,3);
			
			if($info['free']>0)account_change($info['uid'],$info['free'],1,2,'会员提现手续费（平台入账）',$postdata['adminid'],false,4);
		}else{
			$save['status']=2;
			account_change($info['uid'],-$info['money'],2,2,'提现失败，解冻资金',$postdata['adminid']);
			account_change($info['uid'],$info['money'],1,2,'提现失败，返回资金',$postdata['adminid']);
		}
		$save['update_time']=NOW_TIME;
		$save['adminid']=$postdata['adminid'];
		$result=M('MemberWithdrawals')->where('id='.$postdata['id'])->save($save);
		if($result){
			action_log('do_shop_tixian', 'Admin', $postdata['id'], $postdata['adminid']);
			$url=U('MemberWithdrawals/index');
			$this->success('处理成功！',$url);
		}else{
			$url=U('MemberWithdrawals/edit',array('id'=>$postdata['id']));
			$this->success('处理失败！',$url);
		}
		
    }
	
	public function shop_tixian(){
        $postdata=I('param.');if(!$postdata['id'])$this->error('参数错误!');
		$map['id']=$postdata['id'];
		$map['status']=0;
		$info=M('MemberWithdrawals')->where($map)->field(true)->find();
		if(empty($info))$this->error('已处理!');
		$pay_money=$info['money']-$info['free'];
		
		if($postdata['status']==1){
			$save['status']=1;
			
			account_change($info['uid'],-$pay_money,1,2,'店铺提现（平台出账）',$postdata['adminid'],false,3);
			
			if($info['free']>0)account_change($info['uid'],$info['free'],1,2,'店铺提现手续费（平台入账）',$postdata['adminid'],false,4);
		}else{
			$save['status']=2;
			shop_balance_log($info['uid'],$info['money'],1,2,'提现失败，返回资金','',UID);
			shop_balance_log($info['uid'],-$info['money'],4,2,'提现失败，解冻资金','',UID);
		}
		$save['update_time']=NOW_TIME;
		$save['adminid']=$postdata['adminid'];
		$result=M('MemberWithdrawals')->where('id='.$postdata['id'])->save($save);
		if($result){
			action_log('do_user_tixian', 'Admin', $postdata['id'], $postdata['adminid']);
			$url=U('MemberWithdrawals/shop_index');
			$this->success('处理成功！',$url);
		}else{
			$url=U('MemberWithdrawals/edit',array('id'=>$postdata['id']));
			$this->success('处理失败！',$url);
		}
		
    }
	
	public function do_tixian(){
		$return=array('status'=>0,'info'=>'');
        $postdata=I('param.');if(!$postdata['id']){$return['info']='参数错误';return $return;}
		$map['id']=$postdata['id'];
		$map['status']=0;
		$info=M('MemberWithdrawals')->where($map)->field(true)->find();
		if(empty($info)){$return['info']='已处理';return $return;}
		
		$save['status']=1;
		$result=M('MemberWithdrawals')->where('id='.$postdata['id'])->save($save);
		if($result){
			$pay_money=$info['money']-$info['free'];
			if($info['type']==1){
				shop_balance_log($info['uid'],-$info['money'],4,2,'提现成功，解冻资金','',UID);
				account_change($info['uid'],-$pay_money,1,2,'店铺提现（平台出账）',UID,false,3);
				if($info['free']>0)account_change($info['uid'],$info['free'],1,2,'店铺提现手续费（平台入账）',UID,false,4);
				action_log('do_shop_tixian', 'Admin', $postdata['id'], UID);
			}else{
				account_change($info['uid'],-$info['money'],2,2,'提现成功，解冻资金',UID);
				account_change($info['uid'],-$pay_money,1,2,'会员提现（平台出账）',UID,false,3);
				if($info['free']>0)account_change($info['uid'],$info['free'],1,2,'会员提现手续费（平台入账）',UID,false,4);
				action_log('do_user_tixian', 'Admin', $postdata['id'], UID);
			}
			$return['status']=1;
			$return['info']="<a href='javascript:;'>已处理</a>";
		}else{
			$return['info']='处理失败';
		}
		$this->ajaxReturn($return);
    }
	private function get_status($id){
		$status_type=array(0=>'请选择处理状态',1=>'未处理',2=>'已处理',3=>'已关闭');
		foreach($status_type as $k=>$v){
			if($id==$k){
				$status_selected.="<option selected='selected' value='$k'>$v</option>";
			}else{
				$status_selected.='<option value='.$k.'>'.$v.'</option>';
			}
		}
		$this->assign('status_selected',$status_selected);
	}
}
?>