<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
 
namespace Admin\Controller;
class OrderInfoController extends BaseController{
    public function _initialize() {
        parent::_initialize();
        $this->order_type=strtoarray(C('ORDER_TYPE'));$this->assign('order_type',$this->order_type);
		$this->order_status=strtoarray(C('ORDER_STATUS'));$this->assign('order_status',$this->order_status);
		$this->order_pay=strtoarray(C('ORDER_PAY'));$this->assign('order_pay',$this->order_pay);
		$this->order_shipping=strtoarray(C('ORDER_SHIPPING'));$this->assign('order_shipping',$this->order_shipping);
    } 
    public function index(){
        $name = CONTROLLER_NAME;
        $map=array();
		$postdata=I('param.');
        $mapand[]['type']=array('neq','2');
        $mapand[]['type']=array('neq','5');
        $mapand['_logic'] = 'and';
        $map['_complex'] = $mapand;
        $map['is_delete']=0;
        if($postdata['order_sn'])$map['order_sn']=$postdata['order_sn'];
        if($postdata['type'])$map['type']=$postdata['type'];
        if($postdata['status'])$map['status']=$postdata['status'];
        if($postdata['pay_status'])$map['pay_status']=$postdata['pay_status'];
        if($postdata['shipping_status'])$map['shipping_status']=$postdata['shipping_status'];
        if($postdata['keyword']){
            $whereor['uid']=$postdata['keyword'];
            $whereor['consignee']=array('like','%'.$postdata['keyword'].'%');
            $whereor['address']=array('like','%'.$postdata['keyword'].'%');
            $whereor['mobile']=array('like','%'.$postdata['keyword'].'%');
            $whereor['email']=array('like','%'.$postdata['keyword'].'%');
            $whereor['sign_building']=array('like','%'.$postdata['keyword'].'%');
            $whereor['temp']=array('like','%'.$postdata['keyword'].'%');
            $whereor['_logic'] = 'or';
            $map['_complex'] = $whereor;
        }
		$list = $this->lists('OrderInfo',$map);
        $this->assign('list',$list);$this->assign($postdata);
        $this->display();
    }
    public function _before_edit(){
        $id=I('id');
        if(empty($id))$this->error('参数不正确');
        $this->getNodeTree();
		$ordergoods=M('OrderGoods')->where('order_id='.$id)->select();
        $orderinfo=M('OrderInfo')->where('id='.$id)->field(true)->find();
		$ordershipping=M('ShipOrder')->where('order_id='.$id)->select();
		$ordership=array();
		foreach($ordershipping as $v){
			$goodsid=explode(',',$v['goods_id']);
			foreach($goodsid as $val){
				$ordership[$val]=$v;
			}
		}
		foreach($ordergoods as $k=>$v){
			$attr=unserialize($v['goods_attr']);
			$ordergoods[$k]['attr_name']=$attr['name'];
			$ordergoods[$k]['org_parce']=$v['attr_price']*$v['goods_number'];
            $ordergoods[$k]['org_integral']=$v['goods_integral']*$v['goods_number'];
            $ordergoods[$k]['shipping']=$ordership[$v['goods_id']];
		}
		$this->assign('ordergoods',$ordergoods);
		$this->assign($orderinfo);
    }
    public function _before_update(){
        $_POST['province']=$_POST['area_sheng'];
        $_POST['city']=$_POST['area_shi'];
        $_POST['district']=$_POST['area_xian'];
        if($_POST['pay_fee_old']!=$_POST['pay_fee'] || $_POST['shipping_fee_old']!=$_POST['shipping_fee']){
            $_POST['order_amount']=$_POST['goods_amount']+$_POST['pay_fee']+$_POST['shipping_fee'];
        }
		$save['shipping_sn']=I('post.shipping_sn');
		$where['id']=I('post.id');
		M('OrderInfo')->where($where)->save($save);
        unset($_POST['area_sheng'],$_POST['area_shi'],$_POST['area_xian'],$_POST['pay_fee_old'],$_POST['shipping_fee_old']);
        action_log('update_order', 'Admin',I('id'),UID);
    }    
    public function _before_view(){
		$id=I('id');
		if(empty($id))$this->error('参数不正确');
		$operable_list=$this->operable_list($id);
		$this->assign('operable_list',$operable_list);
		$ordergoods=M('OrderGoods')->where('order_id='.$id)->field(true)->select();
		$ordershipping=M('ShipOrder')->where('order_id='.$id)->field(true)->select();
		$ordership=array();
		foreach($ordershipping as $v){
			$goodsid=explode(',',$v['goods_id']);
			foreach($goodsid as $val){
				$ordership[$val]=$v;
			}
		}
		foreach($ordergoods as $k=>$v){
			$attr=unserialize($v['goods_attr']);
			$ordergoods[$k]['attr_name']=$attr['name'];
			$ordergoods[$k]['org_parce']=$v['attr_price']*$v['goods_number'];
            $ordergoods[$k]['org_integral']=$v['goods_integral']*$v['goods_number'];
            $ordergoods[$k]['shipping']=$ordership[$v['goods_id']];
		}
		$this->assign('ordergoods',$ordergoods);
		$actionlog=M('ActionLog')->where('action_id in (9,10) and record_id='.$id)->order('id desc')->select();
		$this->assign('actionlog',$actionlog);
    }
    public function ordergoods(){
        $id=I('id');
        if(empty($id))$this->error('参数不正确');
        $ordergoods=M('OrderGoods')->where('order_id='.$id)->select();
        foreach($ordergoods as $k=>$v){
            $attr=unserialize($v['goods_attr']);
            $ordergoods[$k]['attr_name']=$attr['name'];
            $ordergoods[$k]['goods_price_format']=format_price($v['goods_price']);
            $ordergoods[$k]['org_parce']=$v['goods_price']*$v['goods_number'];
            $ordergoods[$k]['org_parce_format']=format_price($ordergoods[$k]['org_parce']);
            $ordergoods[$k]['org_integral']=$v['goods_integral']*$v['goods_number'];
        }
        $this->assign('ordergoods',$ordergoods);
		$this->assign('order_id',$id);
        $this->display();
    }
	public function delete_goods(){
		$get=I('get.');
		$delete['id']=$get['id'];
		$delete_goods=M('OrderGoods')->where($delete)->delete();
		$url=U('Admin/OrderInfo/ordergoods',array('id'=>$get['order_id']));
		if($delete_goods!= false){
			$this->success('操作成功！',$url);
		}else{
			$this->error('操作失败！',$url);
		}
	}
	 public function new_og(){
		$getdata=I('get.');
		$map['id']=$getdata['id'];
		$map['order_id']=$getdata['order_id'];
		$info=M('OrderGoods')->where($map)->find();
         $goods_attr=unserialize($info['goods_attr']);
        
		
		$this->assign($info);
		$this->assign('goods_attrs',$goods_attr);
		$this->assign('id',$getdata['id']);
		$this->assign('order_id',$getdata['order_id']);
		$this->display();
	}
	
	public function new_og_edit(){
	    $data=I('post.');
        $map['id']=$data['id'];
        $goods_id=M("OrderGoods")->where($map)->getField('goods_id');
		if($data){
			$where['id']=$data['id'];
			$where['order_id']=$data['order_id'];
            $attr=$data['attr_key'];
            $name=$data['attr_name'];
            $attrstock = D("Common/GoodsAttr")->check_attr_stock($attr, $goods_id, $data['goods_number'], $name);
            if ($attrstock['status'] == 0) {
               $this->error("商品库存不足",U('OrderInfo/ordergoods',array('id'=>$data['order_id'])));
            }
            
            $check_goods_count = D("Common/Cart")->check_cart_number($goods_id, $data['goods_number']);
            if ($check_goods_count['status'] == 1) {
                $this->error("商品库存不足",U('OrderInfo/ordergoods',array('id'=>$data['order_id'])));
            }
            $goods_attr=array(
                'key'=>$data['attr_key'],
                'name'=>$data['attr_name']
            );
            $data['goods_arrt']=$goods_attr;
            $info=M('OrderGoods')->where($where)->save($data);
			if($info !== false){
            	$this->success('编辑成功！',U('OrderInfo/ordergoods',array('id'=>$data['order_id'])));
        	}else{
            	$this->error('编辑失败！',U('OrderInfo/ordergoods',array('id'=>$data['order_id'])));
        }
		}
	}
	
	public function order_add_goods(){
		$id=I('order_id');
		$map['id']=$id;
		$info=M('OrderInfo')->where($map)->find();
		$this->assign('u_id',$info['uid']);
		$this->assign('shop_id',$info['shop_id']);
		$this->assign('order_id',$id);
		$this->display();
	}

    
    public function updateordergoods(){

        $mod=M('OrderInfo');

        $id=I('post.order_id');if(empty($id))$this->error('参数不正确');
		
		$orderinfo=$mod->field('goods_amount,order_amount,order_money')->find($id);

		$where['order_id']=$id;
		
		$order_goods=M('OrderGoods')->where($where)->field(true)->select();
		$new_order_amount=0;
        
		foreach($order_goods as $k=>$v){
			$new_order_amount+=$v['goods_price']*$v['goods_number'];
		}
        if($new_order_amount>=$orderinfo['order_amount']){
            $data['order_money']=$new_order_amount;
            $data['order_amount']=$new_order_amount;
        }else{
            $data['order_money']=$new_order_amount;
            $data['order_amount']=$orderinfo['order_amount'];
        }
        $mod->where('id='.$id)->save($data);
        action_log('update_order', 'Admin',I('id'),UID,'更新订单商品价格');
        
        $p_where['is_delete'] = 0;
        $p_where['order_id'] = array("like", "%," . $id. ",%");
        $o_data['is_delete']=1;
        $pay_info = M("PayLog")->where($p_where)->field(true)->find();

        $del_pay= M("PayLog")->where($p_where)->save($o_data);

        
        $p_where['id']=array("in",$pay_info['order_id']);
        $pay_order=M("OrderInfo")->where($p_where)->select();
        foreach(array_filter($pay_order) as $key=>$val){
            if($val['id']==0){
                unset($val['id']);
            }
            $pay_order_id[]=$val['id'];
        }
        $pay_order_id=array_filter($pay_order_id);
        if(!empty($pay_order_id)){
            $payment_id=','.implode(',',$pay_order_id).',';
            $map['id']=array('in',implode(',',$pay_order_id));
            $order_info=M("OrderInfo")->where($map)->field('sum(order_money) as total_price')->find();
            $payment=array();
            $payment['order_id']=$payment_id;
            $payment['type']=$pay_info['type'];
            $payment['user_id']=$pay_info['user_id'];
            $payment['order_sn']=createOrderNo();
            $payment['use_money']=0;
            $payment['use_score']=0;
            $payment['use_score_money']=0;
            $payment['pay_amount']=$order_info['total_price'];
            $payment['order_total_price']=$order_info['total_price'];
            $payment['payment_id']=$pay_info['payment_id'];
            $payment['pay_code']=$pay_info['pay_code'];
            $payment['is_paid']=0;
            $payment['create_time']=NOW_TIME;
            M("PayLog")->add($payment);

        }
        $this->success('更新成功',U('OrderInfo/view',array('id'=>$id)));

    }
	public function add_user(){
		$store=M('Store')->field(true)->select();
		foreach($store as $k=>$v){
			$store_option[$v['id']]=$v['name'];	
		}
		$this->assign('store_option',$store_option);
		$this->display();
    }
	public function add_goods(){
		$order=I('get.');
		$info=I('post.');
		if($info){
			$map['uid']=$info['user_list'];
			if($info['consignee'])$map['consignee']=$info['consignee'];
			if($info['area_sheng'])$map['province']=$info['area_sheng'];
			if($info['area_shi'])$map['city']=$info['area_shi'];
			if($info['area_xian'])$map['district']=$info['area_xian'];
			if($info['address'])$map['address']=$info['address'];
			if($info['store_id'])$map['store_id']=$info['store_id'];
			if($info['mobile'])$map['mobile']=$info['mobile'];
			if($info['best_time'])$map['best_time']=$info['best_time'];
			$map['status']=0;
			$map['addtime']=NOW_TIME;
			$map['order_sn']= createOrderNo();
			
			$add_order=M('OrderInfo')->add($map);
			$this->assign('order_id',$add_order);
			$this->assign('u_id',$map['uid']);
		}
		if($order){
			$order_info=M('OrderGoods')->where('order_id='.$order['id'])->field(true)->select();
			foreach($order_info as $k=>$v){
				$order_info[$k]['only_price']=$order_info[$k]['goods_price']/$order_info[$k]['goods_number'];
			}
			$goods_amount=M('OrderInfo')->where('id='.$order['id'])->field('goods_amount')->find();
			$this->assign('goods_amount',$goods_amount['goods_amount']);
			$this->assign('order_id',$order['id']);
			$this->assign('u_id',$order['u_id']);
			$this->assign('order_info',$order_info);
		}
		$this->display();
	}
	public function add_info(){
		$order_id=I('post.order_id');
		$u_id=I('post.u_id');
		
		$order_info=M('OrderInfo')->where('id='.$order_id)->field(true)->find();
		if(!empty($order_info['consignee'])){
			$send=M('Shipping')->where('status=1')->field(true)->select();
			
			$this->assign('send_goods',$send);	
		}
		$this->assign('order_info',$order_info);
		
		$goods_id=M('OrderGoods')->alias('og')->where('og.order_id='.$order_id)->field('og.goods_id,g.catid')->JOIN('LEFT JOIN __GOODS__ g ON og.goods_id=g.id')->select();		
		$a=$buy_integral=$rank_integral=0;
		foreach($goods_id as $key=>$value){
			$bonus_goods[$a] = M('Goods')->field(true)->where('id='.$value['goods_id'])->find();
			if($bonus_goods[$a]['integral'] = 0){
				if($bonus_goods[$a]['give_integral'] >= 0){
					$buy_integral += $bonus_goods[$a]['give_integral'];
				}elseif($cart_info[$i]['give_integral'] == -1){
					$buy_integral += $bonus_goods[$a]['price_goods_attr'];
				}
				if($bonus_goods[$a]['rank_integral'] >= 0){
					$rank_integral += $bonus_goods[$a]['rank_integral'];
				}elseif($bonus_goods[$a]['rank_integral'] == -1){
					$rank_integral += $bonus_goods[$a]['price_goods_attr'];
				}
				$a++;
			}
		}
		$bonus_user = M('MemberBonus')->alias('mb')->field('b.*,mb.*')->where('mb.used_time=0 and b.id != 4')->JOIN('LEFT JOIN __BONU__ b ON b.id=mb.bonus_type_id')->select();
		
		foreach($goods_id as $key=>$value2){
			foreach($bonus_user as $key1=>$value1){
				if($value1['cat_id']==0){
					if(!empty($bonus_user[$key1]['type_name']) && ($bonus_user[$key1]['min_goods_money'] <= $all_money ) && ($bonus_user[$key1]['start_time'] <= NOW_TIME && $bonus_user[$key1]['end_time'] >= NOW_TIME)){
							if($bonus_user[$key1]['bonus_type_id']==1 && $bonus_user[$key1]['user_id']==$sess['id']){
								$bonu_user[$key1]=$value1;
							}elseif($bonus_user[$key1]['bonus_type_id']==2 && $bonus_user[$key1]['bonus_sn']==$goods_id[$key]['goods_id']){
								$bonu_user[$key1]=$bonus_user[$key1];
								$cat=M('Goods')->where('id='.$bonus_user[$key1]['bonus_sn'])->field('catid')->find();
								$bonu_user[$key1]['cat_id']=$cat['catid'];
							}elseif($bonus_user[$key1]['bonus_type_id']>4 && $bonus_user[$key1]['user_id']==$sess['id']){
								$bonu_user[$key1]=$bonus_user[$key1];
							}
					}
				}else{
					if(!empty($bonus_user[$key1]['type_name']) && ($bonus_user[$key1]['min_goods_money'] <= $all_money ) && ($bonus_user[$key1]['start_time'] <= NOW_TIME && $bonus_user[$key1]['end_time'] >= NOW_TIME)){
							if($bonus_user[$key1]['bonus_type_id']==1 && $bonus_user[$key1]['user_id']==$sess['id'] && $bonus_user[$key1]['cat_id']==$goods_id[$key]['catid']){
								$bonu_user[$key1]=$value1;
							}elseif($bonus_user[$key1]['bonus_type_id']==2 && $bonus_user[$key1]['bonus_sn']==$goods_id[$key]['goods_id']){
								$bonu_user[$key1]=$bonus_user[$key1];
								$cat=M('Goods')->where('id='.$bonus_user[$key1]['bonus_sn'])->field('catid')->find();
								$bonu_user[$key1]['cat_id']=$cat['catid'];
							}elseif($bonus_user[$key1]['bonus_type_id']>4 && $bonus_user[$key1]['user_id']==$sess['id'] && $bonus_user[$key1]['cat_id']==$goods_id[$key]['catid']){
								$bonu_user[$key1]=$bonus_user[$key1];
							}
					}
				}
			}
		}
		if($order_info['uid']){
			$userank = M('Member')->where('id='.$order_info['uid'])->field('money')->find();
			$this->assign('use_money',$userank['money']);
		}
		$pay=M('Payment')->where('status=1')->field(true)->select();
		$this->assign('payment',$pay);
		$this->assign('buy_integral',$buy_integral);
		$this->assign('rank_integral',$rank_integral);
		$this->assign('bonus',$bonu_user);
		$this->assign('order_id',$order_id);
		$this->display();
    }
	public function order_all_info(){
		$info=I('post.');
		
		$pay=M('Payment')->where("code='".$info['paytype']."'")->field('fee')->find();
		$pay_fee= getfeemoney($info['order_money'],$pay['fee'],'1');
		$id=M('OrderInfo')->where('id='.$info['order_id'])->field('uid')->find();
		
		$user_money = I('post.money',0);
		if($user_money && $user_money<=$info['order_money']){
			$use_mon['money']=$pri['money']-$user_money;
			M('Member')->where('id='.$sess['id'])->save($use_mon);
			$add_log['uid']=$id;
			$add_log['adminid']=0;
			$add_log['change_type']=1;
			$add_log['change_num']=$user_money;
			$add_log['change_time']=NOW_TIME;
			$add_log['type']=1;
			$add_log['status']=4;
			M('AccountLog')->add($add_log);
		}
		
		if($all_info['use_bonu_goods']){
		$boun_user_money=M('MemberBonus')->where('bonus_id='.$all_info['use_bonu_goods'])->field(true)->find();					
			if($boun_user_money){
				$bonus=$boun_user_money['money'];
				if($boun_user_money['bonus_type_id']!=2){
				$user_bonu['used_time']=NOW_TIME;}
				$user_bonu['user_id']=$id;
				$where_mb['bonus_id']=$all_info['use_bonu_goods'];
				
				$boun_user_del=M('MemberBonus')->where($where_mb)->save($user_bonu);	
			}
		}
		
		$order_bonus_3=M('Bonu')->where('id=3')->field(true)->find();
		if(($order_bonus_3['min_goods_amount'] <= $info['order_money'] ) && ($order_bonus_3['send_start_date'] < NOW_TIME && $order_bonus_3['send_end_date'] > NOW_TIME)){
			$order_bonus_money=$order_bonus_3['type_money'];
		}
		
		if($id){
			$pri=M('Member')->where('id='.$id['uid'])->field('money,points,usepoints')->find();
			$huan['points']=$pri['points']+$all_info['rank_integral'];
			$huan['usepoints']=$pri['usepoints']+$all_info['buy_integral'];
			M('Member')->where('id='.$id['uid'])->save($huan);
			$add_log_rank['uid']=$id;
			$add_log_rank['adminid']=0;
			$add_log_rank['change_type']=3;
			$add_log_rank['change_num']=$all_info['rank_integral'];
			$add_log_rank['change_time']=NOW_TIME;
			$add_log_rank['type']=0;
			$add_log_rank['status']=6;
			M('AccountLog')->add($add_log_rank);
			$add_log_buy['uid']=$id;
			$add_log_buy['adminid']=0;
			$add_log_buy['change_type']=4;
			$add_log_buy['change_num']=$all_info['buy_integral'];
			$add_log_buy['change_time']=NOW_TIME;
			$add_log_buy['type']=0;
			$add_log_buy['status']=6;
			M('AccountLog')->add($add_log_buy);
		}
		
		if($info['order_money'] < $yunfei)$send_fee=$money; else $send_fee=0;
		$arr['shipping_id']=$info['sendtype'];
		$arr['shipping_fee']=$send['code_fee'];
		$arr['shipping_status']=1;
		$arr['pay_code']=$info['paytype'];
		$arr['pay_fee']=$pay_fee;
		$arr['status']=1;
		$arr['order_amount']=$info['order_money']+$send_fee-$use_money-$bonus-$order_bonus_money;
		$save_order=M('OrderInfo')->where('id='.$info['order_id'])->save($arr);
		if($save_order){
            $this->success('添加成功！',U('OrderInfo/index'));
        }else{
            $this->error('添加失败！',U('OrderInfo/index'));
        }
		
	}
	
	public function search_goods(){
		$g_ingo=I('get.goods_info');
		if($g_ingo){
            $whereor['id']=array('like','%'.$g_ingo.'%');
            $whereor['goods_name']=array('like','%'.$g_ingo.'%');
            $whereor['goods_sn']=array('like','%'.$g_ingo.'%');
            $whereor['_logic'] = 'or';
            $map['_complex'] = $whereor;
        }
		$g_list=M('Goods')->where($map)->field('id,goods_name,goods_sn,status,shop_id')->select();
		
		$result="<option>请选择商品</option>";
		foreach($g_list as $k=>$v){
			if($v['status']==1){
				$result.="<option value='".$v['id']."'>".$v['goods_name']."</option>";	
			}
		}
		echo $result;exit;
	}
	
	public function change_goods(){
		$g_id=I('get.goods_id');
		$u_id=I('get.user_info');
        
		$g_info=M('Goods')->where('id='.$g_id)->find();
		$g_info['cat_name']=idtoname($g_info['cat_id'],'GoodsCategory','name');
		$g_info['brand_name']=idtoname($g_info['brand_id'],'Brand','brand_name');
		
		$goods_attr = M('goods_attr')->alias('ga')->field('ga.attr_id,ga.attr_value,ga.attr_price,g.type,ga.attr_img,g.name,g.options')->where('goods_id='.$g_id)->JOIN('LEFT JOIN __GOODS_ATTRIBUTE__ g ON g.id=ga.attr_id')->order('ga.id')->select();
		 $goodsattr=$goodsattr_price=array();
		foreach($goods_attr as $k=>$row){
			$valarr_img=$valarr=$attrarr='';
			if(in_array($row['type'],array('select','radio','checkbox'))){
				$valarr=explode(',',$row['attr_value']);
				$attrarr=strtoarray($row['options']);
				if(!empty($row['attr_img']))$valarr_img=explode(',',$row['attr_img']);
			}else{
				$valarr=$row['attr_value'];
				$attrarr=$row['options'];
				if(!empty($row['attr_img']))$valarr_img=$row['attr_img'];
			}
			$goodsattr[$row['attr_id']]['name']=$row['name'];
			$goodsattr[$row['attr_id']]['is_price']=$row['is_price'];			 
			if(is_array($valarr)){
				$arrval=array();
				$i=0;
				foreach($valarr as $key=> $rows){
					if(empty($rows) && !is_numeric($rows))continue;
					if($i==0)$goodsattr[$row['attr_id']]['first_key']=$key;
					$arrval[$rows]=$attrarr[$rows];
					if(!empty($valarr_img[$key]))$goodsattr[$row['attr_id']]['img'][$key]=$valarr_img[$key];
					$goodsattr[$row['attr_id']]['option'][$key]=$attrarr[$rows];
				++$i;}$goodsattr[$row['attr_id']]['value']=implode(',',$arrval);
			}else{
				$goodsattr[$row['attr_id']]['value']=$valarr;
			}
		}
		$attrid=$attr=$price='';
		$price.="<input type='radio' id='market_price' name='price' value='".$g_info['market_price']."'>市场价：".$g_info['market_price']."</br>";
		$price.="<input type='radio' id='shop_price' name='price' value='".$g_info['shop_price']."'>本店价:".$g_info['shop_price']."</br>";
		$price.="<input type='radio' name='price'>自定义价格：<input type='text' name='defind_price' id='defind_price'>";
		
			foreach($goodsattr as $ke=>$va){
				
				if(count($va['option'])>1){
					$attrid=$va['name'].":".$attrid;
					foreach($va['option'] as $k1=>$v1){
						$attrid.="<input type='radio' name='goods_attr' value='".$v1."'>".$v1;
					}
				}else{
					$attrid.=$va['name'].":".$va['value']."</br>";
				}
			}
			
		$attr=rtrim($attr,',');	
			
        $result='';
		if($g_info['status']==1){
			$result.="<table width='100%' cellpadding='2' cellspacing='1' class='table_form'>";
			$result.="<tr><th width=100 scope='row'>商品名称:</th><td>".$g_info['goods_name']."<input type='hidden' id='goods_id' value='".$g_info['id']."'></td></tr>";
			$result.="<tr><th width=100 scope='row'>货号:</th><td>".$g_info['goods_sn']."</td></tr>";	
			$result.="<tr><th width=100 scope='row'>分类:</th><td>".$g_info['cat_name']."</td></tr>";	
			$result.="<tr><th width=100 scope='row'>品牌:</th><td>".$g_info['brand_name']."</td></tr>";	
			$result.="<tr><th width=100 scope='row'>价格:</th><td>".$price."</td></tr>";
			$result.="<tr><th width=100 scope='row'>属性:</th><td>".$attrid."</td></tr>";	
			$result.="<tr><th width=100 scope='row'>数量:</th><td><input type='text' name='number' value='1'></td></tr>";
			$result.="<input type='hidden' id='shop_id' value='".$g_info['shop_id']."'>";
			$result.="</table>";						
		}
		echo $result;exit;
	}
	
	public function change_user(){
		$u_id=I('get.user_id');
		
		$g_info=M('Member')->where('id='.$u_id)->find();
		$address_info=M('MemberAddress')->where('uid='.$u_id)->select();
		$attrid=$attr=$address='';
		$address.="<table width='100%' cellpadding='2' cellspacing='1' class='table_form'>";
		$address.="<tr><th width='95'><b>收货地址信息</b></th><td colspan='6'></td></tr>";
		foreach($address_info as $k=>$v){
			$address.="<tr><th></th><td><input type='radio' onclick='change_add()' id='market_price' name='address_id' value='".$v['id']."'>".idtoname($v['province'],'Area','name').idtoname($v['city'],'Area','name').idtoname($v['district'],'Area','name').$v['address']."&nbsp;&nbsp;".$v['consignee']."&nbsp;手机：&nbsp;".$v['mobile']."</td></tr>";
		}
		$address.="</table>";
		$where['uid']=$u_id;
		$card=M('MemberCard')->where($where)->field('card_sn')->find();
		$order=M('OrderInfo')->where($where)->field('id')->order('id desc')->select();
		$where_or['order_id']=$order[0]['id'];
		$order_goods=M('OrderGoods')->where($where_or)->field('goods_name')->order('id desc')->select();
		if($g_info['status']==1){
			$result.="<table width='100%' cellpadding='2' cellspacing='1' class='table_form'>";
			$result.="<tr><th style='text-align:left;'><b>会员信息</b></th><td colspan='7'></td></tr>";
			$result.="<tr><th class='color' style='text-align:center;'>用户名:</th><td>".$g_info['username']."</td>";
			$result.="<th class='color' style='text-align:center;'>手机:</th><td class='red'>".$g_info['mobile']."</td>";	
			$result.="<th class='color' style='text-align:center;'>注册时间:</th><td>".time_format($g_info['reg_time'])."</td>";	
			$result.="<th class='color' style='text-align:center;'>会员卡号:</th><td class='red'>".$card['card_sn']."</td></tr>";	
			$result.="<tr><th class='color' style='text-align:center;'>可用资金:</th><td>".$g_info['money']."</td>";
			$result.="<th class='color' style='text-align:center;'>上次登录时间:</th><td class='red'>".time_format($g_info['last_login'])."</td>";	
			$result.="<th class='color' style='text-align:center;'>消费积分:</th><td>".$g_info['usepoints']."</td>";
			$result.="<th class='color' style='text-align:center;'>上次购买的商品:</th><td class='red'>".$order_goods[0]['goods_name']."</td></tr>";
			$result.="</table>";						
		}
		$data['add']=$address;
		$data['info']=$result;
		$this->ajaxReturn($data);exit;
	}
	
	public function change_address(){
		$id=I('get.address_id');
		
		$address_info=M('MemberAddress')->where('id='.$id)->find();
		$data['consignee']=$address_info['consignee'];
		$area=M('Area')->field('id,name,pid')->select();
		$sheng_option="<option>请选择市</option>";
		foreach($area as $k=>$v){
			if($v['pid']<=1){
				if($v['id']==$address_info['province']){
					$sheng_option.="<option value='".$v['id']."' selected='selected'>".$v['name']."</option>";
				}else{
					$sheng_option.="<option value='".$v['id']."'>".$v['name']."</option>";
				}
			}
		}
		$shi_option="<option>请选择区县</option>";
		foreach($area as $ke=>$va){
			if($va['pid']>1 && $va['pid']<=12){
				if($va['id']==$address_info['city']){
					$shi_option.="<option value='".$va['id']."' selected='selected'>".$va['name']."</option>";
				}else{
					$shi_option.="<option value='".$va['id']."'>".$va['name']."</option>";
				}
			}
		}
		$xian_option="<option>请选择乡镇</option>";
		foreach($area as $key=>$val){
			if($val['pid']>12){
				if($val['id']==$address_info['district']){
					$xian_option.="<option value='".$val['id']."' selected='selected'>".$val['name']."</option>";
				}else{
					$xian_option.="<option value='".$val['id']."'>".$val['name']."</option>";
				}
			}
		}
		$store=M('Store')->field(true)->select();
		$store_option="<option>请选择服务站</option>";
		foreach($store as $k1=>$v1){
			if($v1['id']==$address_info['store_id']){
				$store_option.="<option value='".$v1['id']."' selected='selected'>".$v1['name']."</option>"; 
			}else{
				$store_option.="<option value='".$v1['id']."'>".$v1['name']."</option>";
			}
		}
		$data['store']=$store_option;
		$data['sheng']=$sheng_option;
		$data['shi']=$shi_option;
		$data['xian']=$xian_option;
		$data['mobile']=$address_info['mobile'];
		$data['address']=$address_info['address'];
		$data['best_time']=time_format($address_info['best_time']);				
		$this->ajaxReturn($data);exit;
	}
	public function add_addre(){
		$c=I('get.');
		if($c['address_id']){
			$where['id']=$c['address_id'];
			$save['consignee']=$c['consignee'];
			$save['province']=$c['area_sheng'];
			$save['city']=$c['area_shi'];
			$save['district']=$c['area_xian'];
			$save['store_id']=$c['store_id'];
			$save['mobile']=$c['mobile'];
			$save['address']=$c['address'];
			$save['best_time']=$c['best_time'];
			$address_save=M('MemberAddress')->where($where)->save($save);
			if($address_save !=false){
				$data['status']=0;
			}else{
				$data['status']=1;
			}
		}else{
			$where_a['uid']=$c['user_list'];
			$address_count=M('MemberAddress')->where($where)->count();
			if($address_count<5){
				$add['consignee']=$c['consignee'];
				$add['province']=$c['area_sheng'];
				$add['city']=$c['area_shi'];
				$add['district']=$c['area_xian'];
				$add['store_id']=$c['store_id'];
				$add['mobile']=$c['mobile'];
				$add['address']=$c['address'];
				$add['best_time']=$c['best_time'];
				$address_add=M('MemberAddress')->add($add);
				if($address_add !=false){
					$data['status']=2;
				}else{
					$data['status']=3;
				}
			}else{
				$data['status']=4;
			}
		}
		$this->ajaxReturn($data);exit;
	}
	public function add_order_goods(){
		$c=I('get.');
		
		$attr=str_replace('&lt;/br&gt;',',',$c['goods_attr']);
		$goods_info=M('Goods')->where('id='.$c['id'])->field(true)->find();

		if($c['price'] && !$c['defind_price']){
			$goods_info['shop_price']=$c['price'];
		}elseif($c['defind_price']){
			$goods_info['shop_price']=$c['defind_price'];
		}
		$arrt['goods_id']=$c['id'];
		$arrt['goods_sn']=$goods_info['goods_sn'];
		$arrt['order_id']=$c['order_id'];
		$arrt['goods_name']=$goods_info['goods_name'];
		$arrt['goods_number']=$c['number'];
		$arrt['goods_price']=$goods_info['shop_price']*$c['number'];
		$arrt['attr_price']=$goods_info['shop_price']*$c['number'];
		$arrt['goods_attr']=$attr;

		$arrt['shop_id']=$goods_info['shop_id'];	
		
		$a=M('OrderGoods')->add($arrt);
		$order_info=M('OrderInfo')->where('id='.$c['order_id'])->field('order_amount,goods_amount')->find();
		$order_arr['order_amount']=$order_info['order_amount']+$goods_info['shop_price'];
		$order_arr['goods_amount']=$order_info['goods_amount']+$goods_info['shop_price'];
		$order_arr['shop_id']=$goods_info['shop_id'];
		$b=M('OrderInfo')->where('id='.$c['order_id'])->save($order_arr);
		if($a && $b){
			$data['info']='添加成功！';
			$data['url']=U('Admin/OrderInfo/add_goods', array('id' =>$c['order_id'],'u_id'=>$c['u_id'],'shop_id'=>$c['shop_id']));
			$data['shop_id']=$goods_info['shop_id'];
			$this->ajaxReturn($data);
		}
	}
	public function add_order_goods_order(){
		$c=I('get.');
		
        $time=NOW_TIME;
		$attr=str_replace('&lt;/br&gt;',',',$c['goods_attr']);
		$where['id']=$c['id'];
		$goods_info=M('Goods')->where($where)->field(true)->find();

		if($c['price'] && !$c['defind_price']){
			$goods_info['shop_price']=$c['price'];
		}elseif($c['defind_price']){
			$goods_info['shop_price']=$c['defind_price'];
		}
		$arrt['goods_id']=$c['id'];
		$arrt['goods_sn']=$goods_info['goods_sn'];
		$arrt['order_id']=$c['order_id'];
		$arrt['goods_name']=$goods_info['goods_name'];
		$arrt['goods_number']=$c['number'];
		$arrt['goods_price']=$goods_info['shop_price']*$c['number'];
		$arrt['attr_price']=$goods_info['shop_price']*$c['number'];
		$arrt['goods_attr']=$attr;

		$arrt['shop_id']=$goods_info['shop_id'];	
		
		$a=M('OrderGoods')->add($arrt);
		if($a){
			$data['info']='添加成功！';
			$data['url']=U('Admin/OrderInfo/ordergoods', array('id' =>$c['order_id']));
			$this->ajaxReturn($data);
		}
	}
	public function save_order_goods(){
		$c=I('get.');
		
		$order_id=$c['order_id'];
		$shop_id=$c['shop_id'];
		$count=count($c['goods_id']);
        $arrts=array();
		for($i=0;$i<=$count;$i++){
			$arrt['attr_price']=$arrt['goods_price']=$c['goods_price'][$i];
			$arrt['goods_number']=$c['goods_number'][$i];
			$arrt['goods_attr']=$c['goods_attr'][$i];
			$goods_id=$c['goods_id'][$i];
			$a=M('OrderGoods')->where('order_id='.$order_id.' and goods_id='.$goods_id)->save($arrt);
			$arrts['goods_price']+=$c['goods_price'][$i];
		}
		$order_arr['order_amount']=$arrts['goods_price'];
		$order_arr['goods_amount']=$arrts['goods_price'];
		$b=M('OrderInfo')->where('id='.$order_id)->save($order_arr);
		$data['info']='更新成功！';
		$data['url']=U('Admin/OrderInfo/add_goods', array('id' =>$c['order_id'],'u_id'=>$c['u_id'],'shop_id'=>$shop_id));
		$this->ajaxReturn($data);
	}
	
	public function searchuser(){
		$like=I('get.like');
		
		if($like){
            $whereor['mobile']=$like;
			
            
            $map['_complex'] = $whereor;
			$list=M('Member')->where($map)->field('id,username,status')->select();
			$result="<option>请选择该会员</option>";
			foreach($list as $k=>$v){
				if($v['status']==1){
					$result.="<option value='".$v['id']."'>".$v['username']."</option>";	
				}	
			}
        }
		echo $result;exit;
	}
	public function order_print(){
		$id = I('get.id');
		$price='';
		$order_info = M('OrderInfo')->where('id='.$id)->field(true)->find();
		$pay_name = M('Payment')->where("code='".$order_info['pay_code']."'")->field('name')->find();
		$order_goods = M('OrderGoods')->where('order_id='.$id)->field(true)->select();
		foreach($order_goods as $ke=>$va){
            $attr=unserialize($va['goods_attr']);
            $order_goods[$ke]['attr_name']=$attr['name'];
            $order_goods[$ke]['goods_price_format']=format_price($va['goods_price']);
            $order_goods[$ke]['org_parce']=$va['goods_price']*$va['goods_number'];
            $price += $va['org_parce'];
            $order_goods[$ke]['org_parce_format']=format_price($order_goods[$ke]['org_parce']);
            $order_goods[$ke]['org_integral']=$va['goods_integral']*$va['goods_number'];
		}
		$url = C('WEB_URL');
		$phone = C('WEB_SITE_PHONE');
		$name = C('WEB_SITE_TITLE');
		$admin = idtoname(UID,'admin','username');
		$time = date('Y-m-d H:i:s',NOW_TIME);
		$this->assign('url',$url);
		$this->assign('phone',$phone);
		$this->assign('name',$name);
		$this->assign('admin',$admin);
		$this->assign('time',$time);
		$this->assign('pay_name',$pay_name['name']);
		$this->assign('order_info',$order_info);
		$this->assign('price',$price);
		$this->assign('order_goods',$order_goods);
		$this->display();
    }
	public function store_shou(){
		$id = I('get.id');
		$where['id']=$id;
		$date['status']=6;
		$change=M('OrderInfo')->where($where)->save($date);
		if($change){
            $this->success('签收成功！',U('OrderInfo/index'));
        }else{
            $this->error('签收失败！',U('OrderInfo/index'));
        }
    }

    
    public function deliver_goods(){
        $data['order_id']=I('order_id');
        $data['notice_sn']=I('notice_sn');
        $data['send_type']=I('send_type');
        $data['type']='Admin';
		$data['admin_id']=UID;
        $result=D("Common/OrderInfo")->ship_goods($data);
        if($result['status']){
            $this->success($result['info']);
        }else{
            $this->error($result['info']);
        }
    }
    public function manage(){
        $order_id=I('post.order_id');
		$content=I('post.content');
		$order=I('post.order');
		$store_id=I('post.store_id');
		$orderss=idtoname($order,'OrderInfo','*');
		
		
		if(empty($order_id))$this->error('参数不正确');
        
        $mod=M('OrderInfo');
        if(I('post.confirm')){$log='确认';$data['confirm_time']=NOW_TIME;$data['status']='2';}
        if(I('post.pay')){
			$log='付款';
			$data['pay_time']=NOW_TIME;
			$data['pay_status']='3';
			
			$or_info['id']=$order;
			$shop_map['id']=$orderss['shop_id'];
			$info_g=M('OrderGoods')->alias('og')->where('og.order_id='.$order)->field('og.*,g.supply_price')->JOIN('LEFT JOIN __GOODS__ g ON g.id=og.goods_id')->select();
			$all_supplymoney=0;
			foreach($info_g as $ke1=>$va1){
				$all_supplymoney += $va1['supply_price'];
			}
			$old_total_revenues=idtoname($shop_map['id'],'Shops','total_revenues');
			$old_unbalance=idtoname($shop_map['id'],'Shops','unbalance');
			$order_info['id']=$order;
			$shop_where['id']=$shop_map['id'];
			$con_data['total_revenues']=$old_total_revenues+$all_supplymoney;
			$con_data['unbalance']=$old_unbalance+$all_supplymoney;
			$up_shop=M('Shops')->where($shop_where)->save($con_data);
			shop_moneychange($shop_map['id'],0,$all_supplymoney,'订单'.idtoname($order,'OrderInfo','order_sn').'已付款,营业总额、未结算总额收入:'.$all_supplymoney.'元',$or_info);
			
			$ex=C('EXTENSION_SETTING');
			if($ex){$a=affiliate($order);}
		}
        if(I('post.unpay')){$log='设为未付款';$data['pay_time']=NOW_TIME;$data['pay_status']='1';}
        if(I('post.prepare')){$log='配货';$data['shipping_status']='2';}
        if(I('post.ship')){$log='发货';$data['shipping_time']=NOW_TIME;$data['shipping_status']='3';}
        if(I('post.unship')){$log='未发货';$data['shipping_status']='1';}
        if(I('post.receive')){$log='已收货';$data['status']='3';}
        if(I('post.return')){$log='退货';$data['status']='6';}
        if(I('post.cancel')){$log='取消';$data['status']='4';}
        if(I('post.invalid')){$log='无效';$data['status']='5';}
        if(I('post.after_service') && I('post.content')){$log='售后';}
		$user_info = M('OrderInfo')->where('id='.$order_id)->field('consignee,email')->find();
		
		if($log == '发货'){
			$save['store_id']=$store_id;
			M('OrderInfo')->where('id='.$order)->save($save);
			$member=M('OrderInfo')->where('id='.$order)->field('uid,mobile')->find();
			if(!empty($member['uid'])){
				
				$moblie=M('Member')->where('id='.$member['uid'])->field('mobile')->find();
				
				$phone=$moblie['mobile'];
				
			}else{
				$phone=$member['mobile'];
			}
			
			$data['to']=$phone;   
        	$result=sendbytheme($data,'SHIP_GOODS_CODE');
		}
		if($log == '已收货'){
			$postdata['order_id']=$order_id;
			$postdata['admin_id']=MID;
			$postdata['type']=='Admin';
			$return=D('Common/OrderInfo')->confirm_order($postdata);
			if($return['status']){
				$this->success($return['msg']);
			}else{
				$this->error($return['msg']);
			}
		}
        if($log=="退货"){
            $member_info=session('member_info');
                $order_info=M("OrderInfo")->where('id='.$order_id)->field(true)->find();
                    $money=$order_info['order_amount']-$order_info['delivery_fee'];
                    $info=M("OrderGoods")->where('order_id='.$order_id)->field('id,goods_id,goods_number')->select();
                    foreach($info as $k=>$v){
                        $goods_info[$k]['goods_id']=$v['goods_id'];
                        $goods_info[$k]['number']=$v['goods_number'];
                        
                        $g_map['id']=$v['id'];
                        $g_map['status']=1;
                        $save['status']=3;
                        $res=M('OrderGoods')->where($g_map)->save($save);
                        $org_id[]=$v['id'];
                    }

                $str_orgids=implode(',',$org_id);
                
                $add['org_id']=$str_orgids;
                $add['uid']=$member_info['id'];
                $add['shop_id']=$order_info['shop_id'];
                $add['order_id']=$order_id;
                $add['goods_info']=serialize($goods_info);
                $add['reason']=$content;
                $add['money']=$money;
                $add['add_time']=NOW_TIME;
                $res=M('ReturnGoods')->add($add);
                
                $refund_data['reason']=$content;
                $refund_data['type']=0;
                $refund_data['order_goods']=$str_orgids;
                $result=D("Common/OrderInfo")->add_refund($money,$order_id,$refund_data);
                if($result){
                    action_log('user_apply_return', 'Member', $res, $member_info['id']);
                    
                }


        }
        if($log){
            if($data)$mod->where('id='.$order_id)->save($data);
			$where_oi['id']=$order;
			$orderinfo = M('OrderInfo')->where($where_oi)->find();
			if($orderinfo['shipping_status']==3){
				$where_og['order_id']=$order;
				$ordergoods = M('OrderGoods')->where($where_og)->select();
				foreach($ordergoods as $k=>$v){
					$where_g['id']=$v['goods_id'];
					$old_num = M('Goods')->where($where_g)->find();
					$con['goods_number']=$old_num['goods_number']-$v['goods_number'];
					$con['sell_count']=$old_num['sell_count']+$v['goods_number'];
					M('Goods')->where($where_g)->save($con);
				}
			}
            $log=$log.' '.I('post.content');
            action_log('manage_order', 'OrderInfo',$order_id,UID,$log);
            $this->success(L('DO_OK'),U('OrderInfo/view',array('id'=>$order_id)));
        }else{
            $this->error('参数不正确!');
        }
    }
    
	private function getNodeTree($pid = '') {
	   
       $payment_select=M('Payment')->where(array('status'=>array('egt',0)))->field('code,name')->order('sort,id desc')->select();
       foreach($payment_select as $v){$payment[$v['code']]=$v['name'];}
       
       $shipping_select=M('Shipping')->where(array('status'=>array('egt',0)))->field('id,name')->order('sort,id desc')->select();
       foreach($shipping_select as $v){$shipping[$v['id']]=$v['name'];}
       $this->assign('payment',$payment);
       $this->assign('shipping',$shipping);
       unset($payment_select,$payment,$shipping_select,$shipping);
	}
	
	private function operable_list($orderid){
		$order=M('OrderInfo')->field('status,shipping_status,pay_status,pay_code')->find($orderid);
		$os = $order['status'];$ss = $order['shipping_status'];$ps = $order['pay_status'];
		$priv_list  = array('os'=> true,'ss'=>true,'ps'=>true,'edit'=>true); 
		if($order['pay_code']=='HANCHAObank')$is_cod= $payment = 1;   
		
		$list = array();
		if (1 == $os){
			if ($priv_list['os']){
				$list['confirm']= true; $list['invalid']= true;$list['cancel']= true; 
				if ($is_cod){if ($priv_list['ss']){$list['prepare'] = true; }
				}else{if ($priv_list['ps']) { $list['pay'] = true;}}  
			}
		}elseif (2 == $os ){
			if (1 == $ps){
				if (1 == $ss || 2 == $ss){$list['ship'] = true;
					if ($priv_list['os']){$list['cancel'] = true; $list['invalid'] = true;} 
					if ($is_cod){if ($priv_list['ss'] && 1 == $ss){$list['prepare'] = true;}} 
					else if ($priv_list['ps']){$list['pay'] = true;}
				}else{                
					if ($priv_list['ps']){$list['pay'] = true;}        
					if ($priv_list['ss']){if (3 == $ss){$list['receive'] = true;}} if ($priv_list['os']){$list['return'] = true;} $list['unship'] = true; 
				}
			}else{
				if (1 == $ss || 2 == $ss){$list['ship'] = true;
					if ($priv_list['ss'] && 1 == $ss){$list['prepare'] = true;} 
					if ($priv_list['ps']){$list['unpay'] = true; if ($priv_list['os']){$list['cancel'] = true;} } 
				}else{
					if ($priv_list['ss']){if (3 == $ss){$list['receive'] = true;} if (!$is_cod){$list['unship'] = true;}} 
					if ($priv_list['ps'] && $is_cod){$list['unpay']  = true;} 
					if ($priv_list['os'] && $priv_list['ss'] && $priv_list['ps']){$list['return'] = true;} 
				}
			}
		}elseif (4 == $os){
			if($priv_list['os']){$list['confirm'] = true;}if($priv_list['edit']){$list['remove'] = true;}
		}elseif (5 == $os){
			if($priv_list['os']){$list['confirm'] = true;}if($priv_list['edit']){$list['remove'] = true;}
		}elseif (6 == $os && $priv_list['os']){  
			$list['confirm']=true;
		}
		if($is_cod && $priv_list['ps']){$list['pay']=true;} 
		
		$list['after_service'] = true;
       
		return $list;
		
    }
    public function ship(){
        $id=I('id');if(empty($id))$this->error('参数不正确');
		$ordergoods=M('OrderGoods')->where('order_id='.$id)->select();
		foreach($ordergoods as $k=>$v){
			$attr=unserialize($v['goods_attr']);
			$ordergoods[$k]['attr_name']=$attr['name'];
			$ordergoods[$k]['org_parce']=$v['goods_price']*$v['goods_number'];
		}
        $this->assign('ordergoods',$ordergoods);
        $order_info=M('OrderInfo')->where('id='.$id)->find();
        $this->assign($order_info);
        $shipping_list=M('Shipping')->where('status=1')->field('code,name')->select();
        foreach($shipping_list as $k=>$v){
            $shipping_info[$v['code']]=$v['name'];
        }
        $this->assign('shipping',$shipping_info);
        $this->display ();
    }
    
    public function recycling()
    {
        $name = 'OrderInfo';
        $postdata = I('post.');
        $id = I('get.id');
        if (empty($postdata['id']) && !empty($id)) $postdata['id'][] = $id;
        $is_delete = I('is_delete');
        if (empty($postdata['id'])) {
            if ($is_delete == 1) $this->error(L('PLEASE_SELECT_DELETE_GOODS'));
            else $this->error('请选择要恢复的订单！');
        }
        $where['is_delete'] = $is_delete;
        foreach ($postdata['id'] as $key => $value) {
            $map['id'] = $value;
            $g_info = M($name)->where($map)->save($where);
        }
        if ($is_delete == 1) {
            if (isset($g_info)) {
                $this->success(L('HAVE_PUT_IN_RECYCLE'));
            } else {
                $this->error(L('DELETE_FAILED'));
            }
        } else {
            if (isset($g_info)) {
                $this->success(L('RECOVER_SUCCESS'));
            } else {
                $this->error(L('RECOVER_FAILED'));
            }
        }
    }
    
	public function ship_print(){
		$id = I('get.id','','intval');
		$test = I('get.test','0','intval');
        $res=D('Shop/Shipping')->ship_print($id);
        if($res['status']){
            $this->assign($res['info']);
        }else{
            $this->error($res['info']);exit;
        }
        $this->assign('test',$test);
		$this->display();
    }
}