<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Admin\Controller;
class PromotActController extends BaseController
{
    public function _initialize()
    {
        parent::_initialize();
        $this->PromotAct = getcache('PromotAct');
    }

    public function index()
    {
        $keyword = I('keyword');
        if (is_numeric($keyword)) {
            $map['id|act_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if ($keyword) {
            $map['act_name'] = array('like', '%' . (string)$keyword . '%');
        }
        $map['is_group'] = 0;
        $map['is_limit_time'] = 0;
        $map['is_pt'] = 0;
        $map['is_presale'] = 0;
        $map['shop_id'] = 0;
        $list = $this->lists('PromotAct', $map, 'id desc');
        $this->assign('list', $list);
        $this->display();
    }

    
    public function index_shops()
    {
        $keyword = I('keyword');
        $postdata = I('post.');
        if (is_numeric($keyword)) {
            $map['id|act_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if ($keyword) {
            $map['act_name'] = array('like', '%' . (string)$keyword . '%');
        }
        $s_id_map=$this->get_shop_ids($postdata);
        if ($s_id_map) {
            $map['shop_id'] = $s_id_map;
        } else {
            $map['shop_id'] = array('gt', 0);
        }
        $map['is_group'] = 0;
        $map['is_limit_time'] = 0;
        $list = $this->lists('PromotAct', $map, 'id desc');
        $this->assign('list', $list);
        $this->display();
    }

    public function group_index()
    {
        $keyword = I('keyword');
        if (is_numeric($keyword)) {
            $map['id|act_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if ($keyword) {
            $map['act_name'] = array('like', '%' . (string)$keyword . '%');
        }
        $map['is_pt'] = 1;
        $map['is_limit_time'] = 0;
        $map['is_group'] = 0;
        $map['is_presale'] = 0;
        $list = $this->lists('PromotAct', $map, 'id desc');
        $this->assign('list', $list);
        $this->display();
    }
    
    public function pre_sale()
    {
        $keyword = I('keyword');
        if (is_numeric($keyword)) {
            $map['id|act_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if ($keyword) {
            $map['act_name'] = array('like', '%' . (string)$keyword . '%');
        }
        $map['is_presale'] = 1;
        $map['is_limit_time'] = 0;
        $map['is_group'] = 0;
        $map['is_pt'] = 0;
        $list = $this->lists('PromotAct', $map, 'id desc');
        $this->assign('list', $list);
        $this->display();
    }
    public function add_pre_sale(){
        $id = I('id');
        if ($id) {
            $info = M('PromotAct')->field(true)->find($id);
            $list = M('Goods')->where('pre_id=' . $id)->field('id,goods_name')->find();
            $remark = M('PromotExt')->where('act_id='.$id)->getField('remarks');
            $remarks = unserialize($remark);
            $style = M('PromotExt')->where('act_id='.$id)->getField('style');
            $this->assign('list', $list);
            $this->assign('remarks', $remarks);
            $this->assign('style', $style);
            $this->assign($info);
        }
        $this->display();
    }

    
    public function ajaxgetshopgoods()
    {
        $keyword = I('keyword');
        $shop_id = I('shop_id');
        $is_pt = I('is_pt');
        $is_presale = I('is_presale');
        $map = array();
        if($is_pt == 1 || $is_presale==1){
            $map['pt_id']=0;
            $map['pre_id']=0;
        }
        $map['shop_id'] = $shop_id;
        $map['is_delete'] = 0;
        $map['is_promot'] = 0;
        $map['publish_wait'] = 1;
        if (trim($keyword) != '') $map['goods_name'] = array('like', '%' . $keyword . '%');
        $list_goods = M("Goods")->field('goods_name,id,shop_price')->where($map)->select();
        $data_goods = "<option value=''>请选择商品</option>";
        foreach ($list_goods as $val_goods) {
            $data_goods .= '<option value="' . $val_goods['id'] . '" data="' . $val_goods['shop_price'] . '">' . $val_goods['goods_name'] . '</option>';
        }
        $result['list'] = $data_goods;
        $this->ajaxReturn($result);
    }

    public function limit_time()
    {
        $keyword = I('keyword');
        if (is_numeric($keyword)) {
            $map['id|act_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if ($keyword) {
            $map['act_name'] = array('like', '%' . (string)$keyword . '%');
        }
        $map['is_group'] = 0;
        $map['is_limit_time'] = 1;
        $map['shop_id'] = 0;
        $list = $this->lists('PromotAct', $map, 'id desc');
        $this->assign('list', $list);
        $this->display();
    }

    
    public function limit_time_shop()
    {
        $keyword = I('keyword');
        $postdata = I('post.');
        if (is_numeric($keyword)) {
            $map['id|act_name'] = array(intval($keyword), array('like', '%' . $keyword . '%'), '_multi' => true);
        } else if ($keyword) {
            $map['act_name'] = array('like', '%' . (string)$keyword . '%');
        }
        $s_id_map=$this->get_shop_ids($postdata);
        if ($s_id_map) {
            $map['shop_id'] = $s_id_map;
        } else {
            $map['shop_id'] = array('gt', 0);
        }
        $map['is_group'] = 0;
        $map['is_limit_time'] = 1;
        $list = $this->lists('PromotAct', $map, 'id desc');
        $this->assign('list', $list);
        $this->display();
    }
    private function get_shop_ids($postdata){
        $s_id_map='';
        if (isset($postdata['shops_keyword'])) {
            if(!empty($postdata['shops_keyword'])) {
                $shop_ids = array();
                if (is_numeric($postdata['shops_keyword'])) {
                    $shop_map['id|name'] = array(intval($postdata['shops_keyword']), array('like', '%' . $postdata['shops_keyword'] . '%'), '_multi' => true);
                } else if (!empty($postdata['shops_keyword'])) {
                    $shop_map['name'] = array('like', '%' . (string)$postdata['shops_keyword'] . '%');
                }
                $shops = M('Shops')->field('id')->where($shop_map)->select();
                foreach ($shops as $k => $v) {
                    $shop_ids[$k] = $v['id'];
                }
                if (empty($shop_ids)) {
                    $s_id_map = array('lt', 0);
                } else {
                    $s_id_map = array('in', $shop_ids);
                }
            }else{
                $s_id_map = array('gt', 0);
            }
        } else {
            $s_id_map = 0;
        }
        return $s_id_map;
    }

    public function add_limit_time()
    {
        $id = I('id');
        if ($id) {
            $info = M('PromotAct')->field(true)->find($id);
            $list = M('Goods')->where('promote_id=' . $id)->field('id,goods_name,shop_price,promote_price')->select();
            $this->assign('list', $list);
            $this->assign($info);
        }
        $this->display();
    }

    public function delete_promote()
    {
        $id = I('id');
        $return = array();
        $map = array();
        $map['id'] = $id;
        $data = array();
        $data['promote_id'] = 0;
        $data['promote_price'] = 0;
        $data['promote_start_time'] = 0;
        $data['promote_end_time'] = 0;
        M("Goods")->where($map)->save($data);
        $return['status'] = 1;
        $this->ajaxReturn($return);
    }

    public function edit()
    {
        $id = I('id');
        if ($id) {
            $info = M('PromotAct')->field(true)->find($id);
            $list = M('PromotExt')->where('act_id=' . $id)->select();
            $rang_list = '';
            $goods_list = "<option value=''>请选择商品</option>";
            foreach ($list as $k => $v) {
                if ($info['is_group'] == 0) {
                    if ($v['style'] == 1) {
                        $rang_list .= "<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='" . $v['style_ext_id'] . "' />" . idtoname($v['style_ext_id'], 'GoodsCategory', 'name', 'id', false) . "</label>&nbsp;&nbsp;";
                    } elseif ($v['style'] == 2) {
                        $rang_list .= "<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='" . $v['style_ext_id'] . "' />" . idtoname($v['style_ext_id'], 'Brand', 'brand_name', 'id', false) . "</label>&nbsp;&nbsp;";
                    } elseif ($v['style'] == 3 || $v['style'] == 4) {
                        $rang_list .= "<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='" . $v['style_ext_id'] . "' />" . idtoname($v['style_ext_id'], 'Goods', 'goods_name', 'id', false) . "</label>&nbsp;&nbsp;";
                        $remarks = unserialize($v['remarks']);
                    }
                } else {
                    $goods_id = $v['style_ext_id'];
                    $goods_list = "<option value='" . $v['style_ext_id'] . "'>" . idtoname($v['style_ext_id'], 'Goods', 'goods_name', 'id', false) . "</option>";
                }
            }
            if ($list) {
                if ($list[0]['style'] == 1) {
                    $this->getcateTree($list[0]['style_ext_id']);
                } elseif ($list[0]['style'] == 2) {
                    $this->getcateTree();
                    $info['brand_id'] = $list[0]['style_ext_id'];
                } else {
                    $this->getcateTree();
                }
                $info['act_rang'] = $list[0]['style'];
                $info['remarks'] = $remarks;
            } else {
                $info['act_rang'] = 0;
                $this->getcateTree();
            }
            
            $this->assign('act_rang_ext', $goods_id);
            
            $this->assign($info);
            $this->assign('goods_list', $goods_list);
            $this->assign('range_list', $rang_list);
            $this->assign('id', $id);
        }

        $this->display();
    }

    public function _before_add()
    {
        
        $info['is_pt'] = I('is_pt');
        $goods_list = "<option value=''>请选择商品</option>";
        $this->assign('goods_list', $goods_list);
        $this->assign($info);
        $this->getcateTree();
    }

    
    public function insert()
    {
        $model = M(CONTROLLER_NAME);
        $post = I('post.');
        
        if ($post['is_group']) {
            
        } else {
            $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/index');
        }
        if (empty($post['promot_price']) && $post['is_limit_time'] == 1) {
            $this->error('请选择促销的商品', $jumpUrl);
        }
        if (empty($post['big_img'])) {
            $this->error('请选择活动页大图', $jumpUrl);
        }
        if ($post) {
            $data['act_name'] = $post['act_name'];
            $data['img'] = $post['img'];
            $data['big_img'] = $post['big_img'];
            $data['start_time'] = strtotime($post['start_time']);
            $data['end_time'] = strtotime($post['end_time']);
            $data['min_amount'] = $post['min_amount'];
            $data['max_amount'] = $post['max_amount'];
            $data['act_type'] = $post['act_type'];
            $data['is_addup'] = $post['is_addup'];
            $data['is_group'] = $post['is_group'];
            $data['is_pt'] = $post['is_pt'];
            $data['is_presale'] = $post['is_presale'];
            $data['is_limit_time'] = $post['is_limit_time'];
            $data['act_type_ext'] = $post['act_type_ext'];
            $data['group_number'] = $post['group_number'];
            $data['group_time_limit'] = $post['group_time_limit'];
            $data['buy_limit'] = $post['buy_limit'];
            $data['head_commission_rate'] = $post['head_commission_rate'];
            
            $res = M('PromotAct')->add($data);
            if (is_array($post['act_rang_ext'])) {
                foreach ($post['act_rang_ext'] as $k => $v) {
                    $add['act_id'] = $res;
                    $add['style'] = $post['act_range'];
                    $add['style_ext_id'] = $v;
                    M('PromotExt')->add($add);
                }
                $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/index');
            }else {
                if ($post['is_pt']) {
                    
                        $re_array = array();
                        $add['act_id'] = $res;
                        $add['style'] = $post['act_range'];
                        $add['style_ext_id'] = $post['act_rang_ext'];
                        
                        $add['remarks'] = serialize($post['remarks']);
                        M('PromotExt')->add($add);
                        $goods['id'] = $post['act_rang_ext'];
                        $change['pt_id'] = $res;
                        M('Goods')->where($goods)->save($change);
                    
                    $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/group_index');
                }
                if($post['is_presale']) {
                    $add['act_id'] = $res;
                    $add['style'] = $post['act_range'];
                    $add['style_ext_id'] = $post['act_rang_ext'];
                    $price['group_price'] = $post['remarks'];
                    $price['pre_money'] = $post['pre_money'];
                    $add['remarks'] = serialize($price);
       
                    M('PromotExt')->add($add);
                    $goods['id'] = $post['act_rang_ext'];
                    $change['pre_id'] = $res;
                    M('Goods')->where($goods)->save($change);
                    $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/pre_sale');
                }
                if ($post['is_limit_time']) {
                    foreach ($post['promot_price'] as $k => $v) {
                        $re_array = array();
                        $add['act_id'] = $res;
                        $add['style'] = $post['act_range'];
                        $add['style_ext_id'] = $post['act_rang_ext'];
                        $re_array['promot_price'][$k] = $v;
                        $add['remarks'] = serialize($re_array);
                        M('PromotExt')->add($add);
                    }
                    $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/limit_time');
                }
            }
            $msg = array_merge(array('success' => L('ADD_OK'), 'error' => L('ADD_ERROR'), 'url' => $jumpUrl, 'ajax' => IS_AJAX), (array)$msg);
            if ($res !== false) {
                if (in_array(CONTROLLER_NAME, $this->cache_model)) {
                    savecache(CONTROLLER_NAME);
                }
                $this->success($msg['success'], $msg['url'], $msg['ajax']);
            } else {
                $this->error($msg['error'], $msg['url'], $msg['ajax']);
            }
        }
    }

    
    public function update()
    {
        $model = M(CONTROLLER_NAME);
        $post = I('post.');
        if (empty($post['promot_price']) && $post['is_limit_time'] == 1) {
            $this->error('请选择促销的商品');
        }
        if (empty($post['big_img'])) {
            $this->error('请选择活动页大图');
        }
        $where_ext['act_id'] = $post['id'];
        if($post['is_pt'] == 1){
            $goodsids = M('PromotExt')->where($where_ext)->getField('style_ext_id');
            $save['pt_id'] = 0;
            $update = M('Goods')->where('id='.$goodsids)->save($save);
        }
        if($post['is_presale'] == 1){
            $goodsids = M('PromotExt')->where($where_ext)->getField('style_ext_id');
            $save['pre_id'] = 0;
            $update = M('Goods')->where('id='.$goodsids)->save($save);
        }
        M('PromotExt')->where($where_ext)->delete();
        $id = I('id');
        $data['act_name'] = $post['act_name'];
        $data['img'] = $post['img'];
        $data['big_img'] = $post['big_img'];
        $data['start_time'] = strtotime($post['start_time']);
        $data['end_time'] = strtotime($post['end_time']);
        $data['min_amount'] = $post['min_amount'];
        $data['max_amount'] = $post['max_amount'];
        $data['act_type'] = $post['act_type'];
        $data['is_addup'] = $post['is_addup'];
        $data['act_type_ext'] = $post['act_type_ext'];
        $data['is_group'] = $post['is_group'];
        $data['is_pt'] = $post['is_pt'];
        $data['is_presale'] = $post['is_presale'];
        $data['group_number'] = $post['group_number'];
        $data['group_time_limit'] = $post['group_time_limit'];
        $data['buy_limit'] = $post['buy_limit'];
        $data['head_commission_rate'] = $post['head_commission_rate'];
        $where['shop_id'] = $post['shop_id'];
        $where['id'] = $id;
        $res = M('PromotAct')->where($where)->save($data);
        if (is_array($post['act_rang_ext'])) {
            foreach ($post['act_rang_ext'] as $k => $v) {
                $add['act_id'] = $id;
                $add['style'] = $post['act_range'];
                $add['style_ext_id'] = $v;
                M('PromotExt')->add($add);
            }
            $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/index');
        } else {
            if ($post['is_pt']) {
                
                    $re_array = array();
                    $add['act_id'] = $id;
                    $add['style'] = $post['act_range'];
                    $add['style_ext_id'] = $post['act_rang_ext'];
                    
                    $add['remarks'] = serialize($post['remarks']);
                    M('PromotExt')->add($add);
                    $save['pt_id'] = $id;
                    $update = M('Goods')->where('id='.$post['act_rang_ext'])->save($save);
                
                $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/group_index');
            }
            if ($post['is_presale']) {
                $re_array = array();
                $add['act_id'] = $id;
                $add['style'] = $post['act_range'];
                $add['style_ext_id'] = $post['act_rang_ext'];
                $price['group_price'] = $post['remarks'];
                $price['pre_money'] = $post['pre_money'];
                $add['remarks'] = serialize($price);
                M('PromotExt')->add($add);
                $save['pre_id'] = $id;
                $update = M('Goods')->where('id='.$post['act_rang_ext'])->save($save);
                $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/pre_sale');
            }
            if ($post['is_limit_time']) {
                foreach ($post['promot_price'] as $k => $v) {
                    $re_array = array();
                    $add['act_id'] = $id;
                    $add['style'] = $post['act_range'];
                    $add['style_ext_id'] = $post['goods'][$k];
                    $re_array['promot_price'][$k] = $v;
                    $add['remarks'] = serialize($re_array);
                    M('PromotExt')->add($add);
                }
                $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME . '/limit_time');
            }
        }
        $msg = array_merge(array('success' => L('edit_ok'), 'error' => L('edit_error'), 'url' => $jumpUrl, 'ajax' => IS_AJAX), (array)$msg);
        if ($res !== false) {
            if (in_array(CONTROLLER_NAME, $this->cache_model)) {
                savecache(CONTROLLER_NAME);
            }
            $this->success($msg['success'], $msg['url'], $msg['ajax']);
        } else {
            $this->error($msg['error'], $msg['url'], $msg['ajax']);
        }
    }
	
    public function insert_limit_time(){
        $postdata = I('param.');
        $result = D('Common/Promot')->add_update($postdata);
        if ($result['status'] == 1) {
            $this->success($result['info'],U('PromotAct/limit_time'));
        }else{
			$this->error($result['info']);
		}
    }

    
    public function ajaxgetgoods()
    {
        $keyword = I('keyword');
        $map = array();
        $map['shop_id'] = 0;
        $map['is_delete'] = 0;
        $map['publish_wait'] = 1;
        if (trim($keyword) != '') $map['goods_name'] = array('like', '%' . $keyword . '%');
        $list_goods = M("Goods")->field('goods_name,id,shop_price')->where($map)->select();
        $data_goods = "<option value=''>请选择商品</option>";
        foreach ($list_goods as $val_goods) {
            $data_goods .= '<option value="' . $val_goods['id'] . '" data="' . $val_goods['shop_price'] . '">' . $val_goods['goods_name'] . '</option>';
        }
        $result['list'] = $data_goods;
        $this->ajaxReturn($result);
    }

    private function getcateTree($pid = '', $assign = '')
    {
        $GoodsCategory = getcache('GoodsCategory');
        $Tree = new \Common\Vendor\Tree();
        $select_categorys = '';
        $treemini = $Tree->treemini($GoodsCategory);
        $select_categorys .= $Tree->treeminioption($treemini, $pid);
        if ($assign) return $select_categorys;
        else $this->assign('select_categorys', $select_categorys);
        $wh['status'] = 1;
        $brand = M('Brand')->where($wh)->field('id,brand_name')->select();
        $this->assign('brand_list', $brand);

    }

    
    public function get_goods_attr_stock()
    {
        $post = I('param.');
        if (!isset($post['goods_id'])) return true;
        $model = M('GoodsAttrStock');
        $where['goods_id'] = $post['goods_id'];
        $check = $model->where($where)->count();
        $is_edit = false;
        if (isset($post['act_id'])) {
            $is_edit = true;
            $get_goods_edit_val = $this->get_goods_edit_val($post['act_id']);
        }
        if ($check > 0) {
            $list = $model->alias('gas')->where($where)->JOIN('LEFT JOIN __GOODS__ g ON gas.goods_id=g.id')->field('gas.*,g.shop_price')->select();
            foreach ($list as $k => $v) {
                $val = $this->get_goods_attr_stock_val($v['attr_key']);
                $listformat[$k]['id'] = $v['id'];
                $listformat[$k]['name'] = $val['name'];
                $listformat[$k]['price'] = $val['price'] + $v['shop_price'];
                $listformat[$k]['stock_cfg'] = $v['stock_cfg'];
                if ($is_edit) $listformat[$k]['group_price'] = $get_goods_edit_val[$v['id']];
            }
        } else {
            $list = M('Goods')->where('id=' . $post['goods_id'])->field('goods_name,shop_price,goods_number,id')->find();
            $listformat[0]['id'] = $list['id'];
            $listformat[0]['name'] = $list['goods_name'];
            $listformat[0]['price'] = $list['shop_price'];
            $listformat[0]['stock_cfg'] = $list['goods_number'];
            if ($is_edit) $listformat[0]['group_price'] = $get_goods_edit_val[$list['id']];
        }
        $result['list'] = $listformat;
        $this->assign($result);
        $this->display('goods_group_attr_val');
    }

    
    public function get_goods_attr_stock_val($attr_key = '', $type = '')
    {
        $attr_key_array = explode('_', $attr_key);
        $model = M('GoodsAttr');
        $where['g.id'] = array('in', $attr_key_array);
        $price = $name = '';
        if (count($attr_key_array) > 0) {
            $list = $model->alias('g')->where($where)->JOIN('LEFT JOIN __GOODS_ATTRIBUTE__ ga ON g.attr_id=ga.id')->field('g.attr_price,g.attr_value,ga.options')->select();
            foreach ($list as $k => $v) {
                $price += $v['attr_price'];
                $options = strtoarray($v['options']);
                $name .= $options[$v['attr_value']] . " ";
            }
        }
        $result['price'] = $price;
        $result['name'] = $name;
        return $result;
    }

    
    public function get_goods_edit_val($act_id)
    {
        $model = M('PromotExt');
        $where['act_id'] = $act_id;
        $where['style'] = 4;
        $list = $model->where($where)->field('style_ext_id,remarks')->select();
        $arr = array();
        foreach ($list as $k => $v) {
            $arr = unserialize($v['remarks']);
            foreach ($arr['group_price'] as $key => $val) {
                $listformat[$key] = $val;
            }
        }
        return $listformat;
    }

    
    public function get_goods_edit_price($act_id)
    {
        $model = M('PromotExt');
        $where['act_id'] = $act_id;
        $where['style'] = 5;
        $list = $model->where($where)->field('style_ext_id,remarks')->select();
        $arr = array();
        foreach ($list as $k => $v) {
            $arr = unserialize($v['remarks']);
            foreach ($arr['promot_price'] as $key => $val) {
                $listformat[$key] = $val;
            }
        }
        return $listformat;
    }

    
    public function get_goods_info()
    {
        $get = I('get.');
        $array_id = array();
        if ($get['ides'] || $get['str_goods']) {
            $str_goods = $get['str_goods'] ? $get['str_goods'] : $get['ides'];
            $array_id = explode(',', $str_goods);
        }
        $is_edit = false;
        if (isset($get['act_id'])) {
            $is_edit = true;
            $get_goods_edit_price = $this->get_goods_edit_price($get['act_id']);
        }
        if ($get['goods_id']) {
            array_push($array_id, $get['goods_id']);
        }
        foreach ($array_id as $k => $v) {
            $info = idtoname($v, 'Goods', 'id,goods_name,shop_price', 'id', false);
            $listformat[$k] = $info;
            if ($is_edit) $listformat[$k]['promot_price'] = $get_goods_edit_price[$v];
        }
        $ids = implode(',', $array_id);
        $result['list'] = $listformat;
        $this->assign($result);
        $this->assign('ids', $ids);
        $this->display('goods_limit_time_info');
    }

    public function _before_delete()
    {
        $id = I('id');
        if (isset($id) && is_array($id)) {
            foreach ($id as $k => $v) {
                $result = check_delete($v, 8);
                if (!$result['status']) unset($id[$k]);
            }
            if (empty($id)) {
                $this->error($result['info']);
                exit;
            }
        } else {
            $result = check_delete($id, 8);
            if (!$result['status']) {
                $this->error($result['info']);
                exit;
            }
        }
        $this->id = $id;
    }

    public function view(){
        $id = I('get.id');
        
        $map['pid'] = 0;
        $map['pt_id'] = $id;
        $map['pay_status'] = 3;
        $sum_num = idtoname($id,'PromotAct','group_number');
        $list = $this->lists('OrderInfo', $map, 'id desc');
        if(!empty($list)){
            foreach ($list as $key => $value) {
                $where['pid'] = $value['id'];
                $where['status'] = 2;
                $where['pay_status'] = 3;
                $where['confirm_time'] = array('neq',0);
                $count = M('OrderInfo')->where($where)->count();
                $list[$key]['number'] = $count;
            }
        }
        $this->assign('list',$list);
        $this->display();
    }

    public function view_son(){
        $id = I('get.id');
        $team_mes = M('OrderInfo')->where('id='.$id)->find();
        $where['pid'] = $id;
        $where['status'] = 2;
        $where['pay_status'] = 3;
        $where['confirm_time'] = array('neq',0);
        $list = $this->lists('OrderInfo', $where, 'id desc');
        $this->assign('list',$list);
        $this->assign('team_mes',$team_mes);
        $this->display();
    }

    public function view_presale(){
        $id = I('get.id');
        $where['act_id'] = $id;
        $style = M('PromotExt')->where($where)->getField('style');
        
        $map['pt_id'] = array('eq',$id);
        $map['is_delete'] = 0;
        $map['status'] = array('neq',4);
        $map['type'] = array('eq',7);
        $map['pay_status'] = array('neq',1);
        $list = $this->lists('OrderInfo', $map, 'id desc');
        if(!empty($list)){
            foreach ($list as $key => $value) {
                $maps['order_id'] = $value['id'];
                $list[$key]['goods_number'] = M('OrderGoods')->where($maps)->getField('goods_number');
            }
        }
        
        
        
        
        $this->assign('list',$list);
        $this->assign('style',$style);
        $this->assign('no_all_pay',$no_all_pay);
        $this->assign('all_pay',$all_pay);
        $this->display();
    }

}
?>