<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
class ShippingFeeController extends BaseController
{
    public function index()
    {
        $map['shop_id'] = 0;
        $list = $this->lists('ShippingFee', $map, 'id desc');
        foreach ($list as $key => $val) {
            $area_region = explode(',', $val['area_region']);
            $list[$key]['region'] = $area_region;
        }
        $this->assign('list', $list);
        $this->display();
    }

    public function shop_list()
    {
        $map['shop_id'] = I('shopsid');
        $list = $this->lists('ShippingFee', $map, 'id desc');
        foreach ($list as $key => $val) {
            $area_region = !empty($val['area_region']) ? explode(',', $val['area_region']) : '';
            $list[$key]['region'] = $area_region;
        }
        $this->assign('list', $list);
        $this->assign('id', I('shopsid'));
        $this->display();
    }

    public function insert()
    {
        $post = I('post.');
        if(empty($post['regions'])){
            $this->error("配送区域不得为空");
        }
        if ($post) {
            $data['name'] = $post['name'];
            if ($post['type'] == 1) {
                $info_ship['type'] = $post['type'];
                $info_ship['money'] = $post['money'];
                $info_ship['first_weight'] = $post['first_weight'];
                $info_ship['first_weight_money'] = $post['first_weight_money'];
                $info_ship['x_weight'] = $post['x_weight_1'];
                $info_ship['x_weight_money'] = $post['x_weight_money_1'];
            } else {
                $info_ship['type'] = $post['type'];
                $info_ship['money'] = $post['money'];
                $info_ship['per_money'] = $post['per_money'];
                $info_ship['x_weight'] = $post['x_weight_2'];
                $info_ship['x_weight_money'] = $post['x_weight_money_2'];
            }
            $regions = implode(',', $post['regions']);
            $data['configure'] = serialize($info_ship);
            $data['area_region'] = $regions;
            $data['shipping_id'] = $post['shipping_id'];
            $info = M('ShippingFee')->add($data);
            S("shop_shipping_fee_catch",'');
            if ($info) {
                $url = U(CONTROLLER_NAME . '/index');
                $this->success(L('ADD_OK'), $url);
            } else {
                $this->error(L('ADD_ERROR'));
            }
        } else {
            $this->error('参数错误', U('ShippingfeeShop/index'));
        }
    }

    public function edit()
    {
        $id = I('id');
        $post = I('post.');
        if ($post) {
            if(empty($post['regions'])){
                $this->error("配送区域不得为空");
            }
            $data['name'] = $post['name'];
            if ($post['type'] == 1) {
                $info_ship['type'] = $post['type'];
                $info_ship['money'] = $post['money'];
                $info_ship['first_weight'] = $post['first_weight'];
                $info_ship['first_weight_money'] = $post['first_weight_money'];
                $info_ship['x_weight'] = $post['x_weight_1'];
                $info_ship['x_weight_money'] = $post['x_weight_money_1'];
            } else {
                $info_ship['type'] = $post['type'];
                $info_ship['money'] = $post['money'];
                $info_ship['per_money'] = $post['per_money'];
                $info_ship['x_weight'] = $post['x_weight_2'];
                $info_ship['x_weight_money'] = $post['x_weight_money_2'];
            }
            $regions = implode(',', $post['regions']);
            $data['configure'] = serialize($info_ship);
            $data['area_region'] = $regions;
            $map['id'] = $post['id'];
            $info = M('ShippingFee')->where($map)->save($data);
            S("shop_shipping_fee_catch",'');
            if ($info) {
                $url = U(CONTROLLER_NAME . '/index');
                $this->success(L('DO_OK'), $url);
            } else {
                $this->error(L('DO_ERROR'));
            }
        } else {
            $map['id'] = $id;
            $info = M('ShippingFee')->where($map)->find();
            if (empty($info)) $info['type'] = 1;
            $areas = unserialize($info['configure']);
            $region = explode(',', $info['area_region']);
            $this->assign('region', $region);
            $this->assign($areas);
            $this->assign($info);
            $this->assign('id', $id);
            $this->display();
        }
    }
}