<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
 
namespace Admin\Controller;
class ShopsController extends BaseController
{
    
    public function index()
    {
        $keyword = I('keyword');
        $map = array();
        if ($keyword) {
            $whereor['id'] = array('like', '%' . $keyword . '%');
            $whereor['name'] = array('like', '%' . $keyword . '%');
            $whereor['_logic'] = 'or';
            $map['_complex'] = $whereor;
        }
        $list = $this->lists('Shops', $map);
        $this->assign('list', $list);
        $this->display();
    }

    
    public function add()
    {
        if (IS_POST) {
            $mod = M("Shops");
            $postdata = I('post.');
            $this->check_post($postdata, 0);
            $postdata = $this->format_post($postdata);
            $mod->create($postdata);
            $result = $mod->add();
            if ($result) {
                $postdata['shops_id']=$postdata['id'];
                $postdata['publish_wait']=1;
                unset($postdata['id']);
                M("ShopsSubmit")->data($postdata)->add();
				
				$u_map['id']=$postdata['uid'];
				$u_data['shop_id']=$result;
				M('Member')->where($u_map)->save($u_data);
                $this->success(L('DO_OK'), '', '', 'add');
            } else {
                $this->error(L('DO_ERROR'));
            }
            unset($postdata);
        } else {
            $this->display('edit');
        }
    }

    
    public function edit()
    {
        $id = I('id');
        $model = M("Shops");
        if (IS_POST) {
            $postdata = I('post.');
            $postdata['point']=$postdata['x'].','.$postdata['y'];
            $this->check_post($postdata, $id);
            $postdata = $this->format_post($postdata);
            $shops = $model->create($postdata);
            if (false === $shops) {
                $this->error($model->getError());
            }
            $map['id'] = $id;
            $result = $model->save($shops);
            if (false !== $result) {
                $postdata['shops_id']=$postdata['id'];
                $postdata['publish_wait']=1;
                unset($postdata['id']);
                $ss_map['shops_id']=$postdata['shops_id'];
                M("ShopsSubmit")->where($ss_map)->data($postdata)->save();
                $this->success(L('DO_OK'), '', '', 'edit');
            } else {
                $this->error(L('DO_ERROR'));
            }
            unset($postdata);
        } else {
            if (isset($id)) {
                $id = isset($id) && intval($id) ? intval($id) : $this->error('参数错误');
            }
            if (!$id) $this->error('参数错误');
            $info = $model->field(true)->find($id);
            $info['point']=explode(',',$info['point']);
            $info['x']=$info['point'][0];
            $info['y']=$info['point'][1];
            $this->getlabels($id);
            $uids = array();
            $uids[$info['uid']] = idtoname($info['uid'], 'Member', 'username');
            $this->assign('uids', $uids);
            $map['id'] = $info['uid'];
            $info['user_mobile'] = M('Member')->where($map)->getField('mobile');
            $this->assign($info);
            $this->assign('id', $id);
            $this->getranks();
            $this->display();
        }
    }

    
    public function check_is_uid($uid)
    {
        $mod = M('Member');
        $map['uid'] = $uid;
        $uid = $mod->where($map)->count();
        return $uid;
    }

    
    public function check_uid($uid, $id)
    {
        $map['uid'] = $uid;
        $shop_id = M('Shops')->where($map)->getField('id');
        if (empty($shop_id) || (!empty($shop_id) && $shop_id == $id)) return false;
        return true;
    }

    
    public function check_post($postdata = array(), $id = 0)
    {
        if (empty($postdata)) $this->error("非法数据");
        if ($postdata['name'] == '') $this->error("店铺名称不得为空");
        if ($postdata['uid'] == '') $this->error("会员不得为空");
        if ($postdata['contacts'] == '') $this->error("联系人不得为空");
        if ($postdata['phone'] == '') $this->error("联系电话不得为空");
        if ($this->check_uid($postdata['uid'], $id) == true) $this->error("该会员已绑定店铺");
        if ($this->check_is_uid($postdata['uid']) <= 0) $this->error("该会员不存在");
    }

    
    public function format_post($postdata = array())
    {
        $postdata['end_time'] = strtotime($postdata['end_time']);
        return $postdata;
    }

    
    public function searchuser()
    {
        $like = I('get.like');
        if ($like) {
            $whereor['mobile'] = $like;
            $map['_complex'] = $whereor;
            $list = M('Member')->where($map)->field('id,username,status')->select();
            $result = "<option>请选择该会员</option>";
            foreach ($list as $k => $v) {
                if ($v['status'] == 1) {
                    $result .= "<option value='" . $v['id'] . "'>" . $v['username'] . "</option>";
                }
            }
        }
        echo $result;
        exit;
    }

    
    public function getranks()
    {
        $where['type'] = 2;
        $rank = M('ProjectLabel')->field('id,label_name')->where($where)->select();
        $ranks = array();
        foreach ($rank as $value) {
            $ranks[$value['id']] = $value['label_name'];
        }
        $this->assign('ranks', $ranks);
    }

    
    public function getlabels($id = '')
    {
        if (!empty($id)) {
            $where['pll.shop_id'] = $id;
            $where['pll.publish_wait'] = 1;
            $where['pl.type'] = 1;
            $label = M('ProjectLabelLink')->alias('pll')->JOIN('LEFT JOIN __PROJECT_LABEL__ pl on pll.label_id = pl.id')->field('pll.label_id,pll.deposit')->where($where)->select();
            if (!empty($label)) {
                $labels = '';
                foreach ($label as $v) {
                    $labels .= idtoname($v['label_id'], 'ProjectLabel', 'label_name') . '(保证金' . $v['deposit'] . ')' . '&nbsp;&nbsp;&nbsp;&nbsp;';
                }
                $this->assign('labels', $labels);
            }
        }
    }
    
    public function collect_shops()
    {
        $map['status']=1;
        $list = $this->lists('ShopsCollect', $map);
        $this->assign('list', $list);
        $this->display();
    }
	public function _before_delete(){
		$id=I('id');
		if(isset($id)&&is_array($id)){
			foreach($id as $k=>$v){
				$result=check_delete($v,2);
				if(!$result['status'])unset($id[$k]);
			}
			if(empty($id)){$this->error($result['info']);exit;}
		}else{
			$result=check_delete($id,2);
			if(!$result['status']){$this->error($result['info']);exit;}
		}
		$this->id=$id;
	}
}
?>