<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
class ShopsPowerController extends BaseController
{
    
    public function applylist(){
        $postdata=I('param.');$this->assign($postdata);
        $where=$this->getcondition($postdata);
        $info=array();
        if(!empty($where)) {
            $where['publish_wait'] = array('in', '0,1,2');
            $info = $this->lists('ProjectLabelLink', $where, 'publish_wait');
        }
        $this->assign('info',$info);
        $this->display();
    }

    
    public function quitlist(){
        $postdata=I('param.');$this->assign($postdata);
        $where=$this->getcondition($postdata);
        $info=array();
        if(!empty($where)) {
            $where['publish_wait'] = array('in', '3,4,5');
            $info = $this->lists('ProjectLabelLink', $where, 'publish_wait');
        }
        $this->assign('info',$info);
        $this->display();
    }

    
    public function contractlist(){
        $postdata=I('param.');$this->assign($postdata);
        $where=$this->getcondition($postdata);
        $info=array();
        if(!empty($where)) {
            $where['publish_wait'] = array('in', '1,4');
            $info = $this->lists('ProjectLabelLink', $where, 'publish_wait');
        }
        $this->assign('info',$info);
        $this->display();
    }

    
    public function getcondition($postdata)
    {
        $where = array();
        $plmap['type']=3;
        $label_id=M('ProjectLabel')->where($plmap)->getField('id',true);
        if(empty($label_id))return $where;
        $where['label_id']=array('in',$label_id);
        if (!empty($postdata['apply_from'])) $where['apply_time'][] = array('EGT', strtotime($postdata['apply_from']));
        if (!empty($postdata['apply_to'])) $where['apply_time'][] = array('elt', strtotime($postdata['apply_to']));
        if (!empty($postdata['update_from'])) $where['update_time'][] = array('EGT', strtotime($postdata['update_from']));
        if (!empty($postdata['update_to'])) $where['update_time'][] = array('elt', strtotime($postdata['update_to']));
        if (!empty($postdata['keyword'])) {
            $keyword = $postdata['keyword'];
            $where['shop_id'][] = array('like', '%' . $keyword . '%');
            $memberwhereor['username'] = array('like', '%' . $keyword . '%');
            $memberwhereor['mobile'] = array('like', '%' . $keyword . '%');
            $memberwhere['_complex'] = $memberwhereor;
            $memberwhere['status'] = 1;
            $userid = M('Member')->where($memberwhere)->getField('id', true);
            if (!empty($userid)) {
                $shopwhere['uid'] = array('in', $userid);
                $shopid = M('Shops')->where($shopwhere)->getField('id', true);
                if (!empty($shopid)) $where['shop_id'][] = array('in', $shopid);
            }
            $where['shop_id'][] = 'or';
        } else {
            $where['shop_id'] = array('neq', 0);
        }
        $where['goods_id']=0;
        return $where;
    }

    
    public function audit()
    {
        $name = 'ProjectLabelLink';$type = 4;  
        $content = '';$audit = I('get.audit');    
        $postdata = I('post.');$id=I('get.id');
        if (!empty($id)) $postdata['id'][]=$id;
        if (empty($postdata['id'])) $this->error('请选择要审核的项！');
        $save=array();$save['publish_wait'] = $audit;
        
        if ($audit == 1) $save['update_time'] = NOW_TIME;
        foreach ($postdata['id'] as $key => $value) {
            $label_info=idtoname($value,$name,'label_id,shop_id,deposit');
            $label_name=idtoname($label_info['label_id'],'ProjectLabel','label_name');
            $map=array();$map['id'] = $value;
            $g_info = M($name)->where($map)->save($save);
            if ($g_info>0) {
                if ($audit == 1){
                    $content = $label_name.'权限加入申请通过';
                    shop_balance_log($label_info['shop_id'], $label_info['deposit'], 5, 4, $label_name.'权限加入申请通过，待扣服务费增加'.$label_info['deposit'].'元');
                    $send_data['to']=idtoname($label_info['shop_id'],'Shops','uid');
                    $send_data['from']='admin(系统)';
                    $send_data['type']=2;
                    $send_data['content']='您店铺申请加入的('.$label_name.')权限已审核通过！';
                    send_method(3,$send_data);
                } else if ($audit == 2){
                    $content = $label_name.'权限加入申请不通过';
                    $send_data['to']=idtoname($label_info['shop_id'],'Shops','uid');
                    $send_data['from']='admin(系统)';
                    $send_data['type']=2;
                    $send_data['content']='您店铺申请加入的('.$label_name.')权限审核未通过！';
                    send_method(3,$send_data);
                }
                add_audit_log($value, $type, $audit, $content);
            }
        }
        if ($g_info>0) {
            $this->success('审核成功！');
        } else {
            $this->error('审核失败！');
        }
    }

    
    public function powerlist(){
        $type = 3;
        $where['type']=$type;
        $info = M('ProjectLabel')->where($where)->select();
        $this->assign('type', $type);
        $this->assign('list', $info);
        $this->display();
    }
    
    public function add()
    {
        $this->display('edit');
    }

    
    public function edit()
    {
        $id = I('get.id');
        $this->assign('id', $id);
        $info = M('ProjectLabel')->find($id);
        $this->assign($info);
        $this->display();
    }

    
    public function insert()
    {
        $model = D('ProjectLabel');
        if (false === $model->create()) {
            $this->error($model->getError());
        }
        $id = $model->add();
        $jumpUrl = U('ShopsPower/powerlist');
        if ($id !== false) {
            $this->success(L('ADD_OK'), $jumpUrl);
        } else {
            $this->error(L('ADD_ERROR'));
        }
    }

    
    public function update()
    {
        $model = D('ProjectLabel');
        $postdata = I('post.');
        if (empty($postdata['id'])) {
            $this->error(L('PARAM_ERR'));
        }
        $data = $model->create($postdata);
        $jumpUrl = U('ShopsPower/powerlist');
        $id = $postdata['id'];
        $where = array_merge(array('id' => array('in', $id)), (array)$where);
        if ($model->where($where)->save($data) !== false) {
            $this->success(L('EDIT_OK'), $jumpUrl);
        } else {
            $this->error(L('EDIT_ERROR'), $jumpUrl);
        }
    }
    
    public function delete()
    {
		$id=I('id');
		if(isset($id)&&is_array($id)){
			foreach($id as $k=>$v){
				$result=check_delete($v,9);
				if(!$result['status'])unset($id[$k]);
			}
			if(empty($id)){$this->error($result['info']);exit;}
		}else{
			$result=check_delete($id,9);
			if(!$result['status']){$this->error($result['info']);exit;}
		}
        $name=I('get.model');
        if(empty($name))$name='ProjectLabel';
        $postdata = $id;       
        if (empty($postdata['id']) && !empty($id)) $postdata['id'] = $id;
        if (empty($postdata['id'])) {
            $this->error(L('PARAM_ERR'));
        }
        $map=array();
        $map['id'] = is_array($postdata['id']) || str_exists($postdata['id'],',')?array('in',$postdata['id']):$postdata['id'];
        $deletes = M($name)->where($map)->delete();
        if ($deletes !==false) {
            $this->success(L('DELETE_SUCCESS'));
        } else {
            $this->error(L('DELETE_FAILED'));
        }
    }
}