<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Admin\Controller;
class ShopsRankController extends BaseController
{
    
    public function index()
    {
        $where['type'] = 2;
        $info = $this->lists('ProjectLabel', $where);
        $this->assign('info', $info);
        $this->display();
    }

    
    public function add()
    {
        $this->display('edit');
    }

    
    public function edit()
    {
        $id = I('get.id');
        $this->assign('id', $id);
        $info = M('ProjectLabel')->find($id);
        $this->assign($info);
        $this->display();
    }

    
    public function insert()
    {
        $model = D('ProjectLabel');
        if (false === $model->create()) {
            $this->error($model->getError());
        }
        $id = $model->add();
        $jumpUrl = U('ShopsRank/index');
        if ($id !== false) {
            $this->success(L('ADD_OK'), $jumpUrl);
        } else {
            $this->error(L('ADD_ERROR'));
        }
    }

    
    public function update()
    {
        $model = D('ProjectLabel');
        $postdata = I('post.');
        if (empty($postdata['id'])) {
            $this->error(L('PARAM_ERR'));
        }
        $data = $model->create($postdata);
        $jumpUrl = U('ShopsRank/index');
        $id = $postdata['id'];
        $where = array_merge(array('id' => array('in', $id)), (array)$where);
        if ($model->where($where)->save($data) !== false) {
            $this->success(L('EDIT_OK'), $jumpUrl);
        } else {
            $this->error(L('EDIT_ERROR'), $jumpUrl);
        }
    }
    public function _before_delete(){
		$id=I('id');
		if(isset($id)&&is_array($id)){
			foreach($id as $k=>$v){
				$result=check_delete($v,2,'rank');
				if(!$result['status'])unset($id[$k]);
			}
			if(empty($id)){$this->error($result['info']);exit;}
		}else{
			$result=check_delete($id,2,'rank');
			if(!$result['status']){$this->error($result['info']);exit;}
		}
		$this->id=$id;
	} 
     public function delete(){
        $mod=D('ProjectLabel');
        $id=$this->id?$this->id:I('id');
        if (isset($id) && is_array($id)) {
            $ids = implode(',', $id);
            $result=$mod->delete($ids);
        } else {
            $id = intval($id);
            $result=$mod->delete($id);
        }
        if($result!==false){
          if(in_array(CONTROLLER_NAME,$this->cache_model)){savecache(CONTROLLER_NAME);}
            $this->success(L('DO_OK'));
        }else{$this->error(L('DO_ERROR'));}
    }
}