<?php
namespace Admin\Model;
use Think\Model;
class ActionModel extends Model {
    protected $_validate = array(
        array('name', 'require', '行为标识必须', self::MUST_VALIDATE, 'regex', self::MODEL_BOTH),
        array('name', '/^[a-zA-Z]\w{0,39}$/', '标识不合法', self::MUST_VALIDATE, 'regex', self::MODEL_BOTH),
        array('name', '', '标识已经存在', self::MUST_VALIDATE, 'unique', self::MODEL_BOTH),
        array('title', 'require', '标题不能为空', self::MUST_VALIDATE, 'regex', self::MODEL_BOTH),
        array('title', '1,80', '标题长度不能超过80个字符', self::MUST_VALIDATE, 'length', self::MODEL_BOTH),
        array('remark', 'require', '行为描述不能为空', self::MUST_VALIDATE, 'regex', self::MODEL_BOTH),
        array('remark', '1,140', '行为描述不能超过140个字符', self::MUST_VALIDATE, 'length', self::MODEL_BOTH),
    );
    protected $_auto = array(
        array('status', 1, self::MODEL_INSERT, 'string'),
        array('update_time', 'time', self::MODEL_BOTH, 'function'),
    );
    public function update(){
        $data = $this->create($_POST);
        if(empty($data)){return false;}
        if(empty($data['id'])){ //新增数据
            $id = $this->add(); //添加行为
            if(!$id){$this->error = '新增行为出错！';return false;}
        } else { //更新数据
            $status = $this->save(); //更新基础内容
            if(false === $status){$this->error = '更新行为出错！';return false;}
        }//S('action_list', null);//删除缓存
        return $data;
    }
}