<?php

namespace Admin\Model;
use Think\Model;

class AddonsModel extends Model {
    
    protected function _after_find(&$result,$options) {
    }
    protected function _after_select(&$result,$options){
        foreach($result as &$record){
            $this->_after_find($record,$options);
        }
    }
    
    protected $_auto = array(
        array('create_time', NOW_TIME, self::MODEL_INSERT),
    );
    
    public function getList($addon_dir = ''){ 
        if(!$addon_dir)$addon_dir = HANCHAO_ADDON_PATH;
        $dirs = array_map('basename',glob($addon_dir.'*', GLOB_ONLYDIR));
        if($dirs === FALSE || !file_exists($addon_dir)){
            $this->error = '插件目录不可读或者不存在';
            return FALSE;
        }
       
		$addons			=	array();
        if($dirs){
		    $where['name']	=	array('in',$dirs);   
        }else{
            $where['name']	=	'';
        }
		$list			=	$this->where($where)->field(true)->select();
        foreach($list as $addon){
			$addon['uninstall']		=	0;
			$addons[$addon['name']]	=	$addon;
		}
        foreach ($dirs as $value) {
            if(!isset($addons[$value])){
				$class = get_addon_class($value);
				if(!class_exists($class)){ // 实例化插件失败忽略执行
					\Think\Log::record('插件'.$value.'的入口文件不存在！');
					continue;
				}
                $obj    =   new $class;
				$addons[$value]	= $obj->info;
				if($addons[$value]){
					$addons[$value]['uninstall'] = 1;
                    unset($addons[$value]['status']);
				}
				if(empty($addons[$value]['id']))$addons[$value]['id']='0';
			}
        }
        int_to_string($addons, array('status'=>array(-1=>'损坏', 0=>'禁用', 1=>'启用', null=>'未安装')));
        $addons = list_sort_by($addons,'uninstall','desc');
        return $addons;
    }
    
    public function getAdminList(){
        $admin = array();
        $db_addons = $this->where("status=1 AND has_adminlist=1")->field('id,title,name')->select();
        if($db_addons){
            foreach ($db_addons as $value) {
                $admin[] = array('id'=>$value['id'],'title'=>$value['title'],'url'=>"Addons/adminList?name={$value['name']}");
            }
        }
        return $admin;
    }
}