<?php 
namespace Admin\Model;
use Think\Model;
class ShopsModel extends Model
{
    
    public function get_shop_ids($postdata){
        $s_id_map='';
        if (isset($postdata['shops_keyword'])) {
            if(!empty($postdata['shops_keyword'])) {
                if (is_numeric($postdata['shops_keyword'])) {
                    $shop_map['id|name'] = array(intval($postdata['shops_keyword']), array('like', '%' . $postdata['shops_keyword'] . '%'), '_multi' => true);
                } else if (!empty($postdata['shops_keyword'])) {
                    $shop_map['name'] = array('like', '%' . (string)$postdata['shops_keyword'] . '%');
                }
                $shop_ids = M('Shops')->where($shop_map)->getField('id',true);
                if (empty($shop_ids)) {
                    $s_id_map = array('lt', 0);
                } else {
                    $s_id_map = array('in', $shop_ids);
                }
            }else{
                $s_id_map = array('gt', 0);
            }
        } else {
            $s_id_map = 0;
        }
        return $s_id_map;
    }
    public function operate_shops_cateadd($postdata){
        $return=array();$return['status']=1;
        $id=$postdata['id'];
        $status=$postdata['status'];
        $map=array();
        $map['id']=$id;
        $info=M("ShopCateLink")->where($map)->field(true)->find();
        if($status==2){//通过审核
            $data=array();
            $data['status']=1;
            $map=array();
            $map['id']=$info['brand_id'];
            M('Brand')->where($map)->save($data);
        }
        if($status==3&&$info['type']==3){
            $map=array();
            $map['id']=$info['brand_id'];
            M('Brand')->where($map)->delete();
        }
        $remark=$postdata['remark'];
        $map=array();
        $map['id']=$id;
        $data=array();
        $data['status']=$status;
        if($remark)$data['remark']=$remark;
        $data['updata_time']=NOW_TIME;
        $result=M("ShopCateLink")->where($map)->save($data);
        if($result){
            //更新shops中的经营分类
            $map=array();
            $map['type']=2;
            $map['status']=2;
            $map['shop_id']=$info['shop_id'];
            $cat_ids=M('ShopCateLink')->where($map)->getField('cat_id',true);
            if(!empty($cat_ids)){
                $cate_ids=implode(',',$cat_ids);
                $map=$s_map=$data=array();
                $map['id']=$info['shop_id'];
                $s_map['shops_id']=$info['shop_id'];
                $data['cate_ids']=$cate_ids;
                M('Shops')->where($map)->save($data);
                M('ShopsSubmit')->where($s_map)->save($data);
            }
            $map=array();
            $map['id']=$id;
            $rdata=M("ShopCateLink")->where($map)->find();
            $uid=idtoname($rdata['shop_id'],'Shops','uid');
            $send_data['to']=$uid;
            $send_data['from']='admin(系统)';
            $send_data['type']=2;
            if($rdata['type']==1){//品牌
                $b_map=array();$b_map['id']=$rdata['brand_id'];
                $brand_info=M('Brand')->field('brand_name')->where($b_map)->find();
                if($rdata['status']==2) {
                    $send_data['content'] = '您申请加入的品牌(' . $brand_info['brand_name'] . ')已审核通过！';
                }elseif($rdata['status']==3) {
                    $send_data['content'] = '您申请加入的品牌(' . $brand_info['brand_name'] . ')审核未通过！原因是：'.$remark;
                }elseif($rdata['status']==5) {
                    $send_data['content'] = '您申请退出的品牌(' . $brand_info['brand_name'] . ')已成功退出！';
                }
            }elseif($rdata['type']==2){//经营类目
                $gc_map=array();$gc_map['id']=$rdata['cat_id'];
                $cat_info=M('GoodsCategory')->field('name,price')->where($gc_map)->find();
                if($rdata['status']==2) {
                    $send_data['content'] = '您申请加入的经营类目(' . $cat_info['name'] . ')已审核通过！';
                    shop_balance_log($rdata['shop_id'], $cat_info['price'], 5, 4, '经营类目(' . $cat_info['name'] . ')加入申请通过，待扣服务费增加'.$cat_info['price'].'元');
                }elseif($rdata['status']==3) {
                    $send_data['content'] = '您申请加入的经营类目(' . $cat_info['name'] . ')审核未通过！原因是：'.$remark;
                }elseif($rdata['status']==5) {
                    $send_data['content'] = '您申请退出的经营类目(' . $cat_info['name'] . ')已成功退出！';
                }
            }
            send_method(3,$send_data);
            $return['status']=1;$return['msg']='操作成功';
        }else{
            $return['status']=0;$return['msg']='操作失败';
        }
        return $return;
    }
}