/**
 * windowW最小宽
 */
function windowW() {
	if ($(window).width() < 980) {
		$('#header').css('width', 980 + 'px');
		$('#content').css('width', 980 + 'px');
		$('body').attr('scroll', '');
		$('body').css('overflow', '');
	}
}
/**
 * 打开左侧frame
 */
function _OPENleft(tag, targetUrl) {
	$('.top_menu').removeClass("on");
	$('#_OPENleft' + tag).addClass("on");
	$('.menu_left').hide();
	$("#menu_left_" + tag).show();	
	if (targetUrl) $("#rightMain").attr('src', targetUrl);
}
/**
 * 打开右侧frame
 */
function _OPENright(menuid, name, targetUrl) {
	$('#loading').show();
	$('.sub_menu').removeClass("on fb blue");
	$('#_OPENright' + menuid).addClass("on fb blue");
	$("#rightMain").attr('src', targetUrl);
	$("#current_pos").html(name);
}
/**
 *表格超出后 隐藏 显示title,点击一行 选中前面的多选框
 */
$(function($) {
	$("#myform .table-hanchao tbody tr").each(function() {
		$(this).children("td").not("#fixedtd").mouseover(function() {
			var title = $(this).attr("title");
			if (!title) $(this).attr("title", $(this).text());
		});
		$(this).children("td").on('click', function() {
			if ($(this).find("input").length == 0) {
				var input = $(this).parent().find("input");
				if ($(input).prop("checked")) {
					$(input).prop("checked", false);
				} else {
					$("#myform .table-hanchao tbody tr").find("input").each(function() {
						$(this).prop("checked", false);
					});
					$(input).prop("checked", true);
				}
			}
		})
	});
    submitForm();
    
    /*
     *操作提示缩放动画
     */
     $('#checkZoom').click(function(){
            if($('#explanationZoom').css('display')=='none'){
            $("#explanation").animate({
                color: "#2CBCA3",
                backgroundColor: "#EDFBF8",
                width: "99%",
                height: "35",
            },300,function() {
                $(this).css('height', '100%');
            });
            $("#explanationZoom").show();
        }else{
            $("#explanation").animate({
                color: "#FFF",
                backgroundColor: "#4FD6BE",             
                width: "96",
                height: "35",				              
            },300);
            $("#explanationZoom").hide();
        }
    });
});
/**
 * 双击编辑
 */
function editeTable(obj, field, id, action, model) {
	if (!action) {
		action = 'update';
	}
	if (!model) {
		model = CONTROLLER_NAME;
	}
	if (!field || !id) {
		return false;
	}
	var td = $(obj);
	var oldText = td.text();
	var input = $("<input type='text' class='form-control width10 h20 pd0' value='" + oldText + "'/>");
	td.html(input);
	input.click(function() {return false;});
	input.dblclick(function() {return false;});
	input.trigger("focus").trigger("select");
	input.blur(function() {
		var newval = $(this).val();
		if(newval<0){
			newval=1;
		}
		if (newval != oldText) {
			updateTable(newval, field, id, action, model);
		}
		td.html(newval);
	});
	input.keyup(function(event) {
		var keyEvent = event || window.event;
		var key = keyEvent.keyCode;
		var input_blur = $(this);
		switch (key) {
		case 13:
			var newText = input_blur.val();
			if(newText<0){
				newText=1;
			}
			td.html(newText);
			if (newText != oldText) {
				updateTable(newText, field, id, action, model);
			}
			break;
		case 27:
			//按下esc键，取消修改，把文本框变成文本
			td.html(oldText);
			break;
		}
	});
};
/**
 * 编辑字段入库
 */
function updateTable(value, field, id, action, model) {
	if (!field || !model || !action) {
		return false;
	}
	var url = APP + model + '/' + action + '/' + field + '/' + value + '/id/' + id + '/is_ajax/1';
	$.ajax({
		url: url,
		type: "get",
		dataType: "json",
		success: function(obj) {
			if (obj.status) {
				$.showSuccess(obj.info, 2, 'hc', '', function() {
					location.reload(true);
				});
				return false;
			} else {
				$.showSuccess(obj.info);
				return false;
			}
		}
	});
}
/**
 * 选择全部
 */
function selectall(name) {
	if ($("#check_box").prop("checked") == false) {
		$("input[name='" + name + "']").each(function() {
			this.checked = false;
		});
	} else {
		$("input[name='" + name + "']").each(function() {
			this.checked = true;
		});
	}
}
/**
 *添加扩展分类[+]
 */
function addMoreCat(conObj) {
	var sel = document.createElement("SELECT");
	var selCat = document.forms['myform'].elements['catid'];
	var browser = navigator.userAgent;
	for (i = 0; i < selCat.length; i++) {
		var opt = document.createElement("OPTION");
		opt.text = selCat.options[i].text;
		opt.value = selCat.options[i].value;
		if (browser.indexOf("MSIE") > 0) {
			sel.add(opt);
		} else {
			sel.appendChild(opt);
		}
	}
	conObj.appendChild(sel);
	sel.name = "more_cat[]";
	sel.style.display = "inline";
	sel.setAttribute("class", "form-control width2");
}
/**
 * 修改状态：对勾/叉
 * @param id
 * @param type
 */
function status(id, type) {
	$.get(URL + 'status.html', {
		id: id,
		type: type
	}, function(jsondata) {
		var return_data = eval("(" + jsondata + ")");
		$("#" + type + "_" + id + " img").attr('src', THEME_PATH + 'common/images/status_' + return_data + '.gif');
	});
}
/**
 * 提交表单
 * 当除表单提交按钮，其它按钮也需要提交表单，但不是表单的提交地址的时候
 * @param act
 * @param form
 * @returns {boolean}
 */
function submitForm() {
    $('.submitForm').bind('click', function () {
        var act = $(this).attr('action');
        var form = $(this).attr('form');
        if (!act) {
            return false;
        }
        if (!form) {
            form = 'myform';
        }
        var url = act;
        var query = $('#' + form).serialize();
        $.ajax({
            url: url,
            type: "post",
            data: query,
            dataType: "json",
            success: function (obj) {
                if (obj.status) {
                    $.showSuccess(obj.info, 2, 'hc', '', function () {
                        location.reload(true);
                    });
                    return false;
                } else {
                    $.showSuccess(obj.info);
                    return false;
                }
            }
        });
    });
}
/**
 * 当前页删除该项
 * @param obj
 * @param v 类型 3幻灯片相册
 */
function removethis(obj,v){
    if(v==3){
        $(obj).parent().parent().parent().remove();
    }
}
//格式化价格
function foramtmoney(price, len)
{
    len = len > 0 && len <= 20 ? len : 2;
    if(price<=0)price=0;
    price = parseFloat((price + "").replace(/[^\d\.-]/g, "")).toFixed(len) + "";
    var l = price.split(".")[0].split("").reverse(),
        r = price.split(".")[1];
    t = "";
    for(i = 0; i < l.length; i ++ )
    {
        t += l[i] + ((i + 1) % 3 == 0 && (i + 1) != l.length ? "," : "");
    }
    var re = t.split("").reverse().join("") + "." + r;
    return re.replace("-,","-");
}