<?php
/**
  * 系统公共函数库
  * @Copyright (C) 2016 汉朝 All rights reserved.
  * @License http://www.hanchao9999.com
  * @Author xiaogg <xiaogg@sina.cn>
  */
const HANCHAO_ADDON_PATH = './Addons/';
const HANCHAO_CACHE_MODEL ='AuthRule,ArticleCat,GoodsCategory,Nav,Oauth,Type,PointsRule,MemberNav,ShopsCategory';
function nav_list($navtype=0,$pid=0,$return=''){
    $name='Nav';
    $nav_list=format_array2tree(getcache($name),$pid);
    $nowurl=strtolower(MODULE_NAME."/".CONTROLLER_NAME."/".ACTION_NAME);$baseurl='';
    $now_url=strtolower($_SERVER['REQUEST_URI']?$_SERVER['REQUEST_URI']:$_SERVER['PHP_SELF']);
    $hovernav=$hovernavtrue='0';
    foreach($nav_list as $k => $v){
        if($navtype!=$v['navtype']){unset($nav_list[$k]);continue;}
        if(!str_exists($v['url'],'http://')){
            $realurl=strtolower(geturl($v['url']));
            $create_url=strtr($v['url'],array('?'=>'/','='=>'/','&'=>'/'));
            if(str_exists($now_url,$create_url) || str_exists($now_url,$realurl) || str_exists($now_url,str_replace('Home/','',$create_url)))$hovernav=$k;
            if(empty($hovernav)){
                $urlinfo=parse_url(strtolower($v['url']));
                $basearr=explode('/',$urlinfo['path']);         
                if(count($basearr)==1)$baseurl=MODULE_NAME."/".CONTROLLER_NAME."/".$urlinfo['path'];            
                elseif(count($basearr)==2)$baseurl=MODULE_NAME."/".$urlinfo['path'];else  $baseurl=$urlinfo['path'];
                $baseurl=strtolower($baseurl);
                if($nowurl==$baseurl && !$hovernav){$hovernav=$k;}
            }
        }
    }
    $nav['list']=$nav_list;
    $nav['hover']=$hovernav;
    $nav['hovernavtrue']=$hovernavtrue;
    return $return?$nav[$return]:$nav;
}
function article_list($catid,$limit=5,$order='',$sql='',$field='true',$cache=true){
    $map=array();
    $map['status']=1;
    if($catid){
        $sons=idtoname($catid,'ArticleCat','allson');
        $map['catid']=implode('',$sons)==$catid || !$sons?$catid:array('in',$sons);
    }
    if(empty($order))$order='sort desc,id desc';
    if(!empty($sql))$map['_string']=$sql;
    if($field=='true'){
        $list=M('Article')->where($map)->order($order)->limit($limit)->cache($cache)->field('content',true)->select();
    }else{
        if($field=='*')$field=true;
        $list=M('Article')->where($map)->order($order)->limit($limit)->cache($cache)->field($field)->select();
    }
    return $list;
}
function brand_list($cat_id=0,$brand_cid=0,$cache=true){
    if($cache){$cachename='brand_list'.$cat_id.$brand_cid;$cachecontent=S($cachename);if(!empty($cachecontent))return $cachecontent;}
    $map=$gmap=array();$map['status']=1;
    if(!empty($cat_id)){
        $allson=idtoname($cat_id,'GoodsCategory','allson');
        $gmap['catid']=str_exists($allson,',')?array('in',$allson):$allson;
        $gmap['status']=1;
        $brandids=M("Goods")->where($gmap)->getField('brand_id',true);
        if(empty($brandids))$brandids=array(0);
        $map['id']=array('in',$brandids);
    }
    if($brand_cid>0)$map['brand_cat_id']=$brand_cid;    
    $list=M("Brand")->where($map)->field(true)->order('sort desc,id desc')->select();
    if(empty($cat_id))$list = '';
    if($cache){S($cachename,$list);}
    return $list;
}
function page_list($module,$map=array(),$order='',$field=true,$pagesize=0,$join='',$REQUEST=1){
    if(empty($module))return false;if(empty($pagesize))$pagesize=C('LIST_ROWS') > 0 ? C('LIST_ROWS') : 10;
    if($REQUEST>=1)$REQUEST = (array)I('request.');
    if(!isset($REQUEST['p'])&&isset($REQUEST['page']))$REQUEST['p']=$REQUEST['page'];
    if(intval($REQUEST['p'])<=0)$REQUEST['p']=1;
    $group = '';
    if(isset($map['group'])&&!empty($map['group'])){$group = $map['group'];unset($map['group']);}
    $model = M($module);
    $preve = (intval($REQUEST['p'])-1)*$pagesize;
    $limit = "$preve,$pagesize";
    $return = array();
    if($group){
      $distinct='distinct '.$group;
      $return['count'] = $model->alias('a')->where($map)->join($join)->count($distinct);
    }else{
      $return['count'] = $model->alias('a')->where($map)->join($join)->count();
    }
    $Page = new \Common\Vendor\Page($return['count'],$pagesize,$REQUEST);
    $return['page'] = $Page->show();
    $return['firstRow'] = $Page->firstRow;
    $return['listRows'] = $Page->listRows;
    $return['totalPages'] = $Page->totalPages;
    $return['list'] = $model->alias('a')->where($map)->order('create_time')->join($join)->field($field)->group($group)->order($order)->limit($limit)->select();
    return $return;
}
function goods_list($catid=0,$type='',$limit='10',$order='',$sql='',$field='true',$cache=true){
    $map['status']=1;
    $map['shop_id']=0;
    if($catid){
        GLOBAL $GoodsCategory;
        $catinfo=$GoodsCategory[$catid];
        $extension_goods_id=get_extension_goods($catid,1);
        if(!empty($catinfo['allson']))$where['cat_id']= array('in',$catinfo['allson']);
        if(!empty($extension_goods_id))$where['id']  = array('in',$extension_goods_id);
        if(!empty($where)){$where['_logic'] = 'or';$map['_complex'] = $where;}
    }
    switch($type){
        case 'hot':$map['is_hot']=1;break;
        case 'best':$map['is_best']=1;break;
        case 'new':$map['is_new']=1;break;
        case 'promote':$map['is_promote']=1;$map['promote_end_date']=array('gt',time());break;        
    }
    if(empty($order))$order='sort desc,id desc';
    if(!empty($sql))$map['_string']=$sql;
    if($field=='true'){
        $list=M('Goods')->where($map)->order($order)->limit($limit)->cache($cache)->field('content',true)->select();
    }else{
        if($field=='*')$field=true;
        $list=M('Goods')->where($map)->order($order)->limit($limit)->cache($cache)->field($field)->select();
    }
    return $list;
}
function get_shop_help($pid=4){
    $res = M('Article')->alias('a')->field('c.id,c.name,c.sort,a.id AS article_id,a.title')->JOIN('LEFT JOIN  __ARTICLE_CAT__ c ON a.catid = c.id ')->where('c.pid = '.$pid)->order('c.sort ASC, a.id')->cache(true)->select();
    $arr = array();
    foreach ($res AS $key => $row){
        $arr[$row['id']]['id']= $arr[$row['id']]['cid'] = $row['id'];
        $arr[$row['id']]['cat_name'] = $row['name'];
        $arr[$row['id']]['article'][$key]['article_id'] = $row['article_id'];
        $arr[$row['id']]['article'][$key]['title'] = $row['title'];
        $arr[$row['id']]['article'][$key]['url'] = geturl('Home/Article/show',array('id'=>$row['article_id']));
    }
    return $arr;
}
function get_friendlink($catid=2,$limit=5){
    $where=array();
    $where['status']=1;
    $where['catid']=intval($catid);
    $friend_link=M('Friendlink')->where($where)->cache(true)->field(true)->order('sort desc,id desc')->limit($limit)->select();
    return $friend_link;
}
function showads($adid,$catid='0',$cacheHour=12,$isjs='0',$poster_num=''){
    if(empty($adid))return false;
    $cityid=0;
    $cachefile='adPoster'.$adid.$isjs.$catid.$cityid;
    $cachecontent=S($cachefile);
    if($cachecontent && $cacheHour>0){echo $cachecontent;}
    else{
        $map=array();$adcontent='';
        $map['status']=1;
        if(is_numeric($adid))$map['id']=$adid;
        else $map['code']=$adid;
        $info=M('PosterPosition')->where($map)->field(true)->find();        
        $where=array();
        $where['position_id'] =$info['id'];
        $where['status'] =1;
        if(!empty($catid)){GLOBAL $GoodsCategory;$catson=explode(',',$GoodsCategory[$catid]['allson']);$where['catid'] =array('in',$catson);}
        $where['_string'] = '(start_time <'.NOW_TIME.' OR start_time =0) and (end_time >'.NOW_TIME.' OR end_time =0)';
        if(!empty($poster_num)){$info['number']=$poster_num;}
        $ad_list=M('Poster')->where($where)->field(true)->order('sort desc,id desc')->limit($info['number'])->select();
        if(!empty($ad_list)){
            $View= new \Common\Vendor\TplView();
            $View->assign($info);
            $info['tpl'] = D('Admin/PosterPosition')->get_template_content($info['tpl'],$info['device']);
            $info['tpl'] = strtr($info['tpl'] ,array("\r"=>'',"\n"=>'',"\t"=>''));
            $tpl=trim(htmlspecialchars_decode($info['tpl']));
            foreach($ad_list as $k => $v){
                $ad_list[$k]['url']=$v['url']=geturl('Home/Poster/url',array('id'=>$v['id']),true,true);
            }
            $View->assign('ad_list',$ad_list);
            $adcontent=$View->fetch('',$tpl);
        }
        $cachecontent=$isjs?format_js($adcontent):$adcontent;
        S($cachefile,$cachecontent,60*60*$cacheHour);echo $cachecontent;
    }
}
function geturl($name,$param='',$ext=true,$domain=false,$parammore=false,$page=false){
    if(empty($name))return false;
    if(str_exists($name,'http://')){return $name;}
    if(str_exists($name,'url:'))return rulestourl($name,$domain);
    if(!is_array($param) && !empty($param))$param=strtoarray($param);
    if($parammore){
        $getdata=array_filter(I('request.'));
        if($getdata['id']=='index')unset($getdata['id']);
        if($param)$param=array_merge($getdata,$param);
        else $param=$getdata;
    }
    if(!$page && isset($param['p']))unset($param['p']);
    $url='';
    if($url)return $url;
    $url=U($name,$param,$ext,$domain);
    return $url;
}
function cart_show(){   
    $regis=C('NOT_ADD_CART');
    $sess = session('member_info');
    $cookie_id=cookie('u_cookieid');
    $map = array();
    $map['g.status'] = 1;
    $map['g.publish_wait'] = 1;
    if(empty($regis)){
        if($sess['id']){
            $map['c.user_id']=$sess['id'];
        }else{
            return 0;
        }
    }else{
        if($sess['id']){
            $map['c.user_id']=$sess['id'];
        }else{
            if($cookie_id){
                $map['c.user_id']=0;
                $map['c.cookie_id']=$cookie_id;
            }else{
                return 0;
            }
        }
    }
    $cart_count = M('Cart')->alias('c')->JOIN('LEFT JOIN __GOODS__ g ON g.id=c.goods_id')->where($map)->sum('c.goods_num');
    return intval($cart_count);
}
function idtoname($id,$mod='GoodsCategory',$field='name',$sekey='id',$cache=true){
    if(empty($id))return false;
    if($mod=='GoodsCategory'){GLOBAL $GoodsCategory;if(!empty($GoodsCategory))$cachemod=$GoodsCategory;}
    if(empty($cachemod))$cachemod=getcache($mod);
    if($cachemod && $sekey=='id'){
        return $field=='*'?$cachemod[$id]:$cachemod[$id][$field];
    }else{
        if($field=='*')$field=true;
        $where[$sekey]=$id;
        $fieldstr=str_exists($field,';')?str_replace(';',',',$field):$field;
        if(str_exists($field,','))$fieldstr="`".str_replace(',','`,`',$fieldstr)."`";
        if($cache===true)$cache='idtoname'.$id.$mod.$field.$sekey;
        $result=M($mod)->where($where)->field($fieldstr)->cache($cache)->find();
        if($cache && is_string($result) && substr($result,0,6)=='SELECT')return false;
        return ($field=='*' || str_exists($field,','))?$result:idtonamevalue($result,$field);
    }
}
function idtonamevalue($value,$field){
    if(empty($value) || empty($field))return false;
    $array=explode(';',$field);
    foreach($array as $v){
        if($value[$v])return $value[$v];
    }return false;
}
function arraytostr($array) {
    if(!is_array($array))return $array;
    foreach($array as $k=>$v){$retarr[]=$k.'|'.$v;}
    if($retarr)$return=implode(',',$retarr);
    return $return;
}
function strtoarray($str,$type='key') {
    if(is_array($str))return $str;
    if(empty($str))return false;
    $array=array();$typekey='key';
    if(str_exists($str,'typeid_')) {
        $typeid=floor(strtr($str,array('typeid_'=>'','temp_'=>'')));
        if(str_exists($str,'temp_')){$type='temp';}
        if($typeid)$array=gettypeson($typeid,$type);
    }
    if(!$array) {
        $str=str_replace(PHP_EOL,',',$str);
        $strarr=array_map('trim',explode(',', $str));
        $array =array_values(array_filter($strarr));
    }
    foreach ($array as $k=> $v) {
        if (strpos($v, '|')) {$varr = explode('|', $v);
            $return[$varr[0]] = str_exists($varr[1],'LAN_')?L(str_replace('LAN_','',$varr[1])):$varr[1];
        }else{
           if(strpos($v,':')){
                $varr = explode(':', $v);
                $return[$varr[0]] = str_exists($varr[1],'LAN_')?L(str_replace('LAN_','',$varr[1])):$varr[1];
           }else{
                $arrkey=$typekey=='key'?$k:$v;
                $return[$arrkey] =str_exists($v,'LAN_')?L(str_replace('LAN_','',$v)):$v;
           }
       }
    }
    return $return;
}
function gettypeson($typeid, $type = 'key'){
    $options=array();$types = getcache('Type');
    foreach ($types as $key => $r){
        if ($r['pid'] == $typeid){if ($type=='key')$k = $key;else $k = $r[$type];$options[$k] = $r['name'];}
    }
    return $options;
}
function gettypevalue($typeid,$field='name',$where='id',$pid=''){
    $types=getcache('Type');
    if($where=='id' || $where=='temp'){
        $typeids=is_array($typeid)?$typeid:(str_exists($typeid,',')?explode(',',$typeid):array($typeid));
        $valarr=array();$newtypes=array();
        if($where=='temp'){
            foreach($types as $k=>$v){
                if($pid){
                    if($pid==$v['pid'] && isset($v['temp']))$newtypes[$v['temp']]=$v;
                }else{
                    if(isset($v['temp']))$newtypes[$v['temp']]=$v;
                }
            }
        }else{$newtypes=$types;}
        foreach($typeids as $v){
            if(isset($newtypes[$v][$field]))$valarr[]=$newtypes[$v][$field];
        }
        return implode(',',$valarr);
    }
    foreach($types as $k=>$v){
        if($pid && $pid!=$v['pid'])continue;
        if($v[$where]==$typeid){return $field=='*'?$v:$v[$field];}
    }
    return false;
}
function format_array2tree($cachedata,$pid=0){
    if(empty($cachedata))return false;
    $Tree = new \Common\Vendor\Tree();
    $Tree->init($cachedata);
    return $Tree->get_tree_array($pid);
} 
function getcache($name=''){
    if(empty($name))return false;
    $patharr=array('GoodsCategory'); 
    $cachedata=in_array($name,$patharr)?F('../'.$name):F($name);
    if($cachedata)return $cachedata;
    else{return savecache($name,1);}
}
function savecache($name = '', $type = ''){    
    $cache_model=explode(',',HANCHAO_CACHE_MODEL);
    if(!in_array($name,$cache_model))return false;
    if(!defined('RUNTIME_FILE'))define('RUNTIME_FILE',APP_PATH.'Runtime/');
    if(file_exists(RUNTIME_FILE))unlink(RUNTIME_FILE);
    $Model = M($name);$list=$data= array();
    $allpas=array('GoodsCategory','ArticleCat');
    $patharr=array('GoodsCategory'); 
    if ($name == 'User'){
        $list = $Model->where("status=1")->field(true)->select();		
        foreach ($list as $v){unset($v['password']);$data[$v['id']] = $v;}
        F($name, $data);
    }else if (in_array($name,array('Payment','Oauth'))){
        $list = $Model->where("status=1")->field(true)->select();
        foreach ($list as $v){$data[$v['code']] = $v;}F($name, $data);
    }else if ($name == 'AuthRule'){
        $list = $Model->field(true)->order('sort,id desc')->select();
        foreach ($list as $key => $val){
            $data[$val['id']] = $val;
        }F($name, $data);
        $AdminGroup = M('AuthGroup')->where('status=1')->field('id,rules')->select();
        foreach ($AdminGroup as $groupValue) {
	$ruleCache = F("admin_rule_{$groupValue['id']}");
	if (empty($ruleCache)){
              if(empty($groupValue['rules'])) $groupValue['rules']=0;
        	   $ruleData = $Model->where("id IN({$groupValue['rules']})  AND status=1")->order('sort,id desc')->getField('id,name,title,show_status,type,condition,pid,sort');
        	   F("admin_rule_{$groupValue['id']}",$ruleData);
          }
          unset($ruleCache);
        }
        unset($AdminGroup);
    }else{
        $allfields=$Model->getDbFields();
        $pkid = $Model->getPk();
        $order='';
        $map=array();
        if(in_array('status',$allfields))$map['status'] = 1;
        if(in_array('sort',$allfields))$order.='sort,';
        $order.=$name=="Area"?$pkid:$pkid.' desc';
        $list = $Model->field($allfields)->where($map)->order($order)->select();
        foreach ($list as $key => $val){
            $data[$val[$pkid]] = $val;
            if(in_array($name,$allpas)){
                $data[$val[$pkid]]['allparent']=getallparent($val[$pkid],'',$name);
                $data[$val[$pkid]]['allson']=implode(',',getallson($val[$pkid],$name));
            }
        }
        in_array($name,$patharr)?F('../'.$name,$data):F($name, $data);
    }
    if(!empty($type)){unset($list);return $data;}
    else{unset($list,$data);return true;}
}
function account_changetype($key='',$field=''){
    $array=array(
        1=>array('field'=>'money','name'=>"资金"),
        2=>array('field'=>'frozen_money','name'=>"冻结资金"),
        3=>array('field'=>'points','name'=>C('RANK_INTEGRAL_NAME')),
        4=>array('field'=>'usepoints','name'=>C('SELL_INTEGRAL_NAME')),
    );
    if(empty($key) && empty($field))return $array;
    if(!empty($key) && empty($field))return $array[$key]['name'];
    if(!empty($key) && !empty($field))return $array[$key][$field];
    return false;
}
function account_change($userid, $amount ,$type='0', $status='4', $note = '',$adminid='0',$do=TRUE,$role='0') {
    $allowfields=account_changetype();
    if(empty($allowfields) || !is_array($allowfields))return false;
    if(empty($userid) || empty($amount) || floatval($amount)=='0' || empty($allowfields[$type]))return false;
    $field=$allowfields[$type]['field'];
    $Member=M('Member');$where=array();
    $where['id']=$userid;
    $amount=round($amount,2);
    if($amount>0){
        if($do)$Member->where($where)->setInc($field,$amount);
        $data['change_type']='0';
        $data['change_num']=$amount;
    }else{
        if($do)$Member->where($where)->setDec($field,-$amount);
        $data['change_type']=1;
        $data['change_num']=-$amount;
    }$member_info=session('member_info');
    if($do && $userid==$member_info['id'])updatesession($userid);
    $data['uid']=$userid;
    $data['role']=$role;
    $data['end_num']=$Member->where("`id`='".$userid."'")->getField($field);
    $data['adminid']=$adminid;
    $data['change_time']=NOW_TIME;
    $data['change_desc']=$do?$note:'[日志]'.$note;
    $data['type']=$type;
    $data['status']=$status;
    $AccountLog=M('AccountLog');
    if($note!='NULL')$insertid=$AccountLog->add($data);
    unset($data);
    return $insertid;
}
function updatesession($id,$type='member_info'){
    if(empty($id))return false;
    $modulename=str_replace('_','',ucwords(str_replace('_info','',$type)));
    $info=idtoname($id,$modulename,'*','id',false);
    $info[$type.'_auth_sign'] = data_auth_sign($info,$type);
    session($type, $info);
}
function rolechange($userid,$id,$note=''){
    if(empty($userid) || empty($id))return false;
    $PointsRule=getcache('PointsRule');
    $role=$PointsRule[$id];if(empty($role))return false;
    if(empty($note))$note=$role['name'];
    account_change($userid, $role['value'] ,$type,5, $note);
    if($type==3){account_change($userid, $role['value'] ,4,5, $note);}return true;
}
function getfeemoney($money,$fee='',$type=''){
    if($fee<=0)return 0;
    $money_fee=format_decimal($money*$fee/100);
    if($type)return $money+$money_fee;else return $money_fee;
}
function sendbytheme($data,$theme='',$url=''){  
    if(empty($theme) || empty($data['to']))return '发送失败';
    $data['site_name']=C('WEB_SITE_NAME');
    $data['site_url']=geturl('Home/Index/index','',true,true);
    $data['url']=$url?$url:$data['site_url'];
    $memberinfo=session('member_info');
    if(empty($data['username'])){$data['username']=$memberinfo['username'];}
    $themeinfo=idtoname($theme,'SmsTheme','name,content,type,theme_id,theme_data,code','code');    
    $data['theme_id']=$themeinfo['theme_id'];
    $data['theme_data']=strtoarray($themeinfo['theme_data']);
    $type_array=explode(',',$themeinfo['type']);
    if(!empty($themeinfo['content'])){
        $View= new Think\View();
        $View->assign('data',$data);
        $data['content']=trim($View->fetch('',htmlspecialchars_decode($themeinfo['content'])));
    }else{$data['content']=$data['content'];}
    if(empty($data['title'])) $data['title']=$themeinfo['name'];
    if(empty($data['verify_code'])) $data['verify_code']='';
    if(!empty($memberinfo['push_android_registrationid'])) $data['push_android_registrationid']=$memberinfo['push_android_registrationid'];
    if(!empty($memberinfo['push_ios_registrationid'])) $data['push_ios_registrationid']=$memberinfo['push_ios_registrationid'];
    foreach ($type_array as $v) {$result=send_method($v,$data);}
    if($result['status']==1){$msg='发送成功';}else{$msg='发送失败 错误:'.$result['msg'];}
    return $msg;
}
function send_method($type,$data){
    if(empty($data))return false;
    if(empty($type))$type=1;
    switch($type){
        case 1:
            if(empty($data['to']) || empty($data['from']) || empty($data['title']) || empty($data['content'])) return false;
            $result=sendmail($data['to'],$data['from'],$data['title'],$data['content'],'',$data['verify_code'],$data['touid']);
            return $result;
        break;
        case 2:
            if(empty($data['to']) || empty($data['content'])) return false;
            $result=sendsms($data['to'],$data['content'],$data['verify_code'],$data['touid'],$data);
            return $result;
        break;
        case 3:
            if(empty($data['to']) || empty($data['content'])) return false;
            $result=sendsitesms($data['to'],$data['content'],'',$data['from'],$data['type']);
            return $result;
        break;
        case 4:
            if(empty($data['to']) || empty($data['content'])) return false;
            $result=sendwxmsg($data['to'],$data['content'],'','uid',$data);
            return $result; 
        break; 
        case 5:
            if(empty($data)) return false;
            if($data['push_android_registrationid']){ $ids[]=$data['push_android_registrationid']; }
            if($data['push_ios_registrationid']){ $ids[]=$data['push_ios_registrationid']; }
            if(empty($ids)) return false;
            $data['registration_ids'] = $ids;
            $data['type'] = 'member';
            $result = pushSend($data);
            return $result;
        break;     
        default:
        break;
    }
}
function sendsitesms($to,$content='',$title='',$from='0',$type=1){
    $to=intval($to);
    if(empty($to) || empty($content))return false;
    $data['content']=$content;
    $data['title']=$title?$title:$content;
    $data['touid']=$to;
    $data['fromuid']=$from;
    $data['addtime']=NOW_TIME;
    $data['type']=$type;
    return M('Message')->add($data);
}
function sendsms($to,$body='',$verify_code='',$uid='',$param=''){
    if(empty($to) || empty($body))return false;
    $sendtype=C('SMS_SEND_TYPE');
    if($uid==''){
       if(is_numeric($to) && strlen($to) ==11)
        $uid = M('Member')->where('mobile='.$to)->getField('id');
    }
    if($sendtype==1){
        $result=dosendsms($to,$body,$param);
        $result['is_send']=1;
    }else{
        $result['status']=0;$result['is_send']='0';
        $result['msg']='已经添加到短信列队!';
    }
    $data=array();
    $memberinfo=session('member_info');
    $admininfo=session('admin_info');
    $data['to']=$to;
    $data['content']=$body;
    $data['is_send']=$result['is_send'];
    $data['is_success']=$result['status'];
    $data['result']=$result['msg'];
    $data['send_type']=0;
    $data['uid']=isset($uid)?$uid:$memberinfo['id'];
    $data['adminid']=isset($admininfo['id'])?$admininfo['id']:0;
    $data['addtime']=$data['updatetime']=$data['sendtime']=NOW_TIME;
    if(!empty($verify_code)) $data['verify_code']=$verify_code;
    M('SmsLogs')->add($data);
    $back['status']=$result['status'];
    $back['msg']=$result['msg'];
    return $back;
}
function dosendsms($to,$body='',$param=''){
    if(empty($to) || empty($body))return false;
    $sms =new \Common\Vendor\Sms;
    $data=$param;
    $data['phone']=$to;
    $data['content']=$body;
    return $sms->send($data);
}
function sendmail($to, $name='', $subject = '', $body = '', $attachment = null ,$verify_code='',$uid=''){
    $sendtype=C('SMS_SEND_TYPE');
    if($sendtype==1){
        $sendresult=dosendemail($to,$name,$subject, $body,$attachment);
        if($sendresult){
            $result=true;
            $data['is_send']='1';
            $data['is_success']='1';
            $data['result']='发送成功';
        }else{
            $result=$mail->ErrorInfo;
            $data['is_success']='0';
            $data['is_send']='1';
            $data['result']=$result;
        }
    }else{$data['is_success']='0';$data['result']='已添加到邮件列表';$data['is_send']='0';}
    $memberinfo=session('member_info');
    $admininfo=session('admin_info');
    $data['to']=$to;
    $data['from']=$name;
    $data['title']=$subject;
    $data['content']=$body;
    $data['send_type']=1;
    $data['uid']=isset($uid)?$uid:$memberinfo['id'];
    $data['adminid']=isset($admininfo['id'])?$admininfo['id']:0;
    $data['addtime']=$data['updatetime']=$data['sendtime']=NOW_TIME;
    if(!empty($verify_code)) $data['verify_code']=$verify_code;
    M('SmsLogs')->add($data);
    $back['status']=$data['is_success'];
    $back['msg']=$data['result'];
    return $back;
}
function dosendemail($to, $name='', $subject = '', $body = '', $attachment = null){
     $mail = new \Common\Vendor\PHPMailer\PHPMailer();
     $mail->CharSet = 'UTF-8';$mail->IsSMTP();
     $mail->SMTPAuth = true;                  
     $mail->Host = C('EMAIL_SMTPHOST');  
     $mail->Port = C('EMAIL_SMTPPORT');  
     $mail->Username = C('EMAIL_SMTPNAME');  
     $mail->Password = C('EMAIL_SMTPPASSWORD');  
     $mail->SetFrom(C('EMAIL_FAJIAN'), C('WEB_SITE_TITLE'));
     $mail->AddReplyTo(C('EMAIL_FAJIAN'), C('WEB_SITE_TITLE'));
     $mail->Subject = $subject;
     $mail->MsgHTML($body);
     $mail->AddAddress($to, $name);
     if(is_array($attachment)){foreach ($attachment as $file){is_file($file) && $mail->AddAttachment($file);}}
     return $mail->Send();
}
function sendwxmsg($id,$content,$type='text',$utype='uid',$data=''){
    $wxtype=C('WX_TYPE');
    if($wxtype!=4)return false;
    if(is_numeric($id) && strlen($id) ==11)$id = M('Member')->where('mobile='.$id)->getField('id');
    else return false;
    if($utype=='uid'){
        $uid=$id;
        $map['id']=$id;
        $map['status']='1';        
        $openid=M('Member')->where($map)->cache(true)->getField('wxid');
    }elseif($utype=='openid'){
        $openid=$id;if($openid)$uid=idtoname($id,'Member','id','wxid');
    }
    if(empty($openid)) return false;
    $result = array('errcode'=>1);
    $weixin = new \Common\Vendor\WeixinChat;   
    if($data['theme_id'] && $data['theme_data']){
       $content=array();
       foreach($data['theme_data'] as $k =>$v){
            $content[$k]=array('value'=>(str_exists($v,'$')?$data[substr($v,1)]:$v),'color'=>'#173177');
       }
       $url=$data['url']?$data['url']:geturl('Home/Index/index','',true,true);
       $template_id = $data['theme_id'];
       $result=$weixin->sendTplMsg($content,$url,$openid,$template_id);
       return $result;
    }
    if($result['errcode']!=0)$result=$weixin->sendMsg($content, $openid, $type); 
    $memberinfo=session('member_info');
    $admininfo=session('admin_info');
    if(is_numeric($type) && $type){
        $data['updatetime']=$data['sendtime']=NOW_TIME;
        $data['is_success']=$result['errcode']==0?1:0;
        $data['result']=$result['errmsg'];
        $data['adminid']=isset($admininfo['id'])?$admininfo['id']:0;
        M('WxMsg')->where('id='.$type)->save($data);
        return $result;
    }
    $data['openid']=$openid;
    $data['content']=$content;
    $data['type']=$type;
    $data['uid']=isset($uid)?$uid:$memberinfo['id'];
    $data['adminid']=isset($admininfo['id'])?$admininfo['id']:0;
    $data['addtime']=$data['updatetime']=$data['sendtime']=NOW_TIME;
    if(!empty($verify_code)) $data['verify_code']=$verify_code;  
    $data['is_send']=1;
    $data['is_success']=$result['errcode']==0?1:0;
    $data['result']=$result['errmsg'];
    M('WxMsg')->add($data);
    $back['status']=$data['is_success'];
    $back['msg']=$data['result'] ;
    return $back;
}
function pushSend($param=array(),$m_type='',$m_txt='',$m_time=''){
    if(empty($param))return false;
    $admininfo=session('admin_info');
    if($param['type']=='all'){
        $receive = 'all';
    }else{
        $receive['registration_id'] = $param['registration_ids'];
    }
    vendor("JpushSend.JpushSend");
    $ec = new \JpushSend();
    $result = $ec->send_pub($receive,$param['content'],$m_type,$m_txt,$m_time);
    if($param['type']=='member'){
        $data['uid'] = $param['to'];
    }elseif($param['type']=='all'){
        $data['allid'] = 1;
    }
    if(is_numeric($param['re'])){
        $data['updatetime']=NOW_TIME;
        $data['is_success']=$result['is_success']==1?1:0;
        $data['result']=$result['errmsg'];
        $data['errmsg'] = $result['off_err'];
        $data['adminid']=isset($admininfo['id'])?$admininfo['id']:0;
        M('PushLog')->where('id='.$param['id'])->save($data);
        return $result;
    }
    $data['title']=str_cut($param['content'],20);
    $data['content']=$param['content'];
    $data['addtime']=$data['updatetime']=NOW_TIME;
    $data['is_success']=$result['is_success']==1?1:0;
    $data['result']=$result['errmsg'];
    $data['errmsg'] = $result['off_err'];
    $data['adminid']=isset($admininfo['id'])?$admininfo['id']:0;
    M('PushLog')->add($data);
    return $result;
}
function down_file(){
    $express =new \Common\Vendor\Express;
    return $express->com_url();
}
function doexpress($order_sn,$code){
    if(empty($code))return false;
    $express =new \Common\Vendor\Express;
    $data['order_sn']=$order_sn;
    $data['code']=$code;
    return $express->process($data);
}
function db_create_in($item_list, $field_name = ''){
    if (empty($item_list)){return $field_name . " IN ('') ";}
    else{
        if (!is_array($item_list)){$item_list = explode(',', $item_list);}
        $item_list = array_unique($item_list);
        $item_list_tmp = '';
        foreach ($item_list AS $item){
            if ($item !== ''){$item_list_tmp .= $item_list_tmp ? ",'$item'" : "'$item'";}
        }
        if (empty($item_list_tmp)){return $field_name . " IN ('') ";}
        else{return $field_name . ' IN (' . $item_list_tmp . ') ';}
    }
}
function strimages($val){
    if(empty($val))return false;
    $arr=strtoarray($val);
    $str='';
    foreach($arr as $key=> $v){
        $str.="<img src='".$v."' style='max-height:90px;max-width:90px;margin-right:3px' align='left' title='".$key."' alt='".$key."'>";
    }
    return $str;
}
function min_css($urls,$base=''){
    if(empty($urls) && empty($base))return false;
    if(!empty($base) && !is_array($base))$base=explode('|',$base);
    if(!empty($base) && !empty($urls))$urls=array_merge($base,$urls); else{$urls=$urls?$urls:$base;}
    $urls=array_unique(array_filter($urls));
    $url = md5(implode(',',$urls));
    $urlpathbase=RUNTIME_PATH.'statics/';if(!is_dir($urlpathbase))mkdir($urlpathbase,0777);
    if(strlen(__ROOT__)>1)$urlpathbase=str_replace(__ROOT__,'',$urlpathbase);
    $url_path_back = $urlpathbase.$url.'.css';
    $write_file=ROOT_PATH.substr($url_path_back,1);
    if(!file_exists($write_file) || APP_DEBUG){
        $css_content = '';$tplconfigurl=ROOT_PATH.'/Application/'.get_module_name().'/View/'.get_default_theme().'/config.php';
        if(file_exists($tplconfigurl)){$tpl_config = require_once $tplconfigurl;}
        foreach($urls as $url){
            $url=strtr($url,array("__PUBLIC__"=>__ROOT__.'/Public',"THEME_PATH"=>THEME_PATH));
            if(str_exists($url,'./'))$url=format_url($url,5);
            $realfile=format_url($url,2);
            $cssbase= dirname($url).'/';
            $css_content .= str_replace("../",$cssbase."../",file_get_contents($realfile));
        }
        $css_content = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css_content); 
        $css_content = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css_content);
        if(!empty($tpl_config['color']))$css_content =strtr($css_content,$tpl_config['color']);
        if(empty($css_content))$css_content='';
        file_put_contents($write_file,$css_content);
    }
    return __ROOT__.substr($url_path_back,1);
}
function min_js($urls,$base=array()){
    if(empty($urls) && empty($base))return false;
    if(!empty($base) && !is_array($base))$base=explode('|',$base);
    if(!empty($base) && !empty($urls))$urls=array_merge($base,$urls);
    else{$urls=$urls?$urls:$base;}
    $urls=array_unique(array_filter($urls));    
    $url = md5(implode(',',$urls));
    $urlpathbase=RUNTIME_PATH.'statics/';if(!is_dir($urlpathbase))mkdir($urlpathbase,0777);
    $js_url = $urlpathbase.$url.'.js';
    $write_file=ROOT_PATH.substr($js_url,1);
    if(!file_exists($write_file)||APP_DEBUG){
        $packer = new \Common\Vendor\Jsmin;$js_content = '';        
        foreach($urls as $key=> $url){
            if(str_exists($url,"__PUBLIC__"))$url=str_replace('__PUBLIC__',__ROOT__.'/Public',$url);
            if(str_exists($url,"THEME_PATH"))$url=str_replace('THEME_PATH',THEME_PATH,$url);
            if(str_exists($url,'./'))$url=format_url($url,5);$realfile=format_url($url,2);
            $append_content = oaofile($realfile)."\r\n";
            if(str_exists($key,'min'))$append_content=$packer->minify($append_content);
            $js_content .= $append_content;
        }
        if($js_content)oaofile($write_file,$js_content);
    }
    return __ROOT__.substr($js_url,1);
}
function getjumpurl($jumpUrl='',$extend=''){
    if(!str_exists($jumpUrl,'JUMP_'))return false;
    $urlname=strtr($jumpUrl,array('JUMP_'=>''));
    if(str_exists($urlname,'&')){
       $urlarr=explode('&',$urlname);$extend=str_replace($urlarr[0].'&','',$urlname);$urlname=$urlarr[0];
    }
    $jumurl=ROOT_PATH.'/Application/Common/Data/Jumpdata.php';
    $urldata=require_once($jumurl);
    $type=is_mobile()?'mobile':'home';
    return geturl($urldata[$urlname][$type],$extend);
}
function check_verify_code($to,$code,$type='0'){
    $map['to']=$to;
    $map['verify_code']=$code;
    $map['send_type']=$type;
    $check=M('SmsLogs')->where($map)->field('addtime,is_verify')->order('id desc')->find();
    if(empty($check))return false;
    $youxiaotime=C('MOBILE_TURE_TIME');
    if(empty($youxiaotime))$youxiaotime=300;
    if($check['is_verify'])return false;
    if($check['addtime']<(NOW_TIME-$youxiaotime))return false;
    $data['is_verify']=1;
    $data['updatetime']=NOW_TIME;
    M('SmsLogs')->where($map)->save($data);    
    return true;
}
function getmodtpl($type='show',$pathdir='Intro',$unset=''){
    if(empty($type))$type='show';
    $dir = new \Common\Vendor\Dir;
    $filelist=$dir->getList(APP_PATH.'Home/View/'.get_default_theme('Home').'/'.$pathdir.'/');
    if(empty($filelist))return false;
    $dirlist=array_slice($filelist,2);
    $filelist[0]='默认模板';
    foreach($dirlist as $k => $v){
        if(str_exists($v,$type)){$filelist[$v]= $v;}
    }
    if($unset=='unset'){unset($filelist[0],$filelist[1]);}
    return $filelist;
}
function rulestourl($str,$is_domain=true){
    if(str_exists($str,'http://'))return $str;
    if(!str_exists($str,'url:'))return U($str,'',true,true);
    $arr=explode(':',$str);
    $urlrules=M("UrlRules")->where('id='.$arr[1])->find();
    if(empty($urlrules))return false;
    $is_url=array();
    if($urlrules['is_module'] == 1 && !empty($arr[2])){
        $is_url[]=$urlrules['urlparam'].'='.$arr[2];
    }
    if($urlrules['is_param'] == 1 && !empty($arr[3])){
        $is_url[]=$arr[3];
    }
    $isurl=implode('&',$is_url);
    return U($urlrules['theurl'],$isurl,true,$is_domain);
}
function return_urlrules($value){
    $urlarr[0]=I("url_navtype");
    $urlarr[1]=I("url_modulename");
    $urlarr[2]=I("url_param");
    if(empty($urlarr[0]))return $value;
    return 'url:'.implode(':',$urlarr);
}
function appurl($param=array(),$urlscheme=''){
    if(empty($urlscheme))$urlscheme=C('URL_SCHEME','hcshop');
    $urlparam='';
    $getdata=$param?$param:I('get.');
    if($getdata)$urlparam.='?'. http_build_query($getdata);        
    return $urlscheme."://".$urlparam;
}
function get_promot_goods($num){
    $num=$num?$num:5;
    $map['status']=1;
    $map['is_delete']=0;
    $map['publish_wait']=1;
    $map['promote_id']=array('gt',0);
    $map['promote_price']=array('gt',0);
    $map['promote_start_time']=array('lt',NOW_TIME);
    $map['promote_end_time']=array('gt',NOW_TIME);
    $pro_goods=M('Goods')->field('id,goods_name,img,promote_end_time,shop_price,promote_price')->where($map)->order('promote_end_time asc')->limit($num)->select();
    return $pro_goods;
}
function getallson($pid,$mod='Category',$me='1',$length=5){
    if(empty($pid))return false;$mod=M($mod);
    if($me)$son[$pid] = $pid;else $son='';
    $pids[]=$pid;$i=0;
    do{
        if(empty($pids))break;
        $map=array('pid'=>array('in',$pids));
        $sondata=$mod->where($map)->cache(true)->field('id,pid')->select();
        $pids=array();
        if($sondata){
            foreach ($sondata as $v) { 
               $son[] = $v['id'];$pids[]= $v['id'];
            }
        }++$i;if($i==$length)$sondata=array();
    }while (!empty($sondata));
    return $son;
}
function getallparent($id, $arrparentid = '',$mod='Category',$length=5) {
    if(empty($id))return false;
    if(!empty($arrparentid) && !is_array($arrparentid))$arrparentid=explode(',',$arrparentid);
    $ids =isset($arrparentid)?$arrparentid: array();$i=0;
    do{
        $pidinfo = M($mod)->where('id='.$id)->cache(true)->field('pid')->find();
        $ids[] = $id = intval($pidinfo['pid']);	
        ++$i;if($i==$length)$id=0;	
    }while($id!=0);    
    return implode(',',$ids);
}
function linkagevalue($id,$mod='Area'){
    $length=C('ZONE_LEVEL');
    if(empty($id) || str_exists($id,','))return false;
    $ids[]=$id;$i=0;
    do{
        $map=array();
        $map['id']=$id;
        $map['pid']=array('gt',1);
        $pidinfo = M($mod)->where($map)->cache(true)->field('pid')->find();
        $ids[] = $id = intval($pidinfo['pid']);	
        ++$i;if($i==$length)$id=0;	
    }while($id!=0);
    $id_arr=array_filter($ids);krsort($id_arr);
    return implode(',',$id_arr);
}
function get_children($cat = 0,$type=0){
    $catarr=cat_list($cat,1);
    if($type)return $catarr;
    return ' g.catid ' . db_create_in($catarr);
}
function cat_list($cat_id = 0,$type=0){
   GLOBAL $GoodsCategory;
   if(empty($GoodsCategory))$GoodsCategory=getcache('GoodsCategory');
   if($cat_id){
        $son =  $GoodsCategory[$cat_id]['allson'];
        if(!is_array($son))$son=explode(',',$son);
        if($type)return $son;
        foreach($son as $value){
            $sson = $GoodsCategory[$value];
            $arr['id'] = $sson['id'];
            $arr['name'] = $sson['name'];
            $array[$sson['id']] = $arr;
        }
        return $array;
    }else{return $GoodsCategory;}
}
function get_type_attr($type_id=array(),$catid=0,$is_search='1',$return=1){
    if(empty($type_id)) return false;
    $cachename="get_type_attr".$catid;
    $cachecontent=S($cachename);
    if($cachecontent)return $cachecontent[$return];
    if($catid){
        GLOBAL $GoodsCategory;
        $catinfo=$GoodsCategory[$catid]; 
        $extension_goods_id=get_extension_goods($catinfo['allson'],1);
        if(!empty($catinfo['allson']))$where['g.cat_id']  = array('in',$catinfo['allson']);
        if(!empty($extension_goods_id))$where['g.id']  = array('in',$extension_goods_id);
        if(!empty($where)){$where['_logic'] = 'or';$map['_complex'] = $where;}else{$map['g.cat_id']=$catid;}
    }
    if($is_search!='all')$map['a.is_search']=$is_search;
    $map['a.type_id']=array('in',$type_id);
    $map['a.status']=1;
    $map['g.status']=1;
    $allattr=M('GoodsAttr')->alias('ga')->JOIN('LEFT JOIN __GOODS__ as g on g.id=ga.goods_id')->JOIN('LEFT JOIN __GOODS_ATTRIBUTE__ as a on a.id=ga.attr_id')->where($map)->field('ga.*,a.name,a.options,a.type')->select();
    $attribute=array();
    $goodsattr=array();
    foreach($allattr as $k=>$v){
        if($v['type']=='checkbox'){
            $attribute[]='p'.$v['attr_id'];
            $goodsattr[$v['attr_id']]['id']=$v['attr_id'];
            $goodsattr[$v['attr_id']]['type_id']=$type_id;
            $goodsattr[$v['attr_id']]['name']=$v['name'];
            $v_o=strtoarray($v['options']);
            if($v_o[$v['attr_value']]){
                $goodsattr[$v['attr_id']]['options'][$v['attr_value']]=$v_o[$v['attr_value']];
            }
        }
    }
    $content[0]=$attribute;
    $content[1]=$goodsattr;
    S($cachename,$content);
    return $content[$return];
}
function get_cate_type($catid){
    if(empty($catid)) return false;
    GLOBAL $GoodsCategory;
    $catinfo=$GoodsCategory[$catid]; 
    if($catinfo['type_id']){
        return $catinfo['type_id'];
    }else{
        $all=$catinfo['allparent'].','.$catinfo['allson'];
        $parent=array_filter(array_unique(explode(',',$all)));
        $catinfo['types']='';
        foreach($parent as $v){
            if($GoodsCategory[$v]['type_id']){
                $catinfo['types'][]=$GoodsCategory[$v]['type_id'];
            }
        }
        return $catinfo['types'];
    }
}
function get_extension_attr($id,$value){
    if(empty($id) || empty($value)) return false;
    $where['attr_id']=$id;
    $where['_string']="FIND_IN_SET('".$value."',attr_value)";
    $ids=M('GoodsAttr')->where($where)->field('goods_id')->cache(true)->select();
    $idsarr=array();
    foreach($ids as $val){
        $idsarr[]= $val['goods_id'];
    }
    return db_create_in($idsarr, 'a.id');
}
function checkliveroom(){
    $return = array('status'=>0,'msg'=>'请输入房间号');
    $AppId=isset($_SERVER['HTTP_X_APICLOUD_APPID'])?$_SERVER['HTTP_X_APICLOUD_APPID']:0;
    $AppKey=isset($_SERVER['HTTP_X_APICLOUD_APPKEY'])?$_SERVER['HTTP_X_APICLOUD_APPKEY']:0;
    if($AppId&&$AppKey){
        $roomnumber=I('room_id');
    }else{
        $roomnumber = session('roomnumber');
    }
    if(empty($roomnumber))return $return;
    $map['roomnumber'] = $roomnumber;
    $map['status'] = 1;
    $roominfo = M('LiveAnchor')->where($map)->cache(true)->field(true)->find();
    if(!$roominfo){
        $return['msg'] = '房间不存在或者已被禁用';
        return $return;
    }
    $sensitive_words = session('sensitive_words');
    if(empty($sensitive_words)){
        $sensitive_words = idtoname('sensitive_words','LiveSet','value','name');
        session('sensitive_words',$sensitive_words);
    }
    $return = array();
    $return['status'] = 1;
    $return['roominfo'] = $roominfo;
    $return['sensitive_words'] = $sensitive_words;
    return $return;
}
function get_balance_price($order_id){
    $root=array();
    if(empty($order_id)){return false;}
    $price=0;
    $map['id']=$order_id;
    $order_info=M("OrderInfo")->where($map)->field('shop_id,order_amount,goods_amount,goods_allmoney')->find();
    $o_where['order_id'] = array("like", "%," . $order_id . ",%");
    $pay_info = M("PayLog")->where($o_where)->field(true)->find();
    $og_map['order_id']=$order_id;
    $og_map['status']=array("elt",2);
    $orgoods=M('OrderGoods')->where($og_map)->field('shop_id,goods_id,goods_price,goods_number')->select();
    $save_price=0;
    $goods_rate=0;
    $real_rate=0;
    if($orgoods) {
        foreach ($orgoods as $val) {
            $goods_price = $val['goods_price'] * $val['goods_number'];
            $g_map['is_referral']=1;
            $g_map['id']=$val['goods_id'];
            $save_id=M("Goods")->where($g_map)->count();
            if (!empty($val['shop_id'])) {
                $map['shop_id'] = $val['shop_id'];
                $map['id'] = $val['goods_id'];
                $goods_cate = M("Goods")->where($map)->getField('cat_id');
                if ($goods_cate > 0) {
                    $balance_rate = D("Common/GoodsCategory")->get_parent_pid($goods_cate);
                }
                $goods_rate+=($goods_price - $goods_price * $pay_info['use_score_money'] / $order_info['goods_allmoney']) * $balance_rate/100;
                if($save_id>0){
                    $real_rate+=($goods_price - $goods_price * $pay_info['use_score_money'] / $order_info['goods_allmoney']) * $balance_rate/100;
                }
            } else {
                if (!empty($val['goods_attr'])) {
                    $goods_attr_data = unserialize($val['goods_attr']);
                    $where['id'] = array('in', explode('_', $goods_attr_data['key']));
                    $add_shop_balance = M('GoodsAttr')->where($where)->getField('sum(supplier_price)');
                }
                $supply_price = idtoname($val['goods_id'], 'Goods', 'supply_price', 'id', false);
                $price += ($add_shop_balance + $supply_price) * $val['goods_number'];
            }
        }
        if($order_info['shop_id']>0){
            $real_money=format_decimal($order_info['order_amount']*$goods_rate/$order_info['goods_allmoney']);
            $root['real_money']=format_decimal($order_info['order_amount']*$real_rate/$order_info['goods_allmoney']);
            $root['price']=format_decimal($order_info['order_amount']-$real_money);
        }else{
            $root['price']=$price;
            $root['real_money']=format_decimal($order_info['order_amount']-$price);
        }
    }else{
        return false;
    }
    return $root;
}
function get_balance_new_price($order_id){
    $root=array();
    if(empty($order_id)){return false;}
    $price=0;
    $map['id']=$order_id;
    $order_info=M("OrderInfo")->where($map)->field('shop_id,order_amount,goods_amount,goods_allmoney,discount')->find();
    $o_where['order_id'] = array("like", "%," . $order_id . ",%");
    $pay_info = M("PayLog")->where($o_where)->field(true)->find();
    $og_map['order_id']=$order_id;
    $og_map['status']=array("elt",2);
    $orgoods=M('OrderGoods')->where($og_map)->field('shop_id,goods_id,goods_price,goods_attr,goods_number,is_pro_enable,supply_price')->select();
    $original_balance_price=0;
    $promot_total_price=0;
    foreach($orgoods as $key=>$val){
        $goods_price = $val['goods_price'] * $val['goods_number'];
        if(!empty($val['shop_id'])) {
            $balance_rate = $val['supply_price'];
            $original_balance_price+=$goods_price*(1-$balance_rate/100);
            $p_where['id'] = $val['promot_id'];
            $p_where['shop_id'] = $val['shop_id'];
            $promot_info = M("PromotAct")->where($p_where)->find();
            if ($promot_info['act_type'] == 2) {
                $promot_price = $goods_price * (1 - ($promot_info['act_type_ext'] / 10));
            } else {
                $promot_price = $promot_info['act_type_ext'];
            }
            if ($val['is_pro_enable']) {
                $promot_total_price += $promot_price;
            }
            $b_map = array();
            $b_map['id'] = $val['bonus_id'];
            $b_map['shop_id'] = $val['shop_id'];
            $bonus = M("MemberBonus")->where($b_map)->getField('money');
            if ($val['is_bonus_enable']) {
                $bonus += $bonus;
            }
        }else{
            $price += $val['supply_price'];
        }
    }
    if(!empty($order_info['shop_id'])) {
        if ($order_info['discount'] - $promot_total_price < 0) {
            $promot_real_price = 0;
        } else {
            $promot_real_price = $order_info['discount'] - $promot_total_price;
        }
        if ($order_info['bonus_money'] - $bonus < 0) {
            $bonus_real_price = 0;
        } else {
            $bonus_real_price = $order_info['bonus_money'] - $bonus;
        }
        $balance_price = $original_balance_price - $promot_real_price - $bonus_real_price + $order_info['delivery_fee'];
        $root['price'] = $balance_price;
        $root['real_money'] = $order_info['goods_allmoney'] - $balance_price - $order_info['used_score_money'];
    }else{
        $root['price']=$price;
        $root['real_money']=$price;
    }
    return $root;
}
function shop_balancetype($key='',$field=''){
    $array=array(
    1=>array('field'=>'total_revenues','name'=>'营业总额'),
    2=>array('field'=>'unbalance','name'=>'未结算金额'),
    3=>array('field'=>'onbalance','name'=>'待结算金额'),
    4=>array('field'=>'freeze_price','name'=>'冻结资金 '),
    5=>array('field'=>'deduct_price','name'=>'代扣服务费 '),
    6=>array('field'=>'sale_total_money','name'=>'销售总额 '),
    );
    if(empty($key) && empty($field))return $array;
    if(!empty($key) && empty($field))return $array[$key]['name'];
    if(!empty($key) && !empty($field))return $array[$key][$field];
    return false;
}
function shop_balance_log($shop_id, $change_money=0, $type=0, $status=4, $change_desc='', $order_info='',$adminid=0){
    $allowfields=shop_balancetype();
    if(empty($allowfields) || !is_array($allowfields))return false;
	if(empty($shop_id) || empty($change_money) || floatval($change_money)==0 || empty($allowfields[$type]))return false;
	$field=$allowfields[$type]['field'];
	$Shop=M('Shops');$where=array();$where['id']=$shop_id;
    $shop_info=$Shop->where($where)->count();
	if (!$shop_info)return false;
	$change_money=format_decimal($change_money,2,2);
    if ($change_money>0) {
		$Shop->where($where)->setInc($field,$change_money);
		$log_data['change_type']=0;
		$log_data['change_num']=$change_money;
    }else{
        $Shop->where($where)->setDec($field,-$change_money);
		$log_data['change_type']=1;
		$log_data['change_num']=-$change_money;
    }
    $log_data['shop_id']=$shop_id;
	$log_data['type']=$type;
    $log_data['end_num']=$Shop->where("`id`='".$shop_id."'")->getField($field);
	$log_data['status']=$status;
	$log_data['adminid']=$adminid;
    $log_data['order_id']=$order_info['id']?$order_info['id']:0;
    $log_data['change_time']=NOW_TIME;
    if($change_desc){
        $log_data['change_desc']=$change_desc;
    }else{
        if($change_money>0){
            if($order_info){
                $log_data['change_desc']='订单'.$order_info['order_sn'].'结算入账'.$change_money;
            }else{
                $log_data['change_desc']='入账'.$change_money;
            }
        }else{
            if($order_info){
                $log_data['change_desc']='订单'.$order_info['order_sn'].'支出'.-$change_money;
            }else{
                $log_data['change_desc']='支出'.-$change_money;
            }
        }
    }
    $result = M('ShopbalanceLog')->add($log_data);
    return $result;
}
function give_shop_balance($order_id){
    if(empty($order_id)){return false;}
    $order_info=idtoname($order_id,'OrderInfo','*');
    $price_info=get_balance_new_price($order_id);
    if(!$price_info)return false;
    $deduct_price=0;
    if($order_info['shop_id']){        
      $s_map['id']=$order_info['shop_id'];
      $deduct_price=M("Shops")->where($s_map)->getField("deduct_price");
      if($deduct_price<=$price_info['price']){
            $money=$deduct_price;
            $price=$price_info['price']-$money;
          $data['deduct_price']=0;
          $rel=M("Shops")->where($s_map)->save($data);
        }else{
            $money=$price_info['price'];
            $deduct_price=$deduct_price-$price_info['price'];
            $data['deduct_price']=$deduct_price;
            $rel=M("Shops")->where($s_map)->save($data);
            $price=0;
        }
        shop_balance_log($order_info['shop_id'],-$price,2,3,'订单'.$order_info['order_sn'].'收货,因扣除'.$money.'店铺待扣服务费,未结算总额减少', $order_info);
        if(C('IS_BALANCE')){
            shop_balance_log($order_info['shop_id'],$price,1,3,'订单'.$order_info['order_sn'].'收货,因扣除'.$money.'店铺待扣服务费,营业总额增加', $order_info);
        }else{
            shop_balance_log($order_info['shop_id'],$price,3,3,'订单'.$order_info['order_sn'].'收货,因扣除'.$money.'店铺待扣服务费,待结算总额增加', $order_info);
        }
    }
    return true;
}
function deduct_money($shop_id){
    $map['o.shop_id']=$shop_id;
    $map['o.publish_wait']=1;
    $map['g.type']=3;
    $label_info=M("ProjectLabelLink")->alias('o')->where($map)->JOIN('LEFT JOIN __PROJECT_LABEL__ g ON o.label_id=g.id')->field("o.*,o.id as id, g.label_name")->select();
    $total_price=0;
    if($label_info) {
        foreach ($label_info as $key => $val) {
            $total_price += $val['deposit'];
        }
        $s_map['id']=$shop_id;
        $data['deduct_price']=$total_price;
        $rel=M("Shops")->where($s_map)->save($data);
        if($rel){
            return true;
        }else{
            return false;
        }
    }else{
        return false;
    }
}
function get_suppliers_balance($order_id){
    if(empty($order_id)){return false;}
    $map['order_id']=$order_id;
    $order_goods=M("OrderGoods")->where($map)->field(true)->select();
    $price=0;
    foreach($order_goods as $key=>$val){
        if (!empty($val['suppliers_id'])) {
            if (!empty($val['goods_attr'])) {
                $goods_attr_data = unserialize($val['goods_attr']);
                $where['id'] = array('in', explode('_', $goods_attr_data['key']));
                $add_shop_balance = M('GoodsAttr')->where($where)->getField('sum(supplier_price)');
            }
            $supply_price = idtoname($val['goods_id'], 'Goods', 'supply_price', 'id', false);
            $price = ($add_shop_balance + $supply_price) * $val['goods_number'];
            $sup_map['money']=$price;
            $where['id']=$val['suppliers_id'];
            M("Suppliers")->where($where)->save($sup_map);
        }
    }
    return true;
}
function affiliate($order_id){
    if (empty($order_id)) {return false;}
    $affiliate = unserialize(C('AFFILIATE'));
    if($affiliate['config']['expire_unit'] == 1){
        $date_ss =strtotime("-".$affiliate['config']['expire']."hours");
        $end_time =strtotime("+".$affiliate['config']['bonu_expire']."hours");
    }elseif($affiliate['config']['expire_unit'] == 2){
        $date_ss =strtotime("-".$affiliate['config']['expire']."days");
        $end_time =strtotime("+".$affiliate['config']['bonu_expire']."days");
    }elseif($affiliate['config']['expire_unit'] == 3){
        $date_ss =strtotime("-".$affiliate['config']['expire']."week");
        $end_time =strtotime("+".$affiliate['config']['bonu_expire']."week");
    }
    $order_info=idtoname($order_id,'OrderInfo','*');
    $uidinfo = idtoname($order_info['uid'],'Member','parent_id,reg_time');
    $tui_uid=$uidinfo['parent_id'];
    $re_time=$uidinfo['reg_time'];
    $result='';
    $not_affiliate=0;
    $not_scores=0;
    $balance_price=get_balance_new_price($order_id);
    $affiliate_price=$balance_price['real_money'];
    $rank_info=ex_ranks($order_info['uid']);
    foreach($affiliate['item'] as $key=>$val){
        $affiliate['item'][$key]['tui_id']=$rank_info[$key]['id'];
    }
    foreach($affiliate['item'] as $k=>$v){
        if(empty($v['tui_id'])) continue;
        if($affiliate_price){
            $condition = is_fx($v['tui_id']);
            $point=format_decimal($affiliate_price*$v['level_point']/100,0,2);
            $money=format_decimal($affiliate_price*$v['level_money']/100,2,2);
            if($condition){
              $result+=affiliate_log($order_id,1,$v['tui_id'],$money,$point,'被推荐人('.idtoname($order_info['uid'],'Member','username').')下单，将赠'.$k.'级('.idtoname($v['tui_id'],'Member','username').')推荐人，可用余额：'.$money.'元，积分：'.$point);
            }else{
              $result+=affiliate_log($order_id,1,$v['tui_id'],0,0,'被推荐人('.idtoname($order_info['uid'],'Member','username').')下单，将赠'.$k.'级('.idtoname($v['tui_id'],'Member','username').')推荐人，可用余额：0元，积分：0');
            }
        }
    }
    $result=$result?$result:'';
    return $result;
}
function affiliate_yes($order_id){
    $map['order_id']=$order_id;
    $map['status']=2;
    $num=M('OrderGoods')->where($map)->count();
    if($num > 0){
        $orderinfo=idtoname($order_id,'OrderInfo','order_sn,uid');
        $orderusername=idtoname($orderinfo['uid'],'Member','username');
        $maps['order_id']=$order_id;
        $maps['is_separate']=0;
        $aff_info=M('AffiliateLog')->field('id,uid,money,point')->where($maps)->select();
        $result=0;
        foreach($aff_info as $v){
            account_change($v['uid'],$v['money'],1,5,'被推荐人'.$orderusername.'确认订单'.$orderinfo['order_sn'].'收货完毕，得到余额分成');
            account_change($v['uid'],$v['point'],4,5,'被推荐人'.$orderusername.'确认订单'.$orderinfo['order_sn'].'收货完毕，得到积分分成');
            $map_st['id']=$v['id'];
            $data['is_separate']=1;
            $result += M('AffiliateLog')->where($map_st)->save($data);
        }
        return $result;
    }else{return false;}
}
function affiliate_log($order_id,$separate_type,$tui_uid='',$money='',$point='',$desc=''){
    $ex_data['order_id']=$order_id;
    $ex_data['separate_type']=$separate_type;
    $ex_data['uid']=$tui_uid?$tui_uid:0;
    $ex_data['money']=$money;
    $ex_data['point']=$point;
    $ex_data['desc']=$desc;
    $ex_data['is_separate']=0;
    $ex_data['addtime']=time();
    $ex_data['time']=cookie('tui_time');
    $info=M('AffiliateLog')->add($ex_data);
    return $info;
}
function ex_ranks($id){
    $rank_p=array();
    $where3['id']=$id;
    $rank_p[1]=M('Member')->where($where3)->getField('parent_id');
    if(!empty($rank_p[1])){
        $where2['id']=$rank_p[1];
        $rank_p[2]=M('Member')->where($where2)->getField('parent_id');
    }
    if(!empty($rank_p[2])){
        $where1['id']=$rank_p[2];
        $rank_p[3]=M('Member')->where($where1)->getField('parent_id');
    }
    if(!empty($rank_p[3])){
        $where1['id']=$rank_p[3];
        $rank_p[4]=M('Member')->where($where1)->getField('parent_id');
    }
    if(!empty($rank_p[4])){
        $where1['id']=$rank_p[4];
        $rank_p[5]=M('Member')->where($where1)->getField('parent_id');
    }
    if(!empty($rank_p[5])){
        $where1['id']=$rank_p[5];
        $rank_p[6]=M('Member')->where($where1)->getField('parent_id');
    }
    $rank_p=array_filter($rank_p);
    if(empty($rank_p))return false;
    foreach($rank_p as $key=>$val){
        $rank_info[$key]=idtoname($val,'Member','*');
    }
    return $rank_info;	
}
function user_ranks($uid=0){
    if(empty($uid))return false;
    $map['id']=$uid;
    $map['status']=1;
    $member_info=M('Member')->where($map)->field('rank_id,points')->find();
    if(!$member_info) return false;
    $where['status']=1;
    $where['min_points']=array('elt',$member_info['points']);
    $where['max_points']=array('egt',$member_info['points']);
    $rank_id=M('MemberRank')->where($where)->getField('id');
    if($rank_id>0 && $rank_id!=$member_info['rank_id']){		
        $data['rank_id']=$rank_id;
        M('Member')->where($map)->save($data);
        updatesession($uid);
    }
}
function count_tui($pid){
    $map['parent_id']=$pid;
    $result=M('Member')->where($map)->count();
    return $result;
}
function get_openid($openid = NULL) {
    if ($openid !== NULL) {
        session ( 'openid', $openid );
    } elseif (! empty ( $_REQUEST ['openid'] )) {
        $openid= $_REQUEST ['openid'];session ( 'openid',$openid);
    }
    $isWeixinBrowser = is_weixin();
    if (empty ( $openid ) && $isWeixinBrowser && C('WX_TYPE')==4) {
        $callback = GetCurUrl ();
        OAuthWeixin ( $callback );
    }	
    if (empty ( $openid )) {return - 1;}	
    return $openid;
}
function OAuthWeixin($callback) {
    $isWeixinBrowser = is_weixin();
    $info['appid'] = C('WX_APPID');
    $info ['secret'] = C('WX_APPSECRET');
    if (! $isWeixinBrowser || empty ( $info ['appid'] )) {
        redirect ( $callback . '&openid=-1' );
    }
    $param ['appid'] = $info ['appid'];
    if (! isset ( $_GET ['getOpenId'] )) {
        $param ['redirect_uri'] = $callback . '&getOpenId=1';
        $param ['response_type'] = 'code';
        $param ['scope'] = 'snsapi_base';
        $param ['state'] = 'hanchaowx';
        $url = 'https://open.weixin.qq.com/connect/oauth2/authorize?' . http_build_query ( $param ) . '#wechat_redirect';
        redirect ( $url );
    } elseif ($_GET ['state']) {
        $param ['secret'] = $info ['secret'];
        $param ['code'] = I ( 'code' );
        $param ['grant_type'] = 'authorization_code';
        $url = 'https://api.weixin.qq.com/sns/oauth2/access_token?' . http_build_query ( $param );
        $content = curlget ( $url );
        $content = json_decode ( $content, true );
        redirect ( $callback . '&openid=' . $content ['openid'] );
    }
}
function GetCurUrl() {
    $url = 'http://';
    if (isset ( $_SERVER ['HTTPS'] ) && $_SERVER ['HTTPS'] == 'on') {
        $url = 'https://';
    }
    if ($_SERVER ['SERVER_PORT'] != '80') {
        $url .= $_SERVER ['HTTP_HOST'] . ':' . $_SERVER ['SERVER_PORT'] . $_SERVER ['REQUEST_URI'];
    } else {
        $url .= $_SERVER ['HTTP_HOST'] . $_SERVER ['REQUEST_URI'];
    }
    if (stripos ( $url, '?' ) === false) {
        $url .= '?t=' . time ();
    }
    return $url;
}
function thumb($imgurl, $width = 100, $height = 100, $smallpic = 'nopic.gif',$domain=true ,$water='auto',$autocut = 0) {
    $nopic=$domain?'http://'.$_SERVER['HTTP_HOST'].__ROOT__.'/'.'Public/images/'.$smallpic:'Public/images/'.$smallpic;
    if(empty($imgurl))return $nopic;
    if(str_exists($imgurl,'http://')){
        $imgurl_temp='uploads/thumb/'.md5($imgurl).'.'.fileext($imgurl);
        if(!file_exists(ROOT_PATH.'/'.$imgurl_temp)){oaofile($imgurl_temp,curlget($imgurl));}
        if(file_exists(ROOT_PATH.'/'.$imgurl_temp))$imgurl=$imgurl_temp;
    }
    if($width==0 && $height==0)return format_url($imgurl,$domain);
    $imgurl=format_url($imgurl,2);
    if(!file_exists($imgurl)) return $nopic;
    $newimgurl = 'uploads/thumb/thumb_'.$width.'_'.$height.'_'.basename($imgurl);
    if(file_exists($newimgurl))return format_url($newimgurl,$domain);
    $image = new \Common\Vendor\Image(); 
    $image->open($imgurl);
    $base_width = $image->width(); 
    $base_height = $image->height(); 
    if($width==$base_width && $height==$base_height)return format_url($imgurl,$domain);
    if($width<=0)$width=100;if($height<=0)$height=100;
    if($autocut)$image->thumb($width, $height,\Common\Vendor\Image::IMAGE_THUMB_CENTER)->save($newimgurl);
    else $image->thumb($width, $height,\Common\Vendor\Image::IMAGE_THUMB_FILLED)->save($newimgurl);    
    $w_str='';$w_arr=array();$warter_value_config=C('THUMB_VALUE');$water_touming=C('THUMB_TOUMING');$water_p=C('THUMB_PALACE');
    if($water=='auto'){$is_water=C('THUMB_TYPE');if($is_water==2){$w_str=$is_water."|".$warter_value_config;}
    }else if($water==1)$is_water=1;else{$w_str=$water;$is_water=2;}
    if($w_str){$w_arr=explode('|',$w_str);$is_water=$w_arr[0];
    $warter_value=!empty($w_arr[1])?$w_arr[1]:'HANCHAO';
    $warter_size=!empty($w_arr[2])?$w_arr[2]:'14';
    $warter_color=!empty($w_arr[3])?$w_arr[3]:'#cccccc';
    $warter_fonts=!empty($w_arr[4])?$w_arr[4]:'warter.ttf';}
    if(empty($warter_value))$warter_value=$warter_value_config;    
    if(!$water_touming)$water_touming=80;  $warter_image=C('IMAGE_WATERMARK');  
    if($is_water==1 && $warter_image && str_exists($warter_image,'.')){
        $image->open($newimgurl)->water($warter_image,$water_p,$water_touming)->save($newimgurl);
    }
    if($is_water==2 && $warter_value){
        if($warter_fonts)$warter_fonts='Public/fonts/'.$warter_fonts;
        $image->open($newimgurl)->text($warter_value,$warter_fonts,$warter_size,$warter_color,$water_p)->save($newimgurl); 
    }
    return format_url($newimgurl,$domain);
}
function get_arearegion_cache($region = 0) {
    $data = array();
    $datatype=array('other','region','general','letter');
    $regionUrl = ROOT_PATH.'/Public/data/arearegiondata.json';
    if(!file_exists($regionUrl)) return $data;
    $data = file_get_contents($regionUrl);
    if(!empty($data))$data = json_decode($data,true);
    if($region==0){
        unset($data['region'],$data['general'],$data['letter']);
    }else{
        return $data[$datatype[$region]];
    }
    return $data;
}
function get_current_cate($cat_id = 0){
    if(empty($cat_id))$cat_id=0;
    $map['pid']=$cat_id;
    $cate=M('GoodsCategory')->where($map)->select();
    $info=array();
    if (!empty($cate)) {
        if($cat_id==0)$info['name']='全部分类';
        else $info=idtoname($cat_id,'GoodsCategory','*','id');
        $info['child']=$cate;
        $info['hover']=1;
        $data[]=$info;
    }else{
        $info=idtoname($cat_id,'GoodsCategory','*','id');
        $pre_info=idtoname($info['pid'],'GoodsCategory','*','id');
        $wher['pid']=$info['pid'];
        $catt=M('GoodsCategory')->where($wher)->select();
        foreach ($catt as $key => $val) {
            if($val['id']==$cat_id){
                $catt[$key]['hover']=1;
            }
        }
        $pre_info['hover']=1;
        $pre_info['child']=$catt;
        $data[]=$pre_info;
    }
    return $data;
}
function get_goodslabel_list(){
    $map=array();
    $map['status']=1;
    $map['type']=0;
    $labels=M('ProjectLabel')->where($map)->field('id,label_name')->select();
    return $labels;
}
function check_delete($id,$type,$code='',$field='pid',$msg=''){
    $return=array('status'=>0);
    if(!intval($id)||!intval($type)){$return['info']='参数错误';return $return;}
    $type=intval($type);
    switch($type){
        case "1":
            if($code=='rank'){
                $map=array();
                $map['rank_id']=$id;
                $count=M('Member')->where($map)->count();
                if(!empty($count)){$return['info']='会员已绑定此等级,不可删除';return $return;}
            }else{
                $map=array();
                $map['uid']=$id;
                $count=M('Shops')->where($map)->count();
                if(!empty($count)){$return['info']='请先删除会员下的店铺';return $return;}
                $count=M('OrderInfo')->where($map)->count('id');
                if(!empty($count)){$return['info']='请先清空会员下的订单';return $return;}
            }        
        break;
        case "2":
            if($code=='rank'){
                $map=array();
                $map['rank']=$id;
                $count=M('Shops')->where($map)->count();
                if(!empty($count)){$return['info']='店铺已绑定此等级,不可删除';return $return;}
            }else{
                $map=array();
                $map['shop_id']=$id;
                $count=M('Goods')->where($map)->count();
                if(!empty($count)){$return['info']='请先清除店铺下的商品';return $return;}
                $map['status']=array('lt',3);
                $count=M('OrderInfo')->where($map)->count();
                if(!empty($count)){$return['info']='有未完成的订单,不可删除';return $return;}
            }
        break;
        case "3":
            $map=array();
            $map['id']=$id;
            $map['status']=array('lt',3);
            $count=M('OrderInfo')->where($map)->count();
            if(!empty($count)){$return['info']='订单未完结,不可删除';return $return;}
        break;
        case "4":
            if($code=='cate'){
                $map=array();
                $map['pid']=$id;
                $count_cate=M('GoodsCategory')->where($map)->count();
                if(!empty($count_cate)){$return['info']='请先清除子分类';return $return;}
                $map=array();
                $map['cat_id']=$id;
                $count=M('Goods')->where($map)->count();
                if(!empty($count)){$return['info']='分类下绑定了商品,无法删除';return $return;}
            }else{
                $map=array();
                $map['goods_id']=$id;
                $order_ids=M('OrderGoods')->where($map)->getField('order_id',true);
                if($order_ids){
                    $map=array();
                    $map['id']=array('in',$order_ids);
                    $map['status']=array('lt',3);
                    $count=M('OrderInfo')->where($map)->getField('id',true);
                    if(!empty($count)){$return['info']='此商品关联未完结订单,不可删除('.implode(',',$count).')';return $return;}
                }            
           }
        break;
        case "8":
            $map=array();
            $map['id']=$id;
            $promote_info=M("PromotAct")->where($map)->field(true)->find();
            if( $promote_info['is_limit_time']==1){
                $map=array();
                $map['promote_id']=$id;
                $map['status'] = 1;
                $map['publish_wait'] = 1;
                $map['is_delete'] = 0;
                $count=M('Goods')->where($map)->count();
                if(!empty($count)){$return['info']='请先清除活动下的商品';return $return;}
            }else if( $promote_info['is_pt']==1){
    			$map=array();
    			$map['act_id'] = $id;
    			$goods_id = M('PromotExt')->where($map)->order('id desc')->getField('style_ext_id');
    			$save['pt_id'] = 0;
    			$update = M('Goods')->where('id='.$goods_id)->save($save);
    			if(!empty($count)){$return['info']='请先清除活动下的商品';return $return;}
    		}else{
                $map=array();
                $map['type']=3;
                $map['type_value']=$id;
                $count=M('Bonu')->where($map)->count();
                if(!empty($count)){$return['info']='请先清除活动下的代金券';return $return;}
            }
        break;
        case "9":
            $map=array();
            $map['label_id']=$id;
            $map['shop_id']=array('gt',0);
            $count=M('ProjectLabelLink')->where($map)->count('id');
            if(!empty($count)){$return['info']='已有商铺加入此服务,不可删除';return $return;}
        break;
        case "10":
            $map=array();
            $map['promote_id']=$id;
            $map['status'] = 1;
            $map['publish_wait'] = 1;
            $map['is_delete'] = 0;
            $count=M('Goods')->where($map)->count('id');
            if(!empty($count)){$return['info']='请先清除活动下的商品';return $return;}        
        break;        
        default:
            if(empty($field)){$return['info']='参数错误';return $return;}
            if(empty($msg))$msg='请先清除子类';
            $map=array();
            $map[$field]=is_array($id) || str_exists($id,',')?array('in',$id):$id;
            $count=M($code)->where($map)->count();
            if(!empty($count)){$return['info']=$msg;return $return;}
        break;
    }
    $return['status']=1;
    return $return;
}
function get_goodslabel_url($labelid,$param=''){
    if(empty($param))$param=I('label');
    $paramarr=empty($param)?array():explode(',',$param);
    if($labelid && in_array($labelid,$paramarr)){
        $key = array_search($labelid, $paramarr);unset($paramarr[$key]);
    }else{
        $paramarr[]=$labelid;
    }
    sort($paramarr);
    return geturl('Cate/index',array('label'=>implode(',',$paramarr)),true,true,true);
}
function goods_footprint($uid,$goods_id){
    if(!uid || !$goods_id) return false;
    $value=session($uid+'_footer_history');
    $num=C('BROWSING_HISTORY_NUM')?C('BROWSING_HISTORY_NUM'):10;
    if(!in_array($goods_id,$value)){
        if(count($value)>=$num)array_shift($value);
        $value[]=$goods_id;
        $value=array_filter(array_unique($value));
        session($uid+"_footer_history",$value);
    }
    return true;
}
function get_price_map($catid='',$price=''){
    $return=array();
    GLOBAL $GoodsCategory;$catinfo=$GoodsCategory[$catid];
    if(empty($catinfo)) return $return;
    if ($catinfo['grade'] > 1) {
        $pricelist = get_grade_price($catinfo, $catid);
        $return['pricelist'] = $pricelist;
        if (!empty($price) && !empty($pricelist)) {
            $pricedata = $pricelist[$price];
            if (!empty($pricedata)) {
                if (str_exists($pricedata, '-')) {
                    $pricearr = explode('-', str_replace('&nbsp;', '', $pricedata));
                    $return['shop_price'][] = array('EGT', $pricearr[0]);
                    $return['shop_price'][] = array('elt', $pricearr[1]);
                } else if (str_exists($pricedata, '以上')) {
                    $return['shop_price'] = array('EGT', str_replace('以上', '', $pricedata));
                }
            }
        }
    }
    return $return;
}
function get_grade_price($cat,$catid=''){
    if(empty($catid)) return false;
    $map=array();
    $map['g.status']=1;
    $map['g.publish_wait']=1;
    $map['g.is_delete']=0;
    GLOBAL $GoodsCategory;
    $catinfo = $GoodsCategory[$catid];
    $extension_goods=get_extension_goods($catinfo['allson'],1);
    $whereor['g.cat_id']=array('in',$catinfo['allson']);
    if($extension_goods)$whereor['g.id']=array('in',$extension_goods);
    $whereor['_logic'] = 'or';
    $map['_complex'] = $whereor;
    $row = M('Goods')->alias('g')->field('min(g.shop_price) AS min, max(g.shop_price) AS max')->where($map)->find();
    $price_grade = 0.0001;
    for($i=-2; $i<= log10($row['max']); $i++){$price_grade *= 10;}      
    $dx = ceil(($row['max'] - $row['min']) / ($cat['grade']) / $price_grade) * $price_grade;
    if($dx == 0){$dx = $price_grade;}   
    for($i = 1; $row['min'] > $dx * $i; $i ++);
    for($j = 1; $row['min'] > $dx * ($i-1) + $price_grade * $j; $j++);
    $row['min'] = $dx * ($i-1) + $price_grade * ($j - 1);
    for(; $row['max'] >= $dx * $i; $i ++);
    $row['max'] = $dx * ($i) + $price_grade * ($j - 1);
    $price_grade = M('Goods')->alias('g')->field('(FLOOR((g.shop_price - '.$row['min'].') / '.$dx.')) AS sn, COUNT(*) AS goods_num')->where($map)->group('sn')->select();
    foreach ($price_grade as $key=>$val){
        $temp_key = $key + 1;
        $price_grade[$temp_key]['goods_num'] = $val['goods_num'];
        $price_grade[$temp_key]['start'] = $row['min'] + round($dx * $val['sn']);
        $price_grade[$temp_key]['end'] = $row['min'] + round($dx * ($val['sn'] + 1));
        $price_grade[$temp_key]['price_range'] = $price_grade[$temp_key]['start'] . '&nbsp;-&nbsp;' . $price_grade[$temp_key]['end'];
        $price_grade[$temp_key]['formated_start'] = number_format($price_grade[$temp_key]['start'] ,2, '.', '');
        $price_grade[$temp_key]['formated_end'] = number_format($price_grade[$temp_key]['end'],2, '.', '');
        $price_grade[$temp_key]['url'] = U('Cate/Index', array('cid'=>$cat_id, 'bid'=>$brand, 'price_min'=>$price_grade[$temp_key]['start'], 'price_max'=> $price_grade[$temp_key]['end'], 'filter_attr'=>$filter_attr_str));
        if (isset($_REQUEST['price_min']) && $price_grade[$temp_key]['start'] == $price_min && $price_grade[$temp_key]['end'] == $price_max){
            $price_grade[$temp_key]['selected'] = 1;
        }else{
            $price_grade[$temp_key]['selected'] = 0;
        }
        $pricelist[$temp_key] = $price_grade[$temp_key]['price_range'];
    }
    return $pricelist;
}
function get_online_bonus($shop_id=0,$user_id=0){
    $memberinfo=checkuserauthtype();
    $map=$bouns_info=array();
    if($shop_id==0){
        $map['shop_id']=0;
    }else{
        $map['shop_id']=$shop_id;
    }
    $map['bonus_type_id']=5;
    $map['used_time']=0;
    $map['user_id']=$user_id;
    $now_time=NOW_TIME;
    $map['_string']='(start_time = 0 or start_time <= '.$now_time.') and (end_time = 0 or end_time >= '.$now_time.')';
    $bouns_info=M("MemberBonus")->where($map)->select();
    return $bouns_info;
}
function is_first_open(){
    $is_first_open=session('slide_open');
    if($is_first_open){session('slide_open',2);}else{session('slide_open',1);}
    return session('slide_open');
}
function checkuserauthtype(){    
    if($_REQUEST['uid']&&$_REQUEST['token'])return idtoname($_REQUEST['uid'],'Member','*');
    $memberinfo = session('member_info');
    if($memberinfo)return $memberinfo;
    $AppId=isset($_SERVER['HTTP_X_APICLOUD_APPID'])?$_SERVER['HTTP_X_APICLOUD_APPID']:0; 
    $AppKey=isset($_SERVER['HTTP_X_APICLOUD_APPKEY'])?$_SERVER['HTTP_X_APICLOUD_APPKEY']:0;
    $return=array();
    if($AppId&&$AppKey){
        $paramdata=I('param.');
        if((!isset($paramdata['uid'])||!isset($paramdata['token']))||isset($paramdata['nologin']))return $return;
        $return['status'] = 3;
        $return['msg']='获取登录信息错误,请重新登录!';
        $paramdata['uid']=intval($paramdata['uid']);
        if(empty($paramdata['uid']) || empty($paramdata['token'])){
            echo(json_encode($return));exit;
        }
        $memberinfo=idtoname($paramdata['uid'],'Member','*','id',false);  
        $appkeyarr=explode('.',$AppKey);
        $timestamp=$appkeyarr[1];
        if(SHA1($memberinfo['password'].$timestamp)!=SHA1($paramdata['token'].$timestamp)){
            echo(json_encode($return));exit;
        }
        return $memberinfo;
    }else{
        return $return;
    }
}
function checkuseraddress($address=''){
    $cookie_time=3600*24*7;
    $AppId=isset($_SERVER['HTTP_X_APICLOUD_APPID'])?$_SERVER['HTTP_X_APICLOUD_APPID']:0; 
    $AppKey=isset($_SERVER['HTTP_X_APICLOUD_APPKEY'])?$_SERVER['HTTP_X_APICLOUD_APPKEY']:0;
    $return=array();
    if($AppId&&$AppKey){
        $paramdata=I('param.');
        if(!empty($paramdata['province']))$address_info['province'] = $paramdata['province'];
        if(!empty($paramdata['city']))$address_info['city'] = $paramdata['city'];
        if(!empty($paramdata['district']))$address_info['district'] = $paramdata['district'];
        if($address_info){
            cookie('dingwei_address',$address_info,$cookie_time);
            session('dingwei_address',$address_info);
        }
        return $address_info;
    }
    if(!empty($address)){
        cookie('dingwei_address',$address,$cookie_time);
        session('dingwei_address',$address);return $address;
    }
    $address_info_cookie = cookie('dingwei_address');
    $address_info_session = session('dingwei_address');
    if(!empty($address_info_cookie)){
        if(empty($address_info_session))session('dingwei_address',$address_info_cookie);
        return $address_info_cookie;
    }
    if(!empty($address_info_session)){
        if(empty($address_info_cookie))cookie('dingwei_address',$address_info_session,$cookie_time);
        return $address_info_cookie;
    }
}
function give_login_point($uid){
    if(!$uid)return false;
	$map=$maps=array();
    $map['uid']=$uid;
	$map['type']=4;
	$map['status']=7;
	$last_time=M('account_log')->where($map)->order('id desc')->getField('change_time');
	$last_time=strtotime(date('Y-m-d',$last_time));
	$nowtime=strtotime(date('Y-m-d',NOW_TIME));
    if($nowtime>$last_time){
        $usepoints=C('LOGIN_GAIN_SELL_INTEGRAL');
        if($usepoints>0){
            account_change($uid,$usepoints,4,7,'登录赠消费积分');
        }
    }
    $maps['uid']=$uid;
	$maps['type']=3;
	$maps['status']=8;
	$change_time=M('account_log')->where($maps)->order('id desc')->getField('change_time');
	$change_time=strtotime(date('Y-m-d',$change_time));
    if($nowtime>$change_time){
        $points=C('LOGIN_GAIN_RANK_INTEGRAL');
        if($points>0){
            account_change($uid,$points,3,8,'登录赠等级积分');
            if(C('IS_MEMBER_UPGRADE'))user_ranks($uid);
        }
    }
}
function give_register_point($uid){
    if(!$uid)return false;
    $usepoints=C('REG_GAIN_SELL_INREGRAL');
    if($usepoints>0){
        account_change($uid,$usepoints,4,9,'注册赠消费积分');
    }
    $points=C('REG_GAIN_RANK_INREGRAL');
    if($points>0){
        account_change($uid,$points,3,10,'注册赠等级积分');
        if(C('IS_MEMBER_UPGRADE'))user_ranks($uid);
    }
}
function get_forward(){
    $forward=cookie('forward')?cookie('forward'):$_SERVER['HTTP_REFERER'];
    return $forward;
}
function getpayment($is_online=1,$is_wap=0,$notin='',$in=''){
    $map=array();
    $map['status']=1;
    if($is_online)$map['is_online']=1;
    if($is_wap)$map['is_wap']=1;
    if($notin)$map['code']=array('not in',$notin);
    if($in)$map['code']=array('in',$in);
    $payment=M('Payment')->where($map)->field(true)->cache(true)->order('id asc')->select();
    foreach($payment as $k=>$v){
        $paylogo=paylogo($v['code']);
        if($paylogo)$payment[$k]['logo']=$paylogo;
        $pay = new \Common\Vendor\Pay($v['code'],$payment[$k]);
        $payment[$k]['pay_code']=$pay->get_pay_code();
    }
    return $payment;
}
function paylogo($code){
    if(empty($code))return false;
    $logo=COMMON_PATH."Vendor/Pay/Logo/".strtolower($code).".gif";    
    $backlogo=__ROOT__."/Application/Common/Vendor/Pay/Logo/".strtolower($code).".gif";
    if(file_exists($logo))return $backlogo;
    else return false;
}
function getsendment($where=""){
    $basewhere="status=1";
    if($where)$basewhere.=" and ".$where;
    $payment=M('Shipping')->where($basewhere)->field(true)->cache(true)->order('sort,id desc')->select();
    return $payment;
}
function createOrderNo($type='1') {
    $conf_code=strtoarray(C('PAY_LOGTYPE'));
    $code=substr($conf_code[$type],0,1);
    return $code.NOW_TIME.rand(1000,9999);
}
function catpos($catid,$endwidthbol='1',$modname='GoodsCategory',$urlname="Cate", $symbol=' &gt; '){
    if(empty($catid)){return '';}
    $category = getcache($modname);
    $cateinfo = $category[$catid];
    if(!isset($cateinfo)) return '';
    $pos = '';
    $pos .= '<em>'.$symbol.'</em>';
    $arrparentid = array_unique(array_filter(explode(',', $catid.','.$cateinfo['allparent'])));
    krsort ($arrparentid);$i=1;
    foreach($arrparentid as $v) {
        $url = $category[$v]['url']?$category[$v]['url']:geturl($urlname."/index",array('id'=>$v));
        $pos .= '<a href="'.$url.'" title="'.$category[$v]['name'].'">'.$category[$v]['name'].'</a>';
        if((empty($endwidthbol) && $i<count($arrparentid)) || !empty($endwidthbol))$pos .=$symbol;
        ++$i;
    }
    echo $pos;
}
function clearhomehtml($id=''){
    if(empty($id))return false;
    $config=require('Application/Home/Conf/config.php');
    if(empty($config['HTML_CACHE_ON']))return false;
    $rule=$config['HTML_CACHE_RULES']['Goods:index'][0];
    $file='Application/Html/'.str_replace('{id}',$id,$rule).$config['URL_HTML_SUFFIX'];
    if(file_exists($file)){unlink($file);}
}
function get_extension_goods($cats,$type=0){
    $cats=(!empty($cats))?array('catid'=>array('in',$cats)):$cats;
    $extension_goods_array = M('GoodsCat')->cache(true)->where($cats)->getField('goods_id',true);
    if($type)return $extension_goods_array;
    return db_create_in($extension_goods_array, 'g.id');
}
function action_log($action = null, $model = null, $record_id = null, $user_id = null,$mark=null){
    if(empty($action) || empty($model) || empty($record_id)){return '参数不能为空';}
    if(empty($user_id)){$user_id = is_login();}    
    $action_info = M('Action')->getByName($action);
    if($action_info['status'] != 1){return '该行为被禁用或删除';}
    $data['action_id']      =   $action_info['id'];
    $data['user_id']        =   $user_id;
    $data['action_ip']      =   get_client_ip(1);
    $data['model']          =   $model;
    $data['record_id']      =   $record_id;
    $data['create_time']    =   NOW_TIME;
    if(!empty($action_info['log'])){
        if(preg_match_all('/\[(\S+?)\]/', $action_info['log'], $match)){
            $log['user']    =   $user_id;
            $log['record']  =   $record_id;
            $log['model']   =   $model;
            $log['time']    =   NOW_TIME;
            $log['data']    =   array('user'=>$user_id,'model'=>$model,'record'=>$record_id,'time'=>NOW_TIME);
            foreach ($match[1] as $value){
                $param = explode('|', $value);
                if(isset($param[1])){$replace[] = call_user_func($param[1],$log[$param[0]]);
                }else{$replace[] = $log[$param[0]];}
            }$data['remark'] =   str_replace($match[0], $replace, $action_info['log']);
        }else{$data['remark'] =   $action_info['log'];}
    }else{$data['remark']     =   '操作url：'.$_SERVER['REQUEST_URI'];} 
    if(!empty($mark))$data['mark']=$mark; 
    M('ActionLog')->add($data);
    if(!empty($action_info['rule'])){
        $rules = parse_action($action, $user_id);
        $res = execute_action($rules, $action_info['id'], $user_id);
    }
}
function parse_action($action = null, $self){
    if(empty($action)){return false;}
    if(is_numeric($action)){$map = array('id'=>$action);}else{$map = array('name'=>$action);}    
    $info = M('Action')->where($map)->find();
    if(!$info || $info['status'] != 1){return false;}
    $rules = $info['rule'];
    $rules = str_replace('{$self}', $self, $rules);
    $rules = explode(';', $rules);
    $return = array();
    foreach ($rules as $key=>&$rule){
        $rule = explode('|', $rule);
        foreach ($rule as $k=>$fields){
            $field = empty($fields) ? array() : explode(':', $fields);
            if(!empty($field)){$return[$key][$field[0]] = $field[1];}
        }
        if(!array_key_exists('cycle', $return[$key]) || !array_key_exists('max', $return[$key])){
            unset($return[$key]['cycle'],$return[$key]['max']);
        }
    }
    return $return;
}
function execute_action($rules = false, $action_id = null, $user_id = null){
    if(!$rules || empty($action_id) || empty($user_id)){return false;}
    $return = true;
    foreach ($rules as $rule){
        $map = array('action_id'=>$action_id, 'user_id'=>$user_id);
        $map['create_time'] = array('gt', NOW_TIME - intval($rule['cycle']) * 3600);
        $exec_count = M('ActionLog')->where($map)->count();
        if($exec_count > $rule['max']){continue;}
        $modname=ucfirst($rule['table']);
        $Model = M($modname);
        $field = $rule['field'];
        $res = $Model->where($rule['condition'])->setField($field, array('exp', $rule['rule']));
        $fieldarr=array('points'=>'3','usepoints'=>'4','money'=>'1','frozen_money'=>'2');
        if(isset($rule['rule']) && in_array($modname,array('Member')) && in_array($field,array_keys($fieldarr))){
            $value=str_replace($field,'',$rule['rule']);            
            account_change($user_id,$value,$fieldarr[$field],5);
        }
        if(!$res){$return = false;}
    }
    return $return;
}
function is_fx($uid){
    $uid=intval($uid);
    if(empty($uid))return false;
    $val['v_id'] = C('APPLY_DISTRIBU');
    if(empty($val))return false;
    $v_id = $val['v_id'];if(empty($v_id))$v_id=1;
    if($v_id ==1)return true;
    $user = M('Member')->field('is_fx,points,rank_id')->where('id='.$uid)->find();
    if(empty($user))return false;
    if($user['is_fx']==1)return true;
    if($user['is_fx']==2)return false;
    $value = intval(C('DIS_CON'));
    if($v_id == 2){$result =$user['points']>=$value;} 
    if($v_id == 3){$result =$user['rank_id']==$value;}
    if($v_id == 4){
      if(empty($value))return false;
      $result = M('OrderInfo')->alias('a')->field('b.goods_id')->join('JOIN __ORDER_GOODS__ b ON b.order_id = a.id')->where('a.shipping_status=4 and b.status=2 and a.pay_status=3 and a.uid="'.$uid.'"and b.goods_id='.$value)->count();
    }
    if($result){
      $map=$data=array();
      $data['is_fx'] = 1;
      $map['id'] = $uid;
      M('Member')->where($map)->save($data);
    }
    return $result;
}
function tgercode($id,$is_check=1){
    $id=intval($id);
    $return =array('status'=>0,'msg'=>'');
    if(empty($id)){
        $return['msg']="参数错误!";
        return $return;
    }    
    if(empty($is_check))$$is_check=1;
    $map=array();
    $map['id']=$id;
    $map['status']=1;
    $member_info = M('Member')->where($map)->field('id,username,header_img,nickname,wxid')->find();
    if (empty($member_info)) {
        $return['msg']="会员不存在";
        return $return;
    }
    $old_f="/uploads/image/qrcode/haibao_".$id.".jpg";
    if($is_check==1 && file_exists(ROOT_PATH.$old_f)){
       $return['status']=1;
       $return['url']=format_url($old_f,1);
       return $return;
    }
    $ewm_xy = C('COORDINATE');
    $xyy = array();
    $xy = explode('|',$ewm_xy);
    foreach($xy as $it){$xyy[] = explode(',',$it);}
    unset($xy,$ewm_xy);
    $yuan_img = C('BOTTOM_IMG');if(empty($yuan_img))return false;
    $linshiimg="/uploads/image/qrcode/cache/linshi_".$id.".jpg";
    if(!file_exists(ROOT_PATH.$linshiimg))copy(ROOT_PATH.$yuan_img,ROOT_PATH.$linshiimg);
    if(!file_exists(ROOT_PATH.$linshiimg)){
         $return['msg']="生成图片失败，请重试！(000)";
         return $return;
    }
    $old_cache_f='';
    $sp = intval(C('PERMANENT'));if(empty($sp))$sp=0;
    $erwei = intval(C('ERWEIMA'));if(empty($erwei))$erwei=150;
    if(C('WX_TYPE')==4){
        $weixin = new \Common\Vendor\WeixinChat;
        if(empty($access_token))$access_token=$weixin->getdd();
        if($sp==0){
          $data = '{"action_name": "QR_LIMIT_SCENE", "action_info": {"scene": {"scene_id": '.$id.'}}}';
        }else{
          $data = '{"expire_seconds": '.$sp.',"action_name": "QR_SCENE", "action_info": {"scene": {"scene_id": '.$id.'}}}';
        }
        $rt=curlget('https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token='.$access_token,$data,"POST",array(),true);
        $json=json_decode($rt);
        $ticket = $json->ticket;
        if($ticket){
            $str = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=".urlencode($ticket);
            $img = file_get_contents($str);
            $old_cache= ROOT_PATH."/uploads/image/qrcode/cache/header_".$id.".jpg";
            if(!empty($img)){@file_put_contents($old_cache,$img);}
            $old_cache_f =thumb($old_cache,$erwei,$erwei);
        }
    }else{
        $url = U('Mobile/Login/register',array('eid'=>$id),true,true);
        $old_cache_f = phpgrcode(urlencode($url),'',5,'wximg_'.$id);
        $old_cache_f = thumb($old_cache_f,$erwei,$erwei,'nopic.gif',false);
    }
    $t = mark_img(ROOT_PATH.$linshiimg,$old_cache_f,$xyy[2][0],$xyy[2][1]);
    $touxiang = intval(C('TOUXIANG'));if(empty($touxiang))$touxiang=150;
    if($member_info['header_img']){
      $w_img = $member_info['header_img'];
      $w_img_o =thumb($w_img,$touxiang,$touxiang);
      mark_img(ROOT_PATH.$linshiimg,$w_img_o,$xyy[0][0],$xyy[0][1]);
    }
    $nickname=!empty($member_info['nickname'])?$member_info['nickname']:$member_info['username'];
    $encode = mb_detect_encoding($nickname,array("ASCII","UTF-8","GB2312","GBK","BIG5"));
    if ($encode != "UTF-8"){$nickname = iconv($encode,"UTF-8",$nickname);}
    if($xyy[1][0]=='center'){
         $length= checkStrlength($member_info['username']);
         $xyy[1][0]= floor((827 - $length)/2);   
    }
    if(mark_txt(ROOT_PATH.$linshiimg,$nickname,$xyy[1][0],$xyy[1][1])){
        rename(ROOT_PATH.$linshiimg,ROOT_PATH.$old_f);
        if(file_exists(ROOT_PATH.$old_f)){
            $return['status']=1;
            $return['url']=$old_f;
            return $return;
        }else{
            $return['msg']="生成图片失败，请重试！(002)";
            return $return;
        }
    }else{        
        $return['msg']="生成图片失败，请重试！(003)";
        return $return;
    } 
}
function checkStrlength($str,$size=30,$font='')
{
    if(empty($font))$font=ROOT_PATH.'/Public/fonts/msyhbd.ttf';
    $rect=imagettfbbox(20, 0,$font , $str);
    $minX = min(array($rect[0],$rect[2],$rect[4],$rect[6])); 
    $maxX = max(array($rect[0],$rect[2],$rect[4],$rect[6])); 
    $length=$maxX-$minX;
    return $length;
}
function mark_img($image_dir='',$formname = '',$x=0,$y=0){
  $iinfo=getimagesize($image_dir);
  $nimage=imagecreatetruecolor($iinfo[0],$iinfo[1]);
  $white=imagecolorallocate($nimage,255,255,255);
  $black=imagecolorallocate($nimage,0,0,0);
  $red=imagecolorallocate($nimage,255,0,0);
  $simage =imagecreatefromjpeg($image_dir);
  imagecopy($nimage,$simage,0,0,0,0,$iinfo[0],$iinfo[1]);
  $inn=getimagesize($formname); 
  $in=$inn['mime']=="image/png"?imagecreatefrompng($formname):imagecreatefromjpeg($formname); 
  $wh = imagecolorallocate($in, 255, 255, 255); 
  imagecolortransparent($in,$wh); 
  imagecopy($nimage,$in,$x,$y,0,0,$inn[0],$inn[1]);
  imagedestroy($in);
  imagejpeg($nimage,$image_dir);
  return true;
}
function mark_txt($image_dir='',$formname = '',$x=0,$y=0){
  $iinfo=getimagesize($image_dir);
  $nimage=imagecreatetruecolor($iinfo[0],$iinfo[1]);
  $white=imagecolorallocate($nimage,255,255,255);
  $black=imagecolorallocate($nimage,0,0,0);
  $red=imagecolorallocate($nimage,252, 117, 0);
  $font = ROOT_PATH.'/Public/fonts/msyhbd.ttf'; 
  $simage =imagecreatefromjpeg($image_dir);
  imagecopy($nimage,$simage,0,0,0,0,$iinfo[0],$iinfo[1]);
  $size = intval(C('FONT_SIZE'));if(empty($size))$size=20;
  imagettftext($nimage,$size,0,$x,$y,$red,$font,$formname);
  imagejpeg($nimage,$image_dir);
  return true;
}
function showlocation($x='',$y=''){
    if(empty($x) || empty($y)) return '未定位';
    return '已定位:'.$x.','.$y;
}
function str_cutmobile($mobile,$start_length=3,$replace_length=4,$mark='****'){
    $mobile=substr_replace($mobile,$mark,$start_length,$replace_length);
    return $mobile;
}
require(COMMON_PATH.'Common/global.func.php');
require(COMMON_PATH.'Common/extention.func.php');
?>