<?php


namespace Common\Model;
use Think\Model;
class AreaModel extends Model
{
    
    public function init(){
        $sess=session('member_info');
        $address_info = checkuseraddress();
        if($sess['id'] > 0 && empty($address_info)){
			$wh['uid']=$sess['id']; 
			$wh['status']=1;  
			$address_info=M('MemberAddress')->where($wh)->field('province,city,district')->find(); 
		}
        if(empty($address_info)){
			$iptype='taobao';//'UTFWry.dat';
            $IpLocation = new \Org\Net\IpLocation($iptype); // 实例化类 参数表示IP地址库文件			
            $ip = get_client_ip();
            $result = $IpLocation->getlocation($ip);
			if(str_exists($iptype,'.dat')){
				$w['status']=1;
				$area_list=M('Area')->where($w)->field('name,id,pid')->cache(true)->select();
				foreach($area_list as $k=>$v){ 
					$array_area[$v['id'].','.$v['pid']]=idtoname($v['pid'],'Area','name').$v['name'];
				}
				foreach($array_area as $k=>$v){
					if($result['country'] == $v){
						$area=explode(',',$k);
						if(!empty($area[1]))$address_info['province']=$area[1];
						if(!empty($area[0]))$address_info['city']=$area[0];
						if(!empty($address_info))$address_info['district']=0;
					}
				}
			}else{
				$city=strlen($result['country'])>6?strtr($result['country'],array('省'=>'','市'=>'','县'=>'','区'=>'','自治区'=>'',)):$result['country'];
				$map=array();
				$map['status']=1;
				$map['name']=array('like','%'.$city.'%');
				$cityinfo=M('Area')->where($map)->field('name,id,pid,pinyin')->cache(true)->find();
				if($cityinfo){
					if(!empty($cityinfo['pid']))$address_info['province']=$cityinfo['pid'];
					if(!empty($cityinfo['id']))$address_info['city']=$cityinfo['id'];
					if(!empty($address_info))$address_info['district']=0;
				}

			}
            if(!empty($address_info))checkuseraddress($address_info);
        }
		$map=$area_arr=array();
		if(!empty($address_info['province']))$area_arr[]=$address_info['province'];
		if(!empty($address_info['city']))$area_arr[]=$address_info['city'];
		if(!empty($address_info['district']))$area_arr[]=$address_info['district'];
		if($area_arr){
			$map['status']=1;
			$map['id']=array('in',$area_arr);
			$area_infos=array();
			$area_info=M('Area')->where($map)->field('name,id,pinyin')->cache(true)->select();
			if($area_info){
				foreach($area_info as $av){$area_infos[$av['id']]=$av;}
			}
			if(!empty($area_infos[$address_info['province']]))$return['address_info_format']['province'] =$area_infos[$address_info['province']];
			if(!empty($area_infos[$address_info['city']]))$return['address_info_format']['city'] =$area_infos[$address_info['city']];
			if(!empty($area_infos[$address_info['district']]))$return['address_info_format']['district'] =$area_infos[$address_info['district']];
		}
        $return['address_info'] = $address_info;
        return $return;
    }
    
    public function area_format($data,$type=0){
        $address_info = checkuseraddress();
        if($type<1)$data[0] = $data;
        foreach($data as $key=>$val){
            foreach($val as $k=>$v){
                if(in_array($v['i'],array_values($address_info))){
                    $data[$key][$k]['select'] = 1;
                }
            }
        }
        if($type<1)return $data[0];
        return $data;
    }
    
    public function change_areacache($id,$tabid,$parents){
        if(empty($id)||empty($tabid))return false;
        $data = get_arearegion_cache(0);$parents = trim($parents);
        $address_info = checkuseraddress();//获取定位信息
        $return['status'] = 1;
        if($data[$id]){
            $html = '<dl class="clearfix">';
            foreach($data[$id] as $k=>$v){
                $class = '';
                if(!is_numeric($k))continue;
                if(isset($address_info['city'])||isset($address_info['district'])){
                    if($address_info['city']==$v['i']||$address_info['district']==$v['i']){$class='class="on"';}
                }
                $html .= '<dd><a href="javascript:;" '.$class.' onclick="getarearegion(this,'.$v['i'].','.($tabid+1).','."'".$parents."'".')">'.$v['n'].'</a></dd>';
            }
            $html .= '</dl>';
            $return['data'] = $html;
        }
        if($tabid==2)$address_info['province'] = $id;
        if($tabid==3)$address_info['city'] = $id;
        if($tabid==4)$address_info['district'] = $id;
        checkuseraddress($address_info);
        return $return;
    }
    
    public function change_mobile_index_areacache($id){
        if(empty($id))return false;
        $province = idtoname($id,'Area','pid','id',false);
        if($province)$address_info['province'] = $province;
        $address_info['city'] = $id;
        checkuseraddress($address_info);
        $return['status'] = 1;
        return $return;
    }
    
    public function change_areacache_mobile($id,$level){

        if(empty($id)||empty($level))return false;
        $html = '';
        $data = get_arearegion_cache(0);
        $address_info = checkuseraddress();//获取定位信息
        if($data[$id]){
            $return['status'] = 1;
            foreach($data[$id] as $k=>$v){
                if(!is_numeric($k))continue;
                $html.='<li onClick="intProvince(' . ($level+1) . ',' . $v['i'] . ');">' . $v['n'] . '</li>';
            }
        }
        $datanames = $this->now_area_names();
        $return['datanames'] = 0;
        if($datanames)$return['datanames'] = $datanames;
        $return['data'] = $html;
        if($level==2)$address_info['province'] = $id;
        if($level==3)$address_info['city'] = $id;
        if($level==4)$address_info['district'] = $id;
        checkuseraddress($address_info);
        return $return;
    }
    
    public function now_area_names(){
        $address_info = checkuseraddress();
        if(!isset($address_info))return false;
        $return['address_info'] = $address_info;
        $field = "name";
        if($address_info['province']){
            $strnames = idtoname($address_info['province'],'Area',$field);
        }
        if($address_info['city']){
            $strnames .= $result['cityname'] = idtoname($address_info['city'],'Area',$field);
        }
        if($address_info['district']){
            $strnames .= idtoname($address_info['district'],'Area',$field);
        }
        $result['strnames'] = $strnames;
        return $result;
    }
}
?>