<?php

namespace Common\Model;
use Think\Model;
class BrandModel extends Model
{
    
    public function get_brand_list()
    {
        $return = $map = array();
        $map['b.status'] = 1;
        $map['c.status'] = 1;
        $order = '';
        $order .= 'c.sort desc,b.sort desc';
        $field = 'b.*,c.*,b.id as id';
        $brands = M('Brand')->alias('b')->field($field)->join('LEFT JOIN __BRAND_CATEGORY__ c ON b.brand_cat_id=c.id')->where($map)->order($order)->select();
        foreach ($brands as $key => $val) {
            $return[$val['brand_cat_id']]['name'] = $val['name'];
            $return[$val['brand_cat_id']]['brands'][$val['id']] = $val;
        }
        return $return;
    }

    
    public function get_cont($param, $has_cate = 1, $has_goods = 1)
    {
        $return = array();
        $return['status'] = 1;
        $brandid = $param['id'];
        $cat_id = $param['cat_id'];
        $map = array();
        $map['id'] = $brandid;
        $brand = M('Brand')->field(true)->where($map)->find();
        if (empty($brand)) {
            $return['status'] = 0;
            $return['msg'] = '没有该品牌';
            return $return;
        }
        if ($has_cate == 1) {
            //获取品牌分类
            $brand_cates = $this->get_brand_cate($brandid, $cat_id);
            foreach ($brand_cates as $key => $val) {
                $brand_cates[$key]['url'] = U('Brand/cont', array('id' => $brandid, 'cat_id' => $val['id']));
            }
            $return['brand_cates'] = $brand_cates;
        }
        //获取品牌排序
        $return['orders'] = $this->get_order_list($param);
        //品牌列表
        $goods_map['brand_id'] = $brandid;
        if ($cat_id > 0) $goods_map['cat_id'] = $cat_id;
        $p = $param['page'];
        if ($has_goods) {
            $return['goodslist'] = D('Common/Goods')->get_goods_list(0, $goods_map, '', $return['order']['order'], $p);
        }
        $bid = idtoname($brandid, 'Brand', 'brand_cat_id');
        $return['id'] = $brandid;
        $return['bname'] = idtoname($bid, 'BrandCategory');
        $return['brand_name'] = $brand['brand_name'];
        $return['cat_name'] = idtoname($cat_id, 'GoodsCategory');
        $return['order_name'] = $return['orders']['order_name'];
        $return['brand'] = $brand;
        return $return;
    }

    
    public function get_brand_cate($brandid, $cat_id = 0)
    {
        $return = $goods_map = $arr = $cate_list = array();
        if ($brandid <= 0 || !$brandid) return $return;
        $goods_map['brand_id'] = $brandid;
        $goods_brand = M('Goods')->field('cat_id')->group('cat_id')->where($goods_map)->select();
        foreach ($goods_brand as $k => $v) {
            $cate_list[$k]['id'] = $v['cat_id'];
            $cate_list[$k]['name'] = idtoname($v['cat_id'], 'GoodsCategory');
            if ($cat_id == $v['cat_id']) $cate_list[$k]['checked'] = 1;
        }
        $arr['id'] = 0;
        $arr['name'] = '全部';
        if ($cat_id == 0) $arr['checked'] = 1;
        else $arr['checked'] = 0;
        array_unshift($cate_list, $arr);
        return $cate_list;
    }

    
    public function get_order_list($param, $url = 'Home/Brand/cont', $type = 1)
    {
        $return = $order_list = array();
        $param_o = array();
        $param_o['id'] = $param['id'];
        if ($param['cat_id']) $param_o['cat_id'] = $param['cat_id'];
        if ($param['brand_id']) $param_o['brand_id'] = $param['brand_id'];
        if ($param['shop_cid']) $param_o['shop_cid'] = $param['shop_cid'];
        if ($param['price_id']) $param_o['price_id'] = $param['price_id'];
        if ($param['keyword']) $param_o['keyword'] = $param['keyword'];
        if (!$param['default']) $default = '-1';
        $param_o['default'] = -1;
        $order_list['default'] = array('name' => '默认排序', 'class' => 1, 'icon' => -1, 'url' => U($url, $param_o));
        unset($param_o['default']);
        $param_o['avg_point'] = 1;
        $order_list['avg_point'] = array('name' => '信誉', 'code' => 'avg_point', 'type' => 'desc', 'class' => 0, 'icon' => 1, 'url' => U($url, $param_o));
        unset($param_o['avg_point']);
        $param_o['addtime'] = 1;
        $order_list['addtime'] = array('name' => '时间', 'code' => 'addtime', 'type' => 'desc', 'class' => 0, 'icon' => 1, 'url' => U($url, $param_o));
        unset($param_o['addtime']);
        $param_o['sell_count'] = 1;
        $order_list['sell_count'] = array('name' => '人气', 'code' => 'sell_count', 'type' => 'desc', 'class' => 0, 'icon' => 1, 'url' => U($url, $param_o));
        unset($param_o['sell_count']);
        $order = '';
        foreach ($order_list as $k => $v) {
            if ($param[$k] == 1 && $k != 'default') {
                $order_list['default']['class'] = 0;
                $order_list[$k]['class'] = 1;
                $order_list[$k]['icon'] = 1;
                $param_o[$k] = 2;
                $order_list[$k]['url'] = U($url, $param_o);
                $order = ' ' . $k . ' desc';
            }
            if ($param[$k] == 2 && $k != 'default') {
                $order_list['default']['class'] = 0;
                $order_list[$k]['class'] = 1;
                $order_list[$k]['icon'] = 2;
                $param_o[$k] = 1;
                $order_list[$k]['url'] = U($url, $param_o);
                $order = ' ' . $k . ' asc';
            }
            if ($param[$k]) $order_name = $order_list[$k]['name'];
        }
        $order_name = $order_name ? $order_name : '排序';
        $return['order'] = $order;
        $return['order_list'] = $order_list;
        $return['order_name'] = $order_name;
        return $return;
    }
}
?>