<?php
namespace Common\Model;
use Think\Model;
class CartModel extends Model
{
    public function check_cart($goods_id, $attr, $number = 1, $name='',$address_id=0)
    {
        $return = array('status' => 2, 'msg' => '', 'data' => '', 'url' => '');
        $memberinfo = checkuserauthtype();
        $re_shopping = C('NOT_ADD_CART');
        if (empty($memberinfo) && $re_shopping == 0) {
            $return['msg'] = '请登录';
            $return['status'] = 0;
            $return['url'] = getjumpurl('JUMP_1');
            return $return;
        }
        if (empty($goods_id)) {
            $return['msg'] = '没有可以购买的产品';
            $return['status'] = 1;
            return $return;
        }
        $g_map=array();
        $g_map['id']=$goods_id;
        $status=M('Goods')->where($g_map)->Field('is_delete,status')->find();
        if($status['is_delete']>0 || $status['status']==0){
            $return['msg'] = '商品已下架';
            $return['status'] = 1;
            return $return;
        }
        if (intval($number) <= 0) {
            $return['msg'] = '商品数量必须大于等于1';
            $return['status'] = 1;
            return $return;
        }
        $goods_attr_map = array();
        $goods_attr_map['g.goods_id'] = $goods_id;
        $goods_attr_map['ga.type'] = array('neq', 'text');
        $map['goods_id']=$goods_id;
        $stockcount = M('GoodsAttrStock')->where($map)->count();
        if($stockcount>0) {
            $goods_attrs = M("GoodsAttr")->alias('g')->distinct("g.attr_id")->where($goods_attr_map)->JOIN('LEFT JOIN __GOODS_ATTRIBUTE__ ga ON g.attr_id=ga.id')->field('attr_id')->select();
            if (!empty($goods_attrs)) {
                $attrs = explode("_", $attr);
                if (count($attrs) != count($goods_attrs)) {
                    $return['msg'] = '请选择商品属性';
                    $return['app_data'] = 'open_attr';  
                    $return['status'] = 1;
                    return $return;
                }
            }
        }
        $attrstock = D("Common/GoodsAttr")->check_attr_stock($attr, $goods_id, $number, $name);
        if ($attrstock['status'] == 0) {
            $return['msg'] = $attrstock['msg'];
            $return['status'] = 1;
            return $return;
        }
        $check_goods_count = $this->check_cart_number($goods_id, $number);
        if ($check_goods_count['status'] == 1) {
            $return['msg'] = $check_goods_count['msg'];
            $return['status'] = 1;
            return $return;
        }
        $map['id']=$goods_id;
        $shop_id=M("Goods")->where($map)->getField('shop_id');
        if($shop_id){
            $shop_map=array();
            $shop_map['id']=$shop_id;
            $shop_uid=M("Shops")->where($shop_map)->getField('uid,name');
            if(!empty($memberinfo) && $shop_uid['uid']==$memberinfo['id'] && $shop_uid['uid']>0){
                $return['msg'] ="该商品是本店铺下的商品,不能购买";
                $return['status'] = 1;
                return $return;
            }
        }
        if(empty($address_id)) {
            $address_info = checkuseraddress();            
        }else{
            $addmap['id']=intval($address_id);
            $address_info=M('MemberAddress')->where($addmap)->field('province,city,district')->find();
        }
        if ($address_info['district']) {
            $area_id = $address_info['district'];
        } elseif($address_info['city']) {
            $area_id = $address_info['city'];
        }else {
            $area_id = $address_info['province'];
        }
        $root=D("Common/Cart")->get_area_fee($shop_id,$area_id);
        if($root['is_stock']==0){
            if($shop_id>0){
                $sho_map['id']=$shop_id;
                $shop_name=M("Shops")->where($sho_map)->getField('name');
            }
            $shop_name=empty($shop_name)?'官方自营旗舰店':("店铺".$shop_name);
            $return['msg'] =$shop_name."下的商品在该地区无货,不能购买";
            $return['status'] = 1;
            return $return;
        }
        return $return;
    }
    public function check_cart_number($id, $number)
    {
        $memberinfo = checkuserauthtype();
        $return = $cart_map = $goods_map = $map = $unpaid_map = array();
        $re_shopping = C('NOT_ADD_CART');
        if ($re_shopping > 0 && empty($memberinfo)) {
            $cart_map['cookie_id'] = cookie('u_cookieid');
            $cart_list = M("Cart")->field(true)->where($cart_map)->select();
        } else {
            $cart_map['user_id'] = $memberinfo['id'];
            $cart_list = M("Cart")->field(true)->where($cart_map)->select();
        }
        $goods_map['id'] = $id;
        $goods_info = M("Goods")->where($goods_map)->field(true)->find();
        $goods_buy_count = $goods_info['sell_count'];
        $goods_user_cart_count = 0;
        if ($cart_list) {
            foreach ($cart_list as $k => $v) {
                if ($v['goods_id'] == $id) {
                    $goods_user_cart_count += intval($v['goods_num']);
                }
            }
        }
        $goods_user_paid_count = 0;
        $goods_user_unpaid_count = 0;
        if ($memberinfo) {
            $map['g.goods_id'] = $id;
            $map['o.uid'] = $memberinfo['id'];
            $map['o.pay_status'] = 3;
            $map['o.is_delete'] = 0;
            $goods_user_paid_count = M('OrderGoods')->alias('g')->where($map)->JOIN('LEFT JOIN __ORDER_INFO__ o ON o.id=g.order_id')->sum('g.goods_number');
            $unpaid_map['g.goods_id'] = $id;
            $unpaid_map['o.pay_status'] = array('neq', 3);
            $unpaid_map['o.status'] = array('elt', 3);
            $map['o.uid'] = $memberinfo['id'];
            $unpaid_map['o.is_delete'] = 0;
            $goods_user_unpaid_count = M('OrderGoods')->alias('g')->where($unpaid_map)->JOIN('LEFT JOIN __ORDER_INFO__ o ON o.id=g.order_id')->sum('g.goods_number');
        }
        if ($goods_user_cart_count + $goods_user_unpaid_count + $number < $goods_info['user_min_bought'] && $goods_info['user_min_bought'] > 0) {
            $return['status'] = 1;
            $return['msg'] = "购买数量小于商品最少购买量，不能再购买";
            return $return;
        }
        if ($goods_user_cart_count + $goods_user_paid_count + $goods_user_unpaid_count + $number > $goods_info['user_max_bought'] && $goods_info['user_max_bought'] > 0) {
            $return['status'] = 1;
            $return['msg'] = "已超出商品最大购买量，不能再购买";
            return $return;
        }
        return $return;
    }
    public function get_goods_price($goods_id,$attr=''){
        $return=array();
        $memberinfo = checkuserauthtype();
        $map['id']=$goods_id;
        $goods_info=M("Goods")->where($map)->field('shop_price,promote_id,promote_end_time,promote_price,promote_start_time')->find();
        if($attr){
                $attrs=explode('_',$attr);
                if($attrs){
                    $stockmap['id'] = array('in',$attrs);
                    $attr_price = M('GoodsAttr')->where($stockmap)->getField('sum(attr_price)');
                    $price=$goods_info['shop_price']+$attr_price;
                }
            }else{
                $price=$goods_info['shop_price'];
            }
        if (!empty($memberinfo)) {
            $member_map = $memberrank_map = array();
            $member_map['id'] = $memberinfo['id'];
            $rank_id = M("Member")->where($member_map)->getField('rank_id');
            $memberrank_map['id'] = $rank_id;
            $rank = M("MemberRank")->where($memberrank_map)->getField("goods_price");
        }
        if($goods_info['promote_id']>0 && $goods_info['promote_end_time']>NOW_TIME && NOW_TIME>=$goods_info['promote_start_time'] && $goods_info['promote_price']>0){
            $promotion=$goods_info['promote_price'];
        }
        if($promotion){
            $return['price_type']=3;
            $return['price']=format_decimal($promotion);
        }elseif($rank){
            $return['price']=format_decimal($price*$rank/100);
            $return['price_type']=2;
        }else{
            $return['price']=format_decimal($price);
            $return['price_type']=1;
        }
        return $return;
    }
    public function getminprice($goods_id,$attr='',$name='Goods'){
        $memberinfo = checkuserauthtype();
        $map['id']=$goods_id;
        $goods_info = M($name)->where($map)->field('shop_price,promote_id,promote_end_time,promote_start_time,promote_price')->find();
        $all_price[1]=$goods_info['shop_price'];
        if (!empty($memberinfo)) {
            $member_map = $memberrank_map = array();
            $member_map['id'] = $memberinfo['id'];
            $rank_id = M("Member")->where($member_map)->getField('rank_id');
            $memberrank_map['id'] = $rank_id;
            $rank = M("MemberRank")->where($memberrank_map)->getField("goods_price");
            $all_price[2]=$all_price[1]*$rank/100;
        }
        if($goods_info['promote_id']>0 && $goods_info['promote_end_time']>NOW_TIME && NOW_TIME>=$goods_info['promote_start_time'] && $goods_info['promote_price']>0){
            $all_price[3]=$goods_info['promote_price'];
        }
        $minprice = min(array_filter($all_price));
        $type = array_search($minprice,$all_price);
        $attr_price =D("Common/GoodsAttr")->get_goods_attrprice($attr,$minprice);
        if(empty($attr_price)){
            $newprice =$minprice;
        }else{
            $newprice =$attr_price;
        }
        return array('type'=>$type,'price'=>$newprice);
    }
    public function add_carts($goods_id, $attr = '', $number = 1, $name = '', $act, $type = 0,$anchor_id=0)
    {
        $re_shopping = C('NOT_ADD_CART');
        $return = array('status' => 0, 'msg' => '', 'data' => '', 'url' => '');
        $check = $this->check_cart($goods_id, $attr, $number, $name);
        $goods_info = idtoname($goods_id, 'Goods', 'goods_number,shop_price,goods_name,goods_sn,shop_id,img,brand_id,cat_id', 'id', false);
        if ($attr) {
            $goodsattr_info = array(
                'key' => $attr,
                'name' => $name
            );
            $attr_info = serialize($goodsattr_info);
        }
        $price_info=$this->getminprice($goods_id,$attr);
        if (!empty($attr)) {
            $cart_map['goods_attr'] = $attr_info;
        }else{
            $attr_info='';
        }
        $memberinfo = checkuserauthtype();
        if ($check['status'] == 2 && $re_shopping == 0) {
            $cart_map['user_id'] = $memberinfo['id'];
            $cart_map['goods_id'] = $goods_id;
            $member_cart = M('Cart')->where($cart_map)->field('id,goods_id,goods_attr,all_price,goods_num')->find();
            if (!empty($member_cart)) {
                $map_c['goods_id'] = $goods_id;
                $map_c['user_id'] = $memberinfo['id'];
                $arr_num['goods_num'] = $member_cart['goods_num'] + $number;
                $arr_num['cart_id'] = $act;
                $arr_num['shop_price'] = $price_info['price'];
                $arr_num['price_type'] = $price_info['type'];
                $add_cart = M('Cart')->where($map_c)->save($arr_num);
                $return['data'] = $member_cart['id'];
            } else {
                $cart_data['user_id'] = $memberinfo['id'];
                $cart_data['goods_id'] = $goods_id;
                $cart_data['goods_attr'] = $attr_info;
                $cart_data['goods_num'] = $number;
                $cart_data['shop_price'] = $price_info['price'];
                $cart_data['price_type'] = $price_info['type'];
                $cart_data['cart_id'] = $act;
                $add_cart = M('Cart')->add($cart_data);
                $return['data'] = $add_cart;
            }
            if ($add_cart) {
                $anchor_config=C("SHOW_LIVE_MODEL");
                if($anchor_config){
                    $anchor_data=array();
                    $anchor_data['cart_id']=$add_cart;
                    $anchor_data['goods_id']=$goods_id;
                    $anchor_data['goods_number']=$number;
                    $anchor_data['anchor_id']=$anchor_id;
                    $anchor_data['shop_price']=$price_info['price'];
                    $anchor_data['order_status']=0;
                    $anchor_data['goods_attr']=$attr;
                    $anchor_res=D("Live/LiveDivided")->add_divided($anchor_data);
                }
                $return['msg'] = '加入购物车成功';
                $return['status'] = 2;
                if ($type > 0) {
                    $return['url'] = U('Home/Order/Index', array("ids" => $add_cart));
                } else {
                    $return['url'] = U('Home/Goods/success_tpl');
                }
                return $return;
            } else {
                $return['msg'] = '加入购物车失败';
                $return['status'] = 1;
                return $return;
            }
        } elseif ($check['status'] == 2 && $re_shopping == 1) { 
            if ($memberinfo) {
                $cart_map['user_id'] = $memberinfo['id'];
                $cart_map['goods_id'] = $goods_id;
                $member_cart = M('Cart')->where($cart_map)->field('id,goods_id,goods_attr,all_price,goods_num')->find();
            } else {
                $cart_map['cookie_id'] = cookie('u_cookieid');
                $cart_map['goods_id'] = $goods_id;
                $member_cart = M('Cart')->where($cart_map)->field('id,goods_id,goods_attr,all_price,goods_num')->find();
            }
            if ($member_cart) {
                $map_c['goods_id'] = $goods_id;
                $map_c['goods_attr'] = $attr_info;
                if ($memberinfo) {
                    $map_c['user_id'] = $memberinfo['id'];
                } else {
                    $map_c['user_id'] = 0;
                    $map_c['cookie_id'] = cookie('u_cookieid');
                }
                $arr_num['goods_num'] = $member_cart['goods_num'] + $number;
                $arr_num['cart_id'] = $act;
                $arr_num['shop_price'] = $price_info['price'];
                $arr_num['price_type'] = $price_info['type'];
                $add_cart = M('Cart')->where($map_c)->save($arr_num);
                $return['data'] = $member_cart['id'];
            } else {
                if ($memberinfo) {
                    $cart_data['user_id'] = $memberinfo['id'];
                } else {
                    $cart_data['user_id'] = 0;
                    $cart_data['cookie_id'] = $this->getcookieid();
                }
                $cart_data['goods_id'] = $goods_id;
                $cart_data['goods_attr'] = $attr_info;
                $cart_data['goods_num'] = $number;
                 $cart_data['shop_price'] = $price_info['price'];
                $cart_data['price_type'] = $price_info['type'];
                $cart_data['cart_id'] = $act;
                $add_cart = M('Cart')->add($cart_data);
                $return['data'] = $add_cart;
            }
            if ($add_cart) {
                $anchor_config=C("SHOW_LIVE_MODEL");
                if($anchor_config){
                    $anchor_data=array();
                    $anchor_data['cart_id']=$add_cart;
                    $anchor_data['goods_id']=$goods_id;
                    $anchor_data['goods_number']=$number;
                    $anchor_data['anchor_id']=$anchor_id;
                    $anchor_data['shop_price']=$price_info['price'];
                    $anchor_data['order_status']=0;
                    $anchor_data['goods_attr']=$attr;
                    $anchor_res=D("Live/LiveDivided")->add_divided($anchor_data);
                }
                $return['msg'] = '加入购物车成功';
                $return['status'] = 2;
                if ($type > 0) {
                    $return['url'] = U('Home/Order/Index', array("ids" => $return['data']));
                } else {
                    $return['url'] = U('Home/Goods/success_tpl');
                }
                return $return;
            } else {
                $return['msg'] = '加入购物车失败';
                $return['status'] = 1;
                return $return;
            }
        } else {
            $return['msg'] = $check['msg'];
            $return['status'] = $check['status'];
            $return['url'] = $check['url'];
            $return['app_data'] = $check['app_data'];
            return $return;
        }
        return $return;
    }
    private function getcookieid()
    {
        $cookie_id = cookie('u_cookieid');
        if (empty($cookie_id)) {
            $cookie_id = md5(NOW_TIME . C("HANCHAO_KEY"));
            cookie('u_cookieid', $cookie_id, time() + 3600);
        }
        return $cookie_id;
    }
    public function add_cartlist($goods_id, $number, $act)
    {
        $memberinfo = checkuserauthtype();
        $re_shopping = C('NOT_ADD_CART');
        if (empty($memberinfo) && $re_shopping == 0) {
            $return['msg'] = '请登录';
            $return['status'] = 0;
            $return['url'] = getjumpurl('JUMP_1');
            return $return;
        }
        if ($goods_id == '') {
            $return['msg'] = '没有可以购买的产品';
            $return['status'] = 1;
            return $return;
        }
        if ($number <= 0) {
            $return['msg'] = '商品数量必须大于等于1';
            $return['status'] = 1;
            return $return;
        }
        $goodsattr_map = array();
        $goodsattr_map['g.goods_id'] = $goods_id;
        $goodsattr_map['ga.type'] = array('neq', 'text');
        $goods_attrs = M("GoodsAttr")->alias('g')->distinct("g.attr_id")->where($goodsattr_map)->JOIN('LEFT JOIN __GOODS_ATTRIBUTE__ ga ON g.attr_id=ga.id')->field('attr_id')->select();
        if (!empty($goods_attrs)) {
            $return['status'] = 3;
            $return['url'] = U("Home/Goods/goods_attrs", array("goods_id" => $goods_id, "number" => $number));
            return $return;
        } else {
            $goods_map = array();
            $goods_map['id'] = $goods_id;
            $price = M("Goods")->where($goods_map)->getField("shop_price");
            $return = $this->add_carts($goods_id, '', $number, '', $act, 0);
            return $return;
        }
    }
    public function cart_index()
    {
        $return = array();
        $return['status'] = 0;
        $memberinfo = checkuserauthtype();
        $data = $carts_map = array();
        if (empty($memberinfo)) {
            $ucookieid = cookie('u_cookieid');
            if (empty($ucookieid)) return $return;
            $carts_map['cookie_id'] = $ucookieid;
        } else {
            $carts_map['user_id'] = $memberinfo['id'];
        }
        $cart_ids = M('Cart')->where($carts_map)->getField('id', true);
        $data = $this->cartlist('', $cart_ids);
        $return['status'] = 1;
        $return['data'] = $data;
        return $return;
    }
    public function cartlist($goods_id='', $cart_ids = '', $is_order = 0,$addre_id=0)
    {
        $return = $carts_map = array();
        $return['status'] = $return['all_price'] = $return['all_save_price'] = 0;
        $memberinfo = checkuserauthtype();
        if (empty($memberinfo)) {
            if ($is_order == 1) {
                $return['status'] = 2;
                $return['msg'] = '请登录';
                $return['url'] = getjumpurl('JUMP_1');
                return $return;
            } else {
                $ucookieid = cookie('u_cookieid');
                if (empty($ucookieid)) {
                    $return['data'] = '';
                    return $return;
                }
                $carts_map['c.cookie_id'] = $ucookieid;
            }
        } else {
            $carts_map['c.user_id'] = $memberinfo['id'];
        }
        $carts_map['g.status'] = 1;
        $carts_map['g.publish_wait'] = 1;
        if (!empty($cart_ids)) $carts_map['c.id'] = array('in', $cart_ids);
        if($cart_ids) {
            $carts = M('Cart')->alias('c')->JOIN('LEFT JOIN __GOODS__ g ON g.id=c.goods_id')->where($carts_map)->field('g.*,g.id as goods_id,c.id as id,c.user_id,c.cookie_id,c.goods_attr,c.goods_num,c.cart_id,c.shop_price as shop_price,c.price_type')->order('g.shop_id asc')->select();
        }elseif(!empty($goods_id)){
            $info=D("Common/OrderInfo")->buy_now($goods_id);
            if($info['status']<=0){$return['status']=0;$return['msg']=$info['msg'];return $return;}
            $carts=$info['data'];
        }
        $cartlist = $shoptickets = $promot_lists = $shopgoods = array();
        $orig_total_prices = 0;
        $list = array();
        foreach ($carts as $k => $v) {
            if(empty($v['shop_id'])&&$v['shop_id']!=0)continue;
            if (empty($cartlist[$v['shop_id']]['shop_info'])) $cartlist[$v['shop_id']]['shop_info'] = $this->format_goods_shop($v['shop_id'],$addre_id);
            if (!empty($cartlist[$v['shop_id']]['shop_info'])) {
                if (empty($cartlist[$v['shop_id']]['promot_list'][$v['cart_id']]['promot_info'])) $cartlist[$v['shop_id']]['promot_list'][$v['cart_id']]['promot_info'] = $this->format_goods_promot($v['cart_id']);
                if($v['cart_id']>0 && $cartlist[$v['shop_id']]['promot_list'][$v['cart_id']]['promot_info']['is_valid']==0){
                    $v['status']=0;
                }
                $goods_list = $this->format_goods($v, $cartlist[$v['shop_id']]['promot_list'][$v['cart_id']]['promot_info']['is_limit_time']);
                $cartlist[$v['shop_id']]['promot_list'][$v['cart_id']]['goods_list'][] = $goods_list;
                $cartlist[$v['shop_id']]['promot_list'][$v['cart_id']]['promot_info']['goods_count'] = intval($cartlist[$v['shop_id']]['promot_list'][$v['cart_id']]['promot_info']['goods_count']) + 1;
                if (!empty($goods_list['promot_list']['list'])) $promot_lists = array_merge($promot_lists, $goods_list['promot_list']['list']);
                $shopgoods[$v['shop_id']]['goods_ids'][] = $v['goods_id'];
                $shopgoods[$v['shop_id']]['goods_total_price'] += $v['shop_price'] * $v['goods_num'];
            }
        }
        foreach ($shopgoods as $ke => $va) {
            $shoptickets[$ke] = D('Common/Promot')->goods_to_ticket($va['goods_ids'],$ke);
            $cartlist[$ke]['shop_info']['allgoods_price'] = $cartlist[$ke]['shop_info']['allgoods_weight'] = 0;
            foreach ($cartlist[$ke]['promot_list'] as $ck => $cv) {
                $prices = $demo_prices = 0;
                foreach ($cv['goods_list'] as $cgk => $cgv) {
                    $prices += $cgv['shop_price'] * $cgv['goods_num'];
                    $cartlist[$ke]['shop_info']['allgoods_weight'] += $cgv['goods_weight'] * $cgv['goods_num'];
                }
                $cartlist[$ke]['promot_list'][$ck]['promot_info']['orig_prices'] = $orig_prices = $prices;
                $promot_info = $cv['promot_info'];
                if ($prices >= $promot_info['min_amount']) {
                    if ($promot_info['act_type'] == 1) {
                        if ($promot_info['is_addup'] == 1) {
                            if (!empty($promot_info['max_amount']) && $prices >= $promot_info['max_amount']) {
                                $demo_prices = $promot_info['max_amount'];
                            }
                            if($promot_info['max_amount']==0){
                                $demo_prices=$prices;
                            }
                            if ($promot_info['min_amount'] > 0) $prices = $prices - (floor($demo_prices / $promot_info['min_amount']) * $promot_info['act_type_ext']);
                        } else {
                            $prices = $prices - $promot_info['act_type_ext'];
                        }
                    } else if ($promot_info['act_type'] == 2) {
                        $prices = $prices * ($promot_info['act_type_ext'] / 100);
                    }
                }
                $cartlist[$ke]['promot_list'][$ck]['promot_info']['orig_prices'] = format_decimal($orig_prices);
                $cartlist[$ke]['promot_list'][$ck]['promot_info']['current_prices'] = format_decimal($prices);
                $cartlist[$ke]['shop_info']['allgoods_price'] += $prices;
                $save_prices = $orig_prices - $prices;
                $return['all_save_price'] += $save_prices;
                $cartlist[$ke]['promot_list'][$ck]['promot_info']['save_prices'] = format_decimal($save_prices);
            }
            $return['all_price'] += $cartlist[$ke]['shop_info']['allgoods_price'];
            $allgoods_price = $cartlist[$ke]['shop_info']['allgoods_price'];
            $shipping_fee = array();
            foreach ($cartlist[$ke]['shop_info']['shipping_info'] as $sk => $sv) {
                $cartlist[$ke]['shop_info']['free_shipping_fee'] = (empty($cartlist[$ke]['shop_info']['shipping_info'][$sk]['configure']['money'])) ? 0 : $cartlist[$ke]['shop_info']['shipping_info'][$sk]['configure']['money'];
                $shipping_money = $cartlist[$ke]['shop_info']['shipping_info'][$sk]['configure']['money'];
                $shipping_fee[$sk] = $this->shipping_fee($allgoods_price, $cartlist[$ke]['promot_list'], $sv['configure']);
                $cartlist[$ke]['shop_info']['shipping_info'][$sk]['shipping_fee'] = $shipping_fee[$sk];
            }
            $cartlist[$ke]['shop_info']['shipping_fee_key'] = $cartlist[$ke]['shop_info']['shipping_fee'] = '';
            if (!empty($shipping_fee)) {
                asort($shipping_fee);
                $shipping_fee_key = array_keys($shipping_fee);
                $shipping_fee_min = array_values($shipping_fee);
                $cartlist[$ke]['shop_info']['shipping_fee_key'] = $shipping_fee_key[0];
                $cartlist[$ke]['shop_info']['shipping_fee'] = $shipping_fee_min[0];
            }
            $cartlist[$ke]['shop_info']['allgoods_price'] = format_decimal($cartlist[$ke]['shop_info']['allgoods_price']);
            $cartlist[$ke]['shop_info']['shop_total_price'] = format_decimal($cartlist[$ke]['shop_info']['allgoods_price'] + $cartlist[$ke]['shop_info']['shipping_fee']);
        }
        foreach ($promot_lists as $key => $val) {
            $promot[$val['id']] = $this->format_promot_carts($val);
        }
        if (!empty($cartlist)) $return['status'] = 1;
        $return['list'] = $cartlist;
        $return['shopgoods'] = $shopgoods;
        $return['shopticket'] = $shoptickets;
        $return['all_price'] = format_decimal($return['all_price']);
        $return['all_save_price'] = format_decimal($return['all_save_price']);
        $return['promot_lists_json'] = json_encode($promot);
        return $return;
    }
    public function format_promot_carts($val = array())
    {
        $return = $val;
        return $return;
    }
    public function format_goods_shop($shop_id = 0,$addre_id=0)
    {
        $return = $shippingfeewhere = $where = array();
        if($addre_id){
            $address_map['id']=$addre_id;
            $memberaddress=M("MemberAddress")->where($address_map)->field('province,city,district')->find();
            $address=array($memberaddress['province'],$memberaddress['city'],$memberaddress['district']);
            rsort($address);
        }else{
            $address_info=checkuseraddress();
            if($address_info['district']){
                $area_id=$address_info['district'];
            }elseif($address_info['city']){
                $area_id=$address_info['city'];
            }else{
                $area_id=$address_info['province'];
            }
            $root=D("Common/Cart")->get_area_fee($shop_id,$area_id);
            $area_ids=getallparent($root['area_id'],'','Area');
            $area_ids=explode(',',$area_ids);
            $area_ids[]=$root['area_id'];
            $address=rsort($area_ids);
        }
        $map['id']=$shop_id;
        $shop = M('Shops')->where($map)->field(true)->find();
        if ($shop_id == 0) {
                $return['id'] = $shop_id;
                $return['name'] = '官方自营旗舰店';
                $shippingfeewhere['shop_id'] = 0;
                $order = 'id desc';
                $return['shipping_info'] = M('ShippingFee')->where($shippingfeewhere)->order($order)->field(true)->select();
            }elseif (!empty($shop)) {
                $return['id'] = $shop['id'];
                $return['name'] = $shop['name'];
                $return['thumb'] = $shop['thumb'];
                $return['thumb_img'] = $shop['thumb_img'];
                $return['status'] = $shop['status'];
            $shippingfeewhere['shop_id'] = $shop['id'];
                $order = 'id desc';
                $return['shipping_info'] = M('ShippingFee')->where($shippingfeewhere)->order($order)->field(true)->select();
            }
        if(!empty($return['shipping_info'])) {
            foreach ($address as $val) {
                foreach (array_filter($return['shipping_info'])as $k => $v) {
                    if (empty($v)) continue;
                    if (in_array($val, explode(',', $v['area_region']))) {
                        $return['shipping_info'][$k]['configure'] = unserialize($v['configure']);
                    }else{
                        $return['shipping_info'][$k]['configure']='';
                    }
                    if($return['shipping_info'][$k]['configure']){
                        break;
                    }
                }
                if($return['shipping_info'][$k]['configure']){
                    break;
                }
            }
        }
        return $return;
    }
    public function format_goods($data = array(), $is_limit_time = 0)
    {
        $return = $data;
        $return['goods_attr_format'] = unserialize($data['goods_attr']);
        if($data['goods_attr']){
            $attr=$return['goods_attr_format']['key'];
            $map['attr_key']=$attr;
            $stock=M("GoodsAttrStock")->where($map)->getField('stock_cfg');
            $return['goods_number'] =$stock;
        }else{
            $return['goods_number'] = $data['goods_number'];
        }
        $return['all_price'] = format_decimal($data['shop_price'] * $data['goods_num']);
        $return['all_weight'] = $data['goods_weight'] * $data['goods_num'];
        $return['is_limit_time'] = $is_limit_time;
        $return['is_valid'] = ($data['status'] == 1 && $data['is_delete'] == 0) ? 1 : 0;
        $return['promot_list'] = empty($is_limit_time) ? D('Common/Promot')->goods_to_promot($data['goods_id']) : array();
        $return['collect_count'] = 0;
        $return['contract_list']=D('Common/Goods')->get_goods_contract($data['shop_id']);
        $member=checkuserauthtype();
        if($member){
            $map['uid'] = $member['id'];
            $map['goods_id'] = $data['goods_id'];
            $return['collect_count'] = M('GoodsCollect')->where($map)->count();
        }
        return $return;
    }
    public function format_goods_promot($pro_id = 0)
    {
        $return = array();
        if (empty($pro_id)) return $return;
        $data = M('PromotAct')->field('*')->find($pro_id);
        $return = $data;
            $return['start_time_format'] = time_format($data['start_time'], 'Y.m.d');
            $return['end_time_format'] = time_format($data['end_time'], 'Y.m.d');
            $now_time = NOW_TIME;
            $return['is_valid'] = (($data['start_time'] == 0 || $data['start_time'] <= $now_time) && ($data['end_time'] == 0 || $data['end_time'] >= $now_time)) ? 1 : 0;
        return $return;
    }
    public function change_act($cart_id, $pro_id)
    {
        $return = $map_c = array();
        $return['status'] = 1;
        $memberinfo = checkuserauthtype();
        $map_c = array();
        if (empty($memberinfo)) {
            $ucookieid = cookie('u_cookieid');
            if (empty($ucookieid)) return $return;
            $map_c['cookie_id'] = $ucookieid;
        } else {
            $map_c['user_id'] = $memberinfo['id'];
        }
        $map_c['id'] = $cart_id;
        $arr_num['cart_id'] = $pro_id;
        $add_cart = M('Cart')->where($map_c)->save($arr_num);
        if (empty($add_cart)) $return['status'] = 0;
        return $return;
    }
    public function del_cart($id)
    {
        $return = $map_c = array();
        $return['status'] = 1;
        $memberinfo = checkuserauthtype();
        $anchor_config=C("SHOW_LIVE_MODEL");
        if($anchor_config){
            $a_map=$a_data=array();
            $a_map['cart_id']=array("in",$id);
            $count=M("LiveDivided")->where($a_map)->count();
            if($count){
                $a_data['status']=0;
                $anchor_res=M("LiveDivided")->where($a_map)->save($a_data);
                if(empty($anchor_res)){
                    $return['status'] = 0;
                    return $return;
                }
            }
        }
        $map_c = array();
        if (empty($memberinfo)) {
            $ucookieid = cookie('u_cookieid');
            if (empty($ucookieid)) return $return;
            $map_c['cookie_id'] = $ucookieid;
        } else {
            $map_c['user_id'] = $memberinfo['id'];
        }
        $map_c['id'] = array('in',$id);
        $add_cart = M('Cart')->where($map_c)->delete();
        if (empty($add_cart)) $return['status'] = 0;
        return $return;
    }
    public function sub_cart($cart_id = array(), $number)
    {
        $memberinfo = checkuserauthtype();
        $root = $map = $cart_map = array();
        if (empty($memberinfo)) {
            $root['status'] = 2;
            $root['msg'] = '您没登陆，请登录';
            $root['url'] = getjumpurl('JUMP_1');
            return $root;
        } else {
            if (!empty($cart_id)) {
                $address_info= checkuseraddress();
                if (empty($address_info)) {
                    $root['status'] = 0;
                    $root['msg'] = '请选择配送地区';
                    return $root;
                }
                $cart_ids = implode(",", $cart_id);
                $map['id'] = array("in", $cart_id);
                $cart_info = M("Cart")->field(true)->where($map)->select();
                foreach ($cart_info as $key => $val) {
                    foreach ($cart_id as $k => $id) {
                        $id = intval($id);
                        $num = intval($number[$id]);
                        $gooda_attrs = unserialize($val['goods_attr']);
                        $gooda_attrs_values = array_values($gooda_attrs);
                        $data = $this->check_cart($val['goods_id'], $gooda_attrs_values[0], $num, $gooda_attrs_values[1]);
                        if ($data['status'] == 0 || $data['status'] == 1) {
                            $root['status'] = 0;
                            $root['msg'] = $data['msg'];
                            $root['url'] = $data['url'];
                            return $root;
                        } else {
                            $cart_data['goods_num'] = $num;
                            $cart_map['id'] = $id;
                            M("Cart")->where($cart_map)->save($cart_data);
                        }
                    }
                }
                $root['status'] = 1;
                $root['url'] = U("Order/index", array('ids' => $cart_ids));
            } else {
                $root['status'] = 0;
                $root['msg'] = '没有要结算的商品';
            }
        }
        return $root;
    }
    public function shipping_fee($allgoods_price, $cartlist, $config)
    {
        if (empty($allgoods_price) || empty($cartlist)) return false;
        if ($config['money'] > 0 && $config['money'] < $allgoods_price) return 0.00;
        $num = $weight = array();
        foreach ($cartlist as $k => $val) {
            foreach ($val['goods_list'] as $key => $gv) {
                if ($gv['is_shipping'] > 0) continue;
                $num[] = $gv['goods_num'];
                $weight[] = $gv['goods_weight'];
            }
        }
        $totalnum = array_sum($num);
        $totalweight = array_sum($weight);
        if ($config['type'] == 2) {
            if($totalnum==1){
                return $config['per_money'];
            }else{
                return $config['per_money']+ceil(($totalnum-1)/$config['x_weight'])*$config['x_weight_money'];
            }
        } else {
            $first_weight = $totalweight - $config['first_weight'];
            if ($first_weight <= 0) {
                return $config['first_weight_money'];
            } else {
                return $config['first_weight_money'] + ceil(($totalweight - $config['first_weight']) / $config['x_weight']) * $config['x_weight_money'];
            }
        }
    }
    public function get_area_fee($shop_id=0,$area_id=0){
        $root=array('area_id'=>0,'is_stock'=>0);
        $shop_shipping_area=S("shop_shipping_fee_catch".$shop_id);
        if($shop_shipping_area){
            if (in_array($area_id, $shop_shipping_area)) {
                $root['is_stock'] = 1;
                $root['area_id'] = $area_id;
            } else {$root['is_stock'] = 0;}
        }else {
            $map['shop_id'] = $shop_id;
            $shop_shipinfo = M("ShippingFee")->where($map)->getField('area_region', true);
            $area_ids =array_unique(array_filter(explode(',',implode(',',$shop_shipinfo))));
            $alldata = array();
            if ($shop_shipinfo) {
                $ara_map['id'] = array('in', $area_ids);
                $area_info = M("Area")->where($ara_map)->field('level,id,pid')->select();
                foreach ($area_info as $k => $va) {
                    $areadata = getallson($va['id'],'Area');
                    foreach($areadata as $key=>$val){
                        array_push($alldata,$val);
                    }
                }
                if(in_array($area_id, $alldata)){
                    $root['is_stock'] = 1;
                    $root['area_id'] = $area_id;
                } else {
                    $root['is_stock'] = 0;
                }
                $shop_area = $alldata;
                S("shop_shipping_fee_catch".$shop_id, $shop_area,3600);
            }
        }
        return $root;
    }
}
?>