<?php
namespace Common\Model;
use Think\Model;
class GoodsAttrModel extends Model
{
    public function getattr($goods_id)
    {
        $root = $stock = $attr = $newarr = array();
        $where['ga.goods_id'] = $map['goods_id'] = $goods_id;
        $stockcount = M('GoodsAttrStock')->where($map)->count();
        if ($stockcount > 0) {
            $list = M('GoodsAttribute')->alias('g')->where($where)->JOIN('LEFT JOIN __GOODS_ATTR__ ga ON ga.attr_id=g.id')->field('ga.*,g.name,g.options,g.type')->select();
            foreach ($list as $k => $v) {
                if ($v['type'] == "text") {
                    $attr[$v['attr_id']]['name'] = $v['name'];
                    if ($v['attr_img']) {
                        $attr[$v['attr_id']]['attr_img'] = $v['attr_img'];
                    }
                    $attr[$v['attr_id']]['price'] = $v['attr_price'];
                    $attr[$v['attr_id']]['attr_value'] = $v['attr_value'];
                } else {
                    $formatarr = array();
                    $newarr[$v['attr_id']]['name'] = $v['name'];
                    $newarr[$v['attr_id']]['options'][$v['id']]['id'] = $v['id'];
                    $formatarr = strtoarray($v['options']);
                    $newarr[$v['attr_id']]['options'][$v['id']]['optionsval'] = $formatarr[$v['attr_value']];
                    $newarr[$v['attr_id']]['options'][$v['id']]['attr_price'] = empty($v['attr_price']) ? 0 : $v['attr_price'];
                    $newarr[$v['attr_id']]['options'][$v['id']]['attr_img'] = empty($v['attr_img']) ? '' : $v['attr_img'];
                }
            }
            $liststock = M('GoodsAttrStock')->field('attr_key,stock_cfg,sell_count')->where($map)->select();
            if (!empty($liststock)) {
                foreach ($liststock as $k => $v) {
                    if (empty($v['attr_key'])) contiue;
                    $stock[$k] = explode('_', $v['attr_key']);
                    $stockmap['id'] = array('in', $stock[$k]);
                    $attr_price = M('GoodsAttr')->where($stockmap)->sum('attr_price');
                    $stocks[$v['attr_key']]['attr_key'] = $v['attr_key'];
                    $stocks[$v['attr_key']]['stock_cfg'] = $v['stock_cfg'];
                    $stocks[$v['attr_key']]['sell_count'] = $v['sell_count'];
                    $stocks[$v['attr_key']]['attr_price'] = $attr_price;
                }
            }
        }
        $root['newarr'] = $newarr;
        $root['spec'] = $attr;
        $root['combination'] = json_encode($stock);
        $root['combinationnum'] = count($stock);
        $root['combinationprice'] = json_encode($stocks);
        $root['combinationpricenum'] = count($stock[0]);
        return $root;
    }
    public function goods_to_attrname($attr_ids)
    {
        $where['ga.id'] = array("in", explode("_", $attr_ids));
        $where['g.type'] = "checkbox";
        $list = M('GoodsAttribute')->alias('g')->where($where)->JOIN('LEFT JOIN __GOODS_ATTR__ ga ON ga.attr_id=g.id')->field('ga.attr_value,g.name,g.options')->select();
        $attrname = '';
        foreach ($list as $key => $val) {
            if ($val['options']) {
                $formatarr = strtoarray($val['options']);
                $attrname .= $val['name'] . ":" . $formatarr[$val['attr_value']] . " ";
            }
        }
        return $attrname;
    }
    public function getattr_price($attr_id = 0, $goods_id = 0)
    {
        if (empty($goods_id)) {
            return false;
        }
        $goodsattr_info = $ats_map = array();
        $ats_map['goods_id'] = $goods_id;
        $attr_stock = M('GoodsAttrStock')->where($ats_map)->select();
        foreach ($attr_stock as $key => $val) {
            $attr = explode("_", $val['attr_key']);
            $attr = implode(',', $attr);
            $map = array();
            $map['id'] = array("in", $attr);
            $price_info = M('GoodsAttr')->where($map)->Field('attr_price')->select();
            $price = 0;
            foreach ($price_info as $k => $v) {
                $price += $v['attr_price'];
            }
            $goodsattr_info[$val['attr_key']]['price'] = $price;
            $goodsattr_info[$val['attr_key']]['stock'] = $val['stock_cfg'];
        }
        $attr_price = json_encode($goodsattr_info);
        return $attr_price;
    }
    public function get_goods_attrprice($attr = '', $price)
    {
        if ($attr) {
            $attr = explode("_", $attr);
            $attr = implode(',', $attr);
            $map['id'] = array("in", $attr);
            $attr_price = M('GoodsAttr')->where($map)->getField('sum(attr_price)');
        } else {
            $attr_price = 0;
        }
        $total_price = format_decimal($price + $attr_price);
        return $total_price;
    }
    public function check_attr_stock($attrs = '', $goods_id, $number, $name = '')
    {
        $root = array();
        $root['status'] = 1;
        $goods_id = intval($goods_id);
        $number = intval($number);
        if (empty($number)) {
            $root['status'] = 0;
            $root['msg'] = '商品数量不能为0';
        }
        if (empty($goods_id)) {
            $root['status'] = 0;
            $root['msg'] = '请选择商品';
        }
        $g_map['id'] = $goods_id;
        $goods_info = M("Goods")->where($g_map)->field('goods_number,sell_count,user_max_bought,user_min_bought')->find();
        if ($attrs) {
            $map['goods_id'] = $goods_id;
            $map['attr_key'] = $attrs;
            $attr_info = M("goods_attr_stock")->field(true)->where($map)->find();
            $attrs_stock = $attr_info['stock_cfg'];
            $goods_buy_count = $attr_info['sell_count'];
        } else {
            $attrs_stock = $goods_info['goods_number'];
            $goods_buy_count = $goods_info['sell_count'];
        }
        $memberinfo = checkuserauthtype();
        $re_shopping = C('NOT_ADD_CART');
        if ($attrs) {
            $goodsattr_info = array(
                'key' => $attrs,
                'name' => $name
            );
            $attr_info = serialize($goodsattr_info);
        } else {
            $attr_info = '';
        }
        $cart_map = array();
        if ($re_shopping > 0 && empty($memberinfo)) {
            $cart_map['cookie_id'] = cookie('u_cookieid');
        } else {
            $cart_map['user_id'] = cookie($memberinfo['id']);
        }
        $cart_map['goods_id'] = $goods_id;
        $cart_map['goods_attr'] = $attr_info;
        $goods_user_cart_count = M("Cart")->where($cart_map)->sum('goods_num');
        if ($number > $attrs_stock || $attrs_stock <= 0) {
            $root['status'] = 0;
            $root['msg'] = '该商品库存不足';
        }
        $goods_user_paid_count = 0;
        if ($memberinfo) {
            $unpaid_map['g.goods_id'] = $goods_id;
            $unpaid_map['g.goods_attr'] = $attr_info;
            $unpaid_map['o.pay_status'] = array('neq', 3);
            $unpaid_map['o.status'] = array('elt', 3);
            $unpaid_map['o.is_delete'] = 0;
            $goods_user_unpaid_count = M('OrderGoods')->alias('g')->where($unpaid_map)->JOIN('LEFT JOIN __ORDER_INFO__ o ON o.id=g.order_id')->sum('g.goods_number');
            $pay_map['g.goods_id'] = $goods_id;
            $pay_map['g.goods_attr'] = $attr_info;
            $pay_map['o.pay_status'] = 3;
            $pay_map['o.is_delete'] = 0;
            $goods_user_paid_count = M('OrderGoods')->alias('g')->where($pay_map)->JOIN('LEFT JOIN __ORDER_INFO__ o ON o.id=g.order_id')->sum('g.goods_number');
            if ($goods_user_cart_count + $goods_user_unpaid_count + $goods_user_paid_count + $number > $goods_info['user_max_bought'] && $goods_info['user_max_bought'] > 0) {
                $root['status'] = 0;
                $root['msg'] = "已超出商品最大购买量，不能再购买";
                return $root;
            }
            if ($goods_user_cart_count + $goods_user_unpaid_count + $goods_user_paid_count + $number < $goods_info['user_min_bought'] && $goods_info['user_min_bought'] > 0) {
                $root['status'] = 0;
                $root['msg'] = "已低于商品最小购买量，不能再购买";
                return $root;
            }
        }
        return $root;
    }
    public function getcate_to_attr($cate_id)
    {
        $map['id'] = $cate_id;
        $goodsattr = M('GoodsCategory')->alias('gc')->field('gc.type_id	,g.type,g.is_img,g.name,g.options,g.id')->where("gc.id=" . $cate_id)->JOIN('LEFT JOIN __GOODS_ATTRIBUTE__ g ON g.type_id=gc.type_id')->order('gc.id')->select();
        $attrlist = array();
        if ($goodsattr) {
            foreach ($goodsattr as $key => $val) {
                $attrlist[$val['id']]['attr'] = $val['name'];
                $attrs_options = strtoarray($val['options']);
                $attrlist[$val['id']]['attr_value'] = $attrs_options;
            }
        }
        return $attrlist;
    }
    public function comment_list($goods_id, $type = 0, $p)
    {
        $map['vid'] = $goods_id;
        $map['pid'] = 0;
        $page_size = C('WEB_GOODS_PAGE');
        $p = empty($p) ? 1 : $p;
        if ($type == 1) {
            $map['rank'] =5;
        } else if ($type == 3) {
            $map['rank'] = array('lt', 3);
        }else if($type==2){
            $map['rank'] = array('in', '3,4');
        }
        $count = M("Comment")->where($map)->count();
        $pages = ceil($count / $page_size);
        $info = page_list("Comment", $map, 'addtime desc', true, $page_size, '', $p);
        $re_info = array();
        foreach ($info['list'] as $key => $val) {
            $imgjson = $images = array();
            $r_map['pid'] = $val['id'];
            $r_map['vid'] = $goods_id;
            $r_map['status'] = 1;
            $info['list'][$key]['header_img'] = thumb(M("Member")->where("id=" . $val['uid'])->getField('header_img'));
            $info['list'][$key]['addtime'] = date('Y-m-d H:i:s', $val['addtime']);
            $info['list'][$key]['xing'] = round(($val['rank'] / 5) * 100) . '%';
            $images = unserialize($val['img']);
            foreach($images as $vv){$imgjson[] = thumb($vv);}
            $info['list'][$key]['imgjson'] = $imgjson;
            $re_content = M("Comment")->where($r_map)->field("content")->select();
            if (!empty($re_content)) {
                $info['list'][$key]['re_content'] = $re_content;
            }
        }
        $s_map['vid'] = $goods_id;
        $s_map['status'] = 1;
        $s_map['pid'] = 0;
        $score_count = M('Comment')->where($s_map)->count('score');
        $root['score_count'] = $score_count;
        $root['info'] = $info;
        $root['re_info'] = array_filter($re_info);
        return $root;
    }
    public function collect_goods($id)
    {
        $member_info = $this->member_info;
        if (!$member_info) {
            $data['status'] = 1;
            $data['info'] = '你还没有登入，收藏失败！';
            $data['url'] = U('Home/Login');
        } else {
            $model = M("MemberCollect");
            $map['item_id'] = $id;
            $map['type'] = 0;
            $map['uid'] = $member_info['id'];
            $collectinfo = $model->where($map)->count();
            if ($collectinfo) {
                $model->where($map)->delete();
                $data['status'] = 2;
                $data['info'] = '取消收藏成功!';
            } else {
                $postdata['item_id'] = $id;
                $postdata['uid'] = $member_info['id'];
                $postdata['type'] = 0;
                $postdata['addtime'] = NOW_TIME;
                $result = $model->add($postdata);
                if ($result) {
                    $data['status'] = 0;
                    $data['info'] = '收藏成功';
                } else {
                    $data['status'] = 3;
                    $data['info'] = '收藏失败!';
                }
            }
        }
        return $data;
    }
    public function get_attr($param, $type_id)
    {
        $ext = '';
        if (!empty($type_id)) {
            $attribute = get_type_attr($type_id, $param['cat_id'], 1, '0');
            if ($attribute) {
                foreach ($param as $key => $v) {
                    if (in_array($key, $attribute)) {
                        $extarr = get_extension_attr(str_replace('p', '', $key), $v);
                        if ($extarr) $ext .= ' AND ' . trim($extarr);
                    }
                }
            }
            if ($map['_string']) {
                $map['_string'] .= $ext;
            } else if ($ext) {
                $map['_string'] = substr($ext, 5);
            }
            return $map;
        }
    }
}
?>