<?php


namespace Common\Model;
use Think\Model;
class GoodsCategoryModel extends Model
{

    
    function get_current_cate($cat_id = 0)
    {
        if ($cat_id == 0) {//没有分类显示全部一二级
            return $this->get_categories_tree($cat_id);
        } elseif ($cat_id > 0) {
            GLOBAL $GoodsCategory;
            $cate = array();
            if (empty($GoodsCategory)) $GoodsCategory = getcache('GoodsCategory');
            foreach ($GoodsCategory as $k => $v) {
                if ($v['pid'] == $cat_id) {
                    $cate[$k] = $v;
                }
            }
            if ($cate) {//如有子类 显示当前和子类 其它不显示
                $info = $GoodsCategory[$cat_id];
                $info['child'] = $cate;
                $info['hover'] = 1;
                $data[] = $info;
            } else {//如无子分类 显示当前级和上级
                $info = $GoodsCategory[$cat_id];
                $pre_info = $GoodsCategory[$info['pid']];
                $catt = array();
                foreach ($GoodsCategory as $ke => $va) {
                    if ($va['pid'] == $info['pid']) {
                        $catt[$ke] = $va;
                        if ($va['id'] == $cat_id) {
                            $catt[$ke]['hover'] = 1;
                        }
                    }
                }
                $pre_info['hover'] = 1;
                $pre_info['child'] = $catt;
                $data[] = $pre_info;
            }
            return $data;
        }
    }

    
    function get_categories_tree($cat_id = 0, $cache = true)
    {
        if ($cache) {
            $cachename = 'get_categories_tree' . $cat_id;
            $cachecontent = S($cachename);
            if (!empty($cachecontent)) return $cachecontent;
        }
        GLOBAL $GoodsCategory;
        if (empty($GoodsCategory)) $GoodsCategory = getcache('GoodsCategory');
        $hover = array($cat_id);
        if ($cat_id > 0) {
            $hover[] = $GoodsCategory[$cat_id]['pid'];
            if ($GoodsCategory[$cat_id]['allson'] == $cat_id) $parent_id = $GoodsCategory[$GoodsCategory[$cat_id]['pid']]['pid'];
            else $parent_id = $GoodsCategory[$cat_id]['pid'];
        }
        if (empty($parent_id)) $parent_id = 0;
        $hover[] = $parent_id;
        $cat_arr = array();
        foreach ($GoodsCategory as $v) {
            if ($v['pid'] == $parent_id && $v['status'] == 1) {
                $cat_arr[$v['id']] = $v;
                $cat_arr[$v['id']]['hover'] = in_array($v['id'], $hover) ? 1 : 0;
                $child = array();
                if ($v['allson'] != $v['id']) {
                    $catson = explode(',', $v['allson']);
                    foreach ($catson as $sonid) {
                        $val = $GoodsCategory[$sonid];
                        if ($val['status'] == 1 && $val['id'] != $v['id'] && $val['pid'] == $v['id']) {
                            $child[$val['id']] = $val;
                            $child[$val['id']]['hover'] = in_array($val['id'], $hover) ? 1 : 0;
                        }
                    }
                }
                $cat_arr[$v['id']]['child'] = $child;
            }
        }
        if ($cache) {
            S($cachename, $cat_arr);
        }
        return $cat_arr;
    }

    
    function getcatelist($pid = 0)
    {
        $cacheres = S($tags);
        if ($cacheres) return $cacheres;
        $name = 'GoodsCategory';
        $pid = !empty($pid) ? $pid : '0';
        GLOBAL $GoodsCategory;
        if (!empty($GoodsCategory)) $cachelist = $GoodsCategory;
        if (empty($cachelist)) $cachelist = getcache($name);
        $Tree = new \Common\Vendor\Tree();
        $Tree->init($cachelist);
        $data = $Tree->get_tree_array($pid);
        unset($cachelist);
        $result = empty($tag['return']) ? $data : array_values($data);
        S($tags, $result);
        return $result;
    }

    
    function get_parent_pid($cate_id)
    {
        $GoodsCategory=getcache("GoodsCategory");
        if($GoodsCategory[$cate_id]['pid']==0){
            $balance_rate = $GoodsCategory[$cate_id]['balance_rate'];
        }else{
            do{
                $pidinfo = $GoodsCategory[$GoodsCategory[$cate_id]['pid']];
                $cate_id = intval($pidinfo['id']);
                $id=$pidinfo['pid'];
            }while($id!=0);
            $balance_rate=$pidinfo['balance_rate'];
        }
        return $balance_rate;
    }
}
?>