<?php


namespace Common\Model;
use Think\Model;
class GoodsIntegralModel extends Model
{
    
    public function get_integral_list($map=array(),$join='',$order='',$p=1,$pagesize=0){
        $pagesize=empty($pagesize)?C('WEB_GOODS_PAGE'):$pagesize;
        $p=empty($p)?1:$p;
        $map['a.status']=1;
        $map['g.status']=1;
        $map['g.publish_wait']=1;
        $map['g.is_delete']=0;
        $field='g.*,a.*,g.id as goodsid';
        $join.=' LEFT JOIN __GOODS__ g ON a.goods_id=g.id ';
        $order=empty($order)?'g.sell_count desc,g.avg_point desc,g.count desc,g.updatetime desc':$order;
        $catid=$map['cat_id'];
        if(!empty($catid)) {
            GLOBAL $GoodsCategory;
            $catinfo = $GoodsCategory[$catid];
            $extension_goods_id = get_extension_goods($catinfo['allson'], 1);
            if (!empty($catinfo['allson'])) $where['cat_id'] = array('in', $catinfo['allson']);
            if (!empty($extension_goods_id)) $where['g.id'] = array('in', $extension_goods_id);
            if (!empty($where)) {
                $where['_logic'] = 'or';
                $map['_complex'] = $where;
                unset($map['cat_id']);
            } else {
                $map['cat_id'] = $catid;
            }
        }
        $goodslist=page_list('GoodsIntegral',$map,$order,$field,$pagesize,$join,$p);
        return $goodslist;
    }
    
    public function get_integral($id){
        $return=array();
        $return['status']=0;
        if(empty($id)){
            $return['msg']='参数错误';
            return $return;
        }
        $map['a.id']=$id;
        $map['a.status']=1;
        $map['g.status']=1;
        $map['g.publish_wait']=1;
        $map['g.is_delete']=0;
        $field='g.*,a.*,g.id as goodsid,gc.content';
        $join='LEFT JOIN __GOODS__ g ON a.goods_id=g.id';
        $join.=' LEFT JOIN __GOODS_CONTENT__ gc ON a.goods_id=gc.goods_id';
        $data=M('GoodsIntegral')->alias('a')->join($join)->field($field)->where($map)->find();
        if(empty($data)){
            $return['msg']='未找到该商品';
            return $return;
        }
        $return['status']=1;
        $return['data']=$this->format_integral_item($data);
        return $return;
    }
    public function format_integral_item($data=array()){
        $result=array();
        $result=$data;
        $result['contract_list']=D('Common/Goods')->get_goods_contract($data['shop_id']);
        return $result;
    }
    public function get_cartIntegral($postdata,$addre_id)
    {
        $return = array('status'=>0,'msg'=>'');
       $goods_info=D("Common/OrderInfo")->buy_now($postdata);
        if($goods_info['status']<=0){
            $return['msg']=$goods_info['msg'];
            return $return;
        }

        $list=$goods_info['data'];
        if($list){
                foreach ($list as $key => $val) {
                    $list[$key]['shop_info'] = D("Common/Cart")->format_goods_shop($val['shop_id'],$addre_id);
                    $list[$key]['goods_attr_format'] = unserialize($val['goods_attr']);
                    $list[$key]['all_price'] = ($val['shop_price'] + ($val['cart_integral'] * C('WEB_INTEGRAL_RATIO') / 100)) * $val['goods_num'];
                    $list[$key]['all_price_show'] =format_price($val['shop_price']* $val['goods_num'])." + ". $val['cart_integral']*$val['goods_num']."分";
                    if ($val['shop_price'] > 0) {
                        $list[$key]['all_goods_price'] =format_price($val['shop_price'] * $val['goods_num']) . "+ ";
                    }else{
                        $list[$key]['all_goods_price']=format_price(0)." + ";
                    }
                    if ($val['cart_integral'] > 0) {
                        $list[$key]['all_goods_price'] .= $val['cart_integral'] * $val['goods_num'] . "积分";
                    }
                    $list[$key]['shipping_fee'] = D("Common/Cart")->shipping_fee($list[$key]['all_price'], $val, $list[$key]['shop_info']['configure']);
                    $list[$key]['shop_total_price'] = $list[$key]['shipping_fee'] + $list[$key]['all_price'];//店铺总价格
                    $list[$key]['shop_total_price_show'] =format_price(($val['shop_price']* $val['goods_num'])+$list[$key]['shipping_fee'])." + ". $val['cart_integral']*$val['goods_num']."分";//店铺总价格
                    $list[$key]['shop_total_weight'] = $val['goods_weight'] * $val['goods_num'];//店铺商品总重量
                }
                $return['status']=1;
                $return['list']=$list;
            }else{
                $return['msg']='没有此积分商品';
            }

        return $return;
    }
    public function get_cartIntegrals($cart_ids)
    {
        $return = array();
        $return['status'] = 0;
        $c_where['c.id'] = array('in', $cart_ids);
        $list = M('Cart')->alias('c')->JOIN('LEFT JOIN __GOODS__ g ON g.id=c.goods_id')->JOIN('LEFT JOIN __GOODS_INTEGRAL__ gi ON gi.goods_id=c.goods_id')->where($c_where)->field('g.*,g.id as goods_id,c.id as id,c.user_id,c.cookie_id,c.goods_attr,c.goods_num,c.cart_integral as cart_integral,c.shop_price as shop_price')->order('g.shop_id asc')->select();
        if($list) {
            foreach ($list as $key => $val) {
                $list[$key]['shop_info'] = D("Common/Cart")->format_goods_shop($val['shop_id']);
                $list[$key]['goods_attr_format'] = unserialize($val['goods_attr']);
                $list[$key]['all_price'] = ($val['shop_price'] + ($val['cart_integral'] * C('WEB_INTEGRAL_RATIO') / 100)) * $val['goods_num'];
                if ($val['shop_price'] > 0) {
                    $list[$key]['all_goods_price'] = format_price($val['shop_price'] * $val['goods_num']);
                }
                if ($val['cart_integral'] > 0) {
                    $list[$key]['all_goods_price'] .= '+' . $val['cart_integral'] * $val['goods_num'] . "积分";
                }
                $list[$key]['shipping_fee'] = D("Common/Cart")->shipping_fee($list[$key]['all_price'], $val, $list[$key]['shop_info']['configure']);
                $list[$key]['shop_total_price'] = $list[$key]['shipping_fee'] + $list[$key]['all_price'];//店铺总价格
                $list[$key]['shop_total_weight'] = $val['goods_weight'] * $val['goods_num'];//店铺商品总重量
            }
            $return['status']=1;
            $return['list']=$list;
        }else{
            $return['msg']='没有此积分商品';
        }
        return $return;
    }
}
?>