<?php
namespace Common\Model;
use Think\Model;
class MemberModel extends Model
{
    public function get_collect_goods($map=array(),$join='',$order='',$p=1,$pagesize=0){
        $memberinfo=checkuserauthtype();
        $pagesize=empty($pagesize)?C('WEB_GOODS_PAGE'):$pagesize;
        $p=empty($p)?1:$p;
        $map['a.status']=1;
        $map['a.uid']=$memberinfo['id'];
        $field='g.*,a.*';
        $order="a.id desc";
        $join=" LEFT JOIN __GOODS__ g ON a.goods_id=g.id ";
        $collectgoods=page_list('GoodsCollect',$map,$order,$field,$pagesize,$join,$p);
        return $collectgoods;
    }
    public function get_collect_shops($map=array(),$join='',$order='',$p=1,$pagesize=0){
        $memberinfo=checkuserauthtype();
        $pagesize=empty($pagesize)?C('WEB_GOODS_PAGE'):$pagesize;
        $p=empty($p)?1:$p;
        $map['a.status']=1;
        $map['a.uid']=$memberinfo['id'];
        $field='s.*,a.*';
        $join=" LEFT JOIN __SHOPS__ s ON a.shop_id=s.id ";
        $collectshops=page_list('ShopsCollect',$map,$order,$field,$pagesize,$join,$p);
        foreach($collectshops['list'] as $key=>$val){
            $n_map['shop_id']=$val['shop_id'];
            $n_map['status']=1;
            $n_map['is_new']=1;
            $new_count=M('Goods')->where($n_map)->count('id');
            $collectshops['list'][$key]['new_count']=$new_count;
        }
        return $collectshops;
    }
    public function delete_collect($id,$type){
        $memberinfo=checkuserauthtype();
        if(empty($id)){
            $return['msg'] = '参数错误';
            $return['status']=0;
            return $return;
        }
        $map['id']=$id;
        $map['uid']=$memberinfo['id'];
        if($type=='goods'){
            $result=M('GoodsCollect')->where($map)->delete();
        }else if($type=='shops'){
            $result=M('ShopsCollect')->where($map)->delete();
        }
        if($result){
                $return['msg']='删除成功';
                $return['status']=1;
            }else{
                $return['msg']='删除失败';
                $return['status']=0;
            }
        return $return;
    }
    public function user_infor($data=array()){
        $return['status']=0;
        $memberinfo=checkuserauthtype();
        $map['id']=$memberinfo['id'];
        $userinfo=M('Member')->where($map)->field(true)->find();
        if($data) $regular= new \Common\Vendor\Regular();
        if($data['infos']=='pwd') {
            if(!$regular->isEmpty($data['password']) || !$regular->isEmpty($data['newpassword'])){
                $return['msg']="必填项不能为空";
                 return $return;
             }
            $password=creatpwd($data['password'],'HANCHAO'.$userinfo['salt']);
            if ($password != $userinfo['password']){
                $return['msg']='旧密码输入错误';
                return $return;
            }
            if($data['newpassword'] == $data['password']){
                    $return['msg']='新密码和旧密码一样，请重新输入';
                    return $return;
             }
            if(!$regular->passWord(6,16,$data['newpassword'])){
                 $return['msg']='密码长度应为6-16位，可包含数字、字母、特殊符号';
                return $return;
            }
            if ($data['newpassword'] != $data['repassword']) {
                    $return['msg']='两次输入密码不一致';
                    return $return;
            }
            $savedata['password'] = creatpwd($data['newpassword'],'HANCHAO'.$userinfo['salt']);
        }else if($data['infos']=='paypwd'){
            $paypassword=creatpwd($data['paypassword'],'HANCHAO'.$userinfo['salt']);
            if ($paypassword != $userinfo['paypassword'] && !empty($data['paypassword'])){
                $return['msg']='旧密码输入错误';
                return $return;
            }
            if(empty($data['newpaypassword'])){
                $return['msg']="必填项不能为空";
                return $return;
            }
            if(!$regular->passWord(6,16,$data['newpaypassword'])){
                $return['msg']='密码长度应为6-16位，可包含数字、字母、特殊符号';
                return $return;
            }
            if($data['newpaypassword'] == $data['paypassword']){
                    $return['msg']='新密码和旧密码一样，请重新输入';
                    return $return;
            }
            if ($data['newpaypassword'] != $data['repaypassword']) {
                $return['msg']='两次输入密码不一致';
                return $return;
            }
            $savedata['paypassword'] = creatpwd($data['newpaypassword'],'HANCHAO'.$userinfo['salt']);
        }else if($data['infos']=='user'){
            if(!$regular->isEmpty($data['nickname'])){
                $return['msg']='昵称不能为空';
                return $return;
            }
            if(!$regular->isEmpty($data['username'])){
                $return['msg']='会员名不能为空';
                return $return;
            }
            if($data['username']){
                $where['id']=array('neq',$memberinfo['id']);
                $where['username']=$data['username'];
                $count=M('Member')->where($where)->count('id');
                if($count>0){
                    $return['msg']='会员名已存在，请更换会员名';
                    return $return;
                }
            }
            if(!empty($data['email']) && !$regular->isEmail($data['email'])){
                $return['msg']='邮箱格式不正确';
                return $return;
            }
            $savedata=$data;
            $savedata['updatetime']=NOW_TIME;
        }
        $result=M('Member')->where($map)->save($savedata);
        if($result) {
            if($data['infos']=='pwd'){
                $data=D('Common/Login')->logout();
                $return['url']=$data['url'];
                $return['msg']='修改成功，请重新登录';
            }else{
                $return['url']=getjumpurl('JUMP_4');
                $return['msg']='修改成功';
            }
            $return['status']=1;
        } else {
            $return['msg']='修改失败';
        }
        return $return;
    }
    public function get_address_list($map=array(),$join='',$order='',$p=1,$pagesize=0){
        $memberinfo=checkuserauthtype();
        $map['uid']=$memberinfo['id'];
        $order='id desc';
        $pagesize=empty($pagesize)?C('WEB_DEFAULT_PAGE'):$pagesize;
        $p=empty($p)?1:$p;
        $address_list=page_list('MemberAddress',$map,$order,true,$pagesize,'',$p);
        foreach($address_list['list'] as $key=>$val){
            $address_list['list'][$key]=$this->format_address_item($val);
        }
        return $address_list;
    }
    public function address_cont($id){
        $memberinfo=checkuserauthtype();
        $map['uid']=$memberinfo['id'];
        $map['id']=$id;
        $address=M('MemberAddress')->where($map)->field(true)->find();
        $address=$this->format_address_item($address);
        return $address;
    }
    public function format_address_item($data=array()){
        $result=$data;
        $result['username']=idtoname($data['uid'],"Member",'username');
        $regions['province']=idtoname($data['province'],"Area",'name');
        $regions['city']=idtoname($data['city'],"Area",'name');
        $regions['district']=idtoname($data['district'],"Area",'name');
        $result['region']=$regions['province'].$regions['city'].$regions['district'];
        $result['best_time']=time_format($data['best_time'],'Y-m-d');
        $result['updatetime']=time_format($data['updatetime'],'Y-m-d');
        return $result;
    }
    public function modify_address($param=array()){
        $id = intval($param['id']);
        $memberinfo=checkuserauthtype();
        $return['status'] = 0;
        $num=C('MEMBER_RECRIVE_ADDRESS_NUM');
        if(!isset($param['changetype'])){
            if($param) $regular= new \Common\Vendor\Regular();
            if(!$regular->isEmpty($param['consignee'])){
                $return['msg']='收件人不能为空';
                return $return;
            }
            if(!$regular->isEmpty($param['province']) || !$regular->isEmpty($param['city_id']) || !$regular->isEmpty($param['district'])){
                $return['msg'] = '请填写完整的所在地区';
                return $return;
            }
            if(!$regular->isEmpty($param['address'])){
                $return['msg'] = '请填写完整的收货地址';
                return $return;
            }
            if(!$regular->isEmpty($param['mobile'])){
                $return['msg'] = '手机号不能为空';
                return $return;
            }
            if(!$regular->isPhone($param['mobile'])){
                $return['msg']='手机号格式不正确';
                return $return;
            }
            if(!$regular->isTel($param['tel']) && $regular->isEmpty($param['tel'])){
                $return['msg']='固定电话格式不正确';
                return $return;
            }
        }
        $data = $param;
        if(!empty($param['city_id']))$data['city']=$param['city_id'];
        $data['updatetime']=NOW_TIME;
        if($param['status']==1) {
            $d_map['uid'] = $memberinfo['id'];
            $d_map['status'] = 1;
            $d_id = M('MemberAddress')->where($d_map)->getField('id');
        }
        if($id>0){
            $map['id'] = $id;
            if($param['status']==0 || empty($param['status'])){
                $data['status']=0;
            }
            if($d_id>0){
                $ad_data['status']=0;
                $ad_map['id']=$d_id;
                M('MemberAddress')->where($ad_map)->save($ad_data);
                $data['status']=1;
            }
            $result = M('MemberAddress')->where($map)->save($data);
        }else{
            $where['uid']=$memberinfo['id'];
            $count=M('MemberAddress')->where($where)->count();
            if($count<$num){
                unset($data['id']);
                if($d_id>0){
                    $ad_data['status']=0;
                    $ad_map['id']=$d_id;
                    M('MemberAddress')->where($ad_map)->save($ad_data);
                    $data['status']=1;
                }
                $data['uid'] = $memberinfo['id'];
                $result = M('MemberAddress')->add($data);
            }else{
                $return['msg']='收货地址最多为'.$num.'个';
                return $return;
            }
        }
        if($result){
            $return['status'] = 1;
            $return['msg'] = '操作成功';
            $return['url']=getjumpurl('JUMP_6');
        }else{
            $return['status'] = 0;
            $return['msg'] = '操作失败';
        }
        return $return;
     }
     public function delete_address($id){
        $return['status']=0;
        if(empty($id)){
            $return['msg'] = '参数错误';
            return $return;
        }
        $memberinfo=checkuserauthtype();
        $map['id']=$id;
        $map['uid']=$memberinfo['id'];
        $result=M('MemberAddress')->where($map)->delete();
        if($result){
                $return['msg']='删除成功';
                $return['status']=1;
            }else{
                $return['msg']='删除失败';
            }
        return $return;
     }
     public function my_extension($postdata=array(),$join='',$order='',$p=1,$pagesize=0){
        $data=array();
        $memberinfo=checkuserauthtype();
        $map['uid']=$memberinfo['id'];
        if(!empty($postdata['order_sn'])){
            $where['order_sn']=$postdata['order_sn'];
            $order_id=M('OrderInfo')->where($where)->getField('id');
            $map['order_id']=$order_id;
        }
        $order='id desc';
        $pagesize=empty($pagesize)?C('WEB_GOODS_PAGE'):$pagesize;
        $p=empty($p)?1:$p;
        $records = C('RECORDS');
        $is_fx = is_fx($memberinfo['id']);
        if($is_fx){
            $my_extension=page_list('AffiliateLog',$map,$order,true,$pagesize,'',$p);
            foreach ($my_extension['list'] as $key => $val) {
                $my_extension['list'][$key]=$this->format_extension_item($val);
            }
            $data['extension_list']=$my_extension;
        }else if($records){
            $my_extension=page_list('AffiliateLog',$map,$order,true,$pagesize,'',$p);
            foreach ($my_extension['list'] as $key => $val) {
                $my_extension['list'][$key]=$this->format_extension_item($val);
            }
            $data['extension_list']=$my_extension;
        }
        return $data;
     }
     public function extension_list($postdata=array(),$join='',$order='',$p=1,$pagesize=0){
        $memberinfo=checkuserauthtype();
        if(!empty($postdata['parent_id'])){
            $where_m['id'] = $postdata['parent_id'];
            $m_list = M('Member')->where($where_m)->field('id')->select();
            if (!empty($m_list)) {
                foreach ($m_list as $k => $v) {
                    $me_list[] = $v['id'];
                }
                $map['parent_id'] = array(array('in', $me_list));
            }
        }else{
            $map['parent_id']=$memberinfo['id'];
        }
        $order='id desc';
        $pagesize=empty($pagesize)?C('WEB_DEFAULT_PAGE'):$pagesize;
        $p=empty($p)?1:$p;
        $extension_list = page_list('Member',$map,$order,true,$pagesize,'',$p);
        $data['extension_list']=$extension_list;
        return $data;
     }
     public function extension(){
        $memberinfo=checkuserauthtype();
        $data['uid']=$memberinfo['id'];
        $map['uid']=$memberinfo['id'];
        $sum_separate=M('AffiliateLog')->where($map)->sum('money');
        $data['sum_separate']=$sum_separate;
        $extensionurl=U('Home/Login/register',array('eid'=>$memberinfo['id']),true,true);
        $extension_mobileurl=U('Mobile/Login/register',array('eid'=>$memberinfo['id']),true,true);
        $data['extensionurl']=$extensionurl;
        $data['extension_mobileurl']=$extension_mobileurl;
        $url = U('Mobile/Login/register',array('eid'=>$memberinfo['id']),true,true);
        $data['img_url'] = U('Home/Qrcode/index',array('data'=>urlencode($url)));
        return $data;
     }
     public function format_extension_item($data=array()){
        $result=$data;
        $order_info=idtoname($data['order_id'],"OrderInfo",'order_sn,pay_code,goods_amount,uid');
        $result['order_sn']=$order_info['order_sn'];
        $result['pay_code']=$order_info['pay_code'];
        $result['goods_amount']=$order_info['goods_amount'];
        $result['addtime']=time_format($data['addtime'],'Y-m-d');
        $result['extensionname']=idtoname($order_info['uid'],"Member",'username');
        $result['extensionid']=$order_info['uid'];
        if($data['is_separate']==0) {
            $result['is_separate']='未分成';
        }elseif ($data['is_separate']==1) {
            $result['is_separate']='已分成';
        }else{
            $result['is_separate']='取消分成';
        }
        $result['username']=idtoname($data['uid'],"Member",'username');
        return $result;
     }
     public function integral($data=array(),$type=4,$join='',$order='',$p=1,$pagesize=0){
        $memberinfo=checkuserauthtype();
        $map['id']=$memberinfo['id'];
        $points=M('Member')->where($map)->field('points,usepoints')->find();
        $allpoints=$points['points']+$points['usepoints'];
        $return['allpoints']=format_decimal($allpoints,2);
        if(!empty($data['keyword']))$where['change_desc']=array('like','%'.$data['keyword'].'%');
        if(!empty($data['from_time']))$where['change_time'][]=array('EGT',strtotime($data['from_time']));
        if(!empty($data['to_time']))$where['change_time'][]=array('ELT',strtotime($data['to_time']));
        if(!empty($data['status'])){
            $where['status']=$data['status'];
        }else{
            $where['status']=array('gt',0);
        }
        $where['uid']=$memberinfo['id'];
        if($type==4){
            $usepoints=M('Member')->where($map)->getField('usepoints');
            $return['allpoints']=format_decimal($usepoints,2);
        }else{
            $points=M('Member')->where($map)->getField('points');
            $return['allpoints']=format_decimal($points,2);
        }
        $where['type']=$type;
        $order='id desc';
        $pagesize=empty($pagesize)?C('WEB_DEFAULT_PAGE'):$pagesize;
        $p=empty($data['page'])?1:$data['page'];
        $points_details=page_list('AccountLog',$where,$order,true,$pagesize,'',$p);
        foreach($points_details['list'] as $key=>$val){
            $points_details['list'][$key]=$this->format_integral_item($val);
        }
        $return['points_details']=$points_details;
        return $return;
     }
     public function format_integral_item($data=array()){
        $result=$data;
        if($data['change_type']==0){$result['change_type']='+';}else{$result['change_type']='-';}
        return $result;
     }
     public function redPacket($type,$postdata=array(),$join='',$order='',$p=1,$pagesize=0){
        $memberinfo=checkuserauthtype();
        $order='id desc';
        $pagesize=empty($pagesize)?C('WEB_DEFAULT_PAGE'):$pagesize;
        $p=empty($postdata['page'])?1:$postdata['page'];
        $map['user_id']=$memberinfo['id'];
        $map['used_time']=0;
        if($type==1){
            $map['end_time']=array('gt',NOW_TIME);
        }elseif ($type==2) {
            $map['used_time']=array('gt',0);
        }else{
            $map['end_time']=array('lt',NOW_TIME);
        }
        $bonu_list=page_list('MemberBonus',$map,$order,true,$pagesize,'',$p);
        $n_where['used_time']=0;
        $n_where['user_id']=$memberinfo['id'];
        $n_where['end_time']=array('gt',NOW_TIME);
        $bonu_list['n_count']=M('MemberBonus')->where($n_where)->count('id');
        $u_where['used_time']=array('gt',0);
        $u_where['user_id']=$memberinfo['id'];
        $bonu_list['u_count']=M('MemberBonus')->where($u_where)->count('id');
        $o_where['user_id']=$memberinfo['id'];
        $o_where['end_time']=array('lt',NOW_TIME);
         $o_where['used_time']=0;
        $bonu_list['o_count']=M('MemberBonus')->where($o_where)->count('id');
        return $bonu_list;
     }                                                                                                                     
     public function delete_redPacket($id){
        $memberinfo=checkuserauthtype();
        $return['status']=0;
        if(empty($id)){
            $return['msg'] = '参数错误';
            return $return;
        }
        $map['id']=$id;
        $map['uid']=$memberinfo['id'];
        $result=M('MemberBonus')->where($map)->delete();
        if($result){
            $return['msg']='删除成功';
            $return['status']=1;
        }else{
            $return['msg']='删除失败';
        }
        return $return;
     }
     public function submit_service($postdata=array()){
        $return['status']=0;
        if(empty($postdata['content'])){
            $return['msg']='请输入内容，以便我们及时解决您的问题';
            return $return;
        }
        $adddata['type']=$postdata['type'];
        $adddata['goods_id']=$postdata['goods_id'];
        $adddata['order_id']=$postdata['order_id'];
        if($postdata['goods_id']){
            $adddata['shop_id']=M('Goods')->where('id='.$postdata['goods_id'])->getField('shop_id');
        }elseif($postdata['order_id']){
            $adddata['shop_id']=M('OrderInfo')->where('id='.$postdata['order_id'])->getField('shop_id');
        }
        $adddata=$postdata;
        $adddata['addtime']=NOW_TIME;
        $adddata['status']=0;
        $adddata['is_delete']=0;
        $result=M('Service')->add($adddata);
        if($result){
            $return['status'] = 1;
            $return['msg'] = '提交成功';
            if($postdata['type']==1){
                $return['url']=U('Member/CustomerService/complaint_list');
            }else{
                $return['mobile_url']=U('Mobile/Member/index');
                $return['url']=U('Member/CustomerService/platform_service');
            }
        }else{
            $return['status'] = 0;
            $return['msg'] = '提交失败';
        }
        return $return;
     }
     public function service_list($postdata=array(),$type,$join='',$order='',$p=1,$pagesize=0){
        $memberinfo=checkuserauthtype();
        $map['uid']=$memberinfo['id'];
        $map['type']=$type;
        $map['is_delete']=0;
        if(!empty($postdata)){
            if($postdata['status']==1){
                $map['status']=0;
            }elseif($postdata['status']==2){
                $map['status']=1;
            }elseif($postdata['status']==3){
                $map['status']=2;
            }
        }
        $order='id desc';
        $pagesize=empty($pagesize)?C('WEB_DEFAULT_PAGE'):$pagesize;
        $p=empty($p)?1:$p;
        $list=page_list('Service',$map,$order,true,$pagesize,'',$p);
        foreach ($list['list'] as $key => $val) {
            $list['list'][$key]=$this->format_service_item($val);
        }
        return $list;
     }
     public function service_cont($id){
        $memberinfo=checkuserauthtype();
        $map['uid']=$memberinfo['id'];
        $map['id']=$id;
        $data=M('Service')->where($map)->field(true)->find();
        $list=$this->format_service_item($data);
        return $list;
     }
     public function cancel_service($id){
        $return['status']=0;
        $memberinfo=checkuserauthtype();
        if(empty($id)){
            $return['msg']='参数错误';
            return $return;
        }
        $map['id']=$id;
        $map['uid']=$memberinfo['id'];
        $savedata['status']=2;
        $result=M('Service')->where($map)->save($savedata);
        if($result){
            $return['msg']='取消成功';
            $return['status']=1;
        }else{
            $return['msg']='取消失败';
        }
        return $return;
     }
     public function del_service($id){
        $return['status']=0;
        $memberinfo=checkuserauthtype();
        if(empty($id)){
            $return['msg']='参数错误';
            return $return;
        }
        $map['id']=$id;
        $map['uid']=$memberinfo['id'];
        $savedata['is_delete']=1;
        $result=M('Service')->where($map)->save($savedata);
        if($result){
            $return['msg']='删除成功';
            $return['status']=1;
        }else{
            $return['msg']='删除失败';
        }
        return $return;
     }
     public function format_service_item($data=array()){
        $result=$data;
        if($data['type']==1) {
            $result['type_name']='投诉';
        }elseif ($data['type']==2) {
            $result['type_name']='商品咨询';
        }else{
            $result['type_name']='订单咨询';
        }
        $result['goods_name']=idtoname($data['goods_id'],"Goods",'goods_name');
        $shop_id=idtoname($data['goods_id'],"Goods",'shop_id');
        $result['shop_name']=idtoname($shop_id,"Shops",'name');
        $result['addtime']=time_format($data['addtime'],'Y-m-d');
        $result['updatetime']=time_format($data['updatetime'],'Y-m-d');
        if($data['status']==0){
            $result['status_name']='进行中';
        }elseif($data['status']==1){
            $result['status_name']='已完成';
        }else{
            $result['status_name']='已取消';
        }
        return $result;
     }
    public function resetpwd($param){
        $return=array('status'=>0,'code'=>$param['code']);
        $code=$param['code'];
        if($code=='getpwd'){
            $is_true = check_verify_code($param['mobile'],$param['mobilecode'],0);
            if($is_true == false){
                $return['info']='短信验证码错误!';
                $return['url']=U('Member/Userinfo/securitys_back');
                return $return;
            }else{
                $memberinfo=M('Member')->where('mobile='.$param['mobile'])->field(true)->find();
                if(empty($memberinfo)||$memberinfo['status']==0){
                    $return['info']='用户不存在或已禁用';return $return;
                }
                $return['status']=1;
                $return['mid'] =$memberinfo['id'];
            }
        }elseif($param['code']='resetpwd'){
            $memberinfo=idtoname($param['mid'],'Member','*');
            if(!$param['paypassword'] || !$param['repaypassword'] || $param['paypassword']!=$param['repaypassword']){
                $return['info']='您输入的密码为空或不一致,请重新输入!';
            }else if(empty($memberinfo)){
                $return['info']='参数错误!';
            }else{
                $errorlog=array('0'=>'没有做任何修改','1'=>'更新成功','-1'=>'旧密码不正确','-7'=>'没有做任何修改','-8'=>'该用户受保护无权限更改');
                $result=$this->reset_pwd($memberinfo['id'],$param['paypassword']);
                if($result==1){
                    $return['status']=1;
                    $return['info']='找回密码成功！';
                    $return['url']=U('Member/Index/index');
                }else{
                    $return['info']=$errorlog[$result];
                }
            }
        }
        return $return;
    }
    public function reset_pwd($uid,$password,$is_id='1'){
        if(!$uid || !$password)return false;
        if($is_id==1){
            $where['id']=$uid;
        }else{
            $where['username']=$uid;
        }
        $uinfo=M('Member')->where($where)->field('id,username,email,salt')->find();
        $data['paypassword']=creatpwd($password, 'HANCHAO'.$uinfo['salt']);
        $result=$this->where($where)->save($data);
        if($result)$log=1;else $log=0;
        return $log;
    }
}
?>