<?php
namespace Common\Model;
use Think\Model;
class OrderInfoModel extends Model{
	public function order_list($cart_ids='',$goods_id,$type,$addre_id){
        $memberinfo = checkuserauthtype();
		$return = array();
		$return['status'] = 1;
		if(!$memberinfo['id']){
			$return['status'] = -1;
			$return['msg'] = '还未登录，请先登录';
			return $return;
		}
        $address = M('MemberAddress')->where('uid=' . $memberinfo['id'])->order('status desc')->select();
        foreach ($address as $k => $v) {
            if ($v['status'] == 1) {
                $return['addr_check_id'] = $v['id'];
            }
            $address[$k]['province'] = idtoname($v['province'], 'Area');
            $address[$k]['city'] = idtoname($v['city'], 'Area');
            $address[$k]['district'] = idtoname($v['district'], 'Area');
        }
        $return['address_list'] = $address;
        $where['uid']=$memberinfo['id'];
        $where['status']=1;
        $status_address = M('MemberAddress')->where($where)->getField('id');
        if($addre_id){
            $addre_id=$addre_id;
        }elseif($status_address){
            $addre_id=$status_address;
        }
        if($cart_ids) {
            if (empty($cart_ids)) {
                $return['status'] = 0;
                $return['msg'] = '没有可结算的商品';
                return $return;
            } else {
                $list = D("Common/Cart")->cartlist('', $cart_ids, 1,$addre_id);
                $return['data'] = $list;
            }
        }
        if($goods_id){
            if($type==3){
                $list = D("Common/GoodsIntegral")->get_cartIntegral($goods_id,$addre_id);
            }else {
                $list = D("Common/Cart")->cartlist($goods_id, '', 1,$addre_id);
            }
            $return['data'] = $list;
            $return['is_addcart'] = $type;
        }
		return $return;
	}
	public function modify_address($param=array()){
		$id = intval($param['id']);
		$memberinfo=checkuserauthtype();
		$return['status'] = 0;
                          if($param) $regular= new \Common\Vendor\Regular();
		if(trim($param['consignee'])==''){
			 $return['msg'] = '请填写收货人姓名';
			 return $return;
		}
		if(!$param['province']||!$param['district']||!$param['city_id']){
			 $return['msg'] = '请填写完整的所在地区';
			 return $return;
		}
                         $address_info= cookie('dingwei_address');
                         if($address_info){
                             if($param['province']!=$address_info['province']){
                                 $return['msg'] = '此地址不在配送区域请重新填写';
                                 return $return;
                             }
                             if($param['city_id']!=$address_info['city']){
                                 $return['msg'] = '此地址不在配送区域请重新填写';
                                 return $return;
                             }
                             if($param['district']!=$address_info['district']){
                                 $return['msg'] = '此地址不在配送区域请重新填写';
                                 return $return;
                             }
                         }else{
                             $return['msg'] = '请选择配送区域';
                             return $return;
                         }
		if(trim($param['address'])==''){
			 $return['msg'] = '请填写完整的收货地址';
			 return $return;
		}
                         if(!$param['mobile']&&!$param['tel']){
                             $return['msg'] = '手机号/固话不能为空';
                             return $return;
                         }
                         if(!$regular->isPhone($param['mobile'])){
                                $return['msg']='手机号格式不正确';
                                return $return;
                         }
		$data = $param;
		$data['city']=$param['city_id'];
		$data['updatetime']=NOW_TIME;
		if($id>0){
			$map['id'] = $id;
			$result = M('MemberAddress')->where($map)->save($data);
		}else{
			unset($data['id']);
			$map = array();
			$data['uid'] = $memberinfo['id'];
			$result = M('MemberAddress')->where($map)->add($data);
		}
		if($result){
			$return['status'] = 1;
			$return['msg'] = '操作成功';
		}else{
			$return['status'] = 0;
			$return['msg'] = '操作失败';
		}
		return $return;
	}
	public function check_active($good_ids){
		$return['status']=1;
		if(empty($good_ids)){
			$return['status']=0;
			$return['msg']='请选择需要验证的商品';
			return $return;
		}
		foreach($good_ids as $k=>$v){
			$cart_id=idtoname($v['id'],'Cart','cart_id');
			if($cart_id>0){
				$promot_info=idtoname($cart_id,'PromotAct');
				if(!empty($promot_info)&&$promot_info['end_time']<NOW_TIME){
					$return['status']=0;
					$return['msg']=$promot_info['act_name'].'活动已过期';
					break;
				}
			}
		}
		return $return;
	}
	public function count_total($cart_ids,$data,$type=1,$bonu=array(),$score=0,$use_account=0,$account_money=0,$payment_id=0,$delivery_id=0){
        $total_price=0;
		$total_shipping_fee=0;
		$use_score=0;
		$use_score_money=0;
		$bonu_money=0;
		$active_money=0;
        $goods_integral=0;
        $integral_price=0;
        $total_integral_price=0;
        $total_price_show='';
		$memberinfo=checkuserauthtype();
        if(empty($memberinfo))return false;
		$memberinfo=idtoname($memberinfo['id'],'Member','*');
        if($account_money<=0)$account_money=0;
		if($type==1 || $type==6 || $type==7) {
            $order_type=$type;
            if($cart_ids){
                $cart_list = D("Common/Cart")->cartlist('', $cart_ids,1,$delivery_id);
            }elseif($data){
                $cart_list =  D("Common/Cart")->cartlist($data, '', 1,$delivery_id);
                }
            foreach ($cart_list['shopgoods'] as $key => $val) {
                $total_price += $val['goods_total_price'];
            }
            foreach ($cart_list['list'] as $key => $val) {
                $total_shipping_fee += $val['shop_info']['shipping_fee'];
                foreach($val['promot_list'] as $k=>$gv){
                    foreach($gv['goods_list'] as $kk=>$v){
                        if($v['is_integral']==0){
                            $integral_price+=$v['goods_num']*$v['shop_price'];
                        }
                        if($v['pre_type']==6 && $v['pre_money']>0){
                            $total_price = $v['pre_money'];
                        }
                    }
                    $total_integral_price+=$integral_price;
                }
            }
        }else{
            $order_type=3;
            $cart_list=D("Common/GoodsIntegral")->get_cartIntegral($data);
            if($cart_list['status']==1){
                foreach($cart_list['list'] as $key=>$val){
                    $total_price+=$val["all_price"];
                    $total_price_show.=$val["all_price_show"];
                    $total_shipping_fee+=$val['shipping_fee'];
                    $goods_integral+=$val['cart_integral']*$val['goods_num'];
                }
            }
        }
            $active_money=$cart_list['all_save_price'];
			if(!empty($bonu)){
                $bonu=array_filter($bonu);
				foreach($bonu as $bk=>$bv){
					$bonu_info=idtoname($bv,'MemberBonus','*');
					$bonu_money+=$bonu_info['money'];
				}
			}
			if($score>0){
                if($type==1 || $type==6 || $type==7){
                    $order_type=1;
                    $score_use_total=$total_price-$bonu_money-$active_money-$total_integral_price;
                    if($score_use_total<=0){
                        $score_use_total=0;
                    }
                   $order_score=intval($score_use_total*(C('INTGRAL_PAY_RATIO')/100)*100/C('WEB_INTEGRAL_RATIO'));
                    if($memberinfo['usepoints']>0){
                        if($memberinfo['usepoints']>=$order_score){
                            $use_score=$order_score*(C('WEB_INTEGRAL_RATIO')/100);
                            $pay_score=intval($order_score);
                        }else{
                            $use_score=$memberinfo['usepoints']*(C('WEB_INTEGRAL_RATIO')/100);
                            $pay_score=intval($memberinfo['usepoints']);
                        }
                    }
                    $use_score_money=$use_score;
                }else{
                    $order_type=3;
                    $score_use_total=$goods_integral*C('WEB_INTEGRAL_RATIO')/100;
                    if($memberinfo['usepoints']>0){
                        if($memberinfo['usepoints']>=$score_use_total){
                            $use_score=$score_use_total;
                            $pay_score=$goods_integral;
                        }else{
                            $use_score=$memberinfo['usepoints'];
                            $pay_score=$use_score;
                        }
                    }
                    $use_score_money=$use_score;
                }
			}
			if($memberinfo['money']>0){
				$pay_price=$total_price+$total_shipping_fee-$use_score_money-$bonu_money-$active_money;
				if($use_account==1 && $account_money==0){
					$account_money=$memberinfo['money'];
				}else if($use_account==1 && $account_money>0){
                    $account_money=$account_money;
                }
				if($account_money>$pay_price){
					$account_money=$pay_price;
				}
			}else{
                $account_money=$memberinfo['money'];
            }
			if($payment_id>0 && $payment_id!=1){
				$payment_info=idtoname($payment_id,'Payment','*');
                $counter_fee=$payment_info['fee'];
			}
			if($delivery_id>0){
				$address_info=idtoname($delivery_id,'MemberAddress','*');
				$address='';
				if(!empty($address_info))$address='寄送至：'.$address_info['address'].'    收货人：'.$address_info['consignee'].$address_info['mobile'];
			}
			$pay_price=$total_price+$total_shipping_fee-($use_score_money+$bonu_money+$account_money+$active_money);
            if($counter_fee>0){
                $pay_fee=format_decimal($pay_price*$counter_fee/100);
                $pay_price=$pay_price+$pay_fee;
            }
		if($account_money<0){$account_money=0;}
		$return = array();
		$return['data']=$cart_list;
		$return['total_info']=array(
			'total_price'=>$total_price,
            'total_price_show'=> $total_price_show,
			'pay_price'=>format_decimal($pay_price),
			'pay_fee'=>format_decimal($pay_fee),
			'total_shipping_fee'=>$total_shipping_fee,
			'use_score'=>$use_score,
			'score'=>$pay_score,
			'use_score_money'=>$use_score_money,
			'bonu_money'=>$bonu_money,
			'active_money'=>$active_money,
			'account_money'=>$account_money,
			'payment_info'=>$payment_info,
            'pay_total_price'=>	$total_price+$total_shipping_fee-$active_money-$bonu_money,
			'address_info'=>$address,
			'order_type'=>$order_type,
		);
		return $return;
	}
    public function get_userbouns(){
        $memberinfo=checkuserauthtype();
        $map=$bouns_info=array();
        $map['bonus_type_id']=5;
        $map['used_time']=0;
        $now_time=NOW_TIME;
        $map['_string']='(start_time = 0 or start_time <= '.$now_time.') and (end_time = 0 or end_time >= '.$now_time.')';
        $bouns_info=M("MemberBonus")->where($map)->select();
        return $bouns_info;
    }
    public function check_user_bonus($bonus_id){
        $return=array();
        $return['status']=1;
        if(empty($bonus_id)){
            $return['status']=0;
            $return['msg']='请选择代金券';
            return $return;
        }
        $map['id']=$bonus_id;
        $bonus_info=M("MemberBonus")->where($map)->field(true)->find();
        if(!empty($bonus_info)&&$bonus_info['end_time']<NOW_TIME && $bonus_info['end_time']!=0){
            $return['status']=0;
            $return['msg']=$bonus_info['type_name'].'优惠券已过期';
            return $return;
        }
        return $return;
    }
	public function sub_order($param=array()){
		$return =array('status'=>0,'msg'=>'');
		$memberinfo=checkuserauthtype();
        if(empty($memberinfo)){$return['msg']='请先登录';$return['url'] = getjumpurl('JUMP_1');return $return;}
		$cart_ids=$param['ids'];
		$addr_id = $param['addr_id'];
		$bonu=$param['boun'];
        $content=$param['content'];
		$score=$param['score']?$param['score']:0;
		$type=$param['type'];
		$use_account=$param['use_account'];
		$account_money=floatval($param['account_money'])?floatval($param['account_money']):0;
		$payment_id=$param['payment_id']?$param['payment_id']:0;
        $source=$param['source'];
        $pay_pwd=$param['pay_pwd'];
        $data=$param['order_info'];
        $anchor=$data['anchor_id'];
        $pid = $param['pid'];
        $buy_pretype = $param['pre_way'];
        if($buy_pretype == 6){
            $pre_type = 2;    
        }
        if($buy_pretype == 7){
            $pre_type = 1;    
        }
        $goods_number = $data['number'];
        if(!empty($param['pt_id'])){
            $pt_id = $param['pt_id'];
        }elseif(!empty($param['pre_id'])){
            $pt_id = $param['pre_id'];
            $pre_end = idtoname($pt_id,'PromotAct','end_time');
            $pre_day = idtoname($pt_id,'PromotAct','group_time_limit');
            $pre_endtime = $pre_end + ($pre_day * 86400);
            if($pre_type == 2){
                $pre['act_id'] = $pt_id;
                $pre_money = M('PromotExt')->where($pre)->getField('remarks');
                $premoney = unserialize($pre_money);
                $pre_price = $premoney['pre_money'];
            }
        }
		if($addr_id>0){
            $a_map['id']=$addr_id;
			$address=M('MemberAddress')->field(true)->where($a_map)->find();
		}
        $invoice_info['invoice_type']=$param['invoice_type'];
        $invoice_info['invoice_title']=$param['invoice_title'];
        $invoice_info['organization']=$param['con_name'];
        if($param['is_goods']){
            $invoice_info['invoice_content']='need_invoice_detail';
        }else{
            $invoice_info['invoice_content']='';
        }
        $invoice_info['need_invoice_detail']=$param['con_name'];
        $invoce_map['uid']=$memberinfo['id'];
        $invoce_map['type']=3;
        $invoce_info=M("MemberInvoice")->where($invoce_map)->getField('invoice_info');
        if($invoce_info){
            $invoice=unserialize($invoce_info);
            $invoice_info['vat_invoice']=$invoice;
        }
        $invoice_data=serialize($invoice_info);
		if(empty($address)){$return['msg']='收货地址不存在';return $return;}
        if($cart_ids){
            $carts_map['c.user_id'] = $memberinfo['id'];
            if (!empty($cart_ids)) $carts_map['c.id'] = array('in', $cart_ids);
            $cart_info=M('Cart')->alias('c')->JOIN('LEFT JOIN __GOODS__ g ON g.id=c.goods_id')->where($carts_map)->field('g.*,g.id as goods_id,c.id as id,c.user_id,c.cookie_id,c.goods_attr,c.goods_num,c.cart_id')->order('g.shop_id asc')->select();
        }elseif($data){
            $goodsinfo=$this->buy_now($data);
            $cart_info=$goodsinfo['data'];
        }
         $list=array();
        foreach($cart_info as $key=>$val){
            $gooda_attrs=unserialize($val['goods_attr']);
            $goods_attr_value=array_values($gooda_attrs);
            $check=D("Common/Cart")->check_cart($val['goods_id'],$goods_attr_value[0],$val['goods_num'],$goods_attr_value[1],$addr_id);
            if($check['status']!=2){
                $return['msg']=$check['msg'];return $return;
            }
            if($type!=3){
                $check_act=$this->check_active($val['id']);
                if($check_act['status']==0){
                    $return['msg']=$check_act['msg'];return $return;
                }
            }
            $list[$val['shop_id']]['goods_list'][]=$val;
            $list[$val['shop_id']]['shop_info']=0;
        }
		$data=$this->count_total($cart_ids,$data,$type,$bonu,$score,$use_account,$account_money,$payment_id,$addr_id);
        if($data['total_info']['pay_price']>0 && $payment_id<=0){$return['msg']='请选择支付方式';$return['app_paydata']='app_notpay';return $return;}
        if($data['total_info']['account_money'] >0 || $score >0 ){
            $return['status']=3;
            if($pay_pwd==''){
                $return['msg']='请输入支付密码';
                return $return;
            }
            $m['id']=$memberinfo['id'];
            $userinfo=M("Member")->where($m)->field('paypassword,salt')->find();
            if($userinfo['paypassword'] == ''){
                $return['msg']="您没设置交易密码,请设置交易密码";
                $return['url']=getjumpurl('JUMP_3');
                return $return;
            }
            if($pay_pwd=='' || creatpwd($pay_pwd,'HANCHAO'.$userinfo['salt']) != $userinfo['paypassword']){
                $return['msg']='支付密码错误';
                return $return;
            }
        }
        if($type!=3) {
            if (!empty($bonu)) {
                foreach (array_filter($bonu) as $k => $val) {
                    $check_bonus = $this->check_user_bonus($val);
                    if ($check_bonus['status'] == 0) {
                        $return['msg'] = $check_bonus['msg'];
                        return $return;
                    } else {
                        $b_data['used_time'] = NOW_TIME;
                        $b_map['id'] = $val;
                        M("MemberBonus")->where($b_map)->save($b_data);
                    }
                }
            }
        }
        if($type==3){
            $order_info=$this->add_integra_order($data,$address,$payment_id,$source,$invoice_data);
        }else{
            $data['pt_id'] = $pt_id;
            $data['pid'] = $pid;
            $data['pre_type'] = $pre_type;
            $data['pre_endtime'] = $pre_endtime;
            $data['pre_money'] = $pre_price*$goods_number;
            $order_info=$this->add_order($data,$address,$payment_id,$bonu,$source,$invoice_data,$content);
        }
        if($order_info['status']==1){
            $order_ids=$order_info['order_id'];
        }else{
            $return['msg']=$order_info['msg'];return $return;
        }
		$payment_info=array();
		$payment_info['order_id']=$order_ids;
		$payment_info['user_id']= $memberinfo['id'];
		$payment_info['type']=$data['total_info']['order_type'];
		$payment_info['order_sn']= createOrderNo();
		$payment_info['use_money']=$data['total_info']['account_money'];
		$payment_info['need_pay']=$data['total_info']['pay_price'];
		$payment_info['use_score']=$data['total_info']['score'];
		$payment_info['use_score_money']=$data['total_info']['use_score_money'];
		$payment_info['order_total_price']=$data['total_info']['pay_total_price'];
        $payment_info['payment_id']=$payment_id;
        $payment_info['payment_fee']=$data['total_info']['pay_fee'];
        $payment_info['pay_amount']=0;
		$payment_info['pay_code']=idtoname($payment_id,"Payment",'code');
		$payment_info['is_paid']=0;
		$payment_info['create_time']=NOW_TIME;
		$pay_log_id=M('PayLog')->add($payment_info);
        if($pay_log_id){
           $this->delcartgoods($cart_ids);
            $anchor_config=C("SHOW_LIVE_MODEL");
            if($anchor_config){
                if($cart_ids){
                    $anchor_res= D("Live/LiveDivided")->save_order_divided($cart_ids,$order_ids);
                    if($anchor_res['status']==0){
                        $root['status'] = 0;
                        $root['msg'] = "更改主播订单失败";
                        return $root;
                    }
                }else if($anchor){
                    $anchor_data=array();
                    $anchor_data['goods_id']=$param['order_info']['goods_id'];
                    $anchor_data['goods_number']=$param['order_info']['number'];
                    $anchor_data['anchor_id']=$anchor;
                    $attr=$param['order_info']['goods_attr'];
                    $price_info=D("Common/Cart")->getminprice($param['order_info']['goods_id'],$attr);
                    $anchor_data['shop_price']=$price_info['price'];
                    $order_id=array_filter(explode(',',$order_ids));
                    $anchor_data['order_id']=$order_id[1];
                    $anchor_map=array();
                    $anchor_map['order_id']=$anchor_data['order_id'];
                    $anchor_map['goods_id']=$anchor_data['goods_id'];
                    $order_goods_id=M("OrderGoods")->where($anchor_map)->getField('id');
                    $anchor_data['order_goods_id']=$order_goods_id;
                    if($attr) {
                        $anchor_data['goods_attr'] =$attr;
                    }
                    $rs= D("Live/LiveDivided")->add_divided($anchor_data);
                    if($rs['status']==0){
                        $root['status'] = 0;
                        $root['msg'] = $rs['msg'];
                        return $root;
                    }
                }
            }
            $paylogwhere['id']=$pay_log_id;
            $orderids = M('PayLog')->where($paylogwhere)->getField('order_id');
            $orderids_arr =array_filter(explode(',', $orderids));
            foreach($orderids_arr as $key=>$val) {
                $g_map['order_id'] = $val;
                $order_goods = M("OrderGoods")->where($g_map)->field('goods_id,goods_attr,goods_number')->select();
                if ($order_goods) {
                    foreach ($order_goods as $key => $gv) {
                        if ($gv['goods_attr']) {
                            $attrs=unserialize($gv['goods_attr']);
                            $attr['goods_id'] = $gv['goods_id'];
                            $attr['attr_key'] = $attrs['key'];
                            $goods_stock = M("GoodsAttrStock")->where($attr)->getField("stock_cfg");
                            $attr_data['stock_cfg'] = $goods_stock - $gv['goods_number'];
                            $goods_attr_stock = M("GoodsAttrStock")->where($attr)->save($attr_data);
                        } else {
                            $goods_map['id'] = $gv['goods_id'];
                            $stock = M("Goods")->where($goods_map)->getField("goods_number");
                            $gmap['goods_number'] = $stock - $gv['goods_number'];
                            $goods_attr_stock = M("Goods")->where($goods_map)->save($gmap);
                        }
                    }
                } else {
                    $root['status'] = 0;
                    $root['msg'] = "订单商品不存在";
                    return $root;
                }
            }
            if($data['total_info']['score']){
                account_change($memberinfo['id'],-$data['total_info']['score'],4,4,'购买商品支付');
            }
            if($data['total_info']['account_money']>0){
                account_change($memberinfo['id'],-$data['total_info']['account_money'],1,4,'购买商品支付');
            }
            if($data['total_info']['pay_price']>0 && $data['total_info']['payment_info']){
                $return['pay']=$pay_log_id;
                $return['status']=1;
                return $return;
            }
            $pay_info=array();
            $pay_info['out_trade_no']=$payment_info['order_sn'];
            $pay_info['type']=$payment_info['type'];
            $res=$this->endorder($pay_info);
            if($res['status']==1){
                $return['status']=1;
                $return['data']=$order_ids;
                return $return;
            }else{
                $return['msg']=$res['msg'];
                return $return;
            }
        }else{
            $return['msg']="支付单生成失败";return $return;
        }
		return $return;
	}
    public function add_integra_order($data,$address,$payment_id,$source,$invoice_data){
        $memberinfo=checkuserauthtype();
        $return=array();
        $return['status']=0;
        $list=$data['data']['list'][0];
        if($list) {
            $order = array();
            $order['order_sn'] = createOrderNo();
            $order['type'] = $data['total_info']['order_type'];
            $order['uid'] = $memberinfo['id'];
            $order['consignee'] = $address['consignee'];
            $order['province'] = $address['province'];
            $order['city'] = $address['city'];
            $order['district'] = $address['district'];
            $order['address'] = $address['address'];
            $order['zipcode'] = $address['zipcode'];
            $order['mobile'] = !empty($address['mobile']) ? $address['mobile'] : $memberinfo['mobile'];
            $order['email'] = !empty($address['emai']) ? $address['email'] : $memberinfo['email'];
            $order['best_time'] = $address['best_time'];
            $order['sign_building'] = $address['sign_building'];
            $order['shop_id'] = $list['shop_info']['id'];
            $order['temp'] = '';
            $order['shipping_status'] = 1;
            $order['pay_code'] = idtoname($payment_id, 'Payment', 'code');
            $order['payment_id'] = $payment_id;
            $order['pay_status'] = 1;
            $order['goods_amount'] = $list['all_price'];
            $order['goods_allmoney'] = $list['all_price'];
            $order['order_amount'] = $list['shop_total_price'];
            $order['order_money'] = $list['shop_total_price'];
            $order['delivery_fee'] = $list['shipping_fee'];
            $order['used_score'] =  $data['total_info']['score'];
            $order['used_score_money'] =  $data['total_info']['use_score'];
            $order['status'] = 1;
            $order['addtime'] = NOW_TIME;
            $order['source'] = $source;
            $order['invoice_info'] = $invoice_data;
            $order_id = M('OrderInfo')->add($order);
            if(empty($order_id)){
                $return['msg']='添加订单失败';return $return;
            }else {
                $order_ids[] = $order_id;
                if ($data['total_info']['order_type'] == 3) {    
                    $order_goods = array();
                    $order_goods['order_id'] = $order_id;
                    $order_goods['goods_id'] = $list['goods_id'];
                    $order_goods['goods_name'] = $list['goods_name'];
                    $order_goods['goods_sn'] = $list['goods_sn'];
                    $order_goods['goods_number'] = $list['goods_num'];
                    $order_goods['attr_price'] = $list['shop_price'];
                    $order_goods['goods_price'] = $list['shop_price'];
                    $order_goods['goods_attr'] = $list['goods_attr'];
                    $order_goods['promot_id'] = $list['cart_id'];
                    $order_goods['shop_id'] = $list['shop_info']['id'];
                    $order_goods['suppliers_id'] = $list['suppliers_id'];
                    $order_goods['goods_integral'] = $list['cart_integral'];
                    $order_goods['addtime'] = NOW_TIME;
                    $order_goods['status'] = 0;
                    $order_goods['is_balance'] = 0;
                    $list[] = $order_goods;
                    $order_goods_id = M('OrderGoods')->add($order_goods);
                }
            }
        }else{
            $return['status']=0;
            $return['msg']="订单信息错误";
        }
        $return['status']=1;
        $return['order_id']=",".implode(',',$order_ids).",";
        return $return;
    }
    public function add_order($data,$address,$payment_id,$bonus,$source,$invoice_data,$content){
        $memberinfo=checkuserauthtype();
        $return=array();
        $return['status']=0;
        $act_id=array();
        $act_ids=0;
        foreach($data['data']['list'] as $key=>$val){
                foreach ($val['promot_list'] as $ak => $av) {
                    $act_id[] = $ak;
                }
                if (!empty($act_id)) {
                    $act_ids = implode(',', $act_id);
                }
                if ($bonus) {
                    $bonu=array_filter($bonus);
                    foreach($bonu as $bk=>$bv){
                        $bonu_info=idtoname($bv,'MemberBonus','*');
                        $shop_bonus[$bk]=$bonu_info['money'];
                        $bonus_ids[$bk]=$bv;
                    }
                    $bonus_money = $shop_bonus[$val['shop_info']['id']];
                    $bonus_id = $bonus_ids[$val['shop_info']['id']];
                }
            $order=array();
            $order['order_sn']        = createOrderNo();
            $order['type']            = $data['total_info']['order_type'];
            $order['uid']             = $memberinfo['id'];
            $order['consignee']       = $address['consignee'];
            $order['province']        = $address['province'];
            $order['city']            = $address['city'];
            $order['district']        = $address['district'];
            $order['address']         = $address['address'];
            $order['zipcode']         = $address['zipcode'];
            $order['mobile']          = !empty($address['mobile'])?$address['mobile']:$memberinfo['mobile'];
            $order['email']           = !empty($address['emai'])?$address['email']:$memberinfo['email'];
            if($data['total_info']['order_type']==7){
                $order['best_time']       = $data['pre_endtime'];
            }else{
                $order['best_time']       = $address['best_time'];
            }
            $order['sign_building']   = $address['sign_building'];
            $order['shop_id'] = $val['shop_info']['id'];
            $order['temp'] = $content[$val['shop_info']['id']];
                $order['shipping_status'] = 1;
            $order['pay_code'] = idtoname($payment_id,'Payment','code');
            $order['payment_id'] = $payment_id;
            $order['pay_status'] = 1;
            $order['goods_amount'] = $val['shop_info']['allgoods_price'];
            $order['goods_allmoney'] = $data['data']['shopgoods'][$val['shop_info']['id']]['goods_total_price'];
            $order['order_amount'] = $val['shop_info']['shop_total_price']-$bonus_money;
            $order['order_money'] = $val['shop_info']['shop_total_price']-$bonus_money;
            $order['discount'] = $data['data']['shopgoods'][$val['shop_info']['id']]['goods_total_price']-$val['shop_info']['allgoods_price'];
            $order['bonus_money'] = $bonus_money;
            $order['bonus_id'] = $bonus_id;
            $order['delivery_fee']=$val['shop_info']['shipping_fee'];
            $order['promot_id']=$act_ids;
            $order['status'] = 1;
            $order['addtime'] = NOW_TIME;
            $order['source'] = $source;
            $order['invoice_info'] = $invoice_data;
            $order['pt_id'] = $data['pt_id'];
            $order['pid'] = $data['pid'];
            $order['pre_type'] = $data['pre_type'];
            $order['pre_money'] = $data['pre_money'];
            $order_id=M('OrderInfo')->add($order);
            if(empty($order_id)){
                $return['msg']='添加订单失败';return $return;
            }else {
                $order_ids[] = $order_id;
                if($data['total_info']['order_type']==1 || $data['total_info']['order_type']==6 || $data['total_info']['order_type']==7) { 
                   foreach ($val['promot_list'] as $k => $v) {
                       if(empty($v['goods_list'])){
                           $return['msg']='订单信息错误';return $return;
                       }
                       foreach ($v['goods_list'] as $kk => $vv) {
                           $order_goods = array();
                           $order_goods['order_id'] = $order_id;
                           $order_goods['goods_id'] = $vv['goods_id'];
                           $order_goods['goods_name'] = $vv['goods_name'];
                           $order_goods['goods_sn'] = $vv['goods_sn'];
                           $order_goods['goods_number'] = $vv['goods_num'];
                           $order_goods['attr_price'] = $vv['shop_price'];
                           $order_goods['goods_price'] = $vv['shop_price'];
                           $order_goods['goods_attr'] = $vv['goods_attr'];
                           $order_goods['promot_id'] = $vv['cart_id'];
                           $order_goods['bonus_id'] = $bonus_id;
                           $order_goods['shop_id'] = $vv['shop_id'];
                           if(empty($vv['shop_id'])){
                               if (!empty($vv['goods_attr'])) {
                                   $goods_attr_data = unserialize($vv['goods_attr']);
                                   $where=array();
                                   $where['id'] = array('in', explode('_', $goods_attr_data['key']));
                                   $add_shop_balance = M('GoodsAttr')->where($where)->getField('sum(supplier_price)');
                               }else{
                                   $add_shop_balance=0;
                               }
                               $supply_price = idtoname($vv['goods_id'], 'Goods', 'supply_price', 'id', false);
                               $order_goods['supply_price'] =format_decimal(($add_shop_balance + $supply_price) * $vv['goods_num']);
                           }else{
                               $map=array();
                               $map['shop_id'] = $vv['shop_id'];
                               $map['id'] = $vv['goods_id'];
                               $goods_cate = M("Goods")->where($map)->getField('cat_id');
                               if ($goods_cate > 0) {
                                   $balance_rate = D("Common/GoodsCategory")->get_parent_pid($goods_cate);
                                   $order_goods['supply_price']=$balance_rate;
                               }
                           }
                           $order_goods['suppliers_id'] = $vv['suppliers_id'];
                           $order_goods['addtime'] = NOW_TIME;
                           $order_goods['status'] = 0;
                           $order_goods['is_balance'] = 0;
                           $list[] = $order_goods;
                           $order_goods_id = M('OrderGoods')->add($order_goods);
                       }
                   }
               }
            }
        }
        $return['status']=1;
        $return['order_id']=",".implode(',',$order_ids).",";
        return $return;
    }
    public function endorder($info){
        $root=array('status'=>0,'msg'=>'');
		if(empty($info['out_trade_no'])){$root['msg']="参数错误";return $root;}
        $map['order_sn'] = $info['out_trade_no'];
        $pay_info = M("PayLog")->where($map)->field(true)->find();
        if (format_decimal($pay_info['use_money'] + $pay_info['use_score_money'] + $info['money']) >= format_decimal($pay_info['order_total_price'])) {
			$paylogsave['is_paid'] = 1;
			$paylogsave['pay_sn'] = $info['pay_sn'];
			$paylogsave['update_time'] = NOW_TIME;
			$paylogwhere['is_delete'] = 0;
            $paylogwhere['order_sn'] = $info['out_trade_no'];
            $res = M('PayLog')->where($paylogwhere)->save($paylogsave);
            if ($res) {
				$orderids = M('PayLog')->where($paylogwhere)->getField('order_id');
				$orderids_arr =array_filter(explode(',', $orderids));
				foreach ($orderids_arr as $val) {
					$orderwhere['id'] = $val;
					$orderwhere['is_delete'] = 0;
					$orderwhere['pay_status'] = array('neq',3);
					$orderwhere['status'] = array('lt',3);
					$orderinfo = M('OrderInfo')->where($orderwhere)->field(true)->find();
					if($orderinfo) {
						if ($orderinfo['pay_status'] <= 1 || $orderinfo['pay_status'] == 4 || $orderinfo['pay_status'] == 5) {
                            if($orderinfo['pay_status'] == 1 && $orderinfo['type']==7 && $orderinfo['pre_type']==2){
                                $updatedata['status'] =1;
                                $updatedata['pay_status'] =5;
                                $updatedata['pre_sn'] = $info['pay_sn'];
                                $updatedata['pay_amount'] = $info['money'];
                                $updatedata['pre_time'] = NOW_TIME;
                            }else{
                                $updatedata['pay_status'] =3;
                                $updatedata['pay_sn'] = $info['pay_sn'];
                                $updatedata['pay_amount'] = $info['money'];
                                $updatedata['pay_time'] = NOW_TIME;
                            }
							if ($orderinfo['status'] <= 1 && $orderinfo['type']!=6 && $orderinfo['type']!=7) {
								$updatedata['status'] = 2;
								$updatedata['confirm_time'] = NOW_TIME;
							}elseif($orderinfo['status'] == 2 && ($orderinfo['type'] == 2 || $orderinfo['type'] == 5)){
								$updatedata['status'] = 3;
							}elseif($orderinfo['status'] <= 1 && $orderinfo['type']==6 && $orderinfo['pt_id']>0){
                                $pt_id = idtoname($val,'OrderInfo','pt_id');
                                $sum =  M('PromotAct')->where('id='.$pt_id)->getField('group_number');
                                if($orderinfo['pid'] == 0){
                                    $count = M('OrderInfo')->where('pid='.$val)->count();
                                }else{
                                    $oid = $orderinfo['pid'];
                                    $count = M('OrderInfo')->where('pid='.$oid)->count();
                                }
                                $number = $count+1;
                                if($number == $sum){
                                    $shipping['shipping_status'] = 1;
                                    if($orderinfo['pid'] == 0){
                                        $save = M('OrderInfo')->where('pid='.$val)->save($shipping);
                                    }else{
                                        $save = M('OrderInfo')->where('pid='.$oid)->save($shipping);
                                        $u = M('OrderInfo')->where('id='.$oid)->save($shipping);
                                    }
                                    $updatedata['status'] = 2;
                                    $updatedata['shipping_status'] = 1;
                                    $updatedata['confirm_time'] = NOW_TIME;
                                }else{
                                    $updatedata['status'] = 2;
                                    $updatedata['shipping_status'] = 5;
                                    $updatedata['confirm_time'] = NOW_TIME;
                                }
                            }elseif($orderinfo['status'] <= 1 && $orderinfo['type'] == 7  && $orderinfo['pre_type'] == 1){
                                $updatedata['status'] = 2;
                            }elseif($orderinfo['status'] == 2 && $orderinfo['type'] == 7 && $orderinfo['pay_status'] == 5 ){
                                $updatedata['confirm_time'] = NOW_TIME;
                            }
							M('OrderInfo')->where($orderwhere)->save($updatedata);
                            if($pay_info['type'] == 7){
                                $where['id'] = $val;
                                $order_paystatus = M('OrderInfo')->where($where)->getField('pay_status');
                            }
							if($pay_info['type'] == 1 || $pay_info['type']==3 || $pay_info['type']==6 || ($pay_info['type']==7 && $order_paystatus==3)) {
                                $anchor_config=C("SHOW_LIVE_MODEL");
                                if($anchor_config){
                                    $d_res= D("Live/LiveDivided")->save_order_status($val);
                                    if($d_res['status']==0){
                                        $root['msg']=$d_res['msg'];return $root;
                                    }
                                }
								$shop_unsettled = $this->shop_unbalance($val,0);
								if (!$shop_unsettled) {$root['msg'] = "增加商户待结算金额失败";return $root;}
								if(C('EXTENSION_SETTING')){$affiliate = affiliate($val);}
								if($info['money']>0){account_change($pay_info['user_id'],$info['money'], 1, 1, "会员支付（平台入账）",'0',false,3);}
							}elseif($pay_info['type'] == 2 && $pay_info['user_id']) {
								account_change($pay_info['user_id'], $info['money'], 1, 1, "会员充值");
								account_change($pay_info['user_id'], $info['money'], 1, 1, "会员充值（平台入账）",'0',false,3);
							}elseif($pay_info['type'] == 5 && $pay_info['user_id']) {
								shop_balance_log($pay_info['user_id'],$info['money'],1,1,'店铺充值',$orderinfo);
								account_change($pay_info['user_id'], $info['money'], 1, 1, "店铺充值（平台入账）",'0',false,3);
							}
						}
					}else{
						$root['msg'] = "没有此订单信息";return $root;
					}
				}
            }else{
                $root['msg']="改变支付单状态失败";return $root;
            }
        }else{
            $root['msg']="支付失败";return $root;
        }
		$root['status']=1;
        return $root;
    }
    public function refund_order($info){
        $root=array('status'=>0,'msg'=>'');
        $sale_money=0;
        if(empty($info['out_trade_no'])){$root['msg']="参数错误";return $root;}
        $order_info = idtoname($info['out_trade_no'],'OrderInfo','*','id');
        $refund_info = idtoname($info['out_trade_no'],'RefundOrder','*','order_id');
        $o_where['is_delete'] = 0;
        $o_where['order_id'] = array("like", "%," . $refund_info['order_id'] . ",%");
        $pay_info = M("PayLog")->where($o_where)->field(true)->find();
            if($refund_info['refund_money']>0 && $order_info['pay_status'] != 5){
                account_change($pay_info['user_id'],$refund_info['refund_money'],1,4,'取消订单'.$order_info['order_sn']);
            }
            if($refund_info['refund_scores']>0 && $order_info['pay_status'] != 5){
                account_change($pay_info['user_id'],$refund_info['refund_scores'],4,4,'取消订单'.$order_info['order_sn']);
            }
            $p_where['is_delete'] = 0;
            $p_where['order_id'] = array("like", "%," . $refund_info['order_id']. ",%");
            $o_data['is_delete']=1;
            $del_pay= M("PayLog")->where($p_where)->save($o_data);
            $order_ids=explode(',',$pay_info['order_id']);
            foreach(array_filter($order_ids) as $key=>$val){
                if($val==$refund_info['order_id']){
                    $org_maps['status']=array('in',array(0,1));
                    $org_maps['order_id']=$refund_info['order_id'];
                    $is_del=M('OrderGoods')->where($org_maps)->count();
                    if(!$is_del)unset($val);
                }
                if($val==0){
                    unset($val);
                }
                $pay_order_id[]=$val;
            }
            $pay_order_id=array_filter($pay_order_id);
            if(!empty($pay_order_id)){
                $payment_id=','.implode(',',$pay_order_id).',';
                $use_money=$pay_info['use_money']-$refund_info['refund_money'];
                $use_score=$pay_info['use_score']-$refund_info['refund_scores'];
                $use_web=$pay_info['pay_amount']-$refund_info['refund_web'];
                $payment=array();
                $payment['order_id']=$payment_id;
                $payment['type']=$order_info['type'];
                $payment['user_id']=$order_info['uid'];
                $payment['use_money']=$use_money;
                $payment['use_score']=$use_score;
                $payment['use_score_money']=$use_score*C('WEB_INTEGRAL_RATIO')/100;
                $payment['pay_amount']=$use_web;
                $payment['order_total_price']=$use_web+$use_money+$use_score;
                $payment['payment_id']=$pay_info['payment_id'];
                $payment['pay_code']=$pay_info['pay_code'];
                $payment['is_paid']=$pay_info['is_paid'];
                $payment['create_time']=NOW_TIME;
                M("PayLog")->add($payment);
            }
            if($order_info['pay_status']==3){
                $where['order_id']=$refund_info['order_id'];
                $data['is_separate']=2;
                M("AffiliateLog")->where($where)->save($data);
                $sale_money=format_decimal($order_info['order_amount']-$order_info['delivery_fee']);
                shop_balance_log($order_info['shop_id'], -$refund_info['money'], 2,3,'订单' . $order_info['order_sn'] . '付款,未结算总额减少', $order_info);
                shop_balance_log($order_info['shop_id'], -$sale_money, 6,3,'订单' . $order_info['order_sn'] . '付款,销售总额减少', $order_info);
            }
        $refund_map['id']=$refund_info['id'];
        $refund_data['status']=1;
        $refund_data['update_time']=NOW_TIME;
        M("RefundOrder")->where($refund_map)->save($refund_data);
        return $root;
    }
	public function delcartgoods($cart_id){
        $return =array('status'=>0,'msg'=>'');
        if (empty($cart_id)) {
            $return['msg']='参数错误';
			return $return;
        }
		$map['id']=array('in',explode(',',$cart_id));
		$result=M('Cart')->where($map)->delete();
        if ($result!==false) {
            $return['msg']='删除购物车商品成功';
            $return['status']=1;
        }else{
            $return['msg']='删除购物车商品失败';
        }
        return $return;
	}
    public function shop_unbalance($order_id,$type){
        $map['id']=$order_id;
        $map['pay_status']=3;
        $order_info=$this->where($map)->field(true)->find();
        $price=format_decimal($order_info['order_amount']-$order_info['delivery_fee']);
        if (!$order_info) {return false;}
		$price_info=get_balance_new_price($order_id);
		if($type){$price_info['price']=-$price_info['price'];}
		shop_balance_log($order_info['shop_id'], $price_info['price'], 2,3,'订单' . $order_info['order_sn'] . '付款,未结算总额增加', $order_info);
		shop_balance_log($order_info['shop_id'], $price, 6,3,'订单' . $order_info['order_sn'] . '付款,销售总额增加', $order_info);
        return true;
    }
	public function ship_goods($postdata){
		$return=array('status'=>0,'info'=>'');
		$order_id=$postdata['order_id'];
		$admin_id=$postdata['admin_id'];
		if(!$order_id){$return['info']='请选择要发货的订单';return $return;}
		if($postdata['type']=='Shop'){
			$is_have['shop_id']=$postdata['admin_id'];
			$is_have['id']=$order_id;
			$yes=M('OrderInfo')->where($is_have)->count();
			if(!$yes){$return['info']='无此操作权限';return $return;}
		}
		$ship_map['id']=$order_id;
		$ship_map['pay_status']=3;
		$ship_map['shipping_status']=1;
		$ship_map['status']=array('lt',3);
		$is_ship=M('OrderInfo')->where($ship_map)->count();
		if(!$is_ship){$return['info']='该订单不满足发货条件';return $return;}
		$og_map['order_id']=$order_id;
		$og_map['status']=0;
		$org_ids=M('OrderGoods')->where($og_map)->getField('id',true);
		if(empty($org_ids)){$return['info']='暂无可发货的商品';return $return;}
		$org_map['id']=array('in',$org_ids);
		$org_save['status']=1;
		M('OrderGoods')->where($org_map)->save($org_save);
		$save['shipping_status']=3;
		$res=M('OrderInfo')->where('id='.$order_id)->save($save);
		if($res===false){$return['info']='发货失败,或重复发货';return $return;}
		$g_map['id']=array('in',$org_ids);
		$goods_ids=M('OrderGoods')->where($g_map)->getField('goods_id',true);
        $express_id=M('Express')->where('status=1')->order('id desc')->getField('id');
		$order_info=idtoname($order_id,'OrderInfo','uid,shop_id,order_sn,mobile');
		$ship_data['ship_time']=NOW_TIME;
		$ship_data['remark']=$postdata['remark'];
		$ship_data['notice_sn']=$postdata['notice_sn'];
		$ship_data['send_type']=$postdata['send_type'];
		$ship_data['uid']=$order_info['uid'];
		$ship_data['shop_id']=$order_info['shop_id'];
        $ship_data['express_id']=$express_id;
		$ship_data['goods_id']=implode(',',$goods_ids);
		$ship_data['org_id']=implode(',',$org_ids);
		$ship_data['order_id']=$order_id;
		$result=M('ShipOrder')->add($ship_data);
		if($result){
			$return['status']=1;
			$return['info']='发货成功';
			if($postdata['type']=='Shop'){
				action_log('shop_ship_order', 'Shop', $order_id, $admin_id);
				$send_data['from']=idtoname($admin_id,'Shops','name');
			}elseif($postdata['type']=='Admin'){
				action_log('admin_ship_order', 'Admin', $order_id, $admin_id);
				$send_data['from']='admin(系统)';
			}
			$send_data['to']=$order_info['uid'];
			$send_data['type']=1;
			$send_data['content']='您的订单'.$order_info['order_sn'].'已发货啦！';
			send_method(3,$send_data);
            $order_goods = idtoname($order_id,'OrderGoods','goods_name','order_id');
            $code_data['to'] = $order_info['mobile'];
            $code_data['goods_name'] = $order_goods;
            $code_data['order_sn'] =$order_info['order_sn'];
            $code_data['shops_name'] = C('WEB_SITE_NAME');
            $code_data['code'] =  $order_info['order_sn'];
			sendbytheme($code_data, 'SHIP_GOODS_CODE');
		}else{
			$return['info']='发货失败';
		}
		return $return;
	}
	public function apply_return($postdata){
		$return=array('status'=>0,'msg'=>'');
		$member_info=checkuserauthtype();
		if(!$member_info['id']){$return['msg']='登录信息有误,请重新登录';return $return;}
		foreach($postdata['data'] as $key=>$val){
            $order_info=M("OrderInfo")->where('id='.$key)->field(true)->find();
            if(isset($val['order_goods'])){
                $org_id=$val['order_goods'];
                if(!$org_id){$return['msg']='参数错误';return $return;}
                $goods_map['id']=array("in",$org_id);
                $info=M('OrderGoods')->where($goods_map)->field('order_id,goods_id,shop_id,goods_number')->select();
                foreach($info as $k=>$v){
                    if($val['number']>$v['goods_number']){
                        $return['msg']='退货数量大于购买数量,不能退货';return $return;
                    }
                    $goods_info[$k]['goods_id']=$v['goods_id'];
                    $goods_info[$k]['number']=$v['goods_number'];
                }
                $map['id']=array("in",$org_id);
                $map['status']=1;
                $save['status']=3;
                $res=M('OrderGoods')->where($map)->save($save);
                if(!$res){$return['msg']='申请失败,可能原因（正在退货中,或还未收货）';return $return;}
				$od_map['order_id']=$key;
				$od_map['status']=array('lt',3);
				$have=M('OrderGoods')->where($od_map)->count();
				if(!$have){
					$od_save['status']=8;
					M('OrderInfo')->where('id='.$key)->save($od_save);
				}
                $data['type']='th';
                $data['order_info']=array($key=>$org_id);
                $refund_info=$this->check_refund_money($data);
                $money=$refund_info['data'][$key]['money'];
            }else{
                $money=$order_info['order_amount']-$order_info['delivery_fee'];
				$og_map['order_id']=$key;
				$og_map['status']=1;
                $info=M("OrderGoods")->where($og_map)->field('id,goods_id,goods_number')->select();
                foreach($info as $k=>$v){
                    $goods_info[$k]['goods_id']=$v['goods_id'];
                    $goods_info[$k]['number']=$v['goods_number'];
                    $g_map['id']=$v['id'];
                    $g_map['status']=1;
                    $save['status']=3;
                    $res=M('OrderGoods')->where($g_map)->save($save);
					$org_id[]=$v['id'];
                }
				$od_save['status']=8;
				M('OrderInfo')->where('id='.$key)->save($od_save);
            }
			$str_orgids=implode(',',$org_id);
            $add['org_id']=$str_orgids;
            $add['uid']=$member_info['id'];
            $add['shop_id']=$order_info['shop_id'];
            $add['order_id']=$key;
            $add['goods_info']=serialize($goods_info);
            $add['reason']=$postdata['content'];
            $add['money']=$money;
			$add['add_time']=NOW_TIME;
            $res=M('ReturnGoods')->add($add);
            $refund_data['reason']=$postdata['content'];
            $refund_data['type']=0;
            $refund_data['order_goods']=$str_orgids;
            $result=$this->add_refund($money,$key,$refund_data);
			if($result)action_log('user_apply_return', 'Member', $res, $member_info['id']);
        }
		if($result){
			$return['status']=1;
			$return['msg']='申请已提交';
		}else{
			$return['msg']='申请提交失败';
		}
		return $return;
	}
	public function confirm_goods($postdata){
		$return=array('status'=>0,'msg'=>'');
		$id=$postdata['id'];
		$admin_id=$postdata['admin_id'];
        if(!$id){$return['msg']='参数错误';return $return;}
		if($postdata['type']=='Shop'){
			$is_have['shop_id']=$postdata['admin_id'];
			$is_have['id']=$id;
			$yes=M('ReturnGoods')->where($is_have)->count();
			if(!$yes){$return['msg']='无此操作权限';return $return;}
		}
		$save['shop_status']=1;
        $result=M('ReturnGoods')->where('id='.$id)->save($save);
		if($result !== false){
            $return['status']=1;$return['msg']='收货成功';
			if($postdata['type']=='Shop'){
				action_log('shop_confirm_goods', 'Shop', $id, $admin_id);
			}elseif($postdata['type']=='Admin'){
				action_log('admin_confirm_good', 'Admin', $id, $admin_id);
			}
		}else{
			$return['msg']='收货失败';
		}
		return $return;
	}
	public function return_goods($postdata){
		$return=array('status'=>0,'info'=>'');
		$id=$postdata['id'];
		$admin_id=$postdata['admin_id'];
		if(!$id){$return['info']='参数错误';return $return;}
		$info=M('ReturnGoods')->where('id='.$id)->field(true)->find();
        if(empty($info)){$return['info']='没有此退货信息';return $return;}
		if($postdata['type']==1){
			$yes_map['id']=$id;$yes_map['status']=0;$save['status']=1;$save['update_time']=NOW_TIME;
			$res=M('ReturnGoods')->where($yes_map)->save($save);
			if(!$res){$return['info']='处理失败,可能原因（重复处理）';return $return;}
            if(strstr($info['org_id'],',')){
                $org_map['id']=array('in',$info['org_id']);
            }else{
                $org_map['id']=$info['org_id'];
            }
			$org_map['status']=3;$org_save['status']=4;
			$result=M('OrderGoods')->where($org_map)->save($org_save);
			if(!$result){$return['info']='数据错误';return $return;}
            $where['status'] = 0;
            $where['order_id'] =$info['order_id'];
            $refund_order=M("RefundOrder")->where($where)->getField("id");
            $refund=$this->handle_order($refund_order,$postdata['margin_type'],$admin_id);
		}elseif($postdata['type']==2){
			$no_map['id']=$id;$no_map['status']=0;
            $save['status']=2;$save['update_time']=NOW_TIME;
            $save['content']=$postdata['content'];
			$res=M('ReturnGoods')->where($no_map)->save($save);
			if(!$res){$return['info']='处理失败,可能原因（重复处理）';return $return;}
            if(strstr($info['org_id'],',')){
                $org_map['id']=array('in',$info['org_id']);
            }else{
                $org_map['id']=$info['org_id'];
            }
			$org_map['status']=3;$org_save['status']=5;
			$result=M('OrderGoods')->where($org_map)->save($org_save);
			if(!$result){$return['info']='数据错误';return $return;}
		}
		$return['status']=1;
		$return['info']='处理成功';
		if($postdata['margin_type']=='Admin')action_log('admin_return_goods', 'Admin', $id, $admin_id);
		return $return;
	}
	public function cancel_order($postdata){
		$return=array('status'=>0,'msg'=>'');
		$order_id=$postdata['order_id'];
		$admin_id=$postdata['admin_id'];
        if(empty($order_id)){$return['msg']='参数错误';return $return;}
		$map['id']=$order_id;
		$map['is_delete']=0;
        $map['shipping_status']=array('IN','1,5');
        $order_info=M('OrderInfo')->where($map)->field(true)->find();
		if(empty($order_info)){$return['msg']='订单有误';return $return;}
		$save['status']=4;
        $info=M('OrderInfo')->where($map)->save($save);
		$o_where['order_id'] = array("like", "%," . $order_id . ",%");
        $pay_info = M("PayLog")->where($o_where)->field(true)->find();
		if($pay_info['use_money']>0 || $pay_info['use_score']>0){
			$where['order_id']=$order_id;
			$order_goods=M("OrderGoods")->where($where)->getField('id',true);
			$data['order_goods']=implode(',',$order_goods);
			$data['reason']='';
			$data['type']=1;
			$money=$pay_info['order_total_price']-$pay_info['need_pay'];
			$refund_id=$this->add_refund($money,$order_id,$data);
		}else{
			$this->del_goods_num($order_id);
		}
		if($info !== false){
			if($refund_id){$refund=$this->handle_order($refund_id,$postdata['type'],$admin_id);}
			$return['status']=1;$return['msg']='取消成功';
			if($postdata['type']=='Member'){
				action_log('user_cancel_order', 'Member', $order_id, $admin_id);
			}elseif($postdata['type']=='Admin'){
				action_log('admin_cancel_order', 'Admin', $order_id, $admin_id);
			}
		}else{
			$return['msg']='取消失败';
		}
		return $return;
	}
	public function del_goods_num($order_id){
		if(!$order_id)return false;
		$map['order_id']=$order_id;
		$map['status']=0;
		$goods_info=M('OrderGoods')->where($map)->field('goods_id,goods_number,goods_attr')->select();
		foreach($goods_info as $k=>$v){
			if($v['goods_attr']){
				$attr=unserialize($v['goods_attr']);
				$attr_map['goods_id']=$v['goods_id'];
				$attr_map['attr_key']=$attr['key'];
				M('GoodsAttrStock')->where($attr_map)->setInc('stock_cfg',$v['goods_number']);
			}else{
				M('Goods')->where('id='.$v['goods_id'])->setInc('goods_number',$v['goods_number']);
			}
		}
		return true;
	}
	public function del_order($postdata){
		$return=array('status'=>0,'msg'=>'');
		$order_id=$postdata['order_id'];
		$admin_id=$postdata['admin_id'];
        if(!$order_id){$return['msg']='参数错误';return $return;}
		$map['id']=$order_id;
		$map['status']=array('lt',3);
		$is_del=M('OrderInfo')->where($map)->find();
		if($is_del){$return['msg']='订单未完成，暂不能删除';return $return;}
		$save['is_delete']=1;
        $result=M('OrderInfo')->where('id='.$order_id)->save($save);
		if($result !== false){
            $return['status']=1;$return['msg']='删除成功';
			if($postdata['type']=='Member'){
				action_log('user_del_order', 'Member', $order_id, $admin_id);
			}elseif($postdata['type']=='Admin'){
				action_log('admin_del_order', 'Admin', $order_id, $admin_id);
			}
		}else{
			$return['msg']='删除失败';
		}
		return $return;
	}
	public function confirm_order($postdata){
        $return=array('status'=>0,'msg'=>'');
		$order_id=$postdata['order_id'];
		$admin_id=$postdata['admin_id'];
        if(empty($order_id)){$return['msg']='参数错误';return $return;}
		$or_map['id']=$order_id;
		$or_map['pay_status']=3;
		$or_map['shipping_status']=3;
		$or_map['status']=array('lt',3);
		$is_confirm=M('OrderInfo')->where($or_map)->count();
		if(!$is_confirm){$return['msg']='该订单不满足收货条件';return $return;}
		$og_map['order_id']=$order_id;
		$og_map['status']=3;
        $is_goods=M('OrderGoods')->where($og_map)->count();
		if($is_goods){$return['msg']='该订单有正在退货的商品，暂不能收货';return $return;}
		$map['order_id']=$order_id;
		$map['status']=1;
        $og_save['status']=2;
		M('OrderGoods')->where($map)->save($og_save);
		$save['status']=3;
		$save['shipping_status']=4;
		$res=M('OrderInfo')->where('id='.$order_id)->save($save);
		if($res===false){$return['msg']='确认收货失败,或重复确认收货';return $return;}
		$maps['order_id']=$order_id;
		$maps['status']=0;
        $ship_save['status']=1;
		$ship_save['get_time']=NOW_TIME;
        M('ShipOrder')->where($maps)->save($ship_save);
		$this->add_sell($order_id);
		give_shop_balance($order_id);
        get_suppliers_balance($order_id); 
        $this->change_member_points($order_id);
		if(C('IS_REBATE')){affiliate_yes($order_id);}
        if(C("SHOW_LIVE_MODEL")){
            $res= D("Live/LiveDivided")->anchor_deivided($order_id);
            if($res['status']==0){
                $return['msg']=$res['msg'];return $return;
            }
        }
		$return['status']=1;
		$return['msg']='确认收货成功';
		if($postdata['type']=='Member'){
			action_log('user_confirm_order', 'Member', $order_id, $admin_id);
		}elseif($postdata['type']=='Admin'){
			action_log('admin_confirm_order', 'Admin', $order_id, $admin_id);
		}
        return $return;
    }
    public function change_member_points($order_id){
        if(empty($order_id))return false;
		$uid=idtoname($order_id,'OrderInfo','uid');
        if(empty($uid))return false;
        $rank_points=floatval(C("SALES_GAIN_RANK_INTEGRAL_RATE"));
        $sell_points=floatval(C("SALES_GAIN_SELL_INTEGRAL_RATE"));
        $sell_max_points=intval(C("SALES_GAIN_SELL_INTEGRAL"));
        $rank_max_points=intval(C("SALES_GAIN_RANK_INTEGRAL"));
        $order_where=array();
        $order_where['id']=$order_id;
        $order_money=M("OrderInfo")->where($order_where)->getField("order_money");
        $gift_rank_points=format_decimal($order_money*$rank_points/100,0,2);
        if($gift_rank_points>=$rank_max_points){
            $member_rank_ponits=$rank_max_points;
        }else{
            $member_rank_ponits=$gift_rank_points;
        }
        $gift_sell_points=format_decimal($order_money*$sell_points/100,0,2);
        if($gift_sell_points>=$sell_max_points){
            $member_sell_ponits=$sell_max_points;
        }else{
            $member_sell_ponits=$gift_sell_points;
        }
        $order_sn=M("OrderInfo")->where($order_where)->getField("order_sn");
        $grade_note='订单'.$order_sn.'支付成功变更等级积分';
        $points_note='订单'.$order_sn.'支付成功变更消费积分';
        account_change($uid,$member_rank_ponits,3,4,$grade_note);
        account_change($uid,$member_sell_ponits,4,4,$points_note);
        if(C('IS_MEMBER_UPGRADE')){user_ranks($uid);}
        return true;
    }
	public function add_sell($order_id){
		if(!$order_id)return false;
		$map['order_id']=$order_id;
		$map['status']=2;
		$goods_info=M('OrderGoods')->where($map)->field('goods_id,goods_number,goods_attr')->select();
		foreach($goods_info as $k=>$v){
			if($v['goods_attr']){
				$attr=unserialize($v['goods_attr']);
				$attr_map['goods_id']=$v['goods_id'];
				$attr_map['attr_key']=$attr['key'];
				M('GoodsAttrStock')->where($attr_map)->setInc('sell_count',$v['goods_number']);
			}
			M('Goods')->where('id='.$v['goods_id'])->setInc('sell_count',$v['goods_number']);
		}
		return true;
	}
    public function check_refund_money($postdata)
    {
        $return = array("status" => 0, "msg" => '');
        $memberinfo = checkuserauthtype();
        if (empty($memberinfo)) {
            $return['msg'] = "您没登陆，请登录";
            return $return;
        }
        $refund_order = $postdata['order_info'];
        foreach ($refund_order as $key => $val) {
            $order_where['id'] = $key;
            $order_info = M("OrderInfo")->where($order_where)->field(true)->find();
            if($postdata['type']=='tk'){
                if ($order_info['shipping_status'] >= 2 || $order_info['pay_status'] != 3) {
                    $return['status'] = 0;
                    $return['msg'] = "该商品已经发货或者该订单还没付款，不能退款";
                    return $return;
                }
            }else{
                if ($order_info['shipping_status'] == 1 || $order_info['pay_status'] != 3) {
                    $return['status'] = 0;
                    $return['msg'] = "该商品未发货或者该订单还没付款，不能退货";
                    return $return;
                }
            }
            $g_map=array();
            $order_goods=$goods_count=$money=0;
            $g_map['order_id']=$key;
            $order_goods=M("OrderGoods")->where($g_map)->count();
            $goods_count=count(array_filter(explode(',',$val)));
            if($order_goods>$goods_count) {
                $goods_map['order_id'] = $key;
                $goods_map['id'] = array("in", $val);
                $total_price = M("OrderGoods")->where($goods_map)->field("sum(goods_number*goods_price) as total_price,promot_id,is_pro_enable")->group('promot_id')->select();
                $price = $order_info['goods_allmoney'];
                foreach ($total_price as $k => $va) {
                    $goods_total_price = $va['total_price'];
                    $price -= $goods_total_price;
                    $money = $goods_total_price;
                    if ($va['promot_id'] && $va['is_pro_enable']==0) {
                        $p_where = $promot_info = array();
                        $promot_price = 0;
                        $p_where['id'] = $va['promot_id'];
                        $promot_info = M("PromotAct")->where($p_where)->find();
                        if ($price > $promot_info['min_amount']) {  
                            $return['data'][$key]['order_goods'] = $val;
                        } else {  
                            if ($promot_info['act_type'] == 2) {
                                $promot_price = $goods_total_price * (1 - ($promot_info['act_type_ext'] / 10));
                            } else {
                                $promot_price = $promot_info['act_type_ext'];
                            }
                            if ($price > $promot_price) {    
                                $money = $goods_total_price - $promot_price;
                                $p_map=$data=array();
                                $p_map['order_id']=$key;
                                $p_map['promot_id']=$va['promot_id'];
                                $data['is_pro_enable']=1;
                                M("OrderGoods")->where($p_map)->save($data);
                                $return['data'][$key]['order_goods'] = $val;
                            } else {
                                $return['list'] .= $order_info['order_sn'] . "订单因参与" . $promot_info['act_name'] . "活动,若退款后，此活动不满足,所以不允许退款,若想退款则可以退当前的整个订单,您确定要退整个订单吗？";
                                $return['status'] = 1;
                                return $return;
                                break;
                            }
                        }
                    }
                }
                if ($order_info['bonus_id']) {
                    $map['id'] = $order_info['bonus_id'];
                    $bonus_info = M("MemberBonus")->where($map)->field('min_goods_money,bonus_name,money,bonus_id')->find();
                    if ($price > $bonus_info['min_goods_money']) {
                        $money = $price;
                    } else {
                        if($price>$bonus_info['money']){
                            $money=$price-$bonus_info['money'];
                            $p_map=$data=array();
                            $p_map['order_id']=$key;
                            $p_map['bonus_id']=$bonus_info['bonus_id'];
                            $data['is_bonus_enable']=1;
                            M("OrderGoods")->where($p_map)->save($data);
                            $return['data'][$key]['order_goods'] = $val;
                        }
                        $return['list'] .= $order_info['order_sn'] . "订单因使用" . $bonus_info['bonus_name'] . "代金券,若退款后，此代金券不满足,所以不允许退款,若想退款则可以退当前的整个订单,您确定要退整个订单吗？";
                    }
                }
                $return['data'][$key]['order_goods'] = $val;
            }else{
                $money=$order_info['goods_allmoney'];
            }
            $return['data'][$key]['money']=$money;
            $return['status']=1;
        }
        return $return;
    }
    public function refund_audit($postdata){
        $return=array("status"=>0,"msg"=>'');
        $memberinfo=checkuserauthtype();
        if(empty($memberinfo)){
            $return['msg']="您没登陆，请登录";
            return $return;
        }
        $refund_order=$postdata['data'];
        $anchor_config=C("SHOW_LIVE_MODEL");
        foreach($refund_order as $key=>$val){
			$result=$this->check_refund_audit($key);
			if($result['status']==0)return $result;
            $goods_map['order_id']=$key;
            if(isset($val['order_goods'])){
                $goods_map['id']=array("in",$val['order_goods']);
                $goods_data['status']=3; 
                M("OrderGoods")->where($goods_map)->save($goods_data);
                $refund_data['order_goods']=$val['order_goods'];
				$od_map['order_id']=$key;
				$od_map['status']=array('lt',2);
				$have=M('OrderGoods')->where($od_map)->count();
				if(!$have){
					$od_save['status']=6;
					M('OrderInfo')->where('id='.$key)->save($od_save);
				}
				$order_info=M('OrderInfo')->where('id='.$key)->field('delivery_fee,shipping_status')->find();
				$g_map['order_id']=$key;
				$g_map['status']=array('neq',3);
				$is_have=M("OrderGoods")->where($g_map)->count();
				if($is_have > 0){
					$money=$val['money'];
				}else{
					if($order_info['shipping_status']==1){
						$money=$val['money']+$order_info['delivery_fee'];
					}else{
						$money=$val['money'];
					}
				}
                if($anchor_config){
                    $a_map=array();
                    $a_map['goods_id']=array("in",$val['order_goods']);
                    $a_map['order_id']=$key;
                    $a_data['order_status']=2;
                    $a_data['status']=0;
                    M("LiveDivided")->where($a_map)->save($a_data);
                }
            }else{
				$go_map['order_id']=$key;
				$go_map['status']=0;
				$order_goods= M("OrderGoods")->where($go_map)->getField('id',true);
				$order_goods=implode(',',$order_goods);
				$refund_data['order_goods']=$order_goods;
                $map['id']=$key;
                $order_info=M("OrderInfo")->where($map)->field("order_amount,delivery_fee,shipping_status")->find();
                $goods_map['order_id']=$key;
                $goods_data['status']=3; 
                M("OrderGoods")->where($goods_map)->save($goods_data);
				$od_save['status']=6;
				M('OrderInfo')->where('id='.$key)->save($od_save);
				if($order_info['shipping_status']==1){
					$money=$order_info['order_amount'];
				}else{
					$money=$order_info['order_amount']-$order_info['delivery_fee'];
				}
                if($anchor_config){
                    $a_map=array();
                    $a_map['order_id']=$key;
                    $a_data['order_status']=2;
                    $a_data['status']=0;
                    M("LiveDivided")->where($a_map)->save($a_data);
                }
            }
            $refund_data['reason']=$postdata['content'];
            $refund_data['type']=0;
            $data=$this->add_refund($money,$key,$refund_data);
			if($data)action_log('user_refund_audit', 'Member', $data, $memberinfo['id']);
        }
        if($data){
            $return['status']=1;
            $return['msg']="退款申请已提交，请等待审核";
            return $return;
        }else{
            $return['status']=0;
            $return['msg']="退款申请提交失败";
            return $return;
        }
		return $return;
    }
	public function check_refund_audit($order_id){
		$return=array("status"=>0,"msg"=>'');
		if(empty($order_id)){$return['msg']='请选择要退款的订单';return $return;}
		$order_info=idtoname($order_id,'OrderInfo','order_sn,status,shipping_status','id',false);
		$order_sn=$order_info['order_sn'];
		if($order_info['status']>=3){$return['msg']='订单'.$order_sn.'已完成不能退款';return $return;}
		if($order_info['shipping_status']>=3){$return['msg']='订单'.$order_sn.'已发货不能退款';return $return;}
		$return['status']=1;
		return $return;
	}
	public function add_refund($money,$order_id,$data){
        $order_type = idtoname($order_id,'OrderInfo','type');
        $pre_type = idtoname($order_id,'OrderInfo','pre_type');
        $o_where['is_delete'] = 0;
        $o_where['order_id'] = array("like", "%," . $order_id . ",%");
        if($order_type ==7 && $pre_type == 2){
            $payinfo = M("PayLog")->where($o_where)->field(true)->select();
            if(!empty($payinfo)){
                foreach($payinfo as $key=>$val){
                    $pay_info['use_score_money'] += $val['use_score_money'];  
                    $pay_info['use_score'] += $val['use_score'];  
                    $pay_info['use_money'] += $val['use_money'];  
                    $pay_info['payment_id'] = $val['payment_id'];  
                    $pay_info['payment_code'] = $val['pay_code'];  
                    $pay_info['user_id'] = $val['user_id'];  
                }
            }
        }else{
            $pay_info = M("PayLog")->where($o_where)->field(true)->find();
        }
        $refund_scores=$refund_money=$refund_web=$total_refund_money=0;
        $total_refund_money=$money;
        if($total_refund_money>0 && $pay_info['use_score_money']>0){
            if($pay_info['use_score_money']<$total_refund_money){
                $score_money=$pay_info['use_score_money'];
                $refund_scores=$pay_info['use_score'];
                $total_refund_money=$total_refund_money-$pay_info['use_score_money'];
            }else{
                $refund_scores=$pay_info['use_score'];
                $score_money=$total_refund_money;
                $total_refund_money=0;
            }
        }
        if($total_refund_money>0 && $pay_info['use_money']>0){
            if($pay_info['use_money']<=$total_refund_money){
                $refund_money=$pay_info['use_money'];
                $total_refund_money=$total_refund_money-$pay_info['use_money'];
            }else{
                $refund_money=$total_refund_money;
                $total_refund_money=0;
            }
        }
        if($total_refund_money>0){ 
            $refund_web=$total_refund_money;
        }
		$refund_data['order_id']=$order_id;
		$refund_data['order_goods']=$data['order_goods'];
		$refund_data['money']=$refund_money+$score_money+$refund_web;
		$refund_data['refund_money']=$refund_money;
		$refund_data['refund_scores']=$refund_scores;
		$refund_data['refund_web']=$refund_web;
		$refund_data['payment_id']=$pay_info['payment_id'];
		$refund_data['payment_code']=$pay_info['payment_code'];
		$refund_data['reason']=$data['reason'];
		$refund_data['addtime']=NOW_TIME;
		$refund_data['status']=$data['type'];
		$refund_data['uid']=$pay_info['user_id'];
		$refund_data['shop_id']=idtoname($order_id,'OrderInfo','shop_id');
		$result=M("RefundOrder")->add($refund_data);
		return $result;
	}
    public function handle_order($refund_id,$type,$admin_id){
        $return=array("status"=>0,"msg"=>'');
        $sale_money=0;
        if(!$refund_id){$return['msg']="参数错误";return $return;}
        $where['id']=$refund_id;
        $refund_info=M("RefundOrder")->where($where)->field(true)->find();
		if(empty($refund_info)){$return['msg']="没有退款信息";return $return;}
        $o_where['is_delete'] = 0;
        $o_where['order_id'] = array("like", "%," . $refund_info['order_id'] . ",%");
        $pay_info = M("PayLog")->where($o_where)->field(true)->find();
		if(empty($pay_info)){$return['msg']="支付单已处理";return $return;}
        $order_where['id']=$refund_info['order_id'];
        $order_info=M("OrderInfo")->where($order_where)->field(true)->find();
        $sale_money=format_decimal($order_info['order_amount']-$order_info['delivery_fee']);
		if(empty($order_info)){$return['msg']="没有订单信息";return $return;}
		$org_map['uid']=$refund_info['uid'];
		$org_map['order_id']=$refund_info['order_id'];
		$org_map['org_id']=$refund_info['order_goods'];
		$reg_info=M('ReturnGoods')->where($org_map)->field('id,status,shop_status')->find();
		if(!empty($reg_info)){
			if($reg_info['status']==0 || $reg_info['shop_status']==0 ){
				$return['msg']='请先处理退货单';
				$return['url']=U('TuiHuan/index',array('id'=>$reg_info['id']));
				$this->ajaxReturn($return);
			}
			if($order_info['status']==8){
				$od_save['status']=9;
				M('OrderInfo')->where('id='.$refund_info['order_id'])->save($od_save);
			}
		}else{
			$og_map['status']=4;
			$og_where['id']=array('in',$refund_info['order_goods']);
			M('OrderGoods')->where($og_where)->save($og_map);
			if($order_info['status']==6){
				$od_save['status']=7;
				M('OrderInfo')->where('id='.$refund_info['order_id'])->save($od_save);
			}
		}
		$g_where['order_id']=$refund_info['order_id'];
		$g_where['id']=array("in",$refund_info['order_goods']);
		$order_goods=M('OrderGoods')->where($g_where)->field('goods_id,goods_number,goods_attr')->select();
		foreach($order_goods as $ke=>$vo){
			if($vo['goods_attr']){
				$attr=unserialize($vo['goods_attr']);
				$attr_map['goods_id']=$vo['goods_id'];
				$attr_map['attr_key']=$attr['key'];
				M('GoodsAttrStock')->where($attr_map)->setInc('stock_cfg',$vo['goods_number']);
			}else{
				M('Goods')->where('id='.$vo['goods_id'])->setInc('goods_number',$vo['goods_number']);
			}
		}
        $order_pretype = idtoname($refund_info['order_id'],'OrderInfo','pre_type');
        $order_pay_status = idtoname($refund_info['order_id'],'OrderInfo','pay_status');
        if($refund_info){
            if($refund_info['refund_web']>0 && $order_pay_status != 5){
                $this->refund($pay_info['user_id'],$refund_info['refund_web'],$order_info['order_sn'],1);
            }
            if($refund_info['refund_money']>0 && $order_pay_status != 5){
                account_change($pay_info['user_id'],$refund_info['refund_money'],1,4,'取消订单'.$order_info['order_sn']);
            }
            if($refund_info['refund_scores']>0 && $order_pay_status != 5){
                account_change($pay_info['user_id'],$refund_info['refund_scores'],4,4,'取消订单'.$order_info['order_sn']);
            }
            $p_where['is_delete'] = 0;
            $p_where['order_id'] = array("like", "%," . $refund_info['order_id']. ",%");
            $o_data['is_delete']=1;
            $del_pay= M("PayLog")->where($p_where)->save($o_data);
            $order_ids=explode(',',$pay_info['order_id']);
            foreach(array_filter($order_ids) as $key=>$val){
                if($val==$refund_info['order_id']){
                    $org_maps['status']=array('in',array(0,1));
                    $org_maps['order_id']=$refund_info['order_id'];
                    $is_del=M('OrderGoods')->where($org_maps)->count();
                    if(!$is_del)unset($val);
                }
                if($val==0){
                    unset($val);
                }
                $pay_order_id[]=$val;
            }
            $pay_order_id=array_filter($pay_order_id);
            if(!empty($pay_order_id)){
                $payment_id=','.implode(',',$pay_order_id).',';
                $use_money=$pay_info['use_money']-$refund_info['refund_money'];
                $use_score=$pay_info['use_score']-$refund_info['refund_scores'];
                $use_web=$pay_info['pay_amount']-$refund_info['refund_web'];
                $payment=array();
                $payment['order_id']=$payment_id;
                $payment['type']=$order_info['type'];
                $payment['user_id']=$order_info['uid'];
                $payment['use_money']=$use_money;
                $payment['use_score']=$use_score;
                $payment['use_score_money']=$use_score*C('WEB_INTEGRAL_RATIO')/100;
                $payment['pay_amount']=$use_web;
                $payment['order_total_price']=$use_web+$use_money+$use_score;
                $payment['payment_id']=$pay_info['payment_id'];
                $payment['pay_code']=$pay_info['pay_code'];
                $payment['is_paid']=$pay_info['is_paid'];
                $payment['create_time']=NOW_TIME;
                M("PayLog")->add($payment);
            }
            if($order_info['pay_status']==3){
                $where['order_id']=$refund_info['order_id'];
                $data['is_separate']=2;
                M("AffiliateLog")->where($where)->save($data);
                shop_balance_log($order_info['shop_id'], -$refund_info['money'], 2,3,'订单' . $order_info['order_sn'] . '付款,未结算总额减少', $order_info);
                shop_balance_log($order_info['shop_id'], -$sale_money, 6,3,'订单' . $order_info['order_sn'] . '付款,销售总额减少', $order_info);
            }
        }
        $refund_map['id']=$refund_id;
        $refund_data['status']=1;
        $refund_data['update_time']=NOW_TIME;
        M("RefundOrder")->where($refund_map)->save($refund_data);
		if($type && $admin_id)action_log('admin_do_refund', $type, $refund_id, $admin_id);
		$return['status']=1;
		$return['msg']='退款成功';
        return $return;
    }
	public function all_order($postdata,$type=1,$is_num=0,$page_num=5,$field=true){
		$member_info=checkuserauthtype();
		$uid=$member_info['id'];
		$map['uid']=$uid;$map['is_delete']=0;$map['type']=array('in','1,3,6,7');
		if($type=='no_pay' || $type==2){
			$map['pay_status']=1;$map['status']=array('lt',3);
		}elseif($type=='no_ship' || $type==3){
			$map['pay_status']=3;$map['shipping_status']=1;$map['status']=array('lt',3);
		}elseif($type=='yes_ship' || $type==4){
			$map['pay_status']=3;$map['shipping_status']=3;$map['status']=array('lt',3);
		}elseif($type=='no_comment' || $type==5){
			$map['status']=3;$map['is_comment']=0;
		}elseif($type=='no_group' || $type==6){
            $map['pay_status']=3;$map['shipping_status']=5;
        }
		if($is_num){$all_order['num']=M('OrderInfo')->where($map)->count();return $all_order;}
		if(!empty($postdata['time_form']))$map['addtime'][]=array('egt',strtotime($postdata['time_form']));
		if(!empty($postdata['time_to']))$map['addtime'][]=array('elt',strtotime($postdata['time_to']));
		if(!empty($postdata['keyword'])){
			$search_map['goods_name']=array('like','%'.$postdata['keyword'].'%');
			$search_goods=M('OrderGoods')->where($search_map)->getField('order_id',true);
			if($search_goods)$whereor['id']=array('in',$search_goods);
			$whereor['order_sn']=$postdata['keyword'];
			$whereor['_logic'] = 'or';
            $map['_complex'] = $whereor;
		}
		$page=empty($postdata['page'])?1:$postdata['page'];
		$all_order=page_list('OrderInfo',$map,'id desc',$field,$page_num,'',$page);
		if($all_order){
			foreach($all_order['list'] as $k=>$v){
				$goods_info['all_num']=$goods_info['num']=0;
				$all_order['list'][$k]=$v;
				$all_order['list'][$k]['goods_amount']=$v['goods_amount'];
                if($v['type']==7){
                    $style = M('PromotExt')->where('act_id='.$v['pt_id'])->getField('style');
                    $all_order['list'][$k]['type']=$style;    
                    $all_order['list'][$k]['types']=$v['type'];    
                }
				$goods_map['order_id']=$v['id'];
				$goods_info['list']=M('OrderGoods')->where($goods_map)->getField('id,goods_id,goods_name,goods_attr,goods_price,goods_number,status,goods_integral',true);
				$goods_info['num']=M('OrderGoods')->where($goods_map)->count();
				if($goods_info['list']) {
                    foreach ($goods_info['list'] as $ke => $vo) {
                        $attr = unserialize($vo['goods_attr']);
                        $goods_info['list'][$ke] = $vo;
                        $goods_info['all_num'] += $vo['goods_number'];
                        $goods_info['list'][$ke]['goods_price'] = $vo['goods_price'];
                        $goods_info['list'][$ke]['img'] = idtoname($vo['goods_id'], 'Goods', 'img');
                        $goods_info['list'][$ke]['attr_name'] = $attr['name'];
                        $goods_info['list'][$ke]['status'] = $vo['status'];
                        $map_comment['uid'] = $uid;
                        $map_comment['vid'] = $vo['goods_id'];
                        $map_comment['order_id'] = $v['id'];
                        $is_comment = M('Comment')->where($map_comment)->getField('id');
                        $goods_info['list'][$ke]['is_comment'] = $is_comment;
                    }
					$all_order['list'][$k]['goods']=$goods_info;
                }
			}
		}
		return $all_order;
	}
	public function add_comment($postdata){
		$return=array('status'=>0,'info'=>'');
		$member_info=checkuserauthtype();
		$uid=$member_info['id'];
		if(!$uid){$return['info']='登录信息失效';return $return;}
		$order_id=$postdata['order_id'];
		if(!$order_id){$return['info']='订单信息错误';return $return;}
		$order_info=M('OrderInfo')->where('id='.$order_id)->field('is_comment,shop_id')->find();
		if($order_info['is_comment']){$return['info']='订单已评论';return $return;}
        $map=array();
        $map['order_id']=$order_id;
        $order_goods=M("OrderGoods")->where($map)->count();
		if(count($postdata['content']) <$order_goods){
            $return['info']='评论内容不得为空';return $return;
        }
		$shop_score=$score_num=0;
		foreach($postdata['content'] as $k=>$v){
            if(empty($v)){$return['info']='评论内容不得为空';return $return;}
			$org_info=M('OrderGoods')->where('id='.$k)->field('order_id,goods_id,shop_id')->find();
			if($postdata['goods_img'][$k])$postdata['goods_img'][$k]=serialize($postdata['goods_img'][$k]);
			$score=$postdata['scores'][$k]?$postdata['scores'][$k]:5;
			$add_map['type']=1;
			$add_map['vid']=$org_info['goods_id'];
			$add_map['uid']=$uid;
			$add_map['content']=$postdata['content'][$k];
			$add_map['rank']=$score;
			$add_map['score']=$score;
			$add_map['order_id']=$org_info['order_id'];
			$add_map['shop_id']=$org_info['shop_id'];
			$add_map['ip']=get_client_ip();
			$add_map['addtime']=NOW_TIME;
			$add_map['img']=$postdata['goods_img'][$k];
            $add_map['status']=1;
			$this->insert_comment($add_map);
			$score_num++;
			$shop_score+=$score;
		}
		if($order_info['shop_id']){
			$avg_score=$shop_score/$score_num;
			if($avg_score<3){$num=1;
			}elseif($avg_score==3){$num=2;
			}else{$num=3;
			}
			M('Shops')->where('id='.$order_info['shop_id'])->setInc('dp_count_'.$num);
			M('Shops')->where('id='.$order_info['shop_id'])->setInc('dp_count');
		}
		$comment['is_comment']=1;
		$res=M('OrderInfo')->where('id='.$order_id)->save($comment);
		if($res!==false){
			$return['status']=1;$return['info']='评论成功';
			action_log('user_add_comment', 'Member', $order_id, $uid);
			$usepoints=C('COMMENT_GAIN_SELL_INREGRAL');
			$points=C('COMMENT_GAIN_RANK_INREGRAL');
			if($usepoints>0){account_change($uid,$usepoints,4,5,'评论赠消费积分');}
			if($points>0){
				account_change($uid,$points,3,5,'评论赠等级积分');
				if(C('IS_MEMBER_UPGRADE')){user_ranks($uid);}
			}
		}else{
			$return['info']='评论失败';
		}
		return $return;
	}
	public function insert_comment($data){
		M('Comment')->add($data);
		$goods_map['id']=$data['vid'];
		M('Goods')->where($goods_map)->setInc('dp_count');
		M('Goods')->where($goods_map)->setInc('dp_count_'.$data['score']);
		$info=M('Goods')->where($goods_map)->field('dp_count,dp_count_1,dp_count_2,dp_count_3,dp_count_4,dp_count_5')->find();
		$all_score=$info['dp_count_1']+$info['dp_count_2']*2+$info['dp_count_3']*3+$info['dp_count_4']*4+$info['dp_count_5']*5;
		$save['avg_score']=round($all_score/$info['dp_count'],1);
		$save['avg_point']=$all_score/$info['dp_count']/5;
		$res=M('Goods')->where($goods_map)->save($save);
		return true;
	}
	public function change_ship_free($post){
		$return=array('status'=>0,'info'=>'');
		$order_id=$post['id'];$free=$post['free'];
		$info=M('OrderInfo')->where('id='.$order_id)->field('order_amount,delivery_fee')->find();
		if($free >= $info['delivery_fee']){$return['info']='运费应小于默认运费';return $return;}
		$change_num=$info['delivery_fee']-$free;
		if($post['type']=='Shop'){
			$is_have['shop_id']=$post['admin_id'];
			$is_have['id']=$order_id;
			$yes=M('OrderInfo')->where($is_have)->count();
			if(!$yes){$return['info']='无此操作权限';return $return;}
		}
		$where['is_delete'] = 0;
		$where['order_id'] = array("like", "%," . $order_id . ",%");
		$pay_info = M("PayLog")->where($where)->field(true)->find();
		if($change_num > $pay_info['need_pay']){$return['info']='改变量超出应付款金额';return $return;}
		$order_save['order_amount']=$info['order_amount']-$change_num;
		$order_save['delivery_fee']=$free;
		M('OrderInfo')->where('id='.$order_id)->save($order_save);
		$old_save['is_delete']=1;
		$old_save['update_time']=NOW_TIME;
		M("PayLog")->where($where)->save($old_save);
		unset($pay_info['id']);
		$pay_info['need_pay']=$pay_info['need_pay']-$change_num;
		$pay_info['order_total_price']=$pay_info['order_total_price']-$change_num;
		$pay_info['create_time']=NOW_TIME;
		M("PayLog")->add($pay_info);
		$return['status']=1;
		$return['info']='修改成功';
		if($post['type']=='Shop'){
			action_log('shop_ship_free', 'Shop', $order_id, $post['admin_id']);
		}elseif($post['type']=='Admin'){
			action_log('admin_ship_free', 'Admin', $order_id, $post['admin_id']);
		}
		return $return;
	}
    public function cancel_pay($pay_id){
        $root=array('status'=>0,'msg'=>'');
        if(!$pay_id){
            $root['msg']="无效的支付单";return $root;
        }
        $where['id']=$pay_id;
        $where['is_delete']=0;
        $pay_info=M("PayLog")->where($where)->field(true)->find();
        if(empty($pay_info)){
            $root['msg']="无效的支付单信息";return $root;
        }
        if($pay_info['use_money']){
            $msg="作废支付单，退回支付的余额";
            account_change($pay_info['user_id'],$pay_info['use_money'],1,3,$msg);
        }
        if($pay_info['use_score']){
            $msg="作废支付单，退回支付的积分";
            account_change($pay_info['user_id'],$pay_info['use_score'],4,3,$msg);
        }
        $data['is_delete']=1;
        $data['update_time']=NOW_TIME;
        $res=M("PayLog")->where($where)->save($data);
        if($res){
            $root['status']=1;return $root;
        }else{
            $root['msg']="修改支付单失败";return $root;
        }
    }
    public function continu_pay($order_id=array()){
        $root=array('status'=>0,'msg'=>'');
        if(empty($order_id)){$root['msg']="请选择订单";return $root;}
		$order_ids=array();
		if(!is_array($order_id)){
			$order_ids[]=$order_id;
		}else{
			$order_ids=$order_id;
		}
		$order_ids=array_filter($order_ids);
		foreach ($order_ids as $key => $id) {
			$where['is_delete'] = 0;
			$where['order_id'] = array("like", "%," . $id . ",%");
			$pay_info = M("PayLog")->where($where)->field(true)->find();
			if (!$pay_info) {$root['msg'] = "没有支付单信息";return $root;}
            $act_id = idtoname($id,'OrderInfo','pt_id');
            if(!empty($act_id)){
                $p_end = idtoname($act_id,'PromotAct','end_time');
                $style_id['act_id'] = $act_id;
                $style = M('PromotExt')->where($style_id)->getField('style');
                if($p_end < NOW_TIME){
                    if($style == 4){
                       $status['status'] = 10;
                        M('OrderInfo')->where('id='.$id)->save($status);
                        $root['msg'] = "该团已过期,此订单过期,不可付款";
                        return $root;
                    }else{
                        $status['status'] = 4;
                        M('OrderInfo')->where('id='.$id)->save($status);
                        $root['msg'] = "活动过期,不可付款";
                        return $root;
                    }
                }
                $pid = idtoname($id,'OrderInfo','pid');
                if(!empty($pid)){
                    $p_begintime = idtoname($pid,'OrderInfo','confirm_time');
                    $group_time_limit = idtoname($act_id,'PromotAct','group_time_limit');
                    $p_ends = idtoname($act_id,'PromotAct','end_time');
                    $end_time = $p_begintime + ($group_time_limit * 3600);
                    if($end_time < NOW_TIME || $end_time > $p_ends){
                        $status['status'] = 10;
                        M('OrderInfo')->where('id='.$id)->save($status);
                        $root['msg'] = "该团已过期,此订单过期,不可付款";
                        return $root;
                    }
                    $group_number = idtoname($act_id,'PromotAct','group_number');
                    $map['pid'] = $pid;
                    $map['status'] = 2;
                    $map['pay_status'] = 3;
                    $map['shipping_status'] = 5;
                    $now_count = M('OrderInfo')->where($map)->count();
                    $number = $group_number - $now_count -1;
                    if(empty($number)){
                        $status['status'] = 10;
                        M('OrderInfo')->where('id='.$id)->save($status);
                        $root['msg'] = "该团已成团,此订单过期,不可付款";
                        return $root;
                    }
                }
            }
		}
		$root['status']=1;
		$root['order_id']=implode(',',$order_ids);
        return $root;
    }
    public function count_order_total($order_id,$type=1,$score=0,$use_account=0,$account_money=0,$payment_id=0){
        $root=array();
        $goods_integral=0;
        $root['status']=0;
        $total_price=0;
        $memberinfo=checkuserauthtype();
        if(!$order_id){
            $root['msg']="参数无效";
            return $root;
        }
            $where['id'] = array("in", $order_id);
            $order_info = M("OrderInfo")->where($where)->field(true)->select();
            foreach ($order_info as $k => $val) {
                $total_price+=$val['order_amount'];
                if($val['type']==3){
                    $goods_integral+=$val['used_score'];
                }
                if($val['type']==7 && $val['pre_money']>0 && $val['pre_type']==2 && $val['pay_status']==1){
                    $total_price = $val['pre_money']; 
                }
                if($val['type']==7 && $val['pre_money']>0 && $val['pre_type']==2 && $val['pay_status']==5){
                    $total_price = $val['goods_allmoney']-$val['pre_money']; 
                }
            }
            if($score>0) {
                if($type==1 || $type==6 || $type==7) {
                $score_use_total = $total_price;
                $order_score =intval($score_use_total * (C('INTGRAL_PAY_RATIO') / 100) * 100 / C('WEB_INTEGRAL_RATIO'));
                if ($memberinfo['usepoints'] > 0) {
                    if ($memberinfo['usepoints'] >= $order_score) {
                        $use_score = $order_score * (C('WEB_INTEGRAL_RATIO') / 100);
                        $pay_score = intval($order_score);
                    } else {
                        $use_score = $memberinfo['usepoints'] * (C('WEB_INTEGRAL_RATIO') / 100);
                        $pay_score = intval($memberinfo['usepoints']);
                    }
                }
                $use_score_money =$use_score;
            }else {
                    $score_use_total = $goods_integral * C('WEB_INTEGRAL_RATIO') / 100;
                    if ($memberinfo['usepoints'] > 0) {
                        if ($memberinfo['usepoints'] >= $score_use_total) {
                            $use_score = $score_use_total;
                            $pay_score = $goods_integral;
                        } else {
                            $use_score = $memberinfo['usepoints'];
                            $pay_score = $use_score;
                        }
                    }
                    $use_score_money = intval($use_score);
                }
            }
            if($account_money<=0)$account_money=0;
            if($memberinfo['money']>0){
                $pay_price=$total_price-$use_score_money;
                if($use_account==1 && $account_money==0){
                    $account_money=$memberinfo['money'];
                }else if($use_account==1 && $account_money>0){
                    $account_money=$account_money;
                }
                if($account_money>$pay_price){
                    $account_money=$pay_price;
                }
            }else{
                $account_money=$memberinfo['money'];
            }
            if($payment_id>0 && $payment_id!=1){
                $payment_info=idtoname($payment_id,'Payment','*');
                $counter_fee=$payment_info['fee'];
            }
            $pay_price=$total_price-$use_score_money-$account_money;
            if($counter_fee>0){
            $pay_fee=$pay_price*$counter_fee/100;
            $pay_price=$pay_price+$pay_fee;
        }
        $return = array();
        $return['total_info']=array(
            'total_price'=>$total_price,
            'total_price_show'=>format_price($total_price-$use_score_money)."+ ".$pay_score."分",
            'pay_price'=>$pay_price,
            'pay_fee'=>$pay_fee,
            'score'=>$pay_score,
            'use_score_money'=>$use_score_money,
            'account_money'=>$account_money,
            'payment_info'=>$payment_info,
            'pay_total_price'=>	$total_price,
            'order_type'=>$type
        );
        return $return;
    }
    public function sub_continue_order($param){
        $return=array();
        $memberinfo=checkuserauthtype();
        $return['status']=0;
        $order_id=$param['ids'];
        $score=$param['score'];
        $use_account=$param['use_account'];
        $account_money=$param['account_money'];
        $payment_id=$param['payment_id']?$param['payment_id']:0;
        $pay_pwd=$param['pay_pwd'];
        $type=$param['type'];
        if($account_money >0 || $score >0 ){
            $return['status']=3;
            if($pay_pwd==''){
                $return['msg']='请输入支付密码';
                return $return;
            }
            $m['id']=$memberinfo['id'];
            $userinfo=M("Member")->where($m)->field('paypassword,salt')->find();
            if($userinfo['paypassword'] == ''){
                $return['msg']="您没设置交易密码,请设置交易密码";
                $return['url']=getjumpurl('JUMP_3');
                return $return;
            }
            if($pay_pwd=='' || creatpwd($pay_pwd,'HANCHAO'.$userinfo['salt']) != $userinfo['paypassword']){
                $return['msg']='支付密码错误';
                return $return;
            }
        }
        if($type == 7 || $type == 6){
            $act_id = idtoname($order_id,'OrderInfo','pt_id');
            $end_time = idtoname($act_id,'PromotAct','end_time');
            if($end_time<NOW_TIME){
                $y_map=array();
                $y_map['id']=array('in',$order_id);
                if($type==6){
                    $status['status'] = 10;
                    M('OrderInfo')->where($y_map)->save($status);
                }else{
                    $status['status'] = 4;
                    M('OrderInfo')->where($y_map)->save($status);
                }
                $return['msg']='活动已过期,不可付款';
                return $return;
            }
        }
		$order_ids=explode(',',$order_id);
		foreach($order_ids as $ke=>$id){
			$log_map['is_delete'] = 0;
			$log_map['order_id'] = array("like", "%," . $id . ",%");
			$log_id = M("PayLog")->where($log_map)->getField('id');
			if($log_id){
                $order_map['id'] = $id;
                $order_pretype = M('OrderInfo')->where($order_map)->getField('pre_type');
                $order_pay_status = M('OrderInfo')->where($order_map)->getField('pay_status');
                if($order_pretype!=2){
				    $result = $this->cancel_pay($log_id);
				    if($result['status']==0)return $result;
                }
			}
		}
        $where['o.id']=array("in",$order_id);
        $order_info=M("OrderInfo")->alias('o')->where($where)->JOIN('LEFT JOIN __ORDER_GOODS__ g ON o.id=g.order_id')->field('o.*,g.*')->select();
        if($type == 7 || $type == 6){
            $data=$this->count_order_total($order_id,$type,$score,$use_account,$account_money,$payment_id);
        }else{
            $data=$this->count_order_total($order_id,1,$score,$use_account,$account_money,$payment_id);
        }
        if($data['total_info']['pay_price']>0 && $payment_id<=0){$return['msg']='请选择支付方式';return $return;}
        $payment_info=array();
        $payment_info['order_id']=",".$order_id.",";
        $payment_info['user_id']= $memberinfo['id'];
        $payment_info['type']=$type;
        $payment_info['order_sn']= createOrderNo();
        $payment_info['use_money']=$data['total_info']['account_money'];
        $payment_info['need_pay']=$data['total_info']['pay_price'];
        $payment_info['use_score']=$data['total_info']['score'];
        $payment_info['use_score_money']=$data['total_info']['use_score_money'];
        $payment_info['order_total_price']=$data['total_info']['pay_total_price'];
        $payment_info['payment_id']=$payment_id;
        $payment_info['payment_fee']=$data['total_info']['pay_fee'];
        $payment_info['pay_amount']=0;
        $payment_info['pay_code']=idtoname($payment_id,"Payment",'code');
        $payment_info['is_paid']=0;
        $payment_info['create_time']=NOW_TIME;
        $pay_log_id=M('PayLog')->add($payment_info);
        if($pay_log_id){
            if($data['total_info']['score']){
                account_change($memberinfo['id'],-$data['total_info']['score'],4,4,'购买商品支付');
            }
            if($data['total_info']['account_money']>0){
                account_change($memberinfo['id'],-$data['total_info']['account_money'],1,4,'购买商品支付');
            }
            if($data['total_info']['pay_price']>0 && $data['total_info']['payment_info']){
                $return['pay']=$pay_log_id;
                $return['status']=1;
                return $return;
            }
            $pay_info=array();
            $pay_info['out_trade_no']=$payment_info['order_sn'];
            $pay_info['type']=$payment_info['type'];
            $res=$this->endorder($pay_info);
            if($res['status']==1){
                $return['status']=1;
                $map=$save_data=array();
                $save_data['payment_id']=$payment_id;
                $save_data['pay_code']=idtoname($payment_id,"Payment",'code');
               $map['id']=$order_id;
                M("OrderInfo")->where($map)->save($save_data);
                $return['data']=','.implode(',',$order_id).',';
                return $return;
            }else{
                $return['msg']=$res['msg'];
                return $return;
            }
        }else{
            $return['msg']="支付单生成失败";return $return;
        }
        return $return;
    }
    public function get_continue($order_id){
        $return=array('status'=>0,'msg'=>'','url'=>'');
        if(empty($order_id)){
            $return['msg']='参数错误';
            $return['url']=getjumpurl('JUMP_4');
            return $return;
        }
        $where['id']=array("in",$order_id);
        $order_info=M("OrderInfo")->where($where)->field(true)->select();
        foreach($order_info as $key=>$val){
            $g_map['order_id']=$val['id'];
            $order_info[$key]['goods_list']=M("OrderGoods")->where($g_map)->field('goods_id,goods_name,goods_number,goods_price,goods_attr,goods_integral')->select();
            if($order_info[$key]['goods_list']){
                foreach($order_info[$key]['goods_list'] as $gk=>$gv){
                    $order_info[$key]['goods_list'][$gk]['format_goods_attr']=unserialize($gv['goods_attr']);
                    $map['id']=$gv['goods_id'];
                    $goods_info=M("Goods")->where($map)->Field('goods_weight,img')->find();
                    $order_info[$key]['goods_list'][$gk]['img']=$goods_info['img'];
                    $order_info[$key]['goods_list'][$gk]['goods_weight']=$goods_info['goods_weight'];
                    if($val['type']==3){
                        $is_addcart=3;
                        $order_info[$key]['goods_list'][$gk]['goods_total_price'] =format_price($gv['goods_price'] * $gv['goods_number'])." + ".$gv['goods_integral']*$gv['goods_number']."分";
                    }else {
                        $is_addcart=1;
                        $order_info[$key]['goods_list'][$gk]['goods_total_price'] = format_decimal($gv['goods_price'] * $gv['goods_number']);
                    }
                }
            }
        }
        $return['data']=$order_info;
        $return['is_addcart']=$is_addcart;
        $return['status']=1;
        return $return;
    }
    public function buy_now($postdata){
        $return=array('status'=>0,'msg'=>'');
        $memberinfo = checkuserauthtype();
        if(empty($postdata) || !is_array($postdata)){$postdata=I('get.');}
        $goods_id=intval($postdata['goods_id'])?intval($postdata['goods_id']):0;
        $number=intval($postdata['number'])?intval($postdata['number']):0;
        $integra=intval($postdata['integra'])?$postdata['integra']:0;
        $act=intval($postdata['act'])?intval($postdata['act']):0;
        $attr=$postdata['goods_attr'];
        $name=D("Common/GoodsAttr")->goods_to_attrname($attr);
        $type=$postdata['type'];
        $address_info=checkuseraddress();
        if (empty($address_info)) {
            $root['status'] = 0;
            $root['msg'] = '请选择配送地区';
            return $root;
        }
        if($type==3){
            if($integra<=0){
                $return['msg']="请选择付款方式";
                return $return;
            }
        }
        $check = D("Common/Cart")->check_cart($goods_id, $attr, $number, $name);
        if($check['status']<2){
            $return['msg']=$check['msg'];
            return $return;
        }else{
            if ($attr) {
                $goodsattr_info = array(
                    'key' => $attr,
                    'name' => $name
                );
                $attr_info = serialize($goodsattr_info);
            }
            $carts_map['id']=$goods_id;
            $goods_info=M("Goods")->where($carts_map)->field(true)->order('shop_id asc')->select();
            if($type==1){
                $price_info=D("Common/Cart")->getminprice($goods_id,$attr);
                foreach($goods_info as $k=>$val){
                    $goods_info[$k]['shop_price']=$price_info['price'];
                    $goods_info[$k]['goods_attr']=$attr_info;
                    $goods_info[$k]['goods_num']=$number;
                    $goods_info[$k]['goods_id']=$goods_id;
                    $goods_info[$k]['cart_id']=$act;
                }
            }elseif($type == 6){
                $where['style_ext_id'] = $goods_id;
                $now_time = NOW_TIME;
                $map['c.end_time'] = array('gt',$now_time);
                $map['a.style_ext_id'] = $goods_id;
                $price = M('PromotExt')->where($where)->order('id desc')->getField('remarks');
                $act_id = M('PromotExt')->alias('a')->join('__PROMOT_ACT__ c on c.id=a.act_id')->where($map)->order('a.id desc')->getField('act_id');
                $pt_id = idtoname($act_id,'PromotAct','id');
                $group_price = unserialize($price);
                $group_pprice =D("Common/GoodsAttr")->get_goods_attrprice($attr,$group_price);
                $goods_info[0]['shop_price'] = $group_pprice;
                $goods_info[0]['goods_attr']=$attr_info;
                $goods_info[0]['goods_num']=$number;
                $goods_info[0]['goods_id']=$goods_id;
                $goods_info[0]['pt_id']=$pt_id;
                $goods_info[0]['pid']=$postdata['pid'];
            }elseif($type == 7){
                $where['style_ext_id'] = $goods_id;
                $now_time = NOW_TIME;
                $map['c.end_time'] = array('gt',$now_time);
                $map['a.style_ext_id'] = $goods_id;
                $price = M('PromotExt')->where($where)->order('id desc')->field('remarks,style')->find();
                $act_id = M('PromotExt')->alias('a')->join('__PROMOT_ACT__ c on c.id=a.act_id')->where($map)->order('a.id desc')->getField('act_id');
                $pre_id = idtoname($act_id,'PromotAct','id');
                $premoney = unserialize($price['remarks']);
                $pre_money = $premoney['group_price'];
                $sale_money = $premoney['pre_money'];
                $pre_price =D("Common/GoodsAttr")->get_goods_attrprice($attr,$pre_money);
                $goods_info[0]['shop_price'] = $pre_price;
                $goods_info[0]['pre_money'] = $sale_money*$number;
                $goods_info[0]['goods_attr']=$attr_info;
                $goods_info[0]['goods_num']=$number;
                $goods_info[0]['goods_id']=$goods_id;
                $goods_info[0]['pre_id']=$pre_id;
                $goods_info[0]['pre_type']=$price['style'];
            }elseif($type==3){
                if($integra==1){
                    $map['goods_id']=$goods_id;
                    $only_integral=M("GoodsIntegral")->where($map)->getField("only_integral");
                }else{
                    $map['goods_id']=$goods_id;
                    $goods_integral=M("GoodsIntegral")->where($map)->field("integral,money")->find();
                    $only_integral=$goods_integral['integral'];
                    $price=$goods_integral['money'];
                }
                $member_map = $cart_map = $map_c = array();
                $member_map['id'] = $memberinfo['id'];
                $user_integra = M("Member")->where($member_map)->getField('usepoints');
                if ($only_integral > $user_integra || $only_integral * $number > $user_integra) {
                    $return['status'] = 0;
                    $return['msg'] = '您的积分不足,不能购买';
                    return $return;
                }
                foreach($goods_info as $k=>$val){
                    $goods_info[$k]['shop_price']=$price;
                    $goods_info[$k]['cart_integral']=$only_integral;
                    $goods_info[$k]['goods_attr']=$attr_info;
                    $goods_info[$k]['goods_num']=$number;
                    $goods_info[$k]['goods_id']=$goods_id;
                }
            }
            $return['data']=$goods_info;
            $return['status']=1;
            }
       return $return;
    }
    public function get_order_invoice_info($order_id){
        $map=array();$map['id']=$order_id;
        $invoice=M('OrderInfo')->where($map)->getField('invoice_info');
        return unserialize($invoice);
    }
}
?>