<?php


namespace Common\Model;
use Think\Model;
class PromotModel extends Model
{
    protected $tableName = 'promot_act';

    
    public function goods_to_promot($id, $is_limit = 0)
    {
        $return = $map = $list = array();
        if($is_limit){
            $result= $this->get_limit_promot($id);
            if($result){
                $return['list'][$result['id']] = $result;
            }
        }
        $style_ext_id = $this->goods_promot($id);
        if (empty($style_ext_id)){
            $return['count'] = count($return['list']);
            return $return;
        }
        $map['pa.id'] = array('in', $style_ext_id);
        $list = M('PromotAct')->field('pa.*,pe.style,pe.style_ext_id,pe.remarks')->alias('pa')->where($map)->join('LEFT JOIN __PROMOT_EXT__ pe ON pe.act_id=pa.id')->order('end_time desc')->select();
        foreach ($list as $key => $val) {
            $return['list'][$val['id']] = $val;
        }
        $return['count'] = count($return['list']);
        return $return;
    }

    
    public function goods_promot($ids)
    {
        $return = $map = $pro_emap = array();
        if (is_numeric($ids)) {
            $id = $ids;
            $ids = array();
            $ids[] = $id;
        }
        $map['id'] = array('in', $ids);
        $cat_brand_id = M('Goods')->where($map)->field('cat_id,brand_id,shop_id')->select();
        foreach ($cat_brand_id as $k => $v) {
            if ($v['cat_id'] != 0) $cat_ids[] = $v['cat_id'];
            if ($v['brand_id'] != 0) $brand_ids[] = $v['brand_id'];
            $shop_ids[] = $v['shop_id'];
        }
        //获取活动id    $type_values
        $now_time = NOW_TIME;
        $pro_emap['_string'] = ' ( pa.shop_id in (' . implode(',', $shop_ids) . ') and (pa.start_time = 0 or pa.start_time <= ' . $now_time . ') and (pa.end_time = 0 or pa.end_time >= ' . $now_time . ')) and ((';
        if(count($ids)>0){
            $pro_emap['_string'] .= 'pe.style = 3 and pe.style_ext_id in (' . implode(',', $ids) . ')) ';
        }
        if (count($cat_ids)>0) {
            foreach ($cat_ids as $k => $v) {
                $cat_ids[] = getallparent($v, '', 'GoodsCategory');
            }
            $pro_emap['_string'] .= ' or (pe.style = 1 and pe.style_ext_id in (' . implode(',', $cat_ids) . ') ) ';
        }
        if (count($brand_ids)>0) $pro_emap['_string'] .= ' or (pe.style = 2 and pe.style_ext_id in (' . implode(',', $brand_ids) . ') ) ';
        $pro_emap['_string'] .= ')';
        $return = M('PromotExt')->alias('pe')->where($pro_emap)->join('LEFT JOIN __PROMOT_ACT__ pa ON pe.act_id=pa.id')->getField('act_id', true);
        $return = array_unique($return);
        return $return;
    }
    
    public function get_limit_promot($id)
    {
        $now_time = NOW_TIME;
        $return = $map = array();
        $map['_string'] = ' g.id = '.$id.' and g.is_delete=0 and g.publish_wait=1 and g.promote_end_time > '.$now_time;
        $goods_ids = M('PromotAct')->field('pa.*,g.promote_price,g.id as goodsid')->alias('pa')->where($map)->join('LEFT JOIN __GOODS__ g ON g.promote_id=pa.id')->find();
        if(!empty($goods_ids)) {
            $return = $goods_ids;
            $return['style'] = 5;
            $return['style_ext_id'] = $return['goodsid'];
            $remarks['promot_price'][$return['style_ext_id']] = $return['promote_price'];
            $return['remarks'] = serialize($remarks);
        }
        return $return;
    }

    
    public function goods_to_ticket($ids,$shop_id=0)
    {
        $return = $where = array();
        $type_values = $this->goods_promot($ids);
        //搜索对应活动的红包
        if(empty($type_values)){
            $type_values[]=0;
        }

        $where['type_value'] = array('in', $type_values);
        $now_time = NOW_TIME;
        $where['send_type'] = 5;
        $where['type'] = 3;
        $where['shop_id'] = empty($shop_id)?0:$shop_id;
        $where['_string'] = ' (use_start_date <= ' . $now_time . ' or use_start_date = 0) and (use_end_date >= ' . $now_time . ' or use_end_date = 0)';
        $bonus = M('Bonu')->where($where)->select();
        $return['get_count']=0;
        foreach ($bonus as $key => $val) {
            $bonus[$key] = $this->format_bonus($val);
            if($bonus[$key]['is_get']==1){$return['get_count']++;}
        }
        $return['list'] = $bonus;
        $return['count'] = count($bonus);
        return $return;
    }

    
    public function format_bonus($data = array())
    {
        $return = $mb_map = array();
        $return['id'] = $data['id'];
        $return['type_name'] = $data['type_name'];
        if($data['type_value']==0){$return['type_name'].='(本店通用)';}
        $return['type_money'] = round($data['type_money']);
        $return['send_type'] = $data['send_type'];
        $return['every_num'] = $data['every_num'];
        $return['odds'] = $data['odds'];
        $return['use_start_date'] = $data['use_start_date'];
        $return['use_start_date_format'] = time_format($data['use_start_date'], 'Y.m.d');
        $return['use_end_date'] = $data['use_end_date'];
        $return['use_end_date_format'] = time_format($data['use_end_date'], 'Y.m.d');
        $return['min_goods_amount'] = $data['min_goods_amount'];
        $return['type'] = $data['type'];
        $return['type_value'] = $data['type_value'];
        //判断红包是否领取,使用
        //$member = session('member_info');
        $member = checkuserauthtype();
        if (!empty($member)) {
            $mb_map['bonus_id'] = $data['id'];
            $mb_map['user_id'] = $member['id'];
            $mb_map['used_time'] = 0;
            $member_bonu = M('MemberBonus')->where($mb_map)->field('count(*) as get_count,used_time,id')->find();
            $return['is_get'] = $member_bonu['get_count'] > 0 ? 1 : 0;
            $return['member_bonusid'] = $member_bonu['id'];
           // $return['is_use'] = empty($member_bonu['used_time']) ? 0 : 1;
        } else {
            $return['is_get'] = 0;
//            $return['is_use'] = 0;
        }
        return $return;
    }

    
    public function member_get_bonus($bonus_id = 0)
    {
        $return = $bonus_map = $use_map = $data = array();
        $return['status'] = 0;//2未登录
        if (empty($bonus_id)) {
            $return['info'] = '参数错误！';
            return $return;
        }
        $member = checkuserauthtype();
        //$member = session('member_info');
        if (empty($member)) {
            $return['status'] = 2;
            $return['info'] = '请先登录！';
            $return['url'] = getjumpurl('JUMP_1');
            return $return;
        }
        $bonus_map['id'] = $bonus_id;
        $bonus = M('Bonu')->where($bonus_map)->find();
        if (empty($bonus)) {
            $return['info'] = '没有该代金券吖！';
            return $return;
        }
        $use_map['user_id'] = $member['id'];
        $use_map['bonus_id'] = $bonus_id;
        $use_map['used_time'] = array('eq', 0);
        $mb_id = M('MemberBonus')->where($use_map)->getField('id');
        if (!empty($mb_id)) {
            $return['info'] = '你已经领过该代金券了吖！';
            return $return;
        }
        $data['bonus_id'] = $bonus['id'];
        $data['bonus_name'] = $bonus['type_name'];
        $data['user_id'] = $member['id'];
        $data['money'] = $bonus['type_money'];
        $data['min_goods_money'] = $bonus['min_goods_amount'];
        $data['send_time'] = NOW_TIME;
        $data['start_time'] = $bonus['use_start_date'];
        $data['end_time'] = $bonus['use_end_date'];
        $data['type'] = $bonus['type'];
        $data['type_value'] = $bonus['type_value'];
        $addbonus = M('MemberBonus')->add($data);
        if ($addbonus !== false) {
            $return['status'] = 1;
            $return['info'] = '领取成功！';
        } else $return['info'] = '领取失败！';
        return $return;
    }

    
    public function get_active_goods($getdata){
        $id = $getdata['id'];
        //根据活动id获取条件
        $Extinfo = M('PromotExt')->where('act_id=' . $id)->field(true)->select();
		GLOBAL $GoodsCategory;
		$catinfo=$map=$brand_ids=$goods_ids=array();
        foreach ($Extinfo as $k => $v) {
            if($v['style'] == 1){$catinfo[] = $GoodsCategory[$v['style_ext_id']];}
            if($v['style'] == 2){$brand_ids[] = $v['style_ext_id'];}
            if($v['style'] == 3){$goods_ids[] = $v['style_ext_id'];}
        }
        $shop_id = M('PromotAct')->where('id=' . $id)->getField('shop_id');
        $map['shop_id']=$shop_id;
        if (!empty($brand_ids)) $map['brand_id'] = array('in', $brand_ids);
        if (!empty($goods_ids)) $map['id'] = array('in', $goods_ids);
        if (!empty($catinfo)) {
			foreach($catinfo as $key=>$val){$ids[]=explode(',',$val['allson']);}
			foreach($ids as $ke=>$va){
				foreach($va as $k=>$v){$idss[]=$v;}
			}
			$cat_ids=array_unique($idss);
			$map['cat_id'] = array('in', $cat_ids);
		}
        //排序条件
        $order_list['default'] = array('name' => '默认', 'class' => 1, 'icon' => 0, 'url' => U('PromotAct/cont', array('id' => $id, 'default' => 0)));
        $order_list['shop_price'] = array('name' => '价格', 'class' => 0, 'icon' => 1, 'url' => U('PromotAct/cont', array('id' => $id, 'shop_price' => 1)));
        $order_list['updatetime'] = array('name' => '时间', 'class' => 0, 'icon' => 1, 'url' => U('PromotAct/cont', array('id' => $id, 'updatetime' => 1)));
        $order_list['sell_count'] = array('name' => '销量', 'class' => 0, 'icon' => 1, 'url' => U('PromotAct/cont', array('id' => $id, 'sell_count' => 1)));
        $order = '';
        foreach ($order_list as $k => $v) {
            if ($getdata[$k] == 1) {
                $order_list['default']['class'] = 0;
                $order_list[$k]['class'] = 1;
                $order_list[$k]['icon'] = 1;
                $order_list[$k]['url'] = U('PromotAct/cont', array('id' => $id, $k => 2));
                $order = ' ' . $k . ' desc';
            }
            if ($getdata[$k] == 2) {
                $order_list['default']['class'] = 0;
                $order_list[$k]['class'] = 1;
                $order_list[$k]['icon'] = 2;
                $order_list[$k]['url'] = U('PromotAct/cont', array('id' => $id, $k => 1));
                $order = ' ' . $k . ' asc';
            }
        }
        $return['order'] = $order_list;

        //查询商品，格式化数据
        $join = '';
        $p = empty($getdata['page']) ? 1 : $getdata['page'];
        $pagesize=empty($pagesize)?C('WEB_GOODS_PAGE'):$pagesize;
        $goods_info = page_list('Goods', $map, $order, true, $pagesize, $join, $p);
        $return['goods_info'] = $goods_info;
        return $return;
    }
	
	public function add_update($post){
		$return=array('status'=>0,'info'=>'');
		//时间
		$start_time=$post['start_time'];
		$end_time=$post['end_time'];
		if(empty($start_time) || empty($end_time)){
			$return['info']='请选择开始时间或结束时间';return $return;
		}elseif(strtotime($end_time) < strtotime($start_time)){
			$return['info']='结束时间应大于开始时间';return $return;
		}
		
		//促销商品信息
		$goods_id=$post['goods_id'];
		$promot_price=$post['promot_price'];
		$promotes=array();
		foreach($goods_id as $k=>$v){
			$promotes[$k]['id']=$v;
			$promotes[$k]['promote_price']=$promot_price[$v];
		}
		//编辑或添加
		if($post){
			$data['act_name']=$post['act_name'];
			$data['img']=$post['img'];
			$data['big_img']=$post['big_img'];
			$data['start_time']=strtotime($post['start_time']);
			$data['end_time']=strtotime($post['end_time']);
			$data['shop_id'] = $post['shop_id']?$post['shop_id']:0;
			$data['is_limit_time'] = 1;
			$data['status'] = $post['status'];
			$data['pid'] = $post['pid'];
			if($post['id']){//修改
				//判断时间
				$in_map['pid']=0;
				$in_map['is_limit_time']=1;
				$in_map['id']=array('neq',$post['id']);
				$in_map['start_time']=array('lt',$data['end_time']);
				$in_ids=M('PromotAct')->where($in_map)->getField('id',true);
				if($in_ids){
					$map_in['id']=array('in',$in_ids);
					$last_time= M('PromotAct')->where($map_in)->order('end_time desc')->getField('end_time');
					if($last_time > $data['start_time']){$return['info']='该时间段内已有促销，请选择其他时间段';return $return;}
				}
				//修改信息
				$res = M('PromotAct')->where('id='.$post['id'])->save($data);
				$goods_infos=M('Goods')->where('promote_id='.$post['id'])->field(true)->select();
				foreach($goods_infos as $k=>$v){//清除商品以前的促销信息
					$goods_data=array();
					$goods_data['promote_id']=0;
					$goods_data['is_promote']=0;
					$goods_data['promote_start_time']=0;
					$goods_data['promote_end_time']=0;
					$goods_data['promote_price']=0;
					$map=array();
					$map['id']=$v['id'];
					M('Goods')->where($map)->save($goods_data);		
				}
				foreach($promotes as $k=>$v){//添加新的促销信息
					$goods_data=array();
					$goods_data['is_promote']=1;
					$goods_data['promote_id']=$post['id'];
					$goods_data['promote_start_time']=strtotime($post['start_time']);
					$goods_data['promote_end_time']=strtotime($post['end_time']);
					$goods_data['promote_price']=$promotes[$v['id']]['promote_price'];
					$map=array();
					$map['id']=$v['id'];
					M('Goods')->where($map)->save($goods_data);
				}
			}else{//添加
				//判断时间
				$max['is_limit_time']=1;
				$max['pid']=0;
				$last_time= M('PromotAct')->where($max)->order('end_time desc')->getField('end_time');
				if(strtotime($start_time) < $last_time){$return['info']='该时间段内已有促销，请选择其他时间段';return $return;}
				
				//添加信息
				$res = M('PromotAct')->add($data);
				if($res){
					$goods_data=array();
					$goods_data['is_promote']=1;
					$goods_data['promote_id']=$res;
					$goods_data['promote_start_time']=strtotime($post['start_time']);
					$goods_data['promote_end_time']=strtotime($post['end_time']);
					foreach($promotes as $k=>$v){
						$goods_data['promote_price']=$v['promote_price'];
						$map=array();
						$map['id']=$v['id'];
						M('Goods')->where($map)->save($goods_data);
					}
				}
			} 
			$return['status']=1;
			if($post['id']){
				$return['info']='编辑成功';
			}else{
				$return['info']='添加成功';
			}
			return $return;
		}		
	}
	
    public function get_promot_goods($getdata){
		$act_id = $getdata['act_id'];
		$act_ids=M('PromotAct')->where('pid='.$act_id)->getField('id',true);
		$act_ids[]=$act_id;
		//商品条件
        $g_map['status']=1;
		$g_map['is_promote']=1;
		$g_map['publish_wait']=1;
		$g_map['promote_price']=array('gt',0);
		$g_map['promote_id']=array('in',$act_ids);
		$g_map['promote_start_time']=array('lt',NOW_TIME);
		$g_map['promote_end_time']=array('gt',NOW_TIME);
		//排序条件
        $order_list['default'] = array('name' => '默认', 'class' => 1, 'icon' => 0, 'url' => U('PromotSale/index', array('default' => 0)));
        $order_list['shop_price'] = array('name' => '价格', 'class' => 0, 'icon' => 1, 'url' => U('PromotSale/index', array('shop_price' => 1)));
        $order_list['updatetime'] = array('name' => '时间', 'class' => 0, 'icon' => 1, 'url' => U('PromotSale/index', array('updatetime' => 1)));
        $order_list['sell_count'] = array('name' => '销量', 'class' => 0, 'icon' => 1, 'url' => U('PromotSale/index', array('sell_count' => 1)));
        $order = '';
        foreach ($order_list as $k => $v) {
            if ($getdata[$k] == 1) {
                $order_list['default']['class'] = 0;
                $order_list[$k]['class'] = 1;
                $order_list[$k]['icon'] = 1;
                $order_list[$k]['url'] = U('PromotSale/index', array($k => 2));
                $order = ' ' . $k . ' desc';
            }
            if ($getdata[$k] == 2) {
                $order_list['default']['class'] = 0;
                $order_list[$k]['class'] = 1;
                $order_list[$k]['icon'] = 2;
                $order_list[$k]['url'] = U('PromotSale/index', array($k => 1));
                $order = ' ' . $k . ' asc';
            }
        }
		$p = empty($getdata['page']) ? 1 : $getdata['page'];
        $page_num=empty($page_num)?C('WEB_GOODS_PAGE'):$page_num;
		$goods_list=page_list('Goods',$g_map,$order,true,$page_num,'',$p);
        $return['order'] = $order_list;
        $return['goods_info'] = $goods_list;
        return $return;
    }
}
?>